/*
 * Decompiled with CFR 0.152.
 */
package com.interpress_project.modernshare.client.controller.actions;

import com.interpress_project.modernshare.client.controller.actions.ActionAdaptor;
import com.interpress_project.modernshare.client.controller.actions.ImageFactory;
import com.interpress_project.modernshare.client.controller.command.TaskManager;
import com.interpress_project.modernshare.client.controller.delegate.LocalSVNManager;
import com.interpress_project.modernshare.client.controller.delegate.exceptions.ConnectionFailException;
import com.interpress_project.modernshare.client.controller.delegate.exceptions.InternalFailException;
import com.interpress_project.modernshare.client.controller.model.LocalModelManager;
import com.interpress_project.modernshare.client.controller.model.SVNRoot;
import com.interpress_project.modernshare.client.events.LogEvent;
import com.interpress_project.modernshare.client.events.LogEventType;
import com.interpress_project.modernshare.client.view.ViewManager;
import java.util.ArrayList;
import org.eclipse.jface.dialogs.MessageDialog;

public final class CheckOutAction
extends ActionAdaptor {
    private final ViewManager vmgr;
    private final LocalSVNManager svnmgr = LocalSVNManager.getInstance();

    public CheckOutAction(ViewManager vmgr) {
        this.setText("\u30c7\u30fc\u30bf\u30bb\u30f3\u30bf\u304b\u3089\u30db\u30c3\u30c8\u30b7\u30e7\u30c3\u30c8\u30fb\u30d5\u30a9\u30eb\u30c0\u3092\u4f5c\u6210(&C)");
        this.setToolTipText("\u30c7\u30fc\u30bf\u30bb\u30f3\u30bf\u304b\u3089\u30ed\u30fc\u30ab\u30ebPC\u4e0a\u306b\u30db\u30c3\u30c8\u30b7\u30e7\u30c3\u30c8\u30fb\u30d5\u30a9\u30eb\u30c0\u3092\u4f5c\u6210\u3057\u307e\u3059\u3002");
        try {
            this.setImageDescriptor(ImageFactory.getInstance().getImageDescriptor("chkout"));
        }
        catch (Exception ex) {
            this.sb.getLogger().fatal((Object)"\u30ea\u30bd\u30fc\u30b9\u8a2d\u5b9a\u306e\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002", (Throwable)ex);
            System.exit(-1);
        }
        this.vmgr = vmgr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        TaskManager taskmgr = TaskManager.getInstance();
        ArrayList<SVNRoot> list = null;
        try {
            taskmgr.stop();
            if (!LocalModelManager.getInstance().canRegisterMore()) {
                this.vmgr.getDialogManager().createErrorMessageDialog("\u7ba1\u7406\u3067\u304d\u308b\u30d5\u30a9\u30eb\u30c0\u306f\u6700\u5927\u30674\u3068\u306a\u308a\u307e\u3059\u3002\u3053\u308c\u4ee5\u4e0a\u30d5\u30a9\u30eb\u30c0\u3092\u30c1\u30a7\u30c3\u30af\u30a2\u30a6\u30c8\u3059\u308b\u3053\u3068\u306f\u3067\u304d\u307e\u305b\u3093\u3002");
                return;
            }
            MessageDialog dlg = new MessageDialog(this.vmgr.getShell(), "\u30bf\u30b0\u540d\u30ea\u30b9\u30c8\u306e\u53d6\u5f97", null, "\u30c7\u30fc\u30bf\u30bb\u30f3\u30bf\u304b\u3089\u30bf\u30b0\u540d\u30ea\u30b9\u30c8\u3092\u53d6\u5f97\u3057\u3066\u3044\u307e\u3059\u3002\u3057\u3070\u3089\u304f\u304a\u5f85\u3061\u304f\u3060\u3055\u3044...", 2, new String[0], 0);
            dlg.setBlockOnOpen(false);
            try {
                dlg.open();
                try {
                    this.svnmgr.connect();
                }
                catch (ConnectionFailException ex) {
                    this.logEventSource.fireEvent(new LogEvent((Object)this, ex.getMessage(), LogEventType.ERROR, ex));
                    this.vmgr.getDialogManager().createErrorMessageDialog(ex.getMessage());
                    dlg.close();
                    this.sb.getLogger().debug((Object)this.sb.gc());
                    taskmgr.start();
                    return;
                }
                try {
                    list = this.svnmgr.getTagNames();
                }
                catch (InternalFailException ex) {
                    this.logEventSource.fireEvent(new LogEvent((Object)this, ex.getMessage(), LogEventType.ERROR, ex));
                    this.vmgr.getDialogManager().createErrorMessageDialog(ex.getMessage());
                    dlg.close();
                    this.sb.getLogger().debug((Object)this.sb.gc());
                    taskmgr.start();
                    return;
                }
            }
            finally {
                dlg.close();
            }
            boolean bExist = false;
            LocalModelManager lmmgr = LocalModelManager.getInstance();
            for (int i = 0; i < list.size(); ++i) {
                SVNRoot root = list.get(i);
                if (lmmgr.isExistTagnameInRocal(root.getName())) continue;
                bExist = true;
            }
            if (!bExist) {
                this.sb.getLogger().info((Object)"\u30c7\u30fc\u30bf\u30bb\u30f3\u30bf\u306b\u306f\u30c1\u30a7\u30c3\u30af\u30a2\u30a6\u30c8\u53ef\u80fd\u306a\u30bf\u30b0\u304c\u5b58\u5728\u3057\u3066\u3044\u307e\u305b\u3093\u3002");
                this.vmgr.getDialogManager().createInformationMessageDialog("\u30c1\u30a7\u30c3\u30af\u30a2\u30a6\u30c8\u306e\u78ba\u8a8d", "\u30c7\u30fc\u30bf\u30bb\u30f3\u30bf\u306b\u306f\u30c1\u30a7\u30c3\u30af\u30a2\u30a6\u30c8\u53ef\u80fd\u306a\u30bf\u30b0\u304c\u5b58\u5728\u3057\u3066\u3044\u307e\u305b\u3093\u3002");
                return;
            }
            this.logEventSource.fireEvent(new LogEvent((Object)this, LogEventType.CLEAR));
            this.vmgr.getDialogManager().createCheckoutWizard(list);
        }
        finally {
            this.sb.getLogger().debug((Object)this.sb.gc());
            taskmgr.start();
        }
    }
}

