/*
 * Decompiled with CFR 0.152.
 */
package com.interpress_project.modernshare.client.controller.actions;

import com.interpress_project.modernshare.client.controller.actions.ActionAdaptor;
import com.interpress_project.modernshare.client.controller.actions.ImageFactory;
import com.interpress_project.modernshare.client.controller.command.SVNCommandFactory;
import com.interpress_project.modernshare.client.controller.command.SVNCommandManager;
import com.interpress_project.modernshare.client.controller.command.TaskManager;
import com.interpress_project.modernshare.client.controller.model.LocalRoot;
import com.interpress_project.modernshare.client.controller.model.RootStatus;
import com.interpress_project.modernshare.client.events.GUIEvent;
import com.interpress_project.modernshare.client.events.GUIEventType;
import com.interpress_project.modernshare.client.events.LogEvent;
import com.interpress_project.modernshare.client.events.LogEventType;
import com.interpress_project.modernshare.client.view.ViewManager;

public final class ActivateTargetAction
extends ActionAdaptor {
    private final SVNCommandManager cmdmgr = SVNCommandManager.getInstance();
    private final SVNCommandFactory factory = SVNCommandFactory.getInstance();
    private ViewManager vmgr;
    private LocalRoot item;

    public ActivateTargetAction(ViewManager vmgr, LocalRoot item) {
        this.setText("\u81ea\u52d5\u76e3\u8996\u3092\u958b\u59cb(&S)");
        this.setToolTipText("\u5bfe\u8c61\u3068\u306a\u308b\u30db\u30c3\u30c8\u30b7\u30e7\u30c3\u30c8\u30d5\u30a9\u30eb\u30c0\u306b\u5bfe\u3059\u308b\u81ea\u52d5\u76e3\u8996\u3092\u958b\u59cb\u3057\u307e\u3059\u3002");
        try {
            this.setImageDescriptor(ImageFactory.getInstance().getImageDescriptor("connected"));
        }
        catch (Exception ex) {
            this.sb.getLogger().fatal((Object)"\u30ea\u30bd\u30fc\u30b9\u8a2d\u5b9a\u306e\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002", (Throwable)ex);
            System.exit(-1);
        }
        this.vmgr = vmgr;
        this.item = item;
    }

    private void setActive(String path) {
        this.cmdmgr.addCommand(this.factory.createActiveTargetCommand(path, RootStatus.active));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        int mode = -1;
        TaskManager taskmgr = TaskManager.getInstance();
        try {
            taskmgr.stop();
            boolean bAnswer = this.vmgr.getDialogManager().createYesNoMessageDialog("\u81ea\u52d5\u76e3\u8996\u306e\u958b\u59cb\u78ba\u8a8d", "\u30db\u30c3\u30c8\u30b7\u30e7\u30c3\u30c8\u30d5\u30a9\u30eb\u30c0" + this.item.getAbsolutePath() + "\u306b\u5bfe\u3059\u308b\u81ea\u52d5\u76e3\u8996\u3092\u958b\u59cb\u3057\u307e\u3059\u3002");
            if (!bAnswer) {
                return;
            }
            if (this.item.getPc2host()) {
                mode = this.vmgr.getDialogManager().createSyncModeDialog();
                if (mode == -1) {
                    return;
                }
            } else {
                mode = 1;
            }
            this.guiEventSource.fireEvent(new GUIEvent((Object)this, this.item.getAbsolutePath() + "\u3078\u306e\u81ea\u52d5\u76e3\u8996\u3092\u958b\u59cb\u3057\u307e\u3059...", GUIEventType.START));
            switch (mode) {
                default: {
                    return;
                }
                case 0: {
                    this.cmdmgr.addCommand(this.factory.createSyncRemoteWithLocalCommand(this.item));
                    break;
                }
                case 1: {
                    this.cmdmgr.addCommand(this.factory.createSyncLocalWithRemoteCommand(this.item));
                }
            }
            this.setActive(this.item.getAbsolutePath());
            this.logEventSource.fireEvent(new LogEvent((Object)this, "\u30db\u30c3\u30c8\u30b7\u30e7\u30c3\u30c8\u30d5\u30a9\u30eb\u30c0" + this.item.getAbsolutePath() + "\u306b\u5bfe\u3059\u308b\u81ea\u52d5\u76e3\u8996\u3092\u958b\u59cb\u3057\u307e\u3057\u305f\u3002", LogEventType.INFO));
        }
        finally {
            this.guiEventSource.fireEvent(new GUIEvent((Object)this, "\u30db\u30c3\u30c8\u30b7\u30e7\u30c3\u30c8\u30d5\u30a9\u30eb\u30c0" + this.item.getAbsolutePath() + "\u306e\u81ea\u52d5\u76e3\u8996\u3092\u958b\u59cb\u3057\u307e\u3057\u305f\u3002", GUIEventType.FINISH));
            taskmgr.start();
        }
    }
}

