/*
 * Decompiled with CFR 0.152.
 */
package com.interpress_project.modernshare.client;

import com.interpress_project.modernshare.client.IUserAdmin;
import com.interpress_project.modernshare.client.controller.delegate.exceptions.InternalFailException;

public class Recovery
extends IUserAdmin {
    public Recovery(String[] args) {
        super(args);
        this.sb.setLoggerInfo("HotShot_Client", "etc/log4j.properties");
    }

    @Override
    protected void parseOptions(String[] args) {
        if (args.length == 0) {
            this.usage();
            System.exit(-1);
        }
        for (int i = 0; i < args.length; ++i) {
            if ("-rootpass".equalsIgnoreCase(args[i])) {
                this.setRootPassword(args[++i]);
                continue;
            }
            if ("-host".equalsIgnoreCase(args[i])) {
                this.setAdminHost(args[++i]);
                continue;
            }
            if (!"-port".equalsIgnoreCase(args[i])) continue;
            this.setAdminPort(new Integer(args[++i]));
        }
        if (this.getRootPassword().length() == 0 || this.getAdminHost().length() == 0) {
            this.usage();
            System.exit(-1);
        }
    }

    private void usage() {
        System.out.println("Usage: recovery -rootpass <password> -host <targethost> -port <portnum>");
        System.out.println("HotShot utility recovery runs the database recovery procedure on a HotShot repository. Please do this if you've been getting errors indicationg that recovery ought to be run. Recovery requires exclusive access and will exit if the repository is in use by another process.");
        System.out.println("\t-rootpass <pass>\t: Password for root account.");
        System.out.println("\t-host <hostname>\t: The hostname of HotShot datacenter.");
        System.out.println("\t-port <number>\t\t: Port number of HotShot datacenter.");
    }

    @Override
    protected void run() {
        try {
            this.orbmgr.recovery("root", this.getRootPassword());
        }
        catch (InternalFailException ex) {
            this.sb.getLogger().error((Object)"\u30ea\u30ab\u30d0\u30ea\u51e6\u7406\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002\u30c7\u30fc\u30bf\u30bb\u30f3\u30bf\u30ea\u30dd\u30b8\u30c8\u30ea\u304c\u4e00\u6642\u7684\u306b\u30ed\u30c3\u30af\u3055\u308c\u3066\u3044\u308b\u53ef\u80fd\u6027\u3082\u3042\u308a\u307e\u3059\u306e\u3067\u3001\u3057\u3070\u3089\u304f\u6642\u9593\u3092\u304a\u3044\u3066\u304b\u3089\u518d\u8a66\u884c\u3057\u3066\u307f\u3066\u304f\u3060\u3055\u3044\u3002");
            this.sb.getLogger().error((Object)ex.getMessage());
            return;
        }
        catch (Exception ex) {
            this.sb.getLogger().fatal((Object)ex.getMessage());
            return;
        }
        this.sb.getLogger().info((Object)"\u30c7\u30fc\u30bf\u30bb\u30f3\u30bf\u306e\u30ea\u30dd\u30b8\u30c8\u30ea\u30fb\u30ea\u30ab\u30d0\u30ea\u304c\u6210\u529f\u3057\u307e\u3057\u305f\u3002");
    }

    public static void main(String[] args) {
        Recovery admin = new Recovery(args);
        admin.exec();
    }
}

