/*
 * Decompiled with CFR 0.152.
 */
package com.interpress_project.modernshare.client;

import com.interpress_project.modernshare.client.IUserAdmin;
import com.interpress_project.modernshare.client.controller.delegate.exceptions.AccountNotFoundException;

public class Passwd
extends IUserAdmin {
    public Passwd(String[] args) {
        super(args);
        this.sb.setLoggerInfo("HotShot_Client", "etc/log4j.properties");
    }

    @Override
    protected void parseOptions(String[] args) {
        if (args.length == 0) {
            this.usage();
            System.exit(-1);
        }
        for (int i = 0; i < args.length; ++i) {
            if ("-rootpass".equalsIgnoreCase(args[i])) {
                this.setRootPassword(args[++i]);
                continue;
            }
            if ("-user".equalsIgnoreCase(args[i])) {
                this.setNewAccount(args[++i]);
                continue;
            }
            if ("-pass".equalsIgnoreCase(args[i])) {
                this.setNewPassword(args[++i]);
                continue;
            }
            if ("-host".equalsIgnoreCase(args[i])) {
                this.setAdminHost(args[++i]);
                continue;
            }
            if (!"-port".equalsIgnoreCase(args[i])) continue;
            this.setAdminPort(new Integer(args[++i]));
        }
        if (this.getRootPassword().length() == 0 || this.getNewAccount().length() == 0 || this.getNewPassword().length() == 0) {
            this.usage();
            System.exit(-1);
        }
    }

    private void usage() {
        System.out.println("Usage: passwd -rootpass <pass> -user <account> -pass <newpass> -host <targethost> -port <portnum>");
        System.out.println("HotShot utility passwd changes login password and password attributes.");
        System.out.println("\t-rootpass <pass>\t: Password for root account.");
        System.out.println("\t-user <account>\t\t: The login ID of target user.");
        System.out.println("\t-pass <newpass>\t: The password newly-assigned for the login ID.");
        System.out.println("\t-host <hostname>\t: The hostname of HotShot datacenter.");
        System.out.println("\t-port <number>\t\t: Port number of HotShot datacenter.");
    }

    @Override
    protected void run() {
        try {
            this.orbmgr.changePassword("root", this.getRootPassword(), this.getNewAccount(), this.getNewPassword());
        }
        catch (AccountNotFoundException ex) {
            String msg = ex.getMessage();
            this.sb.getLogger().error((Object)msg);
            return;
        }
        catch (Exception ex) {
            this.sb.getLogger().fatal((Object)ex.getMessage());
            return;
        }
        this.sb.getLogger().info((Object)("\u30a2\u30ab\u30a6\u30f3\u30c8" + this.getNewAccount() + "\u306e\u30d1\u30b9\u30ef\u30fc\u30c9\u5909\u66f4\u306b\u6210\u529f\u3057\u307e\u3057\u305f\u3002"));
    }

    public static void main(String[] args) {
        Passwd admin = new Passwd(args);
        admin.exec();
    }
}

