/*
 * Decompiled with CFR 0.152.
 */
package com.interpress_project.modernshare.client;

import com.interpress_project.modernshare.client.IUserAdmin;

public class HotBackup
extends IUserAdmin {
    public HotBackup(String[] args) {
        super(args);
        this.sb.setLoggerInfo("HotShot_Client", "etc/log4j.properties");
    }

    @Override
    protected void parseOptions(String[] args) {
        if (args.length == 0) {
            this.usage();
            System.exit(-1);
        }
        for (int i = 0; i < args.length; ++i) {
            if ("-rootpass".equalsIgnoreCase(args[i])) {
                this.setRootPassword(args[++i]);
                continue;
            }
            if ("-host".equalsIgnoreCase(args[i])) {
                this.setAdminHost(args[++i]);
                continue;
            }
            if (!"-port".equalsIgnoreCase(args[i])) continue;
            this.setAdminPort(new Integer(args[++i]));
        }
        if (this.getRootPassword().length() == 0 || this.getAdminHost().length() == 0) {
            this.usage();
            System.exit(-1);
        }
    }

    private void usage() {
        System.out.println("Usage: hotbackup -rootpass <password> -host <targethost> -port <portnum>");
        System.out.println("HotShot utility hotbackup makes a hot copy of the HotShot repository.");
        System.out.println("\t-rootpass <pass>\t: Password for root account.");
        System.out.println("\t-host <hostname>\t: The hostname of HotShot datacenter.");
        System.out.println("\t-port <number>\t\t: Port number of HotShot datacenter.");
    }

    @Override
    protected void run() {
        String path = null;
        try {
            this.sb.getLogger().info((Object)"\u30c7\u30fc\u30bf\u30bb\u30f3\u30bf\u306e\u30ea\u30dd\u30b8\u30c8\u30ea\u30fb\u30d0\u30c3\u30af\u30a2\u30c3\u30d7\u3092\u958b\u59cb\u3057\u307e\u3059\u3002");
            this.sb.getLogger().info((Object)"\u3057\u3070\u3089\u304f\u304a\u5f85\u3061\u304f\u3060\u3055\u3044...");
            path = this.orbmgr.backup("root", this.getRootPassword());
        }
        catch (Exception ex) {
            this.sb.getLogger().fatal((Object)"\u30d0\u30c3\u30af\u30a2\u30c3\u30d7\u51e6\u7406\u304c\u5931\u6557\u3057\u307e\u3057\u305f\u3002", (Throwable)ex);
            return;
        }
        this.sb.getLogger().info((Object)"\u30c7\u30fc\u30bf\u30bb\u30f3\u30bf\u306e\u30ea\u30dd\u30b8\u30c8\u30ea\u30fb\u30d0\u30c3\u30af\u30a2\u30c3\u30d7\u304c\u6210\u529f\u3057\u307e\u3057\u305f\u3002");
        this.sb.getLogger().info((Object)("\u30c7\u30fc\u30bf\u30bb\u30f3\u30bf\u306e\u30d0\u30c3\u30af\u30a2\u30c3\u30d7\u9818\u57df" + path + "\u306b\u30db\u30c3\u30c8\u30b7\u30e7\u30c3\u30c8\u304c\u683c\u7d0d\u3055\u308c\u307e\u3057\u305f\u3002"));
    }

    public static void main(String[] args) {
        HotBackup admin = new HotBackup(args);
        admin.exec();
    }
}

