/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.javahl;

import java.io.File;
import java.io.OutputStream;
import org.tigris.subversion.javahl.BlameCallback;
import org.tigris.subversion.javahl.ClientException;
import org.tigris.subversion.javahl.CommitMessage;
import org.tigris.subversion.javahl.DirEntry;
import org.tigris.subversion.javahl.Info;
import org.tigris.subversion.javahl.Info2;
import org.tigris.subversion.javahl.LogMessage;
import org.tigris.subversion.javahl.NativeResources;
import org.tigris.subversion.javahl.Notify;
import org.tigris.subversion.javahl.Notify2;
import org.tigris.subversion.javahl.PromptUserPassword;
import org.tigris.subversion.javahl.PropertyData;
import org.tigris.subversion.javahl.Revision;
import org.tigris.subversion.javahl.SVNClientInterface;
import org.tigris.subversion.javahl.SVNClientLogLevel;
import org.tigris.subversion.javahl.Status;
import org.tigris.subversion.javahl.Version;

public class SVNClient
implements SVNClientInterface {
    protected long cppAddr = this.ctNative();

    public SVNClient() {
        try {
            this.setConfigDirectory(this.determineInitialConfigDir());
        }
        catch (ClientException clientException) {
            // empty catch block
        }
    }

    protected String determineInitialConfigDir() {
        String path;
        if (SVNClient.isOSWindows()) {
            path = SVNClient.getEnv("APPDATA");
            if (path == null && (path = SVNClient.getUserHomeDirectory()) != null) {
                path = new File(path, "Application Data").getPath();
            }
            if (path != null) {
                path = new File(path, "Subversion").getAbsolutePath();
            }
        } else {
            path = SVNClient.getUserHomeDirectory();
            if (path != null) {
                path = new File(path, ".subversion").getAbsolutePath();
            }
        }
        return path;
    }

    private static String getUserHomeDirectory() {
        String path = System.getProperty("user.home");
        return path != null ? path : SVNClient.getEnv("HOME");
    }

    private static final String getEnv(String envVar) {
        try {
            return System.getenv(envVar);
        }
        catch (Throwable jreComplaint) {
            return null;
        }
    }

    private static final boolean isOSWindows() {
        String opSys = System.getProperty("os.name");
        return opSys.toLowerCase().indexOf("windows") >= 0;
    }

    private native long ctNative();

    public native void dispose();

    protected native void finalize();

    public Version getVersion() {
        return NativeResources.version;
    }

    public native String getAdminDirectoryName();

    public native boolean isAdminDirectory(String var1);

    public native String getLastPath();

    public Status[] status(String path, boolean descend, boolean onServer, boolean getAll) throws ClientException {
        return this.status(path, descend, onServer, getAll, false);
    }

    public Status[] status(String path, boolean descend, boolean onServer, boolean getAll, boolean noIgnore) throws ClientException {
        return this.status(path, descend, onServer, getAll, noIgnore, false);
    }

    public native Status[] status(String var1, boolean var2, boolean var3, boolean var4, boolean var5, boolean var6) throws ClientException;

    public DirEntry[] list(String url, Revision revision, boolean recurse) throws ClientException {
        return this.list(url, revision, revision, recurse);
    }

    public native DirEntry[] list(String var1, Revision var2, Revision var3, boolean var4) throws ClientException;

    public native Status singleStatus(String var1, boolean var2) throws ClientException;

    public native void username(String var1);

    public native void password(String var1);

    public native void setPrompt(PromptUserPassword var1);

    public LogMessage[] logMessages(String path, Revision revisionStart, Revision revisionEnd) throws ClientException {
        return this.logMessages(path, revisionStart, revisionEnd, true, false);
    }

    public LogMessage[] logMessages(String path, Revision revisionStart, Revision revisionEnd, boolean stopOnCopy) throws ClientException {
        return this.logMessages(path, revisionStart, revisionEnd, stopOnCopy, false);
    }

    public LogMessage[] logMessages(String path, Revision revisionStart, Revision revisionEnd, boolean stopOnCopy, boolean discoverPath) throws ClientException {
        return this.logMessages(path, revisionStart, revisionEnd, stopOnCopy, discoverPath, 0L);
    }

    public native LogMessage[] logMessages(String var1, Revision var2, Revision var3, boolean var4, boolean var5, long var6) throws ClientException;

    public native long checkout(String var1, String var2, Revision var3, Revision var4, boolean var5, boolean var6) throws ClientException;

    public long checkout(String moduleName, String destPath, Revision revision, boolean recurse) throws ClientException {
        return this.checkout(moduleName, destPath, revision, revision, recurse, false);
    }

    public native void notification(Notify var1);

    public native void notification2(Notify2 var1);

    public native void commitMessageHandler(CommitMessage var1);

    public native void remove(String[] var1, String var2, boolean var3) throws ClientException;

    public native void revert(String var1, boolean var2) throws ClientException;

    public void add(String path, boolean recurse) throws ClientException {
        this.add(path, recurse, false);
    }

    public native void add(String var1, boolean var2, boolean var3) throws ClientException;

    public long update(String path, Revision revision, boolean recurse) throws ClientException {
        return this.update(new String[]{path}, revision, recurse, false)[0];
    }

    public native long[] update(String[] var1, Revision var2, boolean var3, boolean var4) throws ClientException;

    public long commit(String[] path, String message, boolean recurse) throws ClientException {
        return this.commit(path, message, recurse, false);
    }

    public native void copy(String var1, String var2, String var3, Revision var4) throws ClientException;

    public void move(String srcPath, String destPath, String message, Revision revision, boolean force) throws ClientException {
        this.move(srcPath, destPath, message, force);
    }

    public native void move(String var1, String var2, String var3, boolean var4) throws ClientException;

    public native void mkdir(String[] var1, String var2) throws ClientException;

    public native void cleanup(String var1) throws ClientException;

    public native void resolved(String var1, boolean var2) throws ClientException;

    public long doExport(String srcPath, String destPath, Revision revision, boolean force) throws ClientException {
        return this.doExport(srcPath, destPath, revision, revision, force, false, true, null);
    }

    public native long doExport(String var1, String var2, Revision var3, Revision var4, boolean var5, boolean var6, boolean var7, String var8) throws ClientException;

    public native long doSwitch(String var1, String var2, Revision var3, boolean var4) throws ClientException;

    public native void doImport(String var1, String var2, String var3, boolean var4) throws ClientException;

    public void merge(String path1, Revision revision1, String path2, Revision revision2, String localPath, boolean force, boolean recurse) throws ClientException {
        this.merge(path1, revision1, path2, revision2, localPath, force, recurse, false, false);
    }

    public native void merge(String var1, Revision var2, String var3, Revision var4, String var5, boolean var6, boolean var7, boolean var8, boolean var9) throws ClientException;

    public native void merge(String var1, Revision var2, Revision var3, Revision var4, String var5, boolean var6, boolean var7, boolean var8, boolean var9) throws ClientException;

    public void diff(String target1, Revision revision1, String target2, Revision revision2, String outFileName, boolean recurse) throws ClientException {
        this.diff(target1, revision1, target2, revision2, outFileName, recurse, true, false, false);
    }

    public native void diff(String var1, Revision var2, String var3, Revision var4, String var5, boolean var6, boolean var7, boolean var8, boolean var9) throws ClientException;

    public native void diff(String var1, Revision var2, Revision var3, Revision var4, String var5, boolean var6, boolean var7, boolean var8, boolean var9) throws ClientException;

    public PropertyData[] properties(String path) throws ClientException {
        return this.properties(path, null);
    }

    public PropertyData[] properties(String path, Revision revision) throws ClientException {
        return this.properties(path, revision, revision);
    }

    public native PropertyData[] properties(String var1, Revision var2, Revision var3) throws ClientException;

    public void propertySet(String path, String name, String value, boolean recurse) throws ClientException {
        this.propertySet(path, name, value, recurse, false);
    }

    public native void propertySet(String var1, String var2, String var3, boolean var4, boolean var5) throws ClientException;

    public void propertySet(String path, String name, byte[] value, boolean recurse) throws ClientException {
        this.propertySet(path, name, value, recurse, false);
    }

    public native void propertySet(String var1, String var2, byte[] var3, boolean var4, boolean var5) throws ClientException;

    public native void propertyRemove(String var1, String var2, boolean var3) throws ClientException;

    public void propertyCreate(String path, String name, String value, boolean recurse) throws ClientException {
        this.propertyCreate(path, name, value, recurse, false);
    }

    public native void propertyCreate(String var1, String var2, String var3, boolean var4, boolean var5) throws ClientException;

    public void propertyCreate(String path, String name, byte[] value, boolean recurse) throws ClientException {
        this.propertyCreate(path, name, value, recurse, false);
    }

    public native void propertyCreate(String var1, String var2, byte[] var3, boolean var4, boolean var5) throws ClientException;

    public native PropertyData revProperty(String var1, String var2, Revision var3) throws ClientException;

    public native PropertyData[] revProperties(String var1, Revision var2) throws ClientException;

    public native void setRevProperty(String var1, String var2, Revision var3, String var4, boolean var5) throws ClientException;

    public PropertyData propertyGet(String path, String name) throws ClientException {
        return this.propertyGet(path, name, null);
    }

    public PropertyData propertyGet(String path, String name, Revision revision) throws ClientException {
        return this.propertyGet(path, name, revision, revision);
    }

    public native PropertyData propertyGet(String var1, String var2, Revision var3, Revision var4) throws ClientException;

    public byte[] fileContent(String path, Revision revision) throws ClientException {
        return this.fileContent(path, revision, revision);
    }

    public native byte[] fileContent(String var1, Revision var2, Revision var3) throws ClientException;

    public native void streamFileContent(String var1, Revision var2, Revision var3, int var4, OutputStream var5) throws ClientException;

    public native void relocate(String var1, String var2, String var3, boolean var4) throws ClientException;

    public native byte[] blame(String var1, Revision var2, Revision var3) throws ClientException;

    public void blame(String path, Revision revisionStart, Revision revisionEnd, BlameCallback callback) throws ClientException {
        this.blame(path, revisionEnd, revisionStart, revisionEnd, callback);
    }

    public native void blame(String var1, Revision var2, Revision var3, Revision var4, BlameCallback var5) throws ClientException;

    public native void setConfigDirectory(String var1) throws ClientException;

    public native String getConfigDirectory() throws ClientException;

    public native void cancelOperation() throws ClientException;

    public native Info info(String var1) throws ClientException;

    public native String getVersionInfo(String var1, String var2, boolean var3) throws ClientException;

    public static native void enableLogging(int var0, String var1);

    public static native String version();

    public static native int versionMajor();

    public static native int versionMinor();

    public static native int versionMicro();

    public native long commit(String[] var1, String var2, boolean var3, boolean var4) throws ClientException;

    public native void lock(String[] var1, String var2, boolean var3) throws ClientException;

    public native void unlock(String[] var1, boolean var2) throws ClientException;

    public native Info2[] info2(String var1, Revision var2, Revision var3, boolean var4) throws ClientException;

    static native void initNative();

    static {
        NativeResources.loadNativeLibrary();
    }

    public static final class LogLevel
    implements SVNClientLogLevel {
    }
}

