/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.internal.databinding.internal.swt;

import org.eclipse.jface.internal.databinding.provisional.observable.Diffs;
import org.eclipse.jface.internal.databinding.provisional.observable.value.AbstractObservableValue;
import org.eclipse.jface.util.Assert;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Spinner;

public class SpinnerObservableValue
extends AbstractObservableValue {
    private final Spinner spinner;
    private final String attribute;
    private boolean updating = false;
    private int currentSelection;
    static /* synthetic */ Class class$0;

    public SpinnerObservableValue(Spinner spinner, String attribute) {
        this.spinner = spinner;
        this.attribute = attribute;
        if (attribute.equals("selection")) {
            this.currentSelection = spinner.getSelection();
            spinner.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    if (!SpinnerObservableValue.this.updating) {
                        int newSelection = SpinnerObservableValue.this.spinner.getSelection();
                        SpinnerObservableValue.this.fireValueChange(Diffs.createValueDiff(new Integer(SpinnerObservableValue.this.currentSelection), new Integer(newSelection)));
                        SpinnerObservableValue.this.currentSelection = newSelection;
                    }
                }
            });
        } else if (!attribute.equals("min") && !attribute.equals("max")) {
            throw new IllegalArgumentException("Attribute name not valid: " + attribute);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setValue(Object value) {
        try {
            int oldValue;
            this.updating = true;
            int newValue = (Integer)value;
            if (this.attribute.equals("selection")) {
                oldValue = this.spinner.getSelection();
                this.spinner.setSelection(newValue);
                this.currentSelection = newValue;
            } else if (this.attribute.equals("min")) {
                oldValue = this.spinner.getMinimum();
                this.spinner.setMinimum(newValue);
            } else {
                if (!this.attribute.equals("max")) {
                    Assert.isTrue((boolean)false, (String)("invalid attribute name:" + this.attribute));
                    Object var4_4 = null;
                    this.updating = false;
                    return;
                }
                oldValue = this.spinner.getMaximum();
                this.spinner.setMaximum(newValue);
            }
            this.fireValueChange(Diffs.createValueDiff(new Integer(oldValue), new Integer(newValue)));
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            this.updating = false;
            throw throwable;
        }
        {
            Object var4_6 = null;
            this.updating = false;
            return;
        }
    }

    public Object doGetValue() {
        int value = 0;
        if (this.attribute.equals("selection")) {
            value = this.spinner.getSelection();
        } else if (this.attribute.equals("min")) {
            value = this.spinner.getMinimum();
        } else if (this.attribute.equals("max")) {
            value = this.spinner.getMaximum();
        }
        return new Integer(value);
    }

    public Object getValueType() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.lang.Integer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return clazz;
    }
}

