/*
 * Decompiled with CFR 0.152.
 */
package com.interpress_project.modernshare.ipcommon.fastMD5.util.test;

import com.interpress_project.modernshare.ipcommon.fastMD5.io.NullOutputStream;
import com.interpress_project.modernshare.ipcommon.fastMD5.util.MD5;
import com.interpress_project.modernshare.ipcommon.fastMD5.util.MD5OutputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.Random;
import java.util.StringTokenizer;

public class MD5OutputStreamTest {
    public static void main(String[] arg) {
        try {
            long seed = System.currentTimeMillis();
            if (arg.length > 0 && !arg[0].equals("time")) {
                seed = Long.parseLong(arg[0]);
            }
            long max_data = 0x500000000L;
            if (arg.length > 1) {
                max_data = Long.parseLong(arg[1]);
            }
            Random ran = new Random(seed);
            while (true) {
                System.out.print("seed:  " + seed + "  \t");
                long data_size = ran.nextLong();
                if (data_size < 0L) {
                    data_size = -data_size;
                }
                System.out.println("size:  " + (data_size %= max_data + 1L));
                MD5OutputStreamTest.runTest(data_size, ran);
                seed = ran.nextLong();
                ran.setSeed(seed);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
    }

    private static void runTest(long data_size, Random ran) throws IOException {
        Process proc = Runtime.getRuntime().exec("md5sum");
        MD5OutputStream out1 = new MD5OutputStream(new NullOutputStream());
        BufferedOutputStream out2 = new BufferedOutputStream(proc.getOutputStream());
        while (data_size > 0L) {
            int output_type = ran.nextInt() % 100;
            if ((output_type -= 5) < 0) {
                MD5OutputStreamTest.outputSingleByte(ran, out1, out2);
                --data_size;
                continue;
            }
            if ((output_type -= 25) < 0) {
                data_size -= MD5OutputStreamTest.outputFullBuffer(ran, out1, out2, data_size);
                continue;
            }
            data_size -= MD5OutputStreamTest.outputPartialBuffer(ran, out1, out2, data_size);
        }
        BufferedReader in = new BufferedReader(new InputStreamReader(proc.getInputStream()));
        ((OutputStream)out2).flush();
        ((OutputStream)out2).close();
        String native_sum = new StringTokenizer(in.readLine()).nextToken();
        in.close();
        String java_sum = MD5.asHex(out1.hash());
        if (!native_sum.equals(java_sum)) {
            out1.close();
            System.out.println("ERROR");
            System.out.println("java:   " + java_sum);
            System.out.println("native: " + native_sum);
            System.exit(1);
        }
        out1.close();
    }

    private static void outputSingleByte(Random ran, OutputStream out1, OutputStream out2) throws IOException {
        int b = ran.nextInt() & 0xFF;
        out1.write(b);
        out2.write(b);
    }

    private static long outputFullBuffer(Random ran, OutputStream out1, OutputStream out2, long max_bytes) throws IOException {
        int b_len = ran.nextInt();
        if (b_len < 0) {
            b_len = -b_len;
        }
        if ((long)(b_len %= 131072) > max_bytes) {
            b_len = (int)max_bytes;
        }
        byte[] b = new byte[b_len];
        ran.nextBytes(b);
        out1.write(b);
        out2.write(b);
        return b_len;
    }

    private static long outputPartialBuffer(Random ran, OutputStream out1, OutputStream out2, long max_bytes) throws IOException {
        int b_len = ran.nextInt();
        if (b_len < 0) {
            b_len = -b_len;
        }
        if ((long)(b_len %= 524288) > max_bytes) {
            b_len = (int)max_bytes;
        }
        if (b_len == 0) {
            return 0L;
        }
        byte[] b = new byte[b_len];
        ran.nextBytes(b);
        int off = ran.nextInt();
        if (off < 0) {
            off = -off;
        }
        if ((off %= b_len) == b_len) {
            return 0L;
        }
        int len = ran.nextInt();
        if (len < 0) {
            len = -len;
        }
        out1.write(b, off, len %= b_len - off);
        out2.write(b, off, len);
        return len;
    }
}

