/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.svnclientadapter;

import java.io.File;
import java.io.IOException;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.utils.StringUtils;

public class SVNBaseDir {
    protected static File getCommonPart(File file1, File file2) {
        String part2;
        String part1;
        String[] file2Parts;
        int parts2Length;
        String file2AbsPath;
        if (file1 == null) {
            return null;
        }
        if (file2 == null) {
            return null;
        }
        String file1AbsPath = file1.getAbsolutePath();
        if (file1AbsPath.equals(file2AbsPath = file2.getAbsolutePath())) {
            return new File(file1AbsPath);
        }
        String[] file1Parts = StringUtils.split(file1AbsPath, File.separatorChar);
        int parts1Length = file1Parts.length;
        int minLength = parts1Length < (parts2Length = (file2Parts = StringUtils.split(file2AbsPath, File.separatorChar)).length) ? parts1Length : parts2Length;
        StringBuffer commonsPart = new StringBuffer();
        for (int i = 0; i < minLength && (part1 = file1Parts[i]).equals(part2 = file2Parts[i]); ++i) {
            if (i > 0) {
                commonsPart.append(File.separatorChar);
            }
            commonsPart.append(part1);
        }
        if (commonsPart.length() == 0) {
            return null;
        }
        return new File(commonsPart.toString());
    }

    public static File getBaseDir(File file) {
        return SVNBaseDir.getBaseDir(new File[]{file});
    }

    public static File getBaseDir(File[] files) {
        File rootDir = SVNBaseDir.getRootDir(files);
        File baseDir = SVNBaseDir.getCommonPart(rootDir, new File("."));
        return baseDir;
    }

    public static File getRootDir(File[] files) {
        File[] canonicalFiles = new File[files.length];
        for (int i = 0; i < files.length; ++i) {
            canonicalFiles[i] = files[i].getAbsoluteFile();
        }
        File commonPart = canonicalFiles[0];
        for (int i = 0; i < files.length; ++i) {
            if ((commonPart = SVNBaseDir.getCommonPart(commonPart, canonicalFiles[i])) != null) continue;
            return null;
        }
        if (commonPart.isFile()) {
            return commonPart.getParentFile();
        }
        return commonPart;
    }

    public static String getRelativePath(File rootDir, File file) throws SVNClientException {
        try {
            String rootPath = rootDir.getCanonicalPath();
            String filePath = file.getCanonicalPath();
            if (!filePath.startsWith(rootPath)) {
                return null;
            }
            return filePath.substring(rootPath.length());
        }
        catch (IOException e) {
            throw SVNClientException.wrapException(e);
        }
    }
}

