#!/bin/sh

#Copyright (C) since 2013 NEC Corporation
# version 2.0
#
#<License>
#
#This program is distributed in the hope that it will be useful,
#but WITHOUT ANY WARRANTY; without even the implied warranty of
#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.

# bash configuration
SCRIPT_DIR=$(cd $(dirname $0);pwd)
. ${SCRIPT_DIR}/install.cfg

USER=`/usr/bin/whoami`

. ${SCRIPT_DIR}/lib/en_install.lng || exit -1

function exitLog() {
  date +"### Hinemos Web Client installer ended at %Y-%m-%d %H:%M:%S ###" >> ${INSTALL_LOG}
}

checkUser() {
    echo
    echo "${MSG_I002}"

    if [ "x"$USER != "xroot" ] ; then
	echo "[NG]"
	echo "${MSG_E002}"
	echo "${MSG_E004}"; return 1
    fi

    echo "[OK]"
}

########################################
# SHELL
########################################

checkUser || exit 2

trap exitLog 0

date +"### Hinemos Web Client installer started at %Y-%m-%d %H:%M:%S ###" >> ${INSTALL_LOG}
${SCRIPT_DIR}/install_all.sh en 2>&1 | tee -ai ${INSTALL_LOG}
exit $?
