#!/bin/sh

# Copyright (C) since 2013 NEC Corporation
# version 2.0
# 
# <License>
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.

################################################################################
# Bash preparation
################################################################################
SCRIPT_DIR=$(cd $(dirname $0);pwd)
. ${SCRIPT_DIR}/install.cfg || exit -1

USER=`/usr/bin/whoami`

# load language file
LANGUAGE=$1
if [ ! -f ${SCRIPT_DIR}/lib/${LANGUAGE}_uninstall.lng ]
then
    echo "not supported language : ${LANGUAGE}"
    exit 1
fi
. ${SCRIPT_DIR}/lib/${LANGUAGE}_uninstall.lng || exit -1

################################################################################
# Function
################################################################################

echoOK() {
    echo "[OK]"
}

echoNG() {
    echo "[NG]"
}

########################################
# Prepare
########################################

checkUser() {
    echo
    echo "${MSG_I001}"

    if [ "x"$USER != "xroot" ] ; then
	echoNG
	echo "${MSG_E001}"
	echo "${MSG_I002}"; return 1
    fi

    echoOK
}

checkInstallDir() {
    echo
    echo "${MSG_I006}"

    if [ -d "$HINEMOS_WEB_HOME" ] ; then
	echoOK
    else
	echoNG
	echo "${MSG_E005}"
	echo "${MSG_I002}"; return 1
    fi

    if [ -f $HINEMOS_WEB_HOME/_installation ] ; then
	. $HINEMOS_WEB_HOME/_installation || exit -1
    else
	echo
	echo "${MSG_I002}"; return 1
    fi
}

checkTomcatType() {
    # 0 for community version, 1 for rh6 rpm version.
    if [ -d ${APSERVER_PATH}/bin ] ; then
	TOMCAT_TYPE=0
    else
	TOMCAT_TYPE=1
    fi
}

checkDepolyedFile() {
    echo
    echo "${MSG_I003}"

    if [ "$APSERVER_TYPE" -eq 1 ] ; then
	DEPOLY_FILE=${JBOSS_CONFIG_PATH}/deploy/hinemos_web.war 
    else
	checkTomcatType

	if [ "$TOMCAT_TYPE" -eq 0 ] ; then
	    DEPOLY_FILE=${APSERVER_PATH}/conf/Catalina/localhost/hinemos.xml 
	else
	    DEPOLY_FILE=${APSERVER_PATH}/Catalina/localhost/hinemos.xml 
	fi
    fi

    if [ ! -d "$APSERVER_PATH" ] ; then
	echoNG
	echo "${MSG_I002}"; return 1
    fi

    if [ "$APSERVER_TYPE" -eq 1 ] ; then
	if [ ! -d "$JBOSS_CONFIG_PATH" ] ; then
	    echoNG
	    echo "${MSG_I002}"; return 1
	fi
    fi

    if [ ! -f "$DEPOLY_FILE" ] ; then
	echoNG
	echo "${MSG_I002}"; return 1
    fi

    echoOK
}

getMinDate() {
    minDate=99999999999999

    ls "$1"* > /dev/null 2>&1
    if [ $? -eq 0 ] ; then
	for file in "$1"* ; do
	    fileName=`basename "$file"`
	    installDate=`echo "$fileName" | cut -d_ -f2`
	    if [ "$minDate" -gt "$installDate" ] ; then
		minDate=$installDate
	    fi
	done
    fi
}

checkBackupFile() {
    echo
    echo "${MSG_I004}"

    local serverXmlPrefix

    if [ "$APSERVER_TYPE" -eq 1 ] ; then
	# server.xml
	SERVER_XML=${JBOSS_CONFIG_PATH}/deploy/jbossweb.sar/server.xml
	serverXmlPrefix=${SERVER_XML}_

	# run.conf
	RUN_CONF=${APSERVER_PATH}/bin/run.conf
	local runConfPrefix=${RUN_CONF}_

	getMinDate $runConfPrefix
	if [ -f ${runConfPrefix}${minDate} ] ; then
	    RUN_CONF_BACKUP=${runConfPrefix}${minDate}
	fi
    else
	if [ "$TOMCAT_TYPE" -eq 0 ] ; then
	    SERVER_XML=${APSERVER_PATH}/conf/server.xml
	else
	    SERVER_XML=${APSERVER_PATH}/server.xml
	fi
	serverXmlPrefix=${SERVER_XML}_
    fi

    getMinDate $serverXmlPrefix
    if [ -f ${serverXmlPrefix}${minDate} ] ; then
	SERVER_XML_BACKUP=${serverXmlPrefix}${minDate}
    fi

    echoOK
}

welcome() {
    local version
    if [ -e ${HINEMOS_WEB_HOME}/_version ] ; then
	version=`cat ${HINEMOS_WEB_HOME}/_version`
    else
	version="UNKNOWN"
    fi

    echo
    echo "-------------------------------------------------------"
    echo "     Uninstaller for Hinemos Web Client"
    echo "                             Version ${version}"
    echo
    echo "       Copyright (C) NEC Corporation 2012. All Rights Reserved."
    echo "-------------------------------------------------------"

}

showUninstallationInfo() {
    echo
    echo "${MSG_I009}"

    printf "${MSG_I010}\n" $DEPOLY_FILE
    if [ "x"$SERVER_XML_BACKUP != "x" ] ; then
	printf "${MSG_I013}\n" $SERVER_XML_BACKUP
	if [ "$APSERVER_TYPE" -eq 1 ] ; then
	    [ "x"$RUN_CONF_BACKUP != "x" ] && printf "${MSG2_I001}\n" $RUN_CONF_BACKUP
	fi
    else
	if [ "$APSERVER_TYPE" -eq 1 ] ; then
	    [ "x"$RUN_CONF_BACKUP != "x" ] && printf "${MSG_I013}\n" $RUN_CONF_BACKUP
	fi
    fi
    printf "${MSG_I012}\n" $HINEMOS_WEB_HOME

    echo
    echo "${MSG_I008}"
}

confirmUninstall() {
    echo

    local input
    while : ; do
	read -p "${MSG_I007}: " input
	input=${input:-N}
	case $input in
	    y|Y)
		break
		;;
	    n|N)
		echo "${MSG_I002}"
		return 1
		break
		;;
	    *)
		echo "${MSG_W001}"
		;;
	esac
    done
}

undeploy() {
    echo
    echo "${MSG_I014}"

    rm -f "$DEPOLY_FILE"
    if [ $? -eq 0 ] ; then
	echoOK
    else
	echoNG
	printf "${MSG_E003}\n" $DEPOLY_FILE
	echo "${MSG_I002}"; return 1
    fi
}

revertBackupFile() {
    echo
    echo "${MSG_I015}"

    if [  "x"$SERVER_XML_BACKUP != "x" ] ; then
	cp -pf $SERVER_XML_BACKUP $SERVER_XML
	if [ $? -ne 0 ] ; then
	    echoNG
	    printf "${MSG2_E001}" $SERVER_XML
	    echo "${MSG_I002}" ; return 1
	fi
    fi

    if [ "x"$RUN_CONF_BACKUP != "x" ] ; then
	cp -pf $RUN_CONF_BACKUP $RUN_CONF
	if [ $? -ne 0 ] ; then
	    echoNG
	    printf "${MSG2_E001}" $RUN_CONF
	    echo "${MSG_I002}" ; return 1
	fi
    fi

    echoOK
}

removeInstallDir() {
    echo
    echo "${MSG_I018}"

    rm -rf "$HINEMOS_WEB_HOME"
    if [ $? -eq 0 ] ; then
	echoOK
    else
	echoNG
	echo "${MSG_E006}"
	echo "${MSG_W002}"
	echo "${MSG_I002}"; return 1
    fi
}

################################################################################
# Main
################################################################################

# checkUser || exit 2 
checkInstallDir && checkDepolyedFile || exit 3
checkBackupFile || exit 4

welcome

showUninstallationInfo

confirmUninstall || exit 5

undeploy || exit 6

revertBackupFile || exit 7

removeInstallDir || exit 8

echo
echo "${MSG_I016}"
echo "${MSG_I017}"

################################################################################
# Exit Code List
# -1    Failed to Execute source command.
#  0    Success.
#  1    Not Support Language.
#  2 	Non-root user.				(3.2.1)   
#  3    Remove target check failed.		(3.2.2)
#  4    Backup file check failed.		(3.2.3)
#  5    User cancelled installation.		(3.2.5)
#  6    Failed to undeploy.			(3.2.6)
#  7    Failed to revert backup file.		(3.2.7)
#  8    Failed to remove hinemos_web.		(3.2.8)
################################################################################
