<%--
 
Copyright (C) NEC Corporation 2012-2013. All Rights Reserved. 
Copyright (C) NEC Soft, Ltd. 2012-2013. All Rights Reserved. 
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
--%>

<%@page pageEncoding="UTF-8"%>
<%@ taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt" %>
<fmt:setBundle basename="com.necsoft.hinemos.webclient.lang.messages"/>
<div>
	<div class="view-btns-container">
		<button title="<fmt:message key="confirmed"/>" disabled="disabled" class="ui-button ui-state-default" id="confirmed">
			<span class="ui-icon ui-icon-hnm-booltrue"></span>
		</button>
		<button title="<fmt:message key="unconfirm"/>" disabled="disabled" class="ui-button ui-state-default" id="unconfirm">
			<span class="ui-icon ui-icon-hnm-unconfirm"></span>
		</button>
		<button title="<fmt:message key="confirm.all"/>" class="ui-button" id="batchconfirm">
			<span class="ui-icon ui-icon-hnm-batchconfirm"></span>
		</button>
		<span class="ui-icon ui-icon-seperator" ></span>
		<button title="<fmt:message key="detail"/>" disabled="disabled" class="ui-button ui-state-default" id="detail">
			<span class="ui-icon ui-icon-hnm-detail"></span>
		</button>
		<button title="<fmt:message key="update"/>" class="ui-button" id="update">
			<span class="ui-icon ui-icon-hnm-update"></span>
		</button>
		<button title="<fmt:message key="filter"/>" class="ui-button" id="filter">
			<span class="ui-icon ui-icon-hnm-filter"></span>
		</button>
		<button title="<fmt:message key="show.tree"/>" class="ui-button ui-button-active" id="toggle_view">
			<span class="ui-icon ui-icon-hnm-show"></span>
		</button>
	</div>
	<div id="body">
		<div>
			<div id="tree" class="element-body"></div>
		</div>
		<div>
			<table id="grid" class="element-body"></table>
			<div id="grid_pager"></div>
			<div class="contextMenu" id="menu_rightclick" style="display:none">
				<ul class="contextmenu_width_event">
					<li id="detail">
						<span class="ui-icon ui-icon-hnm-detail" style="float:left"></span>
						<span class="action-span-menu"><fmt:message key="detail"/></span>
					</li>
					<hr size="1" style="margin: 3px;">
					<li id="confirmed">
						<span class="ui-icon ui-icon-hnm-booltrue" style="float:left"></span>
						<span class="action-span-menu"><fmt:message key="confirmed"/></span>
					</li>
					<li id="unconfirm">
						<span class="ui-icon ui-icon-hnm-unconfirm" style="float:left"></span>
						<span class="action-span-menu"><fmt:message key="unconfirm"/></span>
					</li>
				</ul>
			</div>
		</div>
	</div>
</div>
