/*
 * Decompiled with CFR 0.152.
 */
package com.necsoft.hinemos.webclient.installer;

import java.io.File;
import java.io.FileOutputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class ServerXmlModifier {
    public static void main(String[] args) {
        if (args.length < 2) {
            System.exit(1);
        }
        String sourceFilePath = args[0];
        String targetFilePath = args[1];
        try {
            File sourceFile = new File(sourceFilePath);
            DocumentBuilder docBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document document = docBuilder.parse(sourceFile);
            ServerXmlModifier.modifyXml(document);
            ServerXmlModifier.writeToFile(document, targetFilePath);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void modifyXml(Document document) {
        NodeList connectorList = document.getElementsByTagName("Connector");
        int i = 0;
        while (i < connectorList.getLength()) {
            Element connectorElm = (Element)connectorList.item(i);
            Attr protocol = connectorElm.getAttributeNode("protocol");
            Attr port = connectorElm.getAttributeNode("port");
            if ((protocol == null || protocol.getNodeValue().equals("HTTP/1.1")) && port.getNodeValue().equals("8080")) {
                port.setNodeValue("80");
            }
            ++i;
        }
    }

    public static void writeToFile(Document sourceDocument, String targetFilePath) throws Exception {
        FileOutputStream fos = null;
        try {
            File targetFile = new File(targetFilePath);
            fos = new FileOutputStream(targetFile);
            StreamResult result = new StreamResult(fos);
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            DOMSource domSource = new DOMSource(sourceDocument);
            transformer.transform(domSource, result);
        }
        finally {
            if (fos != null) {
                fos.close();
            }
        }
    }
}

