#!/bin/sh

#Copyright (C) since 2012 NEC Corporation
# version 2.0
#
# <License>
#
#This program is distributed in the hope that it will be useful,
#but WITHOUT ANY WARRANTY; without even the implied warranty of
#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# <License>

# bash configuration
SCRIPT_DIR=$(cd $(dirname $0);pwd)
. ${SCRIPT_DIR}/install.cfg || exit -1

USER=`/usr/bin/whoami`

. ${SCRIPT_DIR}/lib/ja_uninstall.lng || exit -1

function sigintHandle() {
  echo "アンインストーラーは取り消し不可能なファイル操作を行います。"
    echo "中断操作は行わないでください。"
}

checkUser() {
    echo
    echo "${MSG_I001}"

    if [ "x"$USER != "xroot" ] ; then
	echo "[NG]"
	echo "${MSG_E001}"
	echo "${MSG_I002}"; return 1
    fi

    echo "[OK]"
}

########################################
# SHELL
########################################

checkUser || exit 2

trap sigintHandle 2
date +"### Hinemos Web アンインストーラー started at %Y-%m-%d %H:%M:%S ###" >> ${UNINSTALL_LOG}
${SCRIPT_DIR}/uninstall_all.sh ja 2>&1 | tee -a ${UNINSTALL_LOG}
date +"### Hinemos Web アンインストーラー ended at %Y-%m-%d %H:%M:%S ###" >> ${UNINSTALL_LOG}

exit $?

