/*
 
Copyright (C) NEC Corporation 2012. All Rights Reserved. 
Copyright (C) NEC Soft, Ltd. 2012. All Rights Reserved. 
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/


package com.necsoft.hinemos.webclient.util;

import java.io.InputStream;
import java.util.Properties;

import javax.servlet.ServletException;

import org.apache.log4j.Logger;

public class HinemosWebProperty {
    private static Logger log = Logger.getLogger(HinemosWebProperty.class);

    private static final String CONF_FILE_PATH = "hinemos_web.cfg";

    private static boolean initialized = false;

    private static Properties props = null;

    public static synchronized void init(String realRootPath)
            throws ServletException {
        if (!initialized) {
            initialized = true;
            props = new Properties();
            getResourceProperties(realRootPath);
        }
    }

    private synchronized static void getResourceProperties(String realRootPath)
            throws ServletException {
        try {
            // Get the inputStream
            InputStream inputStream = HinemosWebProperty.class.getClassLoader()
                    .getResourceAsStream(CONF_FILE_PATH);
            // this.getClass().getClassLoader().getResourceAsStream(CONF_FILE_PATH);

            if (inputStream != null) {
                // Load the InputStream using the Properties
                props.clear();
                props.load(inputStream);

                // Release resource stream
                inputStream.close();
            } else {
                log.error("File '" + CONF_FILE_PATH + "' does not exist");
            }
        } catch (Exception e) {
            log.error(e.toString());
        }
    }

    /**
     * @param key
     * @return
     */
    public static String getConfig(String key) {
        return props.getProperty(key);
    }

    /**
     * @param key
     * @param def
     * @return
     */
    public static String getConfig(String key, String def) {
        return props.getProperty(key, def);
    }
}