/*
 
Copyright (C) NEC Corporation 2012. All Rights Reserved. 
Copyright (C) NEC Soft, Ltd. 2012. All Rights Reserved. 
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/



package com.necsoft.hinemos.webclient.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

import com.necsoft.hinemos.webclient.bean.TableColumnInfoJs;
import com.necsoft.hinemos.webclient.common.JsConstant;
import com.necsoft.hinemos.webclient.common.SWT;

/**
 * This class used for convert list.
 * 
 * @version 1.0
 * @since 2011/12/14
 */
public class ConvertListUtil {

    /**
     * This method used for convert columnInfo to ColNames.
     * 
     * @param list
     *            : ArrayList<TableColumnInfoJs>
     * @return ArrayList<String>
     */
    public static ArrayList<String> columnInfoToColNames(
            ArrayList<TableColumnInfoJs> list) {

        ArrayList<String> ret = new ArrayList<String>();
        Iterator<TableColumnInfoJs> itr = list.iterator();
        while (itr.hasNext()) {
            TableColumnInfoJs info = itr.next();
            ret.add(info.getName());
        }
        return ret;
    }

    /**
     * This method used for convert columnInfo to ColModel
     * 
     * @param list
     *            : ArrayList<TableColumnInfoJs>
     * @return ArrayList<HashMap>
     */
    public static ArrayList<Map<String, Object>> columnInfoToColModel(
            ArrayList<TableColumnInfoJs> list) {
        return columnInfoToColModel(list, false);
    }

    /**
     * This method used for convert columnInfo to ColModel
     * 
     * @param list
     *            : ArrayList<TableColumnInfoJs>
     * @return ArrayList<HashMap>
     */
    public static ArrayList<Map<String, Object>> columnInfoToColModel(
            ArrayList<TableColumnInfoJs> list, boolean indexlikeName) {

        ArrayList<Map<String, Object>> ret = new ArrayList<Map<String, Object>>();
        Iterator<TableColumnInfoJs> itr = list.iterator();
        int index = 0;
        while (itr.hasNext()) {
            Map<String, Object> model = new HashMap<String, Object>();
            TableColumnInfoJs info = itr.next();

            // That property is necessary when we need post data which is gotten
            // from row of grid
            String name = "";
            if (info.getModelName() != null) {
                name = info.getModelName();
            } else {
                name = JsConstant.getColNameValue(index);
            }

            if (!name.equals("")) {
                model.put(JsConstant.GRID_MODEL_NAME, name);
            }

            if (indexlikeName && !name.equals("")) {
                // Index of row will same to Name
                model.put(JsConstant.GRID_MODEL_INDEX, name);
            } else {
                // Index of row will be it's position in array
                model.put(JsConstant.GRID_MODEL_INDEX, String.valueOf(index));
            }

            // The with property of column
            if (info.getWidth() != 0) {
                model.put(JsConstant.GRID_MODEL_WIDTH, info.getWidth());
            } else {
                model.put(JsConstant.GRID_MODEL_HIDDEN, true);
            }

            // The align property of column
            model.put(JsConstant.GRID_MODEL_ALIGN,
                    SWT.getHorStyle(info.getStyle()));

            /*
             * Bellow properties are options
             */
            // Set key
            if (info.isKey()) {
                model.put(JsConstant.GRID_MODEL_KEY, true);
            }

            // Classes
            if ((info.getClasses() != null) && (!info.getClasses().equals(""))) {
                model.put(JsConstant.GRID_MODEL_CLASSES, info.getClasses());
            }

            // The property "sortable" of grid default is true, therefore, we
            // will set, this property when it is false
            if (!info.isSortable()) {
                model.put(JsConstant.GRID_MODEL_SORTABLE, false);
            }

            // Set formatter
            if ((info.getFormatter() != null)
                    && (!info.getFormatter().equals(""))) {
                model.put(JsConstant.GRID_MODEL_FORMATTER, info.getFormatter());
            }

            // Set formate options
            if (info.getFormatoptions() != null) {
                model.put(JsConstant.GRID_MODEL_FORMAT_OPTIONS,
                        info.getFormatoptions());
            }

            // Set sort type
            if ((info.getSorttype() != null)
                    && (!info.getSorttype().equals(""))) {
                model.put(JsConstant.GRID_MODEL_SORT_TYPE, info.getSorttype());
            }

            ret.add(model);
            // Increase index
            index++;
        }
        return ret;
    }
}