/*
 
Copyright (C) NEC Corporation 2012. All Rights Reserved. 
Copyright (C) NEC Soft, Ltd. 2012. All Rights Reserved. 
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/


package com.necsoft.hinemos.webclient.repository.servlet;

import java.io.IOException;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.jnp.interfaces.NamingContext;

import com.necsoft.hinemos.webclient.exception.HinemosWebAccessException;
import com.necsoft.hinemos.webclient.exception.HinemosWebException;
import com.necsoft.hinemos.webclient.exception.HinemosWebInvalidRequestParameterException;
import com.necsoft.hinemos.webclient.exception.HinemosWebRemoteException;
import com.necsoft.hinemos.webclient.json.CommonJson;
import com.necsoft.hinemos.webclient.repository.business.GetNodeScopeBusiness;
import com.necsoft.hinemos.webclient.repository.form.NodeScopeForm;
import com.necsoft.hinemos.webclient.servlet.CommonServlet;
import com.necsoft.hinemos.webclient.util.ExceptionHandlerUtils;
import com.necsoft.hinemos.webclient.util.LogUtils;
import com.necsoft.hinemos.webclient.util.PopulateBeanUtils;

/**
 * This class used for display data of NodeScope view
 * 
 * @version 1.0
 * @date 2011/12/14
 */
public class GetNodeScopeServlet extends CommonServlet {

    private static final long serialVersionUID = -7775038566425028930L;

    private static LogUtils logUtils = LogUtils
            .getLogUtils(GetNodeScopeServlet.class);

    public CommonJson process(HttpServletRequest request,
            HttpServletResponse response) throws ServletException, IOException,
            HinemosWebAccessException {

        // 中間変数を宣言
        CommonJson result = new CommonJson();
        NamingContext namingContext = null;
        try {
            // NammingContextを取得する
            namingContext = doLoadNamingContext(request);
            // get data
            result = getNodeScope(request, namingContext);
        } catch (HinemosWebAccessException ex) {
            logUtils.info(ex.getMessage());
            throw new HinemosWebAccessException();
        } catch (HinemosWebRemoteException ex) {
            logUtils.error(ex.getMessage(), ex.getCause());
            result = ExceptionHandlerUtils.doBuildCommonJson(
                    ExceptionHandlerUtils.LEVEL_WARNING, ex.getMessage(),
                    request.getLocale());

        } catch (Exception ex) {
            logUtils.error(ex.getMessage(), ex.getCause());
            result = ExceptionHandlerUtils.doBuildCommonJson(
                    ExceptionHandlerUtils.LEVEL_ERROR, ex.getMessage(),
                    request.getLocale());
        }
        return result;
    }

    private CommonJson getNodeScope(HttpServletRequest request,
            NamingContext namingContext) throws IOException,
            HinemosWebException {
        // 中間変数を宣言
        NodeScopeForm form = new NodeScopeForm();
        PopulateBeanUtils.populateBean(form, request);

        if (!isValidRequestParam(form)) {
            throw new HinemosWebInvalidRequestParameterException(
                    "exception.repository.nodescope.param");
        }

        GetNodeScopeBusiness business = new GetNodeScopeBusiness();

        return business.getNodeScope(form, namingContext);

    }

    private boolean isValidRequestParam(NodeScopeForm form) {
        boolean isValid = true;
        String facilityId = form.getFacilityId();

        // Check request facilityId (manager)
        // http リクエストからユーザID判定する
        if (facilityId == null || facilityId.equals("")) {
            isValid = false;
            logUtils.error("facilityId is invalid", facilityId);
        }

        return isValid;
    }
}
