/*
 
Copyright (C) NEC Corporation 2012. All Rights Reserved. 
Copyright (C) NEC Soft, Ltd. 2012. All Rights Reserved. 
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/


package com.necsoft.hinemos.webclient.monitor.business;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Locale;

import org.apache.commons.lang.StringEscapeUtils;
import org.jnp.interfaces.NamingContext;

import com.clustercontrol.monitor.bean.ScopeTableDefine;
import com.necsoft.hinemos.webclient.composite.CommonTableViewerSorter;
import com.necsoft.hinemos.webclient.exception.HinemosWebException;
import com.necsoft.hinemos.webclient.json.GridDataJson;
import com.necsoft.hinemos.webclient.monitor.action.GetFilterScope;
import com.necsoft.hinemos.webclient.monitor.form.MonitorScopeForm;
import com.necsoft.hinemos.webclient.monitor.util.ConvertListUtil;
import com.necsoft.hinemos.webclient.util.SortOrderUtil;

public class GetScopeListBusiness {

    public ArrayList<ArrayList<Object>> getScopeList(MonitorScopeForm form,
            NamingContext namingContext) throws HinemosWebException {
        // スコープ情報一覧データ(ScopeInfoData)を取得
        GetFilterScope getFilterScope = new GetFilterScope();
        getFilterScope.setNamingContext(namingContext);
        ArrayList<ArrayList<Object>> listInfoData = null;

        listInfoData = getFilterScope.getFilterInfo(StringEscapeUtils
                .unescapeHtml(form.getFacilityId()));

        doSortListInfoData(form, listInfoData);

        ConvertListUtil.sanitizeScopeInfoData(listInfoData);

        return listInfoData;
    }

    private void doSortListInfoData(MonitorScopeForm form,
            ArrayList<?> listInfoData) {
        // Get sorting parameter
        int sortColumnIndex = ScopeTableDefine.SORT_COLUMN_INDEX;
        int sortOrder = ScopeTableDefine.SORT_ORDER;
        if (form.getSidx() != null && !("").equals(form.getSidx().trim())) {
            sortColumnIndex = Integer.valueOf(form.getSidx());
        }
        if (form.getSord() != null && !("").equals(form.getSord().trim())) {
            sortOrder = SortOrderUtil.getSerInt(form.getSord());
        }

        // データをソート
        Collections.sort(listInfoData, new CommonTableViewerSorter(
                sortColumnIndex, -1, sortOrder));
    }

    public GridDataJson doConvertToJson(
            ArrayList<ArrayList<Object>> listInfoData, Locale locale) {
        // Create JSON
        GridDataJson result = new GridDataJson();

        // Set rows
        for (int countRow = 0; countRow < listInfoData.size(); countRow++) {
            ArrayList<Object> infoData = listInfoData.get(countRow);
            result.addRow(infoData, String.valueOf(countRow + 1));
        }

        // Set other content
        result.setRecords(listInfoData.size());
        return result;
    }
}
