/*
 
Copyright (C) NEC Corporation 2012. All Rights Reserved. 
Copyright (C) NEC Soft, Ltd. 2012. All Rights Reserved. 
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/


package com.necsoft.hinemos.webclient.monitor.business;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

import org.apache.commons.lang.StringEscapeUtils;
import org.jnp.interfaces.NamingContext;

import com.clustercontrol.bean.Property;
import com.clustercontrol.bean.PropertyConstant;
import com.necsoft.hinemos.webclient.bean.PropertyValue;
import com.necsoft.hinemos.webclient.common.JsConstant;
import com.necsoft.hinemos.webclient.exception.HinemosWebException;
import com.necsoft.hinemos.webclient.exception.HinemosWebInvalidDataException;
import com.necsoft.hinemos.webclient.json.GridDataJson;
import com.necsoft.hinemos.webclient.monitor.action.GetEventInfoProperty;
import com.necsoft.hinemos.webclient.monitor.form.EventInfoPropertyForm;

public class GetEventInfoPropertyBusiness {

    public Property getEventInfoProperty(EventInfoPropertyForm form,
            NamingContext namingContext, Locale locale)
            throws HinemosWebException {
        Property propertyEvent = null;
        // イベント情報一覧を取得
        GetEventInfoProperty getEventInfoProperty = new GetEventInfoProperty();
        getEventInfoProperty.setNamingContext(namingContext);
        propertyEvent = getEventInfoProperty.getProperty(StringEscapeUtils
                .unescapeHtml(form.getMonitorId()), StringEscapeUtils
                .unescapeHtml(form.getPluginId()), StringEscapeUtils
                .unescapeHtml(form.getFacilityId()),
                new Date(form.getReceiveTime()), locale);

        if (propertyEvent == null) {
            throw new HinemosWebInvalidDataException(
                    "exception.monitor.event.info.data");
        }
        return propertyEvent;
    }

    public GridDataJson doConvertToJson(Property propertyEvent, String language) {
        GridDataJson result = new GridDataJson();
        Object[] properties = propertyEvent.getChildren();
        for (Object object : properties) {
            Property property = (Property) object;
            List<Object> row = new ArrayList<Object>();

            String type;
            Map<String, Object> option = null;
            PropertyValue objValue = new PropertyValue();
            String editor = property.getEditor();
            Object value = property.getValue();

            // Check null for editor
            if (editor == null) {
                editor = PropertyConstant.EDITOR_TEXT;
            }

            if (editor.equals(PropertyConstant.EDITOR_BOOL)) {
                type = JsConstant.PROPERTY_TYPE_BOOL;
                option = new HashMap<String, Object>();
                option.put("disabled", true);
            } else if (editor.equals(PropertyConstant.EDITOR_TEXTAREA)) {
                type = JsConstant.PROPERTY_TYPE_TEXTAREA;
                value = StringEscapeUtils.escapeHtml(value.toString());
            } else if (editor.equals(PropertyConstant.EDITOR_DATETIME)) {
                type = JsConstant.PROPERTY_TYPE_DATETIME;
                if (value != null) {
                    value = ((Date) value).getTime();
                }
            } else {
                type = JsConstant.PROPERTY_TYPE_TEXT;
                value = StringEscapeUtils.escapeHtml(value.toString());
            }

            // Set object
            objValue.setType(type);
            objValue.setValue(value);
            if (option != null) {
                objValue.setOption(option);
            }

            row.add(property.getName());
            row.add(objValue);
            result.addRow(row);
        }

        // Set other content
        result.setRecords(properties.length);
        return result;
    }
}
