/*
 
Copyright (C) NEC Corporation 2012. All Rights Reserved. 
Copyright (C) NEC Soft, Ltd. 2012. All Rights Reserved. 
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.necsoft.hinemos.webclient.monitor.action;

import java.rmi.AccessException;
import java.rmi.RemoteException;
import java.util.ArrayList;

import javax.ejb.CreateException;
import javax.naming.NamingException;

import org.jnp.interfaces.NamingContext;

import com.clustercontrol.FacilityNotFoundException;
import com.clustercontrol.HinemosUnknownException;
import com.clustercontrol.monitor.bean.ScopeInfoData;
import com.clustercontrol.monitor.ejb.session.MonitorController;
import com.necsoft.hinemos.webclient.exception.HinemosWebAccessException;
import com.necsoft.hinemos.webclient.exception.HinemosWebException;
import com.necsoft.hinemos.webclient.exception.HinemosWebRemoteException;
import com.necsoft.hinemos.webclient.monitor.util.ConvertListUtil;
import com.necsoft.hinemos.webclient.monitor.util.EjbConnectionManager;

/**
 * 監視[スコープ]ビューの一覧情報を取得するクライアント側アクションクラス<BR>
 * 
 * マネージャにSessionBean経由でアクセスし、スコープ一覧情報を取得します。
 * 
 * @version 1.0.0
 * @since 1.0.0
 */
public class GetFilterScope {

    // ----- コンストラクタ ----- //

    // ----- instance メソッド ----- //
    // namingContextを定義
    private NamingContext m_namingContext = null;

    /**
     * namingContextを設定
     * 
     * @param namingContext
     * @return void
     */
    public void setNamingContext(NamingContext namingContext) {
        this.m_namingContext = namingContext;
    }

    /**
     * マネージャにSessionBean経由でアクセスし、スコープ情報一覧を取得します。
     * 
     * @param facilityId
     *            取得対象の親ファシリティID
     * @return スコープ情報一覧（Objectの2次元配列）
     * @throws HinemosWebException
     * 
     * @see com.clustercontrol.monitor.util.EjbConnectionManager
     * @see com.clustercontrol.monitor.ejb.session.MonitorController
     * @see com.clustercontrol.monitor.ejb.session.MonitorControllerBean#getScopeList(String)
     */
    public ArrayList<ArrayList<Object>> getFilterInfo(String facilityId)
            throws HinemosWebException {

        EjbConnectionManager ejbConnectionManager = new EjbConnectionManager();
        ejbConnectionManager.setNamingContext(this.m_namingContext);
        MonitorController monitor = ejbConnectionManager.getMonitorController();

        ArrayList<ScopeInfoData> records = null;

        if (monitor == null) {
            return null;
        }

        try {
            records = monitor.getScopeList(facilityId, true, true, false);
        } catch (AccessException e) {
            // アクセス権なしの場合、エラーダイアログを表示する
            throw new HinemosWebAccessException(
                    "exception.monitor.scope.access", e);
        } catch (RemoteException e) {
            throw new HinemosWebRemoteException(
                    "exception.monitor.scope.remote", e);
        } catch (CreateException e) {
            throw new HinemosWebException("exception.monitor.scope.action", e);
        } catch (NamingException e) {
            throw new HinemosWebException("exception.monitor.scope.action", e);
        } catch (FacilityNotFoundException e) {
            throw new HinemosWebException("exception.monitor.scope.action", e);
        } catch (HinemosUnknownException e) {
            throw new HinemosWebException("exception.monitor.scope.action", e);
        }

        if (records == null) {
            return null;
        }

        return ConvertListUtil.scopeInfoDataListToArrayList(records);
    }

}