/*
 
Copyright (C) NEC Corporation 2012. All Rights Reserved. 
Copyright (C) NEC Soft, Ltd. 2012. All Rights Reserved. 
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.necsoft.hinemos.webclient.monitor.action;

import java.util.ArrayList;
import java.util.Locale;

import com.clustercontrol.monitor.bean.EventTableDefine;
import com.necsoft.hinemos.webclient.bean.TableColumnInfoJs;
import com.necsoft.hinemos.webclient.common.SWT;
import com.necsoft.hinemos.webclient.lang.WebMessages;
import com.necsoft.hinemos.webclient.monitor.util.MonitorMappingUtil;

/**
 * イベントテーブルヘッダの義クラス
 * 
 * @version 1.0.0
 * @since 1.0.0
**/
public class GetEventListTableDefine {
	/**
	 * 監視[イベント]ビューのテーブル定義情報を取得します。<BR><BR>
	 * リストに、カラム毎にテーブルカラム情報をセットします。
	 * 
	 * @return テーブル定義情報（{@link com.clustercontrol.bean.TableColumnInfo}のリスト）
	 * 
	 * @see com.clustercontrol.bean.TableColumnInfo#TableColumnInfo(java.lang.String, int, int, int)
	 * @see com.clustercontrol.monitor.bean.EventTableDefine
	 */
	public static ArrayList<TableColumnInfoJs> getEventListTableDefine(Locale locale) {
		
		//Locale locale = Locale.getDefault();
		
		/** テーブル情報定義配列 */
		ArrayList<TableColumnInfoJs> tableDefine = new ArrayList<TableColumnInfoJs>();

		tableDefine.add(EventTableDefine.PRIORITY,
				new TableColumnInfoJs(WebMessages.getString("priority", locale), TableColumnInfoJs.PRIORITY, 70, SWT.LEFT,
						MonitorMappingUtil.getEventName(EventTableDefine.PRIORITY)));
		tableDefine.add(EventTableDefine.RECEIVE_TIME, 
				new TableColumnInfoJs(WebMessages.getString("receive.time", locale), TableColumnInfoJs.NONE, 150, SWT.LEFT,
						MonitorMappingUtil.getEventName(EventTableDefine.RECEIVE_TIME)));
		tableDefine.add(EventTableDefine.OUTPUT_DATE, 
				new TableColumnInfoJs(WebMessages.getString("output.time", locale), TableColumnInfoJs.NONE, 150, SWT.LEFT,
						MonitorMappingUtil.getEventName(EventTableDefine.OUTPUT_DATE)));
		tableDefine.add(EventTableDefine.PLUGIN_ID, 
				new TableColumnInfoJs(WebMessages.getString("plugin.id", locale), TableColumnInfoJs.NONE, 100, SWT.LEFT,
						MonitorMappingUtil.getEventName(EventTableDefine.PLUGIN_ID)));
		tableDefine.add(EventTableDefine.MONITOR_ID, 
				new TableColumnInfoJs(WebMessages.getString("monitor.id", locale), TableColumnInfoJs.NONE, 100, SWT.LEFT,
						MonitorMappingUtil.getEventName(EventTableDefine.MONITOR_ID)));
		tableDefine.add(EventTableDefine.FACILITY_ID, 
				new TableColumnInfoJs(WebMessages.getString("facility.id", locale), TableColumnInfoJs.NONE, 100, SWT.LEFT,
						MonitorMappingUtil.getEventName(EventTableDefine.FACILITY_ID)));
		tableDefine.add(EventTableDefine.SCOPE, 
				new TableColumnInfoJs(WebMessages.getString("scope", locale), TableColumnInfoJs.FACILITY, 150, SWT.LEFT,
						MonitorMappingUtil.getEventName(EventTableDefine.SCOPE)));
		tableDefine.add(EventTableDefine.APPLICATION, 
				new TableColumnInfoJs(WebMessages.getString("application", locale), TableColumnInfoJs.NONE, 100, SWT.LEFT,
						MonitorMappingUtil.getEventName(EventTableDefine.APPLICATION)));
		tableDefine.add(EventTableDefine.MESSAGE_ID, 
				new TableColumnInfoJs(WebMessages.getString("message.id", locale), TableColumnInfoJs.NONE, 200, SWT.LEFT,
						MonitorMappingUtil.getEventName(EventTableDefine.MESSAGE_ID)));
		tableDefine.add(EventTableDefine.MESSAGE,
				new TableColumnInfoJs(WebMessages.getString("message", locale), TableColumnInfoJs.NONE, 200, SWT.LEFT,
						MonitorMappingUtil.getEventName(EventTableDefine.MESSAGE)));
		tableDefine.add(EventTableDefine.CONFIRMED, 
				new TableColumnInfoJs(WebMessages.getString("confirmed", locale), TableColumnInfoJs.CONFIRM, 50, SWT.LEFT,
						MonitorMappingUtil.getEventName(EventTableDefine.CONFIRMED)));
		tableDefine.add(EventTableDefine.CONFIRM_USER, 
				new TableColumnInfoJs(WebMessages.getString("confirm.user", locale), TableColumnInfoJs.NONE, 100, SWT.LEFT,
						MonitorMappingUtil.getEventName(EventTableDefine.CONFIRM_USER)));

		return tableDefine;
	}
}