/*
 
Copyright (C) NEC Corporation 2012. All Rights Reserved. 
Copyright (C) NEC Soft, Ltd. 2012. All Rights Reserved. 
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.necsoft.hinemos.webclient.monitor.action;

import java.rmi.AccessException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;

import javax.ejb.CreateException;
import javax.ejb.FinderException;
import javax.naming.NamingException;

import org.jnp.interfaces.NamingContext;

import com.clustercontrol.bean.ConfirmConstant;
import com.clustercontrol.monitor.ejb.session.MonitorController;
import com.clustercontrol.notify.monitor.ejb.entity.EventLogData;
import com.necsoft.hinemos.webclient.exception.HinemosWebAccessException;
import com.necsoft.hinemos.webclient.exception.HinemosWebException;
import com.necsoft.hinemos.webclient.exception.HinemosWebRemoteException;
import com.necsoft.hinemos.webclient.monitor.util.ConvertListUtil;
import com.necsoft.hinemos.webclient.monitor.util.EjbConnectionManager;

/**
 * イベント情報の確認を更新するクライアント側アクションクラス<BR>
 * 
 * マネージャにSessionBean経由でアクセスし、イベント情報の確認を更新します。
 * 
 */
public class ConfirmEvent {

    // ----- instance メソッド ----- //
    // namingContextを定義
    private NamingContext m_namingContext = null;

    /**
     * namingContextを設定
     * 
     * @param namingContext
     * @return void
     */
    public void setNamingContext(NamingContext namingContext) {
        this.m_namingContext = namingContext;
    }

    // ----- コンストラクタ ----- //

    // ----- instance メソッド ----- //

    /**
     * マネージャにSessionBean経由でアクセスし、引数で指定されたイベント情報一覧の確認を済に更新します。<BR>
     * <p>
     * 指定されたリストには、各イベント情報のリスト（{@link ArrayList}）が格納されています。
     * また、１イベント情報の各値は、テーブルの値を元とした、 EventLogData（
     * {@link com.clustercontrol.monitor.ejb.entity.EventLogData}
     * ）クラスのオブジェクトとして格納されています。
     * 
     * したがって、テーブルに表示されていない情報（例：オリジナルメッセージ）は格納されていません。
     * <p>
     * <dl>
     * <dt>イベント情報一覧（EventLogDataのリスト）</dt>
     * </dl>
     * 
     * @param list
     *            更新対象のイベント情報一覧（EventLogDataのリスト）
     * @return 更新に成功した場合、</code> true </code>
     * @throws HinemosWebException
     * 
     * @see com.clustercontrol.monitor.util.EjbConnectionManager
     * @see com.clustercontrol.monitor.ejb.session.MonitorController
     * @see com.clustercontrol.monitor.ejb.session.MonitorControllerBean#modifyConfirm(List,
     *      int)
     */
    public boolean confirm(List list) throws HinemosWebException {

        ArrayList<EventLogData> eventLogDataList = new ArrayList<EventLogData>();
        eventLogDataList = ConvertListUtil.listToEventLogDataList(list);

        if (eventLogDataList != null && eventLogDataList.size() > 0) {

            EjbConnectionManager ejbConnectionManager = new EjbConnectionManager();
            ejbConnectionManager.setNamingContext(this.m_namingContext);
            MonitorController monitor = ejbConnectionManager
                    .getMonitorController();

            try {
                monitor.modifyConfirm(eventLogDataList,
                        ConfirmConstant.TYPE_CONFIRMED);
                return true;
            } catch (AccessException e) {
                // アクセス権なしの場合、エラーダイアログを表示する
                throw new HinemosWebAccessException(
                        "exception.monitor.event.confirm.access", e);
            } catch (RemoteException e) {
                throw new HinemosWebRemoteException(
                        "exception.monitor.event.confirm.remote", e);
            } catch (CreateException e) {
                throw new HinemosWebException(
                        "exception.monitor.event.confirm.action", e);
            } catch (FinderException e) {
                throw new HinemosWebException(
                        "exception.monitor.event.confirm.action", e);
            } catch (NamingException e) {
                throw new HinemosWebException(
                        "exception.monitor.event.confirm.action", e);
            }
        }
        return false;
    }

    /**
     * マネージャにSessionBean経由でアクセスし、引数で指定されたイベント情報一覧の確認を未に更新します。<BR>
     * <p>
     * 指定されたリストには、各イベント情報のリスト（{@link ArrayList}）が格納されています。
     * また、１イベント情報の各値は、テーブルのカラム順（
     * {@link com.clustercontrol.monitor.bean.EventTableDefine}）にリストに格納されています。
     * <p>
     * <dl>
     * <dt>イベント情報一覧（Objectの2次元配列）</dt>
     * <dd>{ イベント情報1 {カラム1の値, カラム2の値, … }, イベント情報2{カラム1の値, カラム2の値, …}, … }</dd>
     * </dl>
     * 
     * @param list
     *            更新対象のイベント情報一覧（Objectの2次元配列）
     * @return 更新に成功した場合、</code> true </code>
     * 
     * @see com.clustercontrol.monitor.util.EjbConnectionManager
     * @see com.clustercontrol.monitor.ejb.session.MonitorController
     * @see com.clustercontrol.monitor.ejb.session.MonitorControllerBean#modifyConfirm(List,
     *      int)
     */
    /*
     * public boolean unconfirm(List list) {
     * 
     * ArrayList<EventLogData> eventLogDataList = new ArrayList();
     * eventLogDataList = ConvertListUtil.listToEventLogDataList(list);
     * 
     * // if (list != null && list.size()>0) { if (eventLogDataList != null &&
     * eventLogDataList.size()>0) {
     * 
     * EjbConnectionManager ejbConnectionManager = new EjbConnectionManager();
     * ejbConnectionManager.setNamingContext(this.m_namingContext);
     * MonitorController monitor = ejbConnectionManager.getMonitorController();
     * 
     * try { monitor.modifyConfirm(list, ConfirmConstant.TYPE_UNCONFIRMED);
     * monitor.modifyConfirm(eventLogDataList,
     * ConfirmConstant.TYPE_UNCONFIRMED); return true; } catch (RemoteException
     * e) { if(e instanceof AccessException){ // アクセス権なしの場合、エラーダイアログを表示する
     * MessageDialog.openInformation(null, Messages.getString("message"),
     * Messages.getString("message.accesscontrol.16")); } } catch
     * (CreateException e) { } catch (FinderException e) { } catch
     * (NamingException e) { } } return false; }
     */

    /**
     * マネージャにSessionBean経由でアクセスし、引数で指定された条件に一致するイベント情報の確認を一括更新します。
     * 
     * @param confirmType
     *            確認フラグ（未／済）（更新値）
     * @param facilityId
     *            ファシリティID
     * @param condition
     *            更新条件
     * @return 更新に成功した場合、</code> true </code>
     * 
     * @see com.clustercontrol.bean.ConfirmConstant
     * @see com.clustercontrol.monitor.util.EjbConnectionManager
     * @see com.clustercontrol.monitor.ejb.session.MonitorController
     * @see com.clustercontrol.monitor.ejb.session.MonitorControllerBean#modifyBatchConfirm(int,
     *      String, Property)
     */
    /*
     * public boolean confirmBatch(int confirmType, String facilityId, Property
     * condition) {
     * 
     * PropertyUtil.deletePropertyDefine(condition);
     * 
     * MonitorController monitor = EjbConnectionManager.getConnectionManager()
     * .getMonitorController();
     * 
     * try { monitor.modifyBatchConfirm(confirmType, facilityId, condition);
     * return true; } catch (RemoteException e) { if(e instanceof
     * AccessException){ // アクセス権なしの場合、エラーダイアログを表示する
     * MessageDialog.openInformation(null, Messages.getString("message"),
     * Messages.getString("message.accesscontrol.16")); } } catch
     * (CreateException e) { } catch (FinderException e) { } catch
     * (NamingException e) { } catch (SQLException e) { } return false; }
     */
}