/*
 
Copyright (C) NEC Corporation 2012. All Rights Reserved. 
Copyright (C) NEC Soft, Ltd. 2012. All Rights Reserved. 
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.necsoft.hinemos.webclient.json;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TwoGridDataJson extends CommonJson {
    private List<Map<String, Object>> leftData;

    private List<Map<String, Object>> rightData;

    private Map<String, Object> userdata;

    public TwoGridDataJson() {
        this.userdata = new HashMap<String, Object>();
    }

    public Map<String, Object> getUserdata() {
        return this.userdata;
    }

    public void setUserdata(Map<String, Object> userdata) {
        this.userdata = userdata;
    }

    public void addUserdata(String key, Object obj) {
        this.userdata.put(key, obj);
    }

    public void setLeftData(List<Map<String, Object>> leftData) {
        this.leftData = leftData;
    }

    public void addLeftRow(Map<String, Object> rowData) {
        leftData.add(rowData);
    }

    public List<Map<String, Object>> getLeftData() {
        return leftData;
    }

    public void setRightData(List<Map<String, Object>> rightData) {
        this.rightData = rightData;
    }

    public void addRightRow(Map<String, Object> rowData) {
        rightData.add(rowData);
    }

    public List<Map<String, Object>> getRightData() {
        return rightData;
    }
}
