/*
 
Copyright (C) NEC Corporation 2012. All Rights Reserved. 
Copyright (C) NEC Soft, Ltd. 2012. All Rights Reserved. 
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.necsoft.hinemos.webclient.jobmanagement.util;

import java.rmi.RemoteException;

import javax.ejb.CreateException;
import javax.naming.NamingException;

import org.apache.log4j.Logger;
import org.jnp.interfaces.NamingContext;

import com.clustercontrol.jobmanagement.ejb.session.JobController;
import com.clustercontrol.jobmanagement.ejb.session.JobControllerHome;

/**
 * EJBとのコネクションを管理するクラス
 * 
 * @version 1.0
 * @since 2011/12/14
 **/
public class EjbConnectionManager {

    private static Logger m_log = Logger.getLogger(EjbConnectionManager.class);

    // namingContextを定義
    private NamingContext m_ctx = null;

    /**
     * namingContextを設定
     * 
     * @param namingContext
     * @return void
     */
    public void setNamingContext(NamingContext namingContext) {
        this.m_ctx = namingContext;
    }

    /**
     * ジョブ管理SessionBeanのインスタンスを返します。
     * 
     * ログインマネージャにてコンテキストを取得し、 ジョブ管理SessionBeanのインスタンスを取得します。
     * 
     * @return ジョブ管理SessionBean
     * @see com.clustercontrol.util.LoginManager
     * @see com.clustercontrol.Job.ejb.session.JobController
     * @see com.clustercontrol.Job.ejb.session.JobControllerHome
     */
    public JobController getJobController() {
        JobControllerHome home;
        try {
            home = (JobControllerHome) this.m_ctx
                    .lookup(JobControllerHome.JNDI_NAME);
            return home.create();
        } catch (NamingException e) {
            m_log.error("getJobController: " +e.getMessage());
        } catch (RemoteException e) {
            m_log.error("getJobController: " +e.getMessage());
        } catch (CreateException e) {
            m_log.error("getJobController: " +e.getMessage());
        }
        m_ctx = null;
        return null;
    }
}
