/*
 
Copyright (C) NEC Corporation 2012. All Rights Reserved. 
Copyright (C) NEC Soft, Ltd. 2012. All Rights Reserved. 
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.necsoft.hinemos.webclient.jobmanagement.servlet;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Locale;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.clustercontrol.jobmanagement.bean.RunScheduleDetailListTableDefine;
import com.clustercontrol.jobmanagement.bean.RunScheduleDetailTableDefine;
import com.necsoft.hinemos.webclient.bean.TableColumnInfoJs;
import com.necsoft.hinemos.webclient.common.CssClass;
import com.necsoft.hinemos.webclient.common.JsConstant;
import com.necsoft.hinemos.webclient.exception.HinemosWebException;
import com.necsoft.hinemos.webclient.exception.HinemosWebHeaderInvalidException;
import com.necsoft.hinemos.webclient.exception.HinemosWebInvalidRequestParameterException;
import com.necsoft.hinemos.webclient.form.ScheduleTableDefineForm;
import com.necsoft.hinemos.webclient.jobmanagement.business.GetRunScheduleDetailListTableDefineBusiness;
import com.necsoft.hinemos.webclient.jobmanagement.business.GetRunScheduleDetailTableDefineBusiness;
import com.necsoft.hinemos.webclient.json.CommonJson;
import com.necsoft.hinemos.webclient.json.TwoGridHeadersJson;
import com.necsoft.hinemos.webclient.servlet.CommonServlet;
import com.necsoft.hinemos.webclient.util.ExceptionHandlerUtils;
import com.necsoft.hinemos.webclient.util.LogUtils;
import com.necsoft.hinemos.webclient.util.PopulateBeanUtils;

/**
 * This class used for get header list
 * 
 * @version 1.0
 * @since 2011/12/14
 **/
public class GetRunScheduleDetailTableDefinesServlet extends CommonServlet {

    private static final long serialVersionUID = -6712416036223172058L;

    private static LogUtils logUtils = LogUtils
            .getLogUtils(GetRunScheduleDetailTableDefinesServlet.class);

    /**
     * Get header list
     * 
     * @param request
     *            : HttpServletRequest
     * @param response
     *            : HttpServletResponse
     * @throws ServletException
     * @throws IOException
     */
    public CommonJson process(HttpServletRequest request,
            HttpServletResponse response) throws ServletException, IOException {

        CommonJson result = new CommonJson();

        try {
            // Get data form
            ScheduleTableDefineForm form = getDataForm(request);

            // Get left table define: run schedule list table define
            ArrayList<TableColumnInfoJs> leftTableDefine = doLoadLeftTableDefine(request
                    .getLocale());
            setLeftModelProperties(leftTableDefine);

            // Get right table define: run schedule table define
            ArrayList<TableColumnInfoJs> rightTableDefine = doLoadRightTableDefine(
                    form, request.getLocale());
            setRightModelProperties(rightTableDefine);

            result = doConvertToJson(leftTableDefine, rightTableDefine);

        } catch (Exception ex) {
            logUtils.error(ex.getMessage(), ex.getCause());
            result = ExceptionHandlerUtils.doBuildCommonJson(
                    ExceptionHandlerUtils.LEVEL_ERROR, ex.getMessage());
        }
        return result;
    }

    /**
     * @param request
     * @return
     * @throws HinemosWebException
     */
    private ScheduleTableDefineForm getDataForm(HttpServletRequest request)
            throws HinemosWebException {
        ScheduleTableDefineForm form = new ScheduleTableDefineForm();
        PopulateBeanUtils.populateBean(form, request);

        // Check parameters of request
        if (!isValidRequestParam(form)) {
            throw new HinemosWebInvalidRequestParameterException();
        }

        return form;
    }

    /**
     * Check valid parameter
     * 
     * @param form
     *            : ScheduleTableDefineForm
     * @return boolean
     */
    private boolean isValidRequestParam(ScheduleTableDefineForm form) {
        boolean isValid = true;
        Long base = form.getBase();

        // Check request base (manager)
        // http リクエストからユーザID判定する
        if (base == null) {
            isValid = false;
            logUtils.error("base is null");
        } else if (base == 0L) {
            isValid = false;
            logUtils.error("base is invalid");
        }

        return isValid;
    }

    /**
     * @param locale
     * @return
     * @throws HinemosWebException
     */
    private ArrayList<TableColumnInfoJs> doLoadLeftTableDefine(Locale locale)
            throws HinemosWebException {
        return new GetRunScheduleDetailListTableDefineBusiness()
                .getRunScheduleDetailListTableDefine(locale);
    }

    /**
     * Get header list
     * 
     * @return ArrayList<TableColumnInfoJs>
     * @throws HinemosWebHeaderInvalidException
     * @throws Exception
     */
    private ArrayList<TableColumnInfoJs> doLoadRightTableDefine(
            ScheduleTableDefineForm form, Locale locale)
            throws HinemosWebException {
        return new GetRunScheduleDetailTableDefineBusiness().doLoadTableDefine(
                new Date(form.getBase()), locale);
    }

    /**
     * @param tblDefine
     */
    private void setLeftModelProperties(ArrayList<TableColumnInfoJs> tblDefine) {
        tblDefine.get(RunScheduleDetailListTableDefine.TREE).setClasses(
                CssClass.GRID_TREE_ONLY_ICON);
        tblDefine.get(RunScheduleDetailListTableDefine.JOB_ID).setKey(true);
        tblDefine.get(RunScheduleDetailListTableDefine.JOB_TYPE).setFormatter(
                JsConstant.GRID_FMATTER_JOB);
    }

    /**
     * @param tblDefine
     */
    private void setRightModelProperties(ArrayList<TableColumnInfoJs> tblDefine) {
        tblDefine.get(RunScheduleDetailTableDefine.JOB_ID).setKey(true);
        for (int i = 2; i < tblDefine.size(); i++) {
            TableColumnInfoJs infoJs = tblDefine.get(i);
            infoJs.setFormatter(JsConstant.GRID_FMATTER_RUN_SCHEDULE);
        }
    }

    /**
     * @param leftTableDefine
     * @param rightTableDefine
     * @param base
     * @return
     */
    private TwoGridHeadersJson doConvertToJson(
            ArrayList<TableColumnInfoJs> leftTableDefine,
            ArrayList<TableColumnInfoJs> rightTableDefine) {
        TwoGridHeadersJson tableDefines = new TwoGridHeadersJson();
        GetRunScheduleDetailListTableDefineBusiness leftBusiness = new GetRunScheduleDetailListTableDefineBusiness();
        GetRunScheduleDetailTableDefineBusiness rightBusiness = new GetRunScheduleDetailTableDefineBusiness();

        tableDefines.setLeftHeader(leftBusiness
                .doConvertToJson(leftTableDefine));
        tableDefines.setRightHeader(rightBusiness
                .doConvertToJson(rightTableDefine));
        return tableDefines;
    }
}