/*
 
Copyright (C) NEC Corporation 2012. All Rights Reserved. 
Copyright (C) NEC Soft, Ltd. 2012. All Rights Reserved. 
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.necsoft.hinemos.webclient.jobmanagement.servlet;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.jnp.interfaces.NamingContext;

import com.necsoft.hinemos.webclient.common.JsConstant;
import com.necsoft.hinemos.webclient.exception.HinemosWebAccessException;
import com.necsoft.hinemos.webclient.exception.HinemosWebException;
import com.necsoft.hinemos.webclient.exception.HinemosWebInvalidRequestParameterException;
import com.necsoft.hinemos.webclient.exception.HinemosWebRemoteException;
import com.necsoft.hinemos.webclient.jobmanagement.business.GetRunScheduleBusiness;
import com.necsoft.hinemos.webclient.jobmanagement.business.GetRunScheduleListBusiness;
import com.necsoft.hinemos.webclient.jobmanagement.form.RunScheduleForm;
import com.necsoft.hinemos.webclient.json.CommonJson;
import com.necsoft.hinemos.webclient.json.TwoGridDataJson;
import com.necsoft.hinemos.webclient.servlet.CommonServlet;
import com.necsoft.hinemos.webclient.util.ExceptionHandlerUtils;
import com.necsoft.hinemos.webclient.util.LogUtils;
import com.necsoft.hinemos.webclient.util.PopulateBeanUtils;

/**
 * This class used for get Schedule info
 * 
 * @version 1.0
 * @since 2011/12/14
 */
public class GetRunScheduleDataServlet extends CommonServlet {
    private static final long serialVersionUID = -7775038566425028930L;

    private static LogUtils logUtils = LogUtils
            .getLogUtils(GetRunScheduleDataServlet.class);

    /**
     * Get Schedule info
     * 
     * @param request
     *            : HttpServletRequest
     * @param response
     *            : HttpServletResponse
     * @throws ServletException
     * @throws IOException
     * @throws HinemosWebAccessException
     */
    public CommonJson process(HttpServletRequest request,
            HttpServletResponse response) throws ServletException, IOException,
            HinemosWebAccessException {

        CommonJson result = new CommonJson();

        try {
            // NammingContextを取得する
            NamingContext namingContext = doLoadNamingContext(request);

            // Get data form
            RunScheduleForm form = getDataForm(request);

            // Map request data
            List<List<Object>> leftData = doLoadListInfoData(namingContext);

            ArrayList<ArrayList<Object>> rightData = doLoadInfosData(form,
                    namingContext);

            // Create JSON
            result = doLoadDataJson(leftData, rightData, form,
                    request.getLocale());

        } catch (HinemosWebAccessException ex) {
            logUtils.info(ex.getMessage());
            throw new HinemosWebAccessException();
        } catch (HinemosWebRemoteException ex) {
            logUtils.error(ex.getMessage(), ex.getCause());
            result = ExceptionHandlerUtils.doBuildCommonJson(
                    ExceptionHandlerUtils.LEVEL_WARNING, ex.getMessage());

        } catch (Exception ex) {
            logUtils.error(ex.getMessage(), ex.getCause());
            result = ExceptionHandlerUtils.doBuildCommonJson(
                    ExceptionHandlerUtils.LEVEL_ERROR, ex.getMessage());
        }
        return result;
    }

    /**
     * @param request
     * @return
     * @throws HinemosWebException
     */
    private RunScheduleForm getDataForm(HttpServletRequest request)
            throws HinemosWebException {
        RunScheduleForm form = new RunScheduleForm();
        PopulateBeanUtils.populateBean(form, request);

        // Check parameters of request
        if (!isValidRequestParam(form)) {
            throw new HinemosWebInvalidRequestParameterException();
        }

        return form;
    }

    /**
     * Check valid parameter
     * 
     * @param form
     *            : RunScheduleForm
     * @return boolean
     */
    private boolean isValidRequestParam(RunScheduleForm form) {
        boolean isValid = true;
        Long base = form.getBase();

        // Check request base (manager)
        // http リクエストからユーザID判定する
        if (base == null) {
            isValid = false;
            logUtils.error("base is null");
        } else if (base == 0L) {
            isValid = false;
            logUtils.error("base is invalid");
        }

        return isValid;
    }

    /**
     * @param namingContext
     * @return
     * @throws HinemosWebException
     */
    private List<List<Object>> doLoadListInfoData(NamingContext namingContext)
            throws HinemosWebException {

        GetRunScheduleListBusiness business = new GetRunScheduleListBusiness();
        return business.getRunScheduleList(namingContext);
    }

    /**
     * Get Schedule info
     * 
     * @param request
     *            : HttpServletRequest
     * @param namingContext
     *            : NamingContext
     * @return ArrayList<ArrayList<Object>>
     * @throws HinemosWebException
     */
    private ArrayList<ArrayList<Object>> doLoadInfosData(RunScheduleForm form,
            NamingContext namingContext) throws HinemosWebException {

        GetRunScheduleBusiness business = new GetRunScheduleBusiness();
        return business.doLoadListInfoData(new Date(form.getBase()),
                namingContext);
    }

    /**
     * Convert data to JSON structure
     * 
     * @param form
     *            : RunScheduleForm
     * @param listInfoData
     *            : ArrayList<ArrayList<Object>>
     * @return GridDataJson
     * @throws HinemosWebInvalidNumberSizeDataException
     */
    private TwoGridDataJson doLoadDataJson(List<List<Object>> leftData,
            ArrayList<ArrayList<Object>> rightData, RunScheduleForm form,
            Locale locale) throws HinemosWebException {
        TwoGridDataJson result = new TwoGridDataJson();

        GetRunScheduleListBusiness leftBusiness = new GetRunScheduleListBusiness();
        GetRunScheduleBusiness rightBusiness = new GetRunScheduleBusiness();

        result.setLeftData(leftBusiness.doConvertToJson(leftData));
        result.setRightData(rightBusiness.doConvertToJson(rightData, form,
                locale));

        List<String> colNames = rightBusiness.getColNames();
        if (colNames != null) {
            result.addUserdata(JsConstant.GRID_COL_NAMES, colNames);
        }
        return result;
    }
}