/*
 
Copyright (C) NEC Corporation 2012. All Rights Reserved. 
Copyright (C) NEC Soft, Ltd. 2012. All Rights Reserved. 
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.necsoft.hinemos.webclient.jobmanagement.business;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.jnp.interfaces.NamingContext;

import com.clustercontrol.jobmanagement.bean.RunScheduleListTableDefine;
import com.necsoft.hinemos.webclient.composite.CommonTableViewerSorter;
import com.necsoft.hinemos.webclient.exception.HinemosWebException;
import com.necsoft.hinemos.webclient.jobmanagement.action.GetRunScheduleList;
import com.necsoft.hinemos.webclient.jobmanagement.util.ConvertListUtil;
import com.necsoft.hinemos.webclient.jobmanagement.util.JobMappingUtil;

/**
 * This class used for get Schedule list
 * 
 * @version 1.0
 * @since 2011/12/14
 */
public class GetRunScheduleListBusiness {
    /**
     * Get Schedule list
     * 
     * @param namingContext
     *            : NamingContext
     * @param form
     *            : GridForm
     * @return ArrayList<ArrayList<Object>>
     * @throws HinemosWebException
     */
    public List<List<Object>> getRunScheduleList(NamingContext namingContext)
            throws HinemosWebException {

        GetRunScheduleList getRunScheduleList = new GetRunScheduleList();
        getRunScheduleList.setNamingContext(namingContext);
        ArrayList<ArrayList<Object>> listInfoData = null;
        listInfoData = getRunScheduleList.get();
        doSortListInfoData(listInfoData);
        List<List<Object>> list = ConvertListUtil
                .sanitizeRunScheduleList(listInfoData);
        return list;
    }

    /**
     * Sort data
     * 
     * @param listInfoData
     *            : ArrayList
     * @return ArrayList<JobHistory>
     */
    private void doSortListInfoData(ArrayList<ArrayList<Object>> listInfoData) {

        // Get sorting parameter
        int sortColumnIndex = RunScheduleListTableDefine.SORT_COLUMN_INDEX;
        int sortOrder = RunScheduleListTableDefine.SORT_ORDER;
        // データをソート
        Collections.sort(listInfoData, new CommonTableViewerSorter(
                sortColumnIndex, -1, sortOrder));
    }

    /**
     * Convert data to JSON structure
     * 
     * @param listInfoData
     *            : ArrayList<ArrayList<Object>>
     * @return GridDataJson
     */
    public List<Map<String, Object>> doConvertToJson(List<List<Object>> list) {
        // Create JSON
        List<Map<String, Object>> result = new ArrayList<Map<String, Object>>();

        // Set rows
        for (int countRow = 0; countRow < list.size(); countRow++) {
            List<Object> arrData = list.get(countRow);
            Map<String, Object> rowData = new HashMap<String, Object>();

            rowData.put(
                    JobMappingUtil
                            .getRunScheduleListName(RunScheduleListTableDefine.SCHE_ID),
                    arrData.get(RunScheduleListTableDefine.SCHE_ID));
            rowData.put(
                    JobMappingUtil
                            .getRunScheduleListName(RunScheduleListTableDefine.SCHE_NAME),
                    arrData.get(RunScheduleListTableDefine.SCHE_NAME));
            rowData.put(JobMappingUtil
                    .getRunScheduleListName(RunScheduleListTableDefine.JOB_ID),
                    arrData.get(RunScheduleListTableDefine.JOB_ID));
            rowData.put(
                    JobMappingUtil
                            .getRunScheduleListName(RunScheduleListTableDefine.JOB_NAME),
                    arrData.get(RunScheduleListTableDefine.JOB_NAME));
            rowData.put(
                    JobMappingUtil
                            .getRunScheduleListName(RunScheduleListTableDefine.JOBUNIT_ID),
                    arrData.get(RunScheduleListTableDefine.JOBUNIT_ID));
            rowData.put(
                    JobMappingUtil
                            .getRunScheduleListName(RunScheduleListTableDefine.CALENDAR_ID),
                    arrData.get(RunScheduleListTableDefine.CALENDAR_ID));

            result.add(rowData);
        }
        return result;
    }
}
