/*
 
Copyright (C) NEC Corporation 2012. All Rights Reserved. 
Copyright (C) NEC Soft, Ltd. 2012. All Rights Reserved. 
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.necsoft.hinemos.webclient.jobmanagement.business;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.apache.commons.lang.StringEscapeUtils;
import org.jnp.interfaces.NamingContext;

import com.clustercontrol.bean.CommonTableTreeItem;
import com.clustercontrol.jobmanagement.bean.RunScheduleDetailListTableDefine;
import com.necsoft.hinemos.webclient.common.DataProcess;
import com.necsoft.hinemos.webclient.common.JsConstant;
import com.necsoft.hinemos.webclient.exception.HinemosWebException;
import com.necsoft.hinemos.webclient.exception.HinemosWebInvalidDataException;
import com.necsoft.hinemos.webclient.jobmanagement.action.GetRunScheduleDetailList;
import com.necsoft.hinemos.webclient.jobmanagement.form.RunScheduleDetailForm;
import com.necsoft.hinemos.webclient.jobmanagement.util.JobMappingUtil;

/**
 * This class used for get Schedule Detail list
 * 
 * @version 1.0
 * @since 2011/12/14
 */
public class GetRunScheduleDetailListBusiness {
    /**
     * Get Schedule Detail list
     * 
     * @param namingContext
     *            : NamingContext
     * @param form
     *            : RunScheduleDetailForm
     * @return List<CommonTableTreeItem>
     * @throws HinemosWebException
     */
    public List<CommonTableTreeItem> getRunScheduleDetailList(
            RunScheduleDetailForm form, NamingContext namingContext)
            throws HinemosWebException {

        GetRunScheduleDetailList getRunScheduleDetailList = new GetRunScheduleDetailList();
        getRunScheduleDetailList.setNamingContext(namingContext);
        CommonTableTreeItem treeTable = null;
        treeTable = getRunScheduleDetailList.get(
                StringEscapeUtils.unescapeHtml(form.getScheduleId()),
                StringEscapeUtils.unescapeHtml(form.getJobunitId()));

        return Arrays.asList(treeTable.getChildren());
    }

    /**
     * Convert data to JSON structure
     * 
     * @param form
     *            : RunScheduleDetailForm
     * @param listItem
     *            : List<CommonTableTreeItem>
     * @return GridDataJson
     */
    public List<Map<String, Object>> doConvertToJson(
            List<CommonTableTreeItem> listItem, RunScheduleDetailForm form)
            throws HinemosWebException {
        List<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        generateSerializedData(result, form, listItem,
                JsConstant.TREEGRID_ROOT_LEVEL,
                JsConstant.TREEGRID_ROOT_PARENT_ID);

        return result;
    }

    /**
     * Generate Serialized Data
     * 
     * @param result
     *            : GridDataJson
     * @param form
     *            : RunScheduleDetailForm
     * @param listItem
     *            : List<CommonTableTreeItem>
     * @param level
     *            : Integer
     * @param parentId
     *            : String
     */
    private void generateSerializedData(List<Map<String, Object>> result,
            RunScheduleDetailForm form, List<CommonTableTreeItem> listItem,
            int level, String parentId) throws HinemosWebException {

        boolean isLeaf;

        for (int count = 0; count < listItem.size(); count++) {
            CommonTableTreeItem item = listItem.get(count);
            if (item.getChildren().length != 0) {
                isLeaf = false;
            } else {
                isLeaf = true;
            }

            // Add data
            result.add(doConvertTableTreeItemToArray(item, level, parentId,
                    isLeaf));

            // Generate children data
            if (!isLeaf) {
                List<CommonTableTreeItem> listChild = Arrays.asList(item
                        .getChildren());
                generateSerializedData(result, form, listChild, level + 1, item
                        .getData().get(RunScheduleDetailListTableDefine.JOB_ID)
                        .toString());
            }
        }
    }

    /**
     * Convert Tree Item to array
     * 
     * @param treeTable
     *            : CommonTableTreeItem
     * @param level
     *            : Integer
     * @param parentId
     *            : String
     * @param isLeaf
     *            : boolean
     * @return ArrayList
     * @throws HinemosWebInvalidNumberSizeDataException
     */
    private Map<String, Object> doConvertTableTreeItemToArray(
            CommonTableTreeItem treeTable, int level, String parentId,
            boolean isLeaf) throws HinemosWebException {

        // Create JSON
        Map<String, Object> result = new HashMap<String, Object>();
        Map<String, Object> rowData = new HashMap<String, Object>();

        ArrayList<Object> data = treeTable.getData();

        String jobId;
        String jobName;
        String calendarId;
        String parent;
        Boolean expanded = true;

        String jobIdEncode;
        String parentIdEncode;

        // Check jobId
        if (data.get(RunScheduleDetailListTableDefine.JOB_ID) == null) {
            throw new HinemosWebInvalidDataException(
                    "exception.job.runscheduledetaillist.jobid.null");
        } else {
            jobId = data.get(RunScheduleDetailListTableDefine.JOB_ID)
                    .toString();
        }

        // Encode to hex numbers
        jobIdEncode = DataProcess.stringToHex(jobId);

        // Check jobName
        if (data.get(RunScheduleDetailListTableDefine.JOB_NAME) == null) {
            jobName = null;
        } else {
            jobName = StringEscapeUtils.escapeHtml(data.get(
                    RunScheduleDetailListTableDefine.JOB_NAME).toString());
        }

        // Check calendarId
        if (data.get(RunScheduleDetailListTableDefine.CALENDAR_ID) == null) {
            calendarId = null;
        } else {
            calendarId = StringEscapeUtils.escapeHtml(data.get(
                    RunScheduleDetailListTableDefine.CALENDAR_ID).toString());
        }

        // Set parentIds
        if (parentId.equals(JsConstant.TREEGRID_ROOT_PARENT_ID)) {
            parent = JsConstant.TREEGRID_ROOT_PARENT;
            parentIdEncode = parentId;
        } else {
            parent = StringEscapeUtils.escapeHtml(parentId);
            parentIdEncode = DataProcess.stringToHex(parentId);
        }

        // Put data
        rowData.put(
                JobMappingUtil
                        .getRunScheduleDetailListName(RunScheduleDetailListTableDefine.TREE),
                data.get(RunScheduleDetailListTableDefine.TREE));
        rowData.put(
                JobMappingUtil
                        .getRunScheduleDetailListName(RunScheduleDetailListTableDefine.JOB_ID),
                StringEscapeUtils.escapeHtml(jobId));
        rowData.put(
                JobMappingUtil
                        .getRunScheduleDetailListName(RunScheduleDetailListTableDefine.JOB_NAME),
                jobName);
        rowData.put(
                JobMappingUtil
                        .getRunScheduleDetailListName(RunScheduleDetailListTableDefine.JOB_TYPE),
                data.get(RunScheduleDetailListTableDefine.JOB_TYPE));
        rowData.put(
                JobMappingUtil
                        .getRunScheduleDetailListName(RunScheduleDetailListTableDefine.CALENDAR_ID),
                calendarId);

        // Add property of tree grid
        rowData.put("level", level);
        rowData.put("parent", parent);
        rowData.put("isLeaf", isLeaf);
        rowData.put("expanded", expanded);

        // HTML inform
        result.put(JsConstant.TREEGRID_LOCAL_NODEID, jobIdEncode);
        result.put(JsConstant.TREEGRID_LOCAL_PARENTID, parentIdEncode);
        result.put(JsConstant.TREEGRID_LOCAL_DATA, rowData);
        return result;
    }
}