/*
 
Copyright (C) NEC Corporation 2012. All Rights Reserved. 
Copyright (C) NEC Soft, Ltd. 2012. All Rights Reserved. 
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.necsoft.hinemos.webclient.jobmanagement.business;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

import org.apache.commons.lang.StringEscapeUtils;
import org.jnp.interfaces.NamingContext;

import com.clustercontrol.bean.CommonTableTreeItem;
import com.clustercontrol.jobmanagement.bean.RunScheduleDetailTableDefine;
import com.necsoft.hinemos.webclient.bean.TableColumnInfoJs;
import com.necsoft.hinemos.webclient.common.DataProcess;
import com.necsoft.hinemos.webclient.common.JsConstant;
import com.necsoft.hinemos.webclient.composite.CommonTableViewerSorter;
import com.necsoft.hinemos.webclient.exception.HinemosWebException;
import com.necsoft.hinemos.webclient.exception.HinemosWebInvalidDataException;
import com.necsoft.hinemos.webclient.jobmanagement.action.GetRunScheduleDetail;
import com.necsoft.hinemos.webclient.jobmanagement.action.GetRunScheduleDetailTableDefine;
import com.necsoft.hinemos.webclient.jobmanagement.form.RunScheduleDetailForm;
import com.necsoft.hinemos.webclient.util.ConvertListUtil;
import com.necsoft.hinemos.webclient.util.SortOrderUtil;

/**
 * This class used for get Schedule Detail
 * 
 * @version 1.0
 * @since 2011/12/14
 */
public class GetRunScheduleDetailBusiness {

    private Date today;

    private List<String> colNames;

    /**
     * Get Schedule Detail list
     * 
     * @param namingContext
     *            : NamingContext
     * @param form
     *            : RunScheduleDetailForm
     * @return List<CommonTableTreeItem>
     * @throws HinemosWebException
     */
    public List<CommonTableTreeItem> doLoadListInfoData(
            RunScheduleDetailForm form, NamingContext namingContext)
            throws HinemosWebException {

        GetRunScheduleDetail getRunScheduleDetail = new GetRunScheduleDetail();
        getRunScheduleDetail.setNamingContext(namingContext);
        CommonTableTreeItem treeTable = null;
        treeTable = getRunScheduleDetail.get(StringEscapeUtils
                .unescapeHtml(form.getScheduleId()), StringEscapeUtils
                .unescapeHtml(form.getJobunitId()), new Date(form.getBase()));

        return doSortListChildren(form, treeTable);
    }

    /**
     * Sort data
     * 
     * @param RunScheduleDetailForm
     *            : form
     * @param treeTable
     *            : CommonTableTreeItem
     * @return List<CommonTableTreeItem>
     */
    public List<CommonTableTreeItem> doSortListChildren(
            RunScheduleDetailForm form, CommonTableTreeItem treeTable) {

        // Get sorting parameter
        int sortColumnIndex = RunScheduleDetailTableDefine.SORT_COLUMN_INDEX;
        int sortOrder = RunScheduleDetailTableDefine.SORT_ORDER;
        List<CommonTableTreeItem> listItem = Arrays.asList(treeTable
                .getChildren());

        if (form.getSidx() != null && !("").equals(form.getSidx().trim())) {
            sortColumnIndex = Integer.valueOf(form.getSidx());
        }
        if (form.getSord() != null && !("").equals(form.getSord().trim())) {
            sortOrder = SortOrderUtil.getSerInt(form.getSord());
        }

        // データをソート
        Collections.sort(listItem, new CommonTableViewerSorter(sortColumnIndex,
                -1, sortOrder));

        return listItem;
    }

    /**
     * Convert data to JSON structure
     * 
     * @param form
     *            : RunScheduleDetailForm
     * @param listItem
     *            : List<CommonTableTreeItem>
     * @return GridDataJson
     */
    public List<Map<String, Object>> doConvertToJson(
            List<CommonTableTreeItem> listItem, RunScheduleDetailForm form,
            Locale locale) throws HinemosWebException {

        List<Map<String, Object>> result = new ArrayList<Map<String, Object>>();

        // Get today
        today = DataProcess.getToDay();

        generateSerializedData(result, form, listItem,
                JsConstant.TREEGRID_ROOT_LEVEL,
                JsConstant.TREEGRID_ROOT_PARENT_ID);

        // Check whether update column names
        if (form.isUpdateHeader()) {
            setColNames(new Date(form.getBase()), locale);
        }

        return result;
    }

    /**
     * Generate Serialized Data
     * 
     * @param result
     *            : GridDataJson
     * @param form
     *            : RunScheduleDetailForm
     * @param listItem
     *            : List<CommonTableTreeItem>
     * @param level
     *            : Integer
     * @param parentId
     *            : String
     * @throws HinemosWebException
     */
    private void generateSerializedData(List<Map<String, Object>> result,
            RunScheduleDetailForm form, List<CommonTableTreeItem> listItem,
            int level, String parentId) throws HinemosWebException {

        boolean isLeaf;

        for (int count = 0; count < listItem.size(); count++) {
            CommonTableTreeItem item = listItem.get(count);
            if (item.getChildren().length != 0) {
                isLeaf = false;
            } else {
                isLeaf = true;
            }

            // Add data
            result.add(doConvertTableTreeItemToArray(item, level, parentId,
                    isLeaf));

            // Generate children data
            if (!isLeaf) {
                List<CommonTableTreeItem> listChild = doSortListChildren(form,
                        item);
                generateSerializedData(result, form, listChild, level + 1, item
                        .getData().get(RunScheduleDetailTableDefine.JOB_ID)
                        .toString());
            }
        }
    }

    /**
     * Convert Tree Item to array
     * 
     * @param treeTable
     *            : CommonTableTreeItem
     * @param level
     *            : Integer
     * @param parentId
     *            : String
     * @param isLeaf
     *            : boolean
     * @return ArrayList
     * @throws HinemosWebException
     */
    private Map<String, Object> doConvertTableTreeItemToArray(
            CommonTableTreeItem treeTable, int level, String parentId,
            boolean isLeaf) throws HinemosWebException {

        // Create JSON
        Map<String, Object> result = new HashMap<String, Object>();
        Map<String, Object> rowData = new HashMap<String, Object>();

        ArrayList<Object> data = treeTable.getData();
        int size = data.size();

        String jobId;
        String parent;
        Boolean expanded = true;

        String jobIdEncode;
        String parentIdEncode;

        // Check jobId
        if (data.get(RunScheduleDetailTableDefine.JOB_ID) == null) {
            throw new HinemosWebInvalidDataException(
                    "exception.job.runscheduledetail.jobid.null");
        } else {
            jobId = data.get(RunScheduleDetailTableDefine.JOB_ID).toString();
        }

        // Encode to hex numbers
        jobIdEncode = DataProcess.stringToHex(jobId);

        // Set parentIds
        if (parentId.equals(JsConstant.TREEGRID_ROOT_PARENT_ID)) {
            parent = JsConstant.TREEGRID_ROOT_PARENT;
            parentIdEncode = parentId;
        } else {
            parent = StringEscapeUtils.escapeHtml(parentId);
            parentIdEncode = DataProcess.stringToHex(parentId);
        }

        // Put data
        rowData.put(
                JsConstant.getColNameValue(RunScheduleDetailTableDefine.TREE),
                data.get(RunScheduleDetailTableDefine.TREE));
        rowData.put(
                JsConstant.getColNameValue(RunScheduleDetailTableDefine.JOB_ID),
                StringEscapeUtils.escapeHtml(jobId));
        for (int count = (RunScheduleDetailTableDefine.JOB_ID + 1); count < size; count++) {
            Object value;
            if (data.get(count) == null) {
                value = null;
            } else {
                Date obj = (Date) data.get(count);
                value = DataProcess.getViewerSchedule(obj, today);
            }

            rowData.put(JsConstant.getColNameValue(count), value);
        }

        // Add property of tree grid
        rowData.put("level", level);
        rowData.put("parent", parent);
        rowData.put("isLeaf", isLeaf);
        rowData.put("expanded", expanded);

        // Add HTML property
        result.put(JsConstant.TREEGRID_LOCAL_NODEID, jobIdEncode);
        result.put(JsConstant.TREEGRID_LOCAL_PARENTID, parentIdEncode);
        result.put(JsConstant.TREEGRID_LOCAL_DATA, rowData);

        return result;
    }

    /**
     * Get Schedule Detail table define
     * 
     * @param base
     *            : Date
     * @return ArrayList<String>
     */
    public List<String> getColNames() {
        return colNames;
    }

    public void setColNames(Date base, Locale locale) {
        // 中間変数を宣言
        ArrayList<TableColumnInfoJs> tblDefine = null;

        // Run Schedule table define を取得
        tblDefine = GetRunScheduleDetailTableDefine.get(base, locale);

        colNames = ConvertListUtil.columnInfoToColNames(tblDefine);
    }
}
