/*
 
Copyright (C) NEC Corporation 2012. All Rights Reserved. 
Copyright (C) NEC Soft, Ltd. 2012. All Rights Reserved. 
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.necsoft.hinemos.webclient.jobmanagement.action;

import java.util.ArrayList;
import java.util.Locale;

import com.clustercontrol.jobmanagement.bean.NodeDetailTableDefine;
import com.necsoft.hinemos.webclient.bean.TableColumnInfoJs;
import com.necsoft.hinemos.webclient.common.SWT;
import com.necsoft.hinemos.webclient.lang.WebMessages;

/**
 * ジョブ[ノード詳細]ビューのテーブル定義を取得するクライアント側アクションクラス<BR>
 * 
 * マネージャにSessionBean経由でアクセスし、テーブル定義を取得する
 * 
 */
public class GetNodeDetailTableDefine {

    /**
     * マネージャにSessionBean経由でアクセスし、<BR>
     * ジョブ[ノード詳細]ビューのテーブル定義を取得する
     * 
     * @return テーブル定義情報 （{@link com.clustercontrol.bean.TableColumnInfo}のリスト）
     */
    public static ArrayList<TableColumnInfoJs> get(Locale locale) {
        // テーブル情報定義配列
        ArrayList<TableColumnInfoJs> tableDefine = new ArrayList<TableColumnInfoJs>();
        // Locale locale = Locale.getDefault();

        tableDefine.add(NodeDetailTableDefine.STATUS, new TableColumnInfoJs(
                WebMessages.getString("run.status", locale),
                TableColumnInfoJs.STATE, 80, SWT.LEFT, true));
        tableDefine.add(
                NodeDetailTableDefine.RETURN_VALUE,
                new TableColumnInfoJs(WebMessages.getString("return.value",
                        locale), TableColumnInfoJs.NONE, 50, SWT.LEFT, true));
        tableDefine.add(
                NodeDetailTableDefine.FACILITY_ID,
                new TableColumnInfoJs(WebMessages.getString("facility.id",
                        locale), TableColumnInfoJs.NONE, 100, SWT.LEFT, true));
        tableDefine.add(
                NodeDetailTableDefine.FACILITY_NAME,
                new TableColumnInfoJs(WebMessages.getString("facility.name",
                        locale), TableColumnInfoJs.FACILITY, 150, SWT.LEFT,
                        true));
        tableDefine.add(
                NodeDetailTableDefine.START_RERUN_TIME,
                new TableColumnInfoJs(WebMessages.getString("start.rerun.time",
                        locale), TableColumnInfoJs.NONE, 150, SWT.LEFT, true));
        tableDefine.add(
                NodeDetailTableDefine.END_SUSPEND_TIME,
                new TableColumnInfoJs(WebMessages.getString("end.suspend.time",
                        locale), TableColumnInfoJs.NONE, 150, SWT.LEFT, true));
        tableDefine.add(NodeDetailTableDefine.MESSAGE, new TableColumnInfoJs(
                WebMessages.getString("message", locale),
                TableColumnInfoJs.TEXT_DIALOG, 300, SWT.LEFT, true));

        return tableDefine;
    }
}