/*
 
Copyright (C) NEC Corporation 2012. All Rights Reserved. 
Copyright (C) NEC Soft, Ltd. 2012. All Rights Reserved. 
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/


package com.necsoft.hinemos.webclient.jobmanagement.action;

import java.util.Locale;

import com.clustercontrol.bean.DataRangeConstant;
import com.clustercontrol.bean.Property;
import com.clustercontrol.bean.PropertyConstant;
import com.clustercontrol.jobmanagement.bean.HistoryFilterPropertyConstant;
import com.necsoft.hinemos.webclient.lang.WebMessages;

/**
 * ジョブ[履歴]ビューのフィルタ用プロパティを取得するクライアント側アクションクラス<BR>
 * 
 * マネージャにSessionBean経由でアクセスし、フィルタ用プロパティを取得する
 * 
 */
public class GetHistoryFilterProperty {

    /**
     * マネージャにSessionBean経由でアクセスし、履歴フィルタ用プロパティを取得する
     * 
     * @return 履歴フィルタ用プロパティ
     * 
     */
    public Property getProperty(Locale locale) {

        // Locale locale = Locale.getDefault();

        // 開始・再実行日時（自）
        Property m_startFromDate = new Property(
                HistoryFilterPropertyConstant.START_FROM_DATE,
                WebMessages.getString("start", locale),
                PropertyConstant.EDITOR_DATETIME);
        // 開始・再実行日時（至）
        Property m_startToDate = new Property(
                HistoryFilterPropertyConstant.START_TO_DATE,
                WebMessages.getString("end", locale),
                PropertyConstant.EDITOR_DATETIME);
        // 終了・中断日時（自）
        Property m_endFromDate = new Property(
                HistoryFilterPropertyConstant.END_FROM_DATE,
                WebMessages.getString("start", locale),
                PropertyConstant.EDITOR_DATETIME);
        // 終了・中断日時（至）
        Property m_endToDate = new Property(
                HistoryFilterPropertyConstant.END_TO_DATE,
                WebMessages.getString("end", locale),
                PropertyConstant.EDITOR_DATETIME);
        // ジョブID
        Property m_jobId = new Property(HistoryFilterPropertyConstant.JOB_ID,
                WebMessages.getString("job.id", locale),
                PropertyConstant.EDITOR_JOB);
        // 状態
        Property m_status = new Property(HistoryFilterPropertyConstant.STATUS,
                WebMessages.getString("run.status", locale),
                PropertyConstant.EDITOR_SELECT);
        // 実行契機種別
        Property m_triggerType = new Property(
                HistoryFilterPropertyConstant.TRIGGER_TYPE,
                WebMessages.getString("trigger.type", locale),
                PropertyConstant.EDITOR_SELECT);
        // 実行契機情報
        Property m_triggerInfo = new Property(
                HistoryFilterPropertyConstant.TRIGGER_INFO,
                WebMessages.getString("trigger.info", locale),
                PropertyConstant.EDITOR_TEXT, DataRangeConstant.VARCHAR_128);

        // 開始・再実行日時
        Property m_startDate = new Property(
                HistoryFilterPropertyConstant.START_DATE,
                WebMessages.getString("start.rerun.time", locale),
                PropertyConstant.EDITOR_TEXT);
        // 終了・中断日時
        Property m_endDate = new Property(
                HistoryFilterPropertyConstant.END_DATE, WebMessages.getString(
                        "end.suspend.time", locale),
                PropertyConstant.EDITOR_TEXT);
        // 実行契機
        Property m_trigger = new Property(
                HistoryFilterPropertyConstant.TRIGGER, WebMessages.getString(
                        "trigger", locale), PropertyConstant.EDITOR_TEXT);

        // 値を初期化（状態）
        Object statusValues[][] = {
                { "", WebMessages.getString("wait", locale),
                        WebMessages.getString("reserving", locale),
                        WebMessages.getString("running", locale),
                        WebMessages.getString("stopping", locale),
                        WebMessages.getString("stop.at.once", locale),
                        WebMessages.getString("end", locale),
                        WebMessages.getString("modified", locale) },
                { "", WebMessages.getString("wait", locale),
                        WebMessages.getString("reserving", locale),
                        WebMessages.getString("running", locale),
                        WebMessages.getString("stopping", locale),
                        WebMessages.getString("stop.at.once", locale),
                        WebMessages.getString("end", locale),
                        WebMessages.getString("modified", locale) } };

        // 値を初期化（実行契機種別）
        Object triggerValues[][] = {
                { "", WebMessages.getString("schedule", locale),
                        WebMessages.getString("trigger.manual", locale),
                        WebMessages.getString("trigger.monitor", locale) },
                { "", WebMessages.getString("schedule", locale),
                        WebMessages.getString("trigger.manual", locale),
                        WebMessages.getString("trigger.monitor", locale) } };

        m_status.setSelectValues(statusValues);
        m_status.setValue("");
        m_triggerType.setSelectValues(triggerValues);
        m_triggerType.setValue("");

        m_startFromDate.setValue("");
        m_startToDate.setValue("");
        m_endFromDate.setValue("");
        m_endToDate.setValue("");
        m_jobId.setValue("");
        m_triggerInfo.setValue("");

        m_startDate.setValue("");
        m_endDate.setValue("");
        m_trigger.setValue("");

        // 変更の可/不可を設定
        m_startFromDate.setModify(PropertyConstant.MODIFY_OK);
        m_startToDate.setModify(PropertyConstant.MODIFY_OK);
        m_endFromDate.setModify(PropertyConstant.MODIFY_OK);
        m_endToDate.setModify(PropertyConstant.MODIFY_OK);
        m_jobId.setModify(PropertyConstant.MODIFY_OK);
        m_status.setModify(PropertyConstant.MODIFY_OK);
        m_triggerType.setModify(PropertyConstant.MODIFY_OK);
        m_triggerInfo.setModify(PropertyConstant.MODIFY_OK);

        m_startDate.setModify(PropertyConstant.MODIFY_NG);
        m_endDate.setModify(PropertyConstant.MODIFY_NG);
        m_trigger.setModify(PropertyConstant.MODIFY_NG);

        Property property = new Property(null, null, "");

        // 初期表示ツリーを構成。
        property.removeChildren();
        property.addChildren(m_startDate);
        property.addChildren(m_endDate);
        property.addChildren(m_jobId);
        property.addChildren(m_status);
        property.addChildren(m_trigger);

        // 開始・再実行日時
        m_startDate.removeChildren();
        m_startDate.addChildren(m_startFromDate);
        m_startDate.addChildren(m_startToDate);

        // 終了・中断日時
        m_endDate.removeChildren();
        m_endDate.addChildren(m_endFromDate);
        m_endDate.addChildren(m_endToDate);

        // 実行契機
        m_trigger.removeChildren();
        m_trigger.addChildren(m_triggerType);
        m_trigger.addChildren(m_triggerInfo);

        return property;
    }
}