/*
 
Copyright (C) NEC Corporation 2012. All Rights Reserved. 
Copyright (C) NEC Soft, Ltd. 2012. All Rights Reserved. 
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/
package com.necsoft.hinemos.webclient.action;

import java.io.IOException;
import java.rmi.RemoteException;
import java.util.Locale;

import org.jnp.interfaces.NamingContext;

import com.clustercontrol.bean.FacilityTreeItem;
import com.clustercontrol.repository.ejb.session.RepositoryController;
import com.necsoft.hinemos.webclient.exception.HinemosWebException;
import com.necsoft.hinemos.webclient.exception.HinemosWebInvalidDataException;
import com.necsoft.hinemos.webclient.exception.HinemosWebRemoteException;
import com.necsoft.hinemos.webclient.repository.action.GetFacilityTree;
import com.necsoft.hinemos.webclient.util.EjbConnectionManager;

/**
 * スコープツリーアイテムを取得するクライアント側アションクラス
 * 
 * @version 1.0.0
 * @since 1.0.0
 **/
public class FacilityTree {

    // ファシリティツリーのクライアント側ローカルキャッシュを保持
    private FacilityTreeItem m_facilityTreeCache = null;

    // namingContextを定義
    private NamingContext m_namingContext = null;

    /**
     * namingContextを設定
     * 
     * @param namingContext
     * @return void
     */
    public void setNamingContext(NamingContext namingContext) {
        this.m_namingContext = namingContext;
    }

    /**
     * スコープツリー構造を返します。
     * 
     * @return スコープツリー構造
     */
    public FacilityTreeItem getTreeItem(Locale locale)
            throws HinemosWebException {
        FacilityTreeItem item = null;

        if (m_facilityTreeCache == null) {
            // 存在しない場合はキャッシュ再交信再取得
            refreshCache(locale);
            if (m_facilityTreeCache == null) {
                return null;
            }
        }

        // 要素を取得
        try {
            item = m_facilityTreeCache.deepCopy();
        } catch (IOException e) {
            throw new HinemosWebException(
                    "exception.action.facilitytree.treeitem", e);
        } catch (ClassNotFoundException e) {
            throw new HinemosWebException(
                    "exception.action.facilitytree.treeitem", e);
        }

        return item;
    }

    /**
     * セパレータを取得します。<BR>
     * 
     * スコープの区切り文字（セパレータ）を取得します。
     * 
     * @return セパレータ文字列
     * @throws HinemosWebException 
     */
    public String getSeparator() throws HinemosWebException  {
        EjbConnectionManager ejbConnectionManager = new EjbConnectionManager();
        ejbConnectionManager.setNamingContext(this.m_namingContext);

        RepositoryController repository = ejbConnectionManager
                .getRepositoryController();
        String separator = ">";
        try {
            separator = repository.getSeparator();
        } catch (RemoteException e) {
            throw new HinemosWebRemoteException(
                    "exception.action.facilitytree.separator");
        }
        return separator;
    }

    /**
     * キャッシュのリフレッシュ
     * 
     * @throws HinemosWebException
     */
    public void refreshCache(Locale locale) throws HinemosWebException {

        // 再登録
        FacilityTreeItem item = null;

        GetFacilityTree action = new GetFacilityTree();
        action.setNamingContext(this.m_namingContext);

        item = action.getFacilityTree(locale);
        if (item != null) {
            m_facilityTreeCache = item;
        } else {
            throw new HinemosWebInvalidDataException(
                    "exception.action.facilitytree.refresh");
        }
    }

}