/*
 
Copyright (C) NEC Corporation 2012. All Rights Reserved. 
Copyright (C) NEC Soft, Ltd. 2012. All Rights Reserved. 
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.necsoft.hinemos.webclient.accesscontrol.validation;

import com.necsoft.hinemos.webclient.accesscontrol.AccessControlConstants;
import com.necsoft.hinemos.webclient.validator.Validator;

/**
 * ログイン画面に入力内容が有効であるかどうかチェックするクラス
 * 
 * @version 1.0.0
 * @since 1.0.0
 **/
public class LoginValidator extends Validator {
	public static boolean validUserID(String userName) {
		return matchPattern(userName, AccessControlConstants.USER_ID_PARTERN);
	}

	public static boolean validURLServer(String urlServer) {
		return matchPattern(urlServer, AccessControlConstants.URL_SERVER_PARTERN);
	}
}
