<%--
 
Copyright (C) NEC Corporation 2012. All Rights Reserved. 
Copyright (C) NEC Soft, Ltd. 2012. All Rights Reserved. 
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
--%>


<%@page pageEncoding="UTF-8"%>
<%@ taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt" %>
<fmt:setBundle basename="com.necsoft.hinemos.webclient.lang.messages" />
<jsp:useBean id="userBean" class="com.necsoft.hinemos.webclient.accesscontrol.bean.UserBean" scope="session" />
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01//EN" "http://www.w3.org/TR/html4/strict.dtd">
<html>
<head>
	<meta http-equiv='Content-Type' content='text/html; charset=UTF-8' />
	<title><fmt:message key="login" /></title>
	<link rel="shortcut icon" href="images/icon.ico" />

	<link rel="stylesheet" type="text/css" href="jquery/jquery-ui.css" />
	<link rel="stylesheet" type="text/css" href="jquery/layout-default.css" />	
	<link rel="stylesheet" type="text/css" href="css/login.css"/>
	
	<script type="text/javascript" src="jquery/jquery.js"></script>
	<script type="text/javascript" src="jquery/jquery-ui.js"></script>
	<script type="text/javascript" src="jquery/jquery.layout.js"></script>
	<script type="text/javascript" src="language/accesscontrol/login.js"></script>
</head>
<body>
	<div class="ui-layout-north">
		<img src=<fmt:message key="imgLogo"/>>
	</div>
	<div class="ui-layout-center">
		<img src=<fmt:message key="imgTitle"/>>
		<center>
		<div id="frm-login" >
			<form action="login_auth" method="post">
				<div class="lbl-header">
					<span class="hinemos-icon"></span>
					<span class="hinemos-label"><fmt:message key="login" /></span>
				</div>
				<table class="tbl-login">
					<tr>
						<td class="lbl-input"><fmt:message key="user.id" />:</td>
						<td><input type="text" name="userName" value="${userBean.userName}" maxlength=64 /></td>
					</tr>
					<tr>
						<td class="lbl-input"><fmt:message key="password"/>:</td>
						<td><input type="password" name="password" autocomplete="off" value="" maxlength=64 /></td>
					</tr>
					<tr>
						<td class="lbl-input"><fmt:message key="connection.url"/>:</td>
						<td><input type="text" name="urlServer" value="${userBean.urlServer}" maxlength=100 /></td>
					</tr>
				</table>
			</form>
			<table class="tbl-action">
				<tr>
					<td class="lbl-input"></td>
					<td class="ntf-err-message" id="ntfErrMessage">${userBean.errMessage}</td>
				</tr>
				<tr>
					<td class="lbl-input"></td>
					<td>
						<button id="btn_login"><fmt:message key="login"/></button>
						<button id="btn_clear"><fmt:message key="clear"/></button>
					</td>
				</tr>			
			</table>
		</div>
		</center>
	</div>
	<div class="ui-layout-south">
		<fmt:message key="copyrightText"/>
	</div>
</body>
</html>