/*
 
Copyright (C) NEC Corporation 2012. All Rights Reserved. 
Copyright (C) NEC Soft, Ltd. 2012. All Rights Reserved. 
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

/*******************************************************************************
 * Create monitor scope
 */
var fn = function(_view){
	var __ = cm
	,_pers = this
	;
	
	 var view = $.extend({}, __._fnview_grid, {
		facility_id: ""
		,facility_name: ""
		
		,/*
		 * Set caption of grid
		 */
		setCaption: function(path){
			var _ = this;
			_.grid.setCaption([
				__.getLang("facility_id")
				,":&nbsp;"
				,_.facility_id
				,"<br>"
				,__.getLang("facility_name")
				,":&nbsp;"
				,_.facility_name
			].join(""));
		}
		
		,/*
		 * Update data when click on view 'node' content
		 */
		updateData: function(){
			var _          = this 
			,facility_id   = _view.__facility_id
			,facility_name = _view.__facility_name
			,grid          = _.grid
			;
			
			// Check for update data
			if(facility_id == _.facility_id){
				return;
			}
			
			// Case updating
			_.facility_id = facility_id;
			_.facility_name = facility_name;
			_.setCaption();
			
			// Check to clear?
			if(facility_id === ""){
				grid.clearGridData();
				return;
			}
			
			// Reload grid
			grid.refreshData({facilityId: facility_id});
		}
		
		,/*
		 * Get scope list
		 */
		createGrid: function(){
			var _ = this;
			
			$.ajax({
				url      : "get_node_scope_table_define"
				,dataType: "json"
				,type    : "get"
				,success : function(data_respond){
					// Cache local variants
					var grid   = _.grid
					,post_data = {}
					;
					
					// Check validation of data_respond
					if (__.checkJsonError(data_respond) !== true){
						return;
					}
					
					// Check session_id of view: control
					if(_view.__facility_id){
						_.facility_id = _view.__facility_id;
						_.facility_name = _view.__facility_name;
						
						post_data.facilityId = _.facility_id;
					}
					
					// Set some options for grid
					$.extend(data_respond,{
						url             : "get_node_scope"
						,caption        : "&nbsp;"
						,postData       : post_data
						,ajaxGridOptions: {
							// This function prevent grid send request without 
							//   facilityId or facilityId = "" 
							beforeSend: function (jqXhr, settings){
								var str_params = settings.data // form: a=b&c=d ...
								,params = str_params.split("&")
								,count  = params.length
								;
								
								// Check every parameter (form: a=b) 
								while(count--){
									var str_param = params[count]
									,param = str_param.split("=")
									;
									
									// Check parameter:
									if(param[0] && (param[0] == "facilityId") && (param[1])){
										return true;
									}
								}
								
								return false;
							}
						}
					});
				
					grid.processData(data_respond);
					grid.controlSize();
					_.setCaption();
				}
				,error   : __.loadDataError
			});
		}
				
		,/*
		 * Bind some action
		 */
		bindAction: function(){
			var _     = this;
			var _btns = _.$btns;
			
			// Bind actions for button in left of pane
			// Bind update grid data
			_btns.children("#update").click(function(){
				_.grid.refreshData();
			});
		}
	});
	
	return view;
};