/*
 
Copyright (C) NEC Corporation 2012. All Rights Reserved. 
Copyright (C) NEC Soft, Ltd. 2012. All Rights Reserved. 
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

/*******************************************************************************
 * Create monitor scope
 */
var fn = function(_view){
	var __ = cm
	,_pers = this
	;
	
	var view = $.extend({}, __._fnview_grid, {
		/*
		 * Update data for jobDetail
		 */
		updateJobDetail: function(session_id){
			var _ = this
			,vw_dtl
			;
			
			// Check whether view "job detail" exists
			if(!(vw_dtl = _pers["job_detail"])){
				return;
			}
			
			// Update data for view detail
			vw_dtl.updateData({session_id: session_id});
		}
		
		,/*
		 * Get scope list
		 */
		createGrid: function(){
			var _ = this;
			
			$.ajax({
				url      : "get_history_table_define"
				,dataType: "json"
				,type    : "get"
				,success : function(data_respond){
					// Cache local variants
					var grid = _.grid
					,pager   = grid.$pgr
					;
					
					// Check validation of data_respond
					if (__.checkJsonError(data_respond) !== true){
						return;
					}
					
					// Set some options for grid
					$.extend(data_respond,{
						url          : "get_history"
						,caption     : "&nbsp;"
						,pager       : pager
						,viewrecords : true
						,loadComplete: function(){
							// Set refresh data
							_view.setRefresh();
						}
						,onSelectRow : function(row_id){
							var i     = this
							,row_data = $(i).getRowData(row_id)
							;
							
							_.updateJobDetail($.jgrid.htmlEncode(row_data.sessionId));
						}
					});
				
					grid.processData(data_respond);
					grid.controlSize();
				}
				,error   : __.loadDataError
			});
		}
		
		,/*
		 * Create dialogs
		 */
		createDialog: function(){
			// Cache local variant
			var _ = this;
			
			// Declare filter dialog
			__.crePropActnDlg.call(
				_
				,"filter"
				,{
					option: {
						title   : _pers.getTitle("filter_histories")
						,width  : 400
						,height : 330
						,open   : function(){
							$(this).siblings('div.ui-dialog-buttonpane:first').find("button:eq(1)").focus();
						}
						,buttons: [
							{
								text  : __.getLang("clear")
								,click: function(){
									_.filter.reset("filter");
								}
							}
							,{
								text  : __.getLang("ok_o")
								,click: function(){
									_.filter.execute(function(post_data){
										var _ = this;
										
										// Extend filter is true
										$.extend(post_data, {filter: true});
										
										// Refresh data
										_.grid.refreshData(post_data)
										
										// Store filter active
										_.filter_active = true;
										
										// Set caption
										_.grid.setCaption(__.getLang("filtered_list"));
										
										// Add class button active
										_.$btns.children("#filter").addClass("ui-button-active");
									});
									
									$(this).dialog("close");
								}
							}
							,{
								text  : __.getLang("cancel")
								,click: function(){
									$(this).dialog("close");
								}
							}
						]
					}
					,url  : "get_history_filter_property"
				}
				,function(){
					var $input = _.filter.$dlg.$bd
						.find(":input.input-jobid:first")
					,$btn = $input.siblings("button:first");
					;
					
					if($btn.length != 0){
						$btn.text("...")
							.css("visibility", "hidden")
							.click(function(){
								// Open text dialog
								_pers.openTreeJobDlg($input);
							});
						
						$input.click(function(){
							$btn.css("visibility", "visible");
						});
					}
				}
			);
		}
		
		,/*
		 * Refresh data
		 */
		refreshData: function(){
			this.grid.refreshData();
		}
		
		,/*
		 * Bind some action
		 */
		bindAction: function(){
			var _  = this
			,_btns = _.$btns
			,_grid = _.grid
			;
			
			// Bind actions for button in left of pane
			// Bind filter
			_btns.children("#filter").click(function(){
				if(_.filter_active){
					// Inactive filter for filter grid
					_grid.refreshData({filter: false});
					_grid.setCaption("&nbsp;");
					
					// Process CSS for button
					$(this).removeClass("ui-button-active");
					_.filter_active = false;
				}else{
					// Open dialog which contain filter property grid
					_.filter.open();
				}
			});
			
			// Bind update grid data
			_btns.children("#update").click(function(){
				_.grid.refreshData();
			});
		}
	});
	
	return view;
};