/*
 * Decompiled with CFR 0.152.
 */
package EDU.oswego.cs.dl.util.concurrent.misc;

import EDU.oswego.cs.dl.util.concurrent.Channel;
import EDU.oswego.cs.dl.util.concurrent.misc.DelegatedRNG;
import EDU.oswego.cs.dl.util.concurrent.misc.PublicSynchRNG;
import EDU.oswego.cs.dl.util.concurrent.misc.RNG;

class ChanRNG
extends DelegatedRNG {
    boolean single_;

    ChanRNG() {
        this.setDelegate(new PublicSynchRNG());
    }

    public synchronized void setSingle(boolean s) {
        this.single_ = s;
    }

    public synchronized boolean isSingle() {
        return this.single_;
    }

    public long producerNext(Channel c) throws InterruptedException {
        RNG r = this.getDelegate();
        if (this.isSingle()) {
            c.put(r);
            r = (RNG)c.take();
            r.update();
        } else {
            if (this.pcBias < 0) {
                r.update();
                r.update();
            } else if (this.pcBias == 0) {
                r.update();
            }
            if (this.pmode == 0) {
                c.put(r);
            } else {
                while (!c.offer(r, this.waitTime)) {
                }
            }
        }
        return r.get();
    }

    public long consumerNext(Channel c) throws InterruptedException {
        RNG r = null;
        if (this.cmode == 0) {
            r = (RNG)c.take();
        } else {
            while (r == null) {
                r = (RNG)c.poll(this.waitTime);
            }
        }
        if (this.pcBias == 0) {
            r.update();
        } else if (this.pcBias > 0) {
            r.update();
            r.update();
        }
        return r.get();
    }
}

