/*

 Copyright (C) 2006 NTT DATA Corporation

 This program is free software; you can redistribute it and/or
 Modify it under the terms of the GNU General Public License
 as published by the Free Software Foundation, version 2.

 This program is distributed in the hope that it will be
 useful, but WITHOUT ANY WARRANTY; without even the implied
 warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
 PURPOSE.  See the GNU General Public License for more details.

 */


package com.clustercontrol.monitor.bean;

import com.clustercontrol.util.Messages;

/**
 * コメント入力有／無の定義を定数として格納するクラス<BR>
 * 
 * @version 4.0.0
 * @since 4.0.0
 */

public class CommentFlgConstant {
	/** 有（種別）。 */
	public static final int TYPE_COMMENTED = 1;

	/** 無（種別）。 */
	public static final int TYPE_NOT_COMMENTED = 0;


	/** 有（文字列）。 */
	public static final String STRING_COMMENTED = Messages.getString("comment.yes");

	/** 無（文字列）。 */
	public static final String STRING_NOT_COMMENTED = Messages.getString("comment.no");


	/** 有（真偽）。 */
	public static final boolean BOOLEAN_COMMENTED = true;

	/** 無（真偽）。 */
	public static final boolean BOOLEAN_NOT_COMMENTED = false;

	/**
	 * 種別から文字列に変換します。
	 * 
	 * @param type 種別
	 * @return 文字列
	 */
	public static String typeToString(int type) {
		if (type == TYPE_COMMENTED) {
			return STRING_COMMENTED;
		} else if (type == TYPE_NOT_COMMENTED) {
			return STRING_NOT_COMMENTED;
		}
		return "";
	}

	/**
	 * 文字列から種別に変換します。<BR>
	 * 
	 * @param string 文字列
	 * @return 種別
	 */
	public static int stringToType(String string) {
		if (string.equals(STRING_COMMENTED)) {
			return TYPE_COMMENTED;
		} else if (string.equals(STRING_NOT_COMMENTED)) {
			return TYPE_NOT_COMMENTED;
		}
		return -1;
	}

	/**
	 * 種別から真偽に変換します。<BR>
	 * 
	 * @param type 種別
	 * @return 真偽
	 */
	public static boolean typeToBoolean(int type) {
		if (type == TYPE_COMMENTED) {
			return BOOLEAN_COMMENTED;
		} else if (type == TYPE_NOT_COMMENTED) {
			return BOOLEAN_NOT_COMMENTED;
		}
		return false;
	}

	/**
	 * 真偽から種別に変換します。<BR>
	 * 
	 * @param bool 真偽
	 * @return 種別
	 */
	public static int booleanToType(boolean bool) {
		if (bool == BOOLEAN_COMMENTED) {
			return TYPE_COMMENTED;
		} else if (bool == BOOLEAN_NOT_COMMENTED) {
			return TYPE_NOT_COMMENTED;
		}
		return -1;
	}
}
