package com.clustercontrol.agent;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class Win32Error {
	public static final Map<Integer, String> map = new ConcurrentHashMap<Integer, String>();

	public static String getMessage(int error) {
		String message = null;
		message = map.get(error);
		if (message != null) {
			message += "(" + error + ")";
		} else {
			message = "UNKNOWN_MESSAGE_" + error;
		}
		return message;
	}

	/*
	 * http://msdn.microsoft.com/en-us/library/cc231199(v=prot.10).aspx
	 * 2.2 Win32 Error Codes
	 */
	static {
		map.put(0x00000000, "ERROR_SUCCESS");
		map.put(0x00000000, "NERR_Success");
		map.put(0x00000001, "ERROR_INVALID_FUNCTION");
		map.put(0x00000002, "ERROR_FILE_NOT_FOUND");
		map.put(0x00000003, "ERROR_PATH_NOT_FOUND");
		map.put(0x00000004, "ERROR_TOO_MANY_OPEN_FILES");
		map.put(0x00000005, "ERROR_ACCESS_DENIED");
		map.put(0x00000006, "ERROR_INVALID_HANDLE");
		map.put(0x00000007, "ERROR_ARENA_TRASHED");
		map.put(0x00000008, "ERROR_NOT_ENOUGH_MEMORY");
		map.put(0x00000009, "ERROR_INVALID_BLOCK");
		map.put(0x0000000A, "ERROR_BAD_ENVIRONMENT");
		map.put(0x0000000B, "ERROR_BAD_FORMAT");
		map.put(0x0000000C, "ERROR_INVALID_ACCESS");
		map.put(0x0000000D, "ERROR_INVALID_DATA");
		map.put(0x0000000E, "ERROR_OUTOFMEMORY");
		map.put(0x0000000F, "ERROR_INVALID_DRIVE");
		map.put(0x00000010, "ERROR_CURRENT_DIRECTORY");
		map.put(0x00000011, "ERROR_NOT_SAME_DEVICE");
		map.put(0x00000012, "ERROR_NO_MORE_FILES");
		map.put(0x00000013, "ERROR_WRITE_PROTECT");
		map.put(0x00000014, "ERROR_BAD_UNIT");
		map.put(0x00000015, "ERROR_NOT_READY");
		map.put(0x00000016, "ERROR_BAD_COMMAND");
		map.put(0x00000017, "ERROR_CRC");
		map.put(0x00000018, "ERROR_BAD_LENGTH");
		map.put(0x00000019, "ERROR_SEEK");
		map.put(0x0000001A, "ERROR_NOT_DOS_DISK");
		map.put(0x0000001B, "ERROR_SECTOR_NOT_FOUND");
		map.put(0x0000001C, "ERROR_OUT_OF_PAPER");
		map.put(0x0000001D, "ERROR_WRITE_FAULT");
		map.put(0x0000001E, "ERROR_READ_FAULT");
		map.put(0x0000001F, "ERROR_GEN_FAILURE");
		map.put(0x00000020, "ERROR_SHARING_VIOLATION");
		map.put(0x00000021, "ERROR_LOCK_VIOLATION");
		map.put(0x00000022, "ERROR_WRONG_DISK");
		map.put(0x00000024, "ERROR_SHARING_BUFFER_EXCEEDED");
		map.put(0x00000026, "ERROR_HANDLE_EOF");
		map.put(0x00000027, "ERROR_HANDLE_DISK_FULL");
		map.put(0x00000032, "ERROR_NOT_SUPPORTED");
		map.put(0x00000033, "ERROR_REM_NOT_LIST");
		map.put(0x00000034, "ERROR_DUP_NAME");
		map.put(0x00000035, "ERROR_BAD_NETPATH");
		map.put(0x00000036, "ERROR_NETWORK_BUSY");
		map.put(0x00000037, "ERROR_DEV_NOT_EXIST");
		map.put(0x00000038, "ERROR_TOO_MANY_CMDS");
		map.put(0x00000039, "ERROR_ADAP_HDW_ERR");
		map.put(0x0000003A, "ERROR_BAD_NET_RESP");
		map.put(0x0000003B, "ERROR_UNEXP_NET_ERR");
		map.put(0x0000003C, "ERROR_BAD_REM_ADAP");
		map.put(0x0000003D, "ERROR_PRINTQ_FULL");
		map.put(0x0000003E, "ERROR_NO_SPOOL_SPACE");
		map.put(0x0000003F, "ERROR_PRINT_CANCELLED");
		map.put(0x00000040, "ERROR_NETNAME_DELETED");
		map.put(0x00000041, "ERROR_NETWORK_ACCESS_DENIED");
		map.put(0x00000042, "ERROR_BAD_DEV_TYPE");
		map.put(0x00000043, "ERROR_BAD_NET_NAME");
		map.put(0x00000044, "ERROR_TOO_MANY_NAMES");
		map.put(0x00000045, "ERROR_TOO_MANY_SESS");
		map.put(0x00000046, "ERROR_SHARING_PAUSED");
		map.put(0x00000047, "ERROR_REQ_NOT_ACCEP");
		map.put(0x00000048, "ERROR_REDIR_PAUSED");
		map.put(0x00000050, "ERROR_FILE_EXISTS");
		map.put(0x00000052, "ERROR_CANNOT_MAKE");
		map.put(0x00000053, "ERROR_FAIL_I24");
		map.put(0x00000054, "ERROR_OUT_OF_STRUCTURES");
		map.put(0x00000055, "ERROR_ALREADY_ASSIGNED");
		map.put(0x00000056, "ERROR_INVALID_PASSWORD");
		map.put(0x00000057, "ERROR_INVALID_PARAMETER");
		map.put(0x00000058, "ERROR_NET_WRITE_FAULT");
		map.put(0x00000059, "ERROR_NO_PROC_SLOTS");
		map.put(0x00000064, "ERROR_TOO_MANY_SEMAPHORES");
		map.put(0x00000065, "ERROR_EXCL_SEM_ALREADY_OWNED");
		map.put(0x00000066, "ERROR_SEM_IS_SET");
		map.put(0x00000067, "ERROR_TOO_MANY_SEM_REQUESTS");
		map.put(0x00000068, "ERROR_INVALID_AT_INTERRUPT_TIME");
		map.put(0x00000069, "ERROR_SEM_OWNER_DIED");
		map.put(0x0000006A, "ERROR_SEM_USER_LIMIT");
		map.put(0x0000006B, "ERROR_DISK_CHANGE");
		map.put(0x0000006C, "ERROR_DRIVE_LOCKED");
		map.put(0x0000006D, "ERROR_BROKEN_PIPE");
		map.put(0x0000006E, "ERROR_OPEN_FAILED");
		map.put(0x0000006F, "ERROR_BUFFER_OVERFLOW");
		map.put(0x00000070, "ERROR_DISK_FULL");
		map.put(0x00000071, "ERROR_NO_MORE_SEARCH_HANDLES");
		map.put(0x00000072, "ERROR_INVALID_TARGET_HANDLE");
		map.put(0x00000075, "ERROR_INVALID_CATEGORY");
		map.put(0x00000076, "ERROR_INVALID_VERIFY_SWITCH");
		map.put(0x00000077, "ERROR_BAD_DRIVER_LEVEL");
		map.put(0x00000078, "ERROR_CALL_NOT_IMPLEMENTED");
		map.put(0x00000079, "ERROR_SEM_TIMEOUT");
		map.put(0x0000007A, "ERROR_INSUFFICIENT_BUFFER");
		map.put(0x0000007B, "ERROR_INVALID_NAME");
		map.put(0x0000007C, "ERROR_INVALID_LEVEL");
		map.put(0x0000007D, "ERROR_NO_VOLUME_LABEL");
		map.put(0x0000007E, "ERROR_MOD_NOT_FOUND");
		map.put(0x0000007F, "ERROR_PROC_NOT_FOUND");
		map.put(0x00000080, "ERROR_WAIT_NO_CHILDREN");
		map.put(0x00000081, "ERROR_CHILD_NOT_COMPLETE");
		map.put(0x00000082, "ERROR_DIRECT_ACCESS_HANDLE");
		map.put(0x00000083, "ERROR_NEGATIVE_SEEK");
		map.put(0x00000084, "ERROR_SEEK_ON_DEVICE");
		map.put(0x00000085, "ERROR_IS_JOIN_TARGET");
		map.put(0x00000086, "ERROR_IS_JOINED");
		map.put(0x00000087, "ERROR_IS_SUBSTED");
		map.put(0x00000088, "ERROR_NOT_JOINED");
		map.put(0x00000089, "ERROR_NOT_SUBSTED");
		map.put(0x0000008A, "ERROR_JOIN_TO_JOIN");
		map.put(0x0000008B, "ERROR_SUBST_TO_SUBST");
		map.put(0x0000008C, "ERROR_JOIN_TO_SUBST");
		map.put(0x0000008D, "ERROR_SUBST_TO_JOIN");
		map.put(0x0000008E, "ERROR_BUSY_DRIVE");
		map.put(0x0000008F, "ERROR_SAME_DRIVE");
		map.put(0x00000090, "ERROR_DIR_NOT_ROOT");
		map.put(0x00000091, "ERROR_DIR_NOT_EMPTY");
		map.put(0x00000092, "ERROR_IS_SUBST_PATH");
		map.put(0x00000093, "ERROR_IS_JOIN_PATH");
		map.put(0x00000094, "ERROR_PATH_BUSY");
		map.put(0x00000095, "ERROR_IS_SUBST_TARGET");
		map.put(0x00000096, "ERROR_SYSTEM_TRACE");
		map.put(0x00000097, "ERROR_INVALID_EVENT_COUNT");
		map.put(0x00000098, "ERROR_TOO_MANY_MUXWAITERS");
		map.put(0x00000099, "ERROR_INVALID_LIST_FORMAT");
		map.put(0x0000009A, "ERROR_LABEL_TOO_LONG");
		map.put(0x0000009B, "ERROR_TOO_MANY_TCBS");
		map.put(0x0000009C, "ERROR_SIGNAL_REFUSED");
		map.put(0x0000009D, "ERROR_DISCARDED");
		map.put(0x0000009E, "ERROR_NOT_LOCKED");
		map.put(0x0000009F, "ERROR_BAD_THREADID_ADDR");
		map.put(0x000000A0, "ERROR_BAD_ARGUMENTS");
		map.put(0x000000A1, "ERROR_BAD_PATHNAME");
		map.put(0x000000A2, "ERROR_SIGNAL_PENDING");
		map.put(0x000000A4, "ERROR_MAX_THRDS_REACHED");
		map.put(0x000000A7, "ERROR_LOCK_FAILED");
		map.put(0x000000AA, "ERROR_BUSY");
		map.put(0x000000AD, "ERROR_CANCEL_VIOLATION");
		map.put(0x000000AE, "ERROR_ATOMIC_LOCKS_NOT_SUPPORTED");
		map.put(0x000000B4, "ERROR_INVALID_SEGMENT_NUMBER");
		map.put(0x000000B6, "ERROR_INVALID_ORDINAL");
		map.put(0x000000B7, "ERROR_ALREADY_EXISTS");
		map.put(0x000000BA, "ERROR_INVALID_FLAG_NUMBER");
		map.put(0x000000BB, "ERROR_SEM_NOT_FOUND");
		map.put(0x000000BC, "ERROR_INVALID_STARTING_CODESEG");
		map.put(0x000000BD, "ERROR_INVALID_STACKSEG");
		map.put(0x000000BE, "ERROR_INVALID_MODULETYPE");
		map.put(0x000000BF, "ERROR_INVALID_EXE_SIGNATURE");
		map.put(0x000000C0, "ERROR_EXE_MARKED_INVALID");
		map.put(0x000000C1, "ERROR_BAD_EXE_FORMAT");
		map.put(0x000000C2, "ERROR_ITERATED_DATA_EXCEEDS_64k");
		map.put(0x000000C3, "ERROR_INVALID_MINALLOCSIZE");
		map.put(0x000000C4, "ERROR_DYNLINK_FROM_INVALID_RING");
		map.put(0x000000C5, "ERROR_IOPL_NOT_ENABLED");
		map.put(0x000000C6, "ERROR_INVALID_SEGDPL");
		map.put(0x000000C7, "ERROR_AUTODATASEG_EXCEEDS_64k");
		map.put(0x000000C8, "ERROR_RING2SEG_MUST_BE_MOVABLE");
		map.put(0x000000C9, "ERROR_RELOC_CHAIN_XEEDS_SEGLIM");
		map.put(0x000000CA, "ERROR_INFLOOP_IN_RELOC_CHAIN");
		map.put(0x000000CB, "ERROR_ENVVAR_NOT_FOUND");
		map.put(0x000000CD, "ERROR_NO_SIGNAL_SENT");
		map.put(0x000000CE, "ERROR_FILENAME_EXCED_RANGE");
		map.put(0x000000CF, "ERROR_RING2_STACK_IN_USE");
		map.put(0x000000D0, "ERROR_META_EXPANSION_TOO_LONG");
		map.put(0x000000D1, "ERROR_INVALID_SIGNAL_NUMBER");
		map.put(0x000000D2, "ERROR_THREAD_1_INACTIVE");
		map.put(0x000000D4, "ERROR_LOCKED");
		map.put(0x000000D6, "ERROR_TOO_MANY_MODULES");
		map.put(0x000000D7, "ERROR_NESTING_NOT_ALLOWED");
		map.put(0x000000D8, "ERROR_EXE_MACHINE_TYPE_MISMATCH");
		map.put(0x000000D9, "ERROR_EXE_CANNOT_MODIFY_SIGNED_BINARY");
		map.put(0x000000DA, "ERROR_EXE_CANNOT_MODIFY_STRONG_SIGNED_BINARY");
		map.put(0x000000DC, "ERROR_FILE_CHECKED_OUT");
		map.put(0x000000DD, "ERROR_CHECKOUT_REQUIRED");
		map.put(0x000000DE, "ERROR_BAD_FILE_TYPE");
		map.put(0x000000DF, "ERROR_FILE_TOO_LARGE");
		map.put(0x000000E0, "ERROR_FORMS_AUTH_REQUIRED");
		map.put(0x000000E1, "ERROR_VIRUS_INFECTED");
		map.put(0x000000E2, "ERROR_VIRUS_DELETED");
		map.put(0x000000E5, "ERROR_PIPE_LOCAL");
		map.put(0x000000E6, "ERROR_BAD_PIPE");
		map.put(0x000000E7, "ERROR_PIPE_BUSY");
		map.put(0x000000E8, "ERROR_NO_DATA");
		map.put(0x000000E9, "ERROR_PIPE_NOT_CONNECTED");
		map.put(0x000000EA, "ERROR_MORE_DATA");
		map.put(0x000000F0, "ERROR_VC_DISCONNECTED");
		map.put(0x000000FE, "ERROR_INVALID_EA_NAME");
		map.put(0x000000FF, "ERROR_EA_LIST_INCONSISTENT");
		map.put(0x00000102, "WAIT_TIMEOUT");
		map.put(0x00000103, "ERROR_NO_MORE_ITEMS");
		map.put(0x0000010A, "ERROR_CANNOT_COPY");
		map.put(0x0000010B, "ERROR_DIRECTORY");
		map.put(0x00000113, "ERROR_EAS_DIDNT_FIT");
		map.put(0x00000114, "ERROR_EA_FILE_CORRUPT");
		map.put(0x00000115, "ERROR_EA_TABLE_FULL");
		map.put(0x00000116, "ERROR_INVALID_EA_HANDLE");
		map.put(0x0000011A, "ERROR_EAS_NOT_SUPPORTED");
		map.put(0x00000120, "ERROR_NOT_OWNER");
		map.put(0x0000012A, "ERROR_TOO_MANY_POSTS");
		map.put(0x0000012B, "ERROR_PARTIAL_COPY");
		map.put(0x0000012C, "ERROR_OPLOCK_NOT_GRANTED");
		map.put(0x0000012D, "ERROR_INVALID_OPLOCK_PROTOCOL");
		map.put(0x0000012E, "ERROR_DISK_TOO_FRAGMENTED");
		map.put(0x0000012F, "ERROR_DELETE_PENDING");
		map.put(0x0000013D, "ERROR_MR_MID_NOT_FOUND");
		map.put(0x0000013E, "ERROR_SCOPE_NOT_FOUND");
		map.put(0x0000015E, "ERROR_FAIL_NOACTION_REBOOT");
		map.put(0x0000015F, "ERROR_FAIL_SHUTDOWN");
		map.put(0x00000160, "ERROR_FAIL_RESTART");
		map.put(0x00000161, "ERROR_MAX_SESSIONS_REACHED");
		map.put(0x00000190, "ERROR_THREAD_MODE_ALREADY_BACKGROUND");
		map.put(0x00000191, "ERROR_THREAD_MODE_NOT_BACKGROUND");
		map.put(0x00000192, "ERROR_PROCESS_MODE_ALREADY_BACKGROUND");
		map.put(0x00000193, "ERROR_PROCESS_MODE_NOT_BACKGROUND");
		map.put(0x000001E7, "ERROR_INVALID_ADDRESS");
		map.put(0x000001F4, "ERROR_USER_PROFILE_LOAD");
		map.put(0x00000216, "ERROR_ARITHMETIC_OVERFLOW");
		map.put(0x00000217, "ERROR_PIPE_CONNECTED");
		map.put(0x00000218, "ERROR_PIPE_LISTENING");
		map.put(0x00000219, "ERROR_VERIFIER_STOP");
		map.put(0x0000021A, "ERROR_ABIOS_ERROR");
		map.put(0x0000021B, "ERROR_WX86_WARNING");
		map.put(0x0000021C, "ERROR_WX86_ERROR");
		map.put(0x0000021D, "ERROR_TIMER_NOT_CANCELED");
		map.put(0x0000021E, "ERROR_UNWIND");
		map.put(0x0000021F, "ERROR_BAD_STACK");
		map.put(0x00000220, "ERROR_INVALID_UNWIND_TARGET");
		map.put(0x00000221, "ERROR_INVALID_PORT_ATTRIBUTES");
		map.put(0x00000222, "ERROR_PORT_MESSAGE_TOO_LONG");
		map.put(0x00000223, "ERROR_INVALID_QUOTA_LOWER");
		map.put(0x00000224, "ERROR_DEVICE_ALREADY_ATTACHED");
		map.put(0x00000225, "ERROR_INSTRUCTION_MISALIGNMENT");
		map.put(0x00000226, "ERROR_PROFILING_NOT_STARTED");
		map.put(0x00000227, "ERROR_PROFILING_NOT_STOPPED");
		map.put(0x00000228, "ERROR_COULD_NOT_INTERPRET");
		map.put(0x00000229, "ERROR_PROFILING_AT_LIMIT");
		map.put(0x0000022A, "ERROR_CANT_WAIT");
		map.put(0x0000022B, "ERROR_CANT_TERMINATE_SELF");
		map.put(0x0000022C, "ERROR_UNEXPECTED_MM_CREATE_ERR");
		map.put(0x0000022D, "ERROR_UNEXPECTED_MM_MAP_ERROR");
		map.put(0x0000022E, "ERROR_UNEXPECTED_MM_EXTEND_ERR");
		map.put(0x0000022F, "ERROR_BAD_FUNCTION_TABLE");
		map.put(0x00000230, "ERROR_NO_GUID_TRANSLATION");
		map.put(0x00000231, "ERROR_INVALID_LDT_SIZE");
		map.put(0x00000233, "ERROR_INVALID_LDT_OFFSET");
		map.put(0x00000234, "ERROR_INVALID_LDT_DESCRIPTOR");
		map.put(0x00000235, "ERROR_TOO_MANY_THREADS");
		map.put(0x00000236, "ERROR_THREAD_NOT_IN_PROCESS");
		map.put(0x00000237, "ERROR_PAGEFILE_QUOTA_EXCEEDED");
		map.put(0x00000238, "ERROR_LOGON_SERVER_CONFLICT");
		map.put(0x00000239, "ERROR_SYNCHRONIZATION_REQUIRED");
		map.put(0x0000023A, "ERROR_NET_OPEN_FAILED");
		map.put(0x0000023B, "ERROR_IO_PRIVILEGE_FAILED");
		map.put(0x0000023C, "ERROR_CONTROL_C_EXIT");
		map.put(0x0000023D, "ERROR_MISSING_SYSTEMFILE");
		map.put(0x0000023E, "ERROR_UNHANDLED_EXCEPTION");
		map.put(0x0000023F, "ERROR_APP_INIT_FAILURE");
		map.put(0x00000240, "ERROR_PAGEFILE_CREATE_FAILED");
		map.put(0x00000241, "ERROR_INVALID_IMAGE_HASH");
		map.put(0x00000242, "ERROR_NO_PAGEFILE");
		map.put(0x00000243, "ERROR_ILLEGAL_FLOAT_CONTEXT");
		map.put(0x00000244, "ERROR_NO_EVENT_PAIR");
		map.put(0x00000245, "ERROR_DOMAIN_CTRLR_CONFIG_ERROR");
		map.put(0x00000246, "ERROR_ILLEGAL_CHARACTER");
		map.put(0x00000247, "ERROR_UNDEFINED_CHARACTER");
		map.put(0x00000248, "ERROR_FLOPPY_VOLUME");
		map.put(0x00000249, "ERROR_BIOS_FAILED_TO_CONNECT_INTERRUPT");
		map.put(0x0000024A, "ERROR_BACKUP_CONTROLLER");
		map.put(0x0000024B, "ERROR_MUTANT_LIMIT_EXCEEDED");
		map.put(0x0000024C, "ERROR_FS_DRIVER_REQUIRED");
		map.put(0x0000024D, "ERROR_CANNOT_LOAD_REGISTRY_FILE");
		map.put(0x0000024E, "ERROR_DEBUG_ATTACH_FAILED");
		map.put(0x0000024F, "ERROR_SYSTEM_PROCESS_TERMINATED");
		map.put(0x00000250, "ERROR_DATA_NOT_ACCEPTED");
		map.put(0x00000251, "ERROR_VDM_HARD_ERROR");
		map.put(0x00000252, "ERROR_DRIVER_CANCEL_TIMEOUT");
		map.put(0x00000253, "ERROR_REPLY_MESSAGE_MISMATCH");
		map.put(0x00000254, "ERROR_LOST_WRITEBEHIND_DATA");
		map.put(0x00000255, "ERROR_CLIENT_SERVER_PARAMETERS_INVALID");
		map.put(0x00000256, "ERROR_NOT_TINY_STREAM");
		map.put(0x00000257, "ERROR_STACK_OVERFLOW_READ");
		map.put(0x00000258, "ERROR_CONVERT_TO_LARGE");
		map.put(0x00000259, "ERROR_FOUND_OUT_OF_SCOPE");
		map.put(0x0000025A, "ERROR_ALLOCATE_BUCKET");
		map.put(0x0000025B, "ERROR_MARSHALL_OVERFLOW");
		map.put(0x0000025C, "ERROR_INVALID_VARIANT");
		map.put(0x0000025D, "ERROR_BAD_COMPRESSION_BUFFER");
		map.put(0x0000025E, "ERROR_AUDIT_FAILED");
		map.put(0x0000025F, "ERROR_TIMER_RESOLUTION_NOT_SET");
		map.put(0x00000260, "ERROR_INSUFFICIENT_LOGON_INFO");
		map.put(0x00000261, "ERROR_BAD_DLL_ENTRYPOINT");
		map.put(0x00000262, "ERROR_BAD_SERVICE_ENTRYPOINT");
		map.put(0x00000263, "ERROR_IP_ADDRESS_CONFLICT1");
		map.put(0x00000264, "ERROR_IP_ADDRESS_CONFLICT2");
		map.put(0x00000265, "ERROR_REGISTRY_QUOTA_LIMIT");
		map.put(0x00000266, "ERROR_NO_CALLBACK_ACTIVE");
		map.put(0x00000267, "ERROR_PWD_TOO_SHORT");
		map.put(0x00000268, "ERROR_PWD_TOO_RECENT");
		map.put(0x00000269, "ERROR_PWD_HISTORY_CONFLICT");
		map.put(0x0000026A, "ERROR_UNSUPPORTED_COMPRESSION");
		map.put(0x0000026B, "ERROR_INVALID_HW_PROFILE");
		map.put(0x0000026C, "ERROR_INVALID_PLUGPLAY_DEVICE_PATH");
		map.put(0x0000026D, "ERROR_QUOTA_LIST_INCONSISTENT");
		map.put(0x0000026E, "ERROR_EVALUATION_EXPIRATION");
		map.put(0x0000026F, "ERROR_ILLEGAL_DLL_RELOCATION");
		map.put(0x00000270, "ERROR_DLL_INIT_FAILED_LOGOFF");
		map.put(0x00000271, "ERROR_VALIDATE_CONTINUE");
		map.put(0x00000272, "ERROR_NO_MORE_MATCHES");
		map.put(0x00000273, "ERROR_RANGE_LIST_CONFLICT");
		map.put(0x00000274, "ERROR_SERVER_SID_MISMATCH");
		map.put(0x00000275, "ERROR_CANT_ENABLE_DENY_ONLY");
		map.put(0x00000276, "ERROR_FLOAT_MULTIPLE_FAULTS");
		map.put(0x00000277, "ERROR_FLOAT_MULTIPLE_TRAPS");
		map.put(0x00000278, "ERROR_NOINTERFACE");
		map.put(0x00000279, "ERROR_DRIVER_FAILED_SLEEP");
		map.put(0x0000027A, "ERROR_CORRUPT_SYSTEM_FILE");
		map.put(0x0000027B, "ERROR_COMMITMENT_MINIMUM");
		map.put(0x0000027C, "ERROR_PNP_RESTART_ENUMERATION");
		map.put(0x0000027D, "ERROR_SYSTEM_IMAGE_BAD_SIGNATURE");
		map.put(0x0000027E, "ERROR_PNP_REBOOT_REQUIRED");
		map.put(0x0000027F, "ERROR_INSUFFICIENT_POWER");
		map.put(0x00000281, "ERROR_SYSTEM_SHUTDOWN");
		map.put(0x00000282, "ERROR_PORT_NOT_SET");
		map.put(0x00000283, "ERROR_DS_VERSION_CHECK_FAILURE");
		map.put(0x00000284, "ERROR_RANGE_NOT_FOUND");
		map.put(0x00000286, "ERROR_NOT_SAFE_MODE_DRIVER");
		map.put(0x00000287, "ERROR_FAILED_DRIVER_ENTRY");
		map.put(0x00000288, "ERROR_DEVICE_ENUMERATION_ERROR");
		map.put(0x00000289, "ERROR_MOUNT_POINT_NOT_RESOLVED");
		map.put(0x0000028A, "ERROR_INVALID_DEVICE_OBJECT_PARAMETER");
		map.put(0x0000028B, "ERROR_MCA_OCCURED");
		map.put(0x0000028C, "ERROR_DRIVER_DATABASE_ERROR");
		map.put(0x0000028D, "ERROR_SYSTEM_HIVE_TOO_LARGE");
		map.put(0x0000028E, "ERROR_DRIVER_FAILED_PRIOR_UNLOAD");
		map.put(0x0000028F, "ERROR_VOLSNAP_PREPARE_HIBERNATE");
		map.put(0x00000290, "ERROR_HIBERNATION_FAILURE");
		map.put(0x00000299, "ERROR_FILE_SYSTEM_LIMITATION");
		map.put(0x0000029C, "ERROR_ASSERTION_FAILURE");
		map.put(0x0000029D, "ERROR_ACPI_ERROR");
		map.put(0x0000029E, "ERROR_WOW_ASSERTION");
		map.put(0x0000029F, "ERROR_PNP_BAD_MPS_TABLE");
		map.put(0x000002A0, "ERROR_PNP_TRANSLATION_FAILED");
		map.put(0x000002A1, "ERROR_PNP_IRQ_TRANSLATION_FAILED");
		map.put(0x000002A2, "ERROR_PNP_INVALID_ID");
		map.put(0x000002A3, "ERROR_WAKE_SYSTEM_DEBUGGER");
		map.put(0x000002A4, "ERROR_HANDLES_CLOSED");
		map.put(0x000002A5, "ERROR_EXTRANEOUS_INFORMATION");
		map.put(0x000002A6, "ERROR_RXACT_COMMIT_NECESSARY");
		map.put(0x000002A7, "ERROR_MEDIA_CHECK");
		map.put(0x000002A8, "ERROR_GUID_SUBSTITUTION_MADE");
		map.put(0x000002A9, "ERROR_STOPPED_ON_SYMLINK");
		map.put(0x000002AA, "ERROR_LONGJUMP");
		map.put(0x000002AB, "ERROR_PLUGPLAY_QUERY_VETOED");
		map.put(0x000002AC, "ERROR_UNWIND_CONSOLIDATE");
		map.put(0x000002AD, "ERROR_REGISTRY_HIVE_RECOVERED");
		map.put(0x000002AE, "ERROR_DLL_MIGHT_BE_INSECURE");
		map.put(0x000002AF, "ERROR_DLL_MIGHT_BE_INCOMPATIBLE");
		map.put(0x000002B0, "ERROR_DBG_EXCEPTION_NOT_HANDLED");
		map.put(0x000002B1, "ERROR_DBG_REPLY_LATER");
		map.put(0x000002B2, "ERROR_DBG_UNABLE_TO_PROVIDE_HANDLE");
		map.put(0x000002B3, "ERROR_DBG_TERMINATE_THREAD");
		map.put(0x000002B4, "ERROR_DBG_TERMINATE_PROCESS");
		map.put(0x000002B5, "ERROR_DBG_CONTROL_C");
		map.put(0x000002B6, "ERROR_DBG_PRINTEXCEPTION_C");
		map.put(0x000002B7, "ERROR_DBG_RIPEXCEPTION");
		map.put(0x000002B8, "ERROR_DBG_CONTROL_BREAK");
		map.put(0x000002B9, "ERROR_DBG_COMMAND_EXCEPTION");
		map.put(0x000002BA, "ERROR_OBJECT_NAME_EXISTS");
		map.put(0x000002BB, "ERROR_THREAD_WAS_SUSPENDED");
		map.put(0x000002BC, "ERROR_IMAGE_NOT_AT_BASE");
		map.put(0x000002BD, "ERROR_RXACT_STATE_CREATED");
		map.put(0x000002BE, "ERROR_SEGMENT_NOTIFICATION");
		map.put(0x000002BF, "ERROR_BAD_CURRENT_DIRECTORY");
		map.put(0x000002C0, "ERROR_FT_READ_RECOVERY_FROM_BACKUP");
		map.put(0x000002C1, "ERROR_FT_WRITE_RECOVERY");
		map.put(0x000002C2, "ERROR_IMAGE_MACHINE_TYPE_MISMATCH");
		map.put(0x000002C3, "ERROR_RECEIVE_PARTIAL");
		map.put(0x000002C4, "ERROR_RECEIVE_EXPEDITED");
		map.put(0x000002C5, "ERROR_RECEIVE_PARTIAL_EXPEDITED");
		map.put(0x000002C6, "ERROR_EVENT_DONE");
		map.put(0x000002C7, "ERROR_EVENT_PENDING");
		map.put(0x000002C8, "ERROR_CHECKING_FILE_SYSTEM");
		map.put(0x000002C9, "ERROR_FATAL_APP_EXIT");
		map.put(0x000002CA, "ERROR_PREDEFINED_HANDLE");
		map.put(0x000002CB, "ERROR_WAS_UNLOCKED");
		map.put(0x000002CD, "ERROR_WAS_LOCKED");
		map.put(0x000002CF, "ERROR_ALREADY_WIN32");
		map.put(0x000002D0, "ERROR_IMAGE_MACHINE_TYPE_MISMATCH_EXE");
		map.put(0x000002D1, "ERROR_NO_YIELD_PERFORMED");
		map.put(0x000002D2, "ERROR_TIMER_RESUME_IGNORED");
		map.put(0x000002D3, "ERROR_ARBITRATION_UNHANDLED");
		map.put(0x000002D4, "ERROR_CARDBUS_NOT_SUPPORTED");
		map.put(0x000002D5, "ERROR_MP_PROCESSOR_MISMATCH");
		map.put(0x000002D6, "ERROR_HIBERNATED");
		map.put(0x000002D7, "ERROR_RESUME_HIBERNATION");
		map.put(0x000002D8, "ERROR_FIRMWARE_UPDATED");
		map.put(0x000002D9, "ERROR_DRIVERS_LEAKING_LOCKED_PAGES");
		map.put(0x000002DA, "ERROR_WAKE_SYSTEM");
		map.put(0x000002DF, "ERROR_ABANDONED_WAIT_0");
		map.put(0x000002E4, "ERROR_ELEVATION_REQUIRED");
		map.put(0x000002E5, "ERROR_REPARSE");
		map.put(0x000002E6, "ERROR_OPLOCK_BREAK_IN_PROGRESS");
		map.put(0x000002E7, "ERROR_VOLUME_MOUNTED");
		map.put(0x000002E8, "ERROR_RXACT_COMMITTED");
		map.put(0x000002E9, "ERROR_NOTIFY_CLEANUP");
		map.put(0x000002EA, "ERROR_PRIMARY_TRANSPORT_CONNECT_FAILED");
		map.put(0x000002EB, "ERROR_PAGE_FAULT_TRANSITION");
		map.put(0x000002EC, "ERROR_PAGE_FAULT_DEMAND_ZERO");
		map.put(0x000002ED, "ERROR_PAGE_FAULT_COPY_ON_WRITE");
		map.put(0x000002EE, "ERROR_PAGE_FAULT_GUARD_PAGE");
		map.put(0x000002EF, "ERROR_PAGE_FAULT_PAGING_FILE");
		map.put(0x000002F0, "ERROR_CACHE_PAGE_LOCKED");
		map.put(0x000002F1, "ERROR_CRASH_DUMP");
		map.put(0x000002F2, "ERROR_BUFFER_ALL_ZEROS");
		map.put(0x000002F3, "ERROR_REPARSE_OBJECT");
		map.put(0x000002F4, "ERROR_RESOURCE_REQUIREMENTS_CHANGED");
		map.put(0x000002F5, "ERROR_TRANSLATION_COMPLETE");
		map.put(0x000002F6, "ERROR_NOTHING_TO_TERMINATE");
		map.put(0x000002F7, "ERROR_PROCESS_NOT_IN_JOB");
		map.put(0x000002F8, "ERROR_PROCESS_IN_JOB");
		map.put(0x000002F9, "ERROR_VOLSNAP_HIBERNATE_READY");
		map.put(0x000002FA, "ERROR_FSFILTER_OP_COMPLETED_SUCCESSFULLY");
		map.put(0x000002FB, "ERROR_INTERRUPT_VECTOR_ALREADY_CONNECTED");
		map.put(0x000002FC, "ERROR_INTERRUPT_STILL_CONNECTED");
		map.put(0x000002FD, "ERROR_WAIT_FOR_OPLOCK");
		map.put(0x000002FE, "ERROR_DBG_EXCEPTION_HANDLED");
		map.put(0x000002FF, "ERROR_DBG_CONTINUE");
		map.put(0x00000300, "ERROR_CALLBACK_POP_STACK");
		map.put(0x00000301, "ERROR_COMPRESSION_DISABLED");
		map.put(0x00000302, "ERROR_CANTFETCHBACKWARDS");
		map.put(0x00000303, "ERROR_CANTSCROLLBACKWARDS");
		map.put(0x00000304, "ERROR_ROWSNOTRELEASED");
		map.put(0x00000305, "ERROR_BAD_ACCESSOR_FLAGS");
		map.put(0x00000306, "ERROR_ERRORS_ENCOUNTERED");
		map.put(0x00000307, "ERROR_NOT_CAPABLE");
		map.put(0x00000308, "ERROR_REQUEST_OUT_OF_SEQUENCE");
		map.put(0x00000309, "ERROR_VERSION_PARSE_ERROR");
		map.put(0x0000030A, "ERROR_BADSTARTPOSITION");
		map.put(0x0000030B, "ERROR_MEMORY_HARDWARE");
		map.put(0x0000030C, "ERROR_DISK_REPAIR_DISABLED");
		map.put(0x0000030D, "ERROR_INSUFFICIENT_RESOURCE_FOR_SPECIFIED_SHARED_SECTION_SIZE");
		map.put(0x0000030E, "ERROR_SYSTEM_POWERSTATE_TRANSITION");
		map.put(0x0000030F, "ERROR_SYSTEM_POWERSTATE_COMPLEX_TRANSITION");
		map.put(0x00000310, "ERROR_MCA_EXCEPTION");
		map.put(0x00000311, "ERROR_ACCESS_AUDIT_BY_POLICY");
		map.put(0x00000312, "ERROR_ACCESS_DISABLED_NO_SAFER_UI_BY_POLICY");
		map.put(0x00000313, "ERROR_ABANDON_HIBERFILE");
		map.put(0x00000314, "ERROR_LOST_WRITEBEHIND_DATA_NETWORK_DISCONNECTED");
		map.put(0x00000315, "ERROR_LOST_WRITEBEHIND_DATA_NETWORK_SERVER_ERROR");
		map.put(0x00000316, "ERROR_LOST_WRITEBEHIND_DATA_LOCAL_DISK_ERROR");
		map.put(0x000003E2, "ERROR_EA_ACCESS_DENIED");
		map.put(0x000003E3, "ERROR_OPERATION_ABORTED");
		map.put(0x000003E4, "ERROR_IO_INCOMPLETE");
		map.put(0x000003E5, "ERROR_IO_PENDING");
		map.put(0x000003E6, "ERROR_NOACCESS");
		map.put(0x000003E7, "ERROR_SWAPERROR");
		map.put(0x000003E9, "ERROR_STACK_OVERFLOW");
		map.put(0x000003EA, "ERROR_INVALID_MESSAGE");
		map.put(0x000003EB, "ERROR_CAN_NOT_COMPLETE");
		map.put(0x000003EC, "ERROR_INVALID_FLAGS");
		map.put(0x000003ED, "ERROR_UNRECOGNIZED_VOLUME");
		map.put(0x000003EE, "ERROR_FILE_INVALID");
		map.put(0x000003EF, "ERROR_FULLSCREEN_MODE");
		map.put(0x000003F0, "ERROR_NO_TOKEN");
		map.put(0x000003F1, "ERROR_BADDB");
		map.put(0x000003F2, "ERROR_BADKEY");
		map.put(0x000003F3, "ERROR_CANTOPEN");
		map.put(0x000003F4, "ERROR_CANTREAD");
		map.put(0x000003F5, "ERROR_CANTWRITE");
		map.put(0x000003F6, "ERROR_REGISTRY_RECOVERED");
		map.put(0x000003F7, "ERROR_REGISTRY_CORRUPT");
		map.put(0x000003F8, "ERROR_REGISTRY_IO_FAILED");
		map.put(0x000003F9, "ERROR_NOT_REGISTRY_FILE");
		map.put(0x000003FA, "ERROR_KEY_DELETED");
		map.put(0x000003FB, "ERROR_NO_LOG_SPACE");
		map.put(0x000003FC, "ERROR_KEY_HAS_CHILDREN");
		map.put(0x000003FD, "ERROR_CHILD_MUST_BE_VOLATILE");
		map.put(0x000003FE, "ERROR_NOTIFY_ENUM_DIR");
		map.put(0x0000041B, "ERROR_DEPENDENT_SERVICES_RUNNING");
		map.put(0x0000041C, "ERROR_INVALID_SERVICE_CONTROL");
		map.put(0x0000041D, "ERROR_SERVICE_REQUEST_TIMEOUT");
		map.put(0x0000041E, "ERROR_SERVICE_NO_THREAD");
		map.put(0x0000041F, "ERROR_SERVICE_DATABASE_LOCKED");
		map.put(0x00000420, "ERROR_SERVICE_ALREADY_RUNNING");
		map.put(0x00000421, "ERROR_INVALID_SERVICE_ACCOUNT");
		map.put(0x00000422, "ERROR_SERVICE_DISABLED");
		map.put(0x00000423, "ERROR_CIRCULAR_DEPENDENCY");
		map.put(0x00000424, "ERROR_SERVICE_DOES_NOT_EXIST");
		map.put(0x00000425, "ERROR_SERVICE_CANNOT_ACCEPT_CTRL");
		map.put(0x00000426, "ERROR_SERVICE_NOT_ACTIVE");
		map.put(0x00000427, "ERROR_FAILED_SERVICE_CONTROLLER_CONNECT");
		map.put(0x00000428, "ERROR_EXCEPTION_IN_SERVICE");
		map.put(0x00000429, "ERROR_DATABASE_DOES_NOT_EXIST");
		map.put(0x0000042A, "ERROR_SERVICE_SPECIFIC_ERROR");
		map.put(0x0000042B, "ERROR_PROCESS_ABORTED");
		map.put(0x0000042C, "ERROR_SERVICE_DEPENDENCY_FAIL");
		map.put(0x0000042D, "ERROR_SERVICE_LOGON_FAILED");
		map.put(0x0000042E, "ERROR_SERVICE_START_HANG");
		map.put(0x0000042F, "ERROR_INVALID_SERVICE_LOCK");
		map.put(0x00000430, "ERROR_SERVICE_MARKED_FOR_DELETE");
		map.put(0x00000431, "ERROR_SERVICE_EXISTS");
		map.put(0x00000432, "ERROR_ALREADY_RUNNING_LKG");
		map.put(0x00000433, "ERROR_SERVICE_DEPENDENCY_DELETED");
		map.put(0x00000434, "ERROR_BOOT_ALREADY_ACCEPTED");
		map.put(0x00000435, "ERROR_SERVICE_NEVER_STARTED");
		map.put(0x00000436, "ERROR_DUPLICATE_SERVICE_NAME");
		map.put(0x00000437, "ERROR_DIFFERENT_SERVICE_ACCOUNT");
		map.put(0x00000438, "ERROR_CANNOT_DETECT_DRIVER_FAILURE");
		map.put(0x00000439, "ERROR_CANNOT_DETECT_PROCESS_ABORT");
		map.put(0x0000043A, "ERROR_NO_RECOVERY_PROGRAM");
		map.put(0x0000043B, "ERROR_SERVICE_NOT_IN_EXE");
		map.put(0x0000043C, "ERROR_NOT_SAFEBOOT_SERVICE");
		map.put(0x0000044C, "ERROR_END_OF_MEDIA");
		map.put(0x0000044D, "ERROR_FILEMARK_DETECTED");
		map.put(0x0000044E, "ERROR_BEGINNING_OF_MEDIA");
		map.put(0x0000044F, "ERROR_SETMARK_DETECTED");
		map.put(0x00000450, "ERROR_NO_DATA_DETECTED");
		map.put(0x00000451, "ERROR_PARTITION_FAILURE");
		map.put(0x00000452, "ERROR_INVALID_BLOCK_LENGTH");
		map.put(0x00000453, "ERROR_DEVICE_NOT_PARTITIONED");
		map.put(0x00000454, "ERROR_UNABLE_TO_LOCK_MEDIA");
		map.put(0x00000455, "ERROR_UNABLE_TO_UNLOAD_MEDIA");
		map.put(0x00000456, "ERROR_MEDIA_CHANGED");
		map.put(0x00000457, "ERROR_BUS_RESET");
		map.put(0x00000458, "ERROR_NO_MEDIA_IN_DRIVE");
		map.put(0x00000459, "ERROR_NO_UNICODE_TRANSLATION");
		map.put(0x0000045A, "ERROR_DLL_INIT_FAILED");
		map.put(0x0000045B, "ERROR_SHUTDOWN_IN_PROGRESS");
		map.put(0x0000045C, "ERROR_NO_SHUTDOWN_IN_PROGRESS");
		map.put(0x0000045D, "ERROR_IO_DEVICE");
		map.put(0x0000045E, "ERROR_SERIAL_NO_DEVICE");
		map.put(0x0000045F, "ERROR_IRQ_BUSY");
		map.put(0x00000460, "ERROR_MORE_WRITES");
		map.put(0x00000461, "ERROR_COUNTER_TIMEOUT");
		map.put(0x00000462, "ERROR_FLOPPY_ID_MARK_NOT_FOUND");
		map.put(0x00000463, "ERROR_FLOPPY_WRONG_CYLINDER");
		map.put(0x00000464, "ERROR_FLOPPY_UNKNOWN_ERROR");
		map.put(0x00000465, "ERROR_FLOPPY_BAD_REGISTERS");
		map.put(0x00000466, "ERROR_DISK_RECALIBRATE_FAILED");
		map.put(0x00000467, "ERROR_DISK_OPERATION_FAILED");
		map.put(0x00000468, "ERROR_DISK_RESET_FAILED");
		map.put(0x00000469, "ERROR_EOM_OVERFLOW");
		map.put(0x0000046A, "ERROR_NOT_ENOUGH_SERVER_MEMORY");
		map.put(0x0000046B, "ERROR_POSSIBLE_DEADLOCK");
		map.put(0x0000046C, "ERROR_MAPPED_ALIGNMENT");
		map.put(0x00000474, "ERROR_SET_POWER_STATE_VETOED");
		map.put(0x00000475, "ERROR_SET_POWER_STATE_FAILED");
		map.put(0x00000476, "ERROR_TOO_MANY_LINKS");
		map.put(0x0000047E, "ERROR_OLD_WIN_VERSION");
		map.put(0x0000047F, "ERROR_APP_WRONG_OS");
		map.put(0x00000480, "ERROR_SINGLE_INSTANCE_APP");
		map.put(0x00000481, "ERROR_RMODE_APP");
		map.put(0x00000482, "ERROR_INVALID_DLL");
		map.put(0x00000483, "ERROR_NO_ASSOCIATION");
		map.put(0x00000484, "ERROR_DDE_FAIL");
		map.put(0x00000485, "ERROR_DLL_NOT_FOUND");
		map.put(0x00000486, "ERROR_NO_MORE_USER_HANDLES");
		map.put(0x00000487, "ERROR_MESSAGE_SYNC_ONLY");
		map.put(0x00000488, "ERROR_SOURCE_ELEMENT_EMPTY");
		map.put(0x00000489, "ERROR_DESTINATION_ELEMENT_FULL");
		map.put(0x0000048A, "ERROR_ILLEGAL_ELEMENT_ADDRESS");
		map.put(0x0000048B, "ERROR_MAGAZINE_NOT_PRESENT");
		map.put(0x0000048C, "ERROR_DEVICE_REINITIALIZATION_NEEDED");
		map.put(0x0000048D, "ERROR_DEVICE_REQUIRES_CLEANING");
		map.put(0x0000048E, "ERROR_DEVICE_DOOR_OPEN");
		map.put(0x0000048F, "ERROR_DEVICE_NOT_CONNECTED");
		map.put(0x00000490, "ERROR_NOT_FOUND");
		map.put(0x00000491, "ERROR_NO_MATCH");
		map.put(0x00000492, "ERROR_SET_NOT_FOUND");
		map.put(0x00000493, "ERROR_POINT_NOT_FOUND");
		map.put(0x00000494, "ERROR_NO_TRACKING_SERVICE");
		map.put(0x00000495, "ERROR_NO_VOLUME_ID");
		map.put(0x00000497, "ERROR_UNABLE_TO_REMOVE_REPLACED");
		map.put(0x00000498, "ERROR_UNABLE_TO_MOVE_REPLACEMENT");
		map.put(0x00000499, "ERROR_UNABLE_TO_MOVE_REPLACEMENT_2");
		map.put(0x0000049A, "ERROR_JOURNAL_DELETE_IN_PROGRESS");
		map.put(0x0000049B, "ERROR_JOURNAL_NOT_ACTIVE");
		map.put(0x0000049C, "ERROR_POTENTIAL_FILE_FOUND");
		map.put(0x0000049D, "ERROR_JOURNAL_ENTRY_DELETED");
		map.put(0x000004A6, "ERROR_SHUTDOWN_IS_SCHEDULED");
		map.put(0x000004A7, "ERROR_SHUTDOWN_USERS_LOGGED_ON");
		map.put(0x000004B0, "ERROR_BAD_DEVICE");
		map.put(0x000004B1, "ERROR_CONNECTION_UNAVAIL");
		map.put(0x000004B2, "ERROR_DEVICE_ALREADY_REMEMBERED");
		map.put(0x000004B3, "ERROR_NO_NET_OR_BAD_PATH");
		map.put(0x000004B4, "ERROR_BAD_PROVIDER");
		map.put(0x000004B5, "ERROR_CANNOT_OPEN_PROFILE");
		map.put(0x000004B6, "ERROR_BAD_PROFILE");
		map.put(0x000004B7, "ERROR_NOT_CONTAINER");
		map.put(0x000004B8, "ERROR_EXTENDED_ERROR");
		map.put(0x000004B9, "ERROR_INVALID_GROUPNAME");
		map.put(0x000004BA, "ERROR_INVALID_COMPUTERNAME");
		map.put(0x000004BB, "ERROR_INVALID_EVENTNAME");
		map.put(0x000004BC, "ERROR_INVALID_DOMAINNAME");
		map.put(0x000004BD, "ERROR_INVALID_SERVICENAME");
		map.put(0x000004BE, "ERROR_INVALID_NETNAME");
		map.put(0x000004BF, "ERROR_INVALID_SHARENAME");
		map.put(0x000004C0, "ERROR_INVALID_PASSWORDNAME");
		map.put(0x000004C1, "ERROR_INVALID_MESSAGENAME");
		map.put(0x000004C2, "ERROR_INVALID_MESSAGEDEST");
		map.put(0x000004C3, "ERROR_SESSION_CREDENTIAL_CONFLICT");
		map.put(0x000004C4, "ERROR_REMOTE_SESSION_LIMIT_EXCEEDED");
		map.put(0x000004C5, "ERROR_DUP_DOMAINNAME");
		map.put(0x000004C6, "ERROR_NO_NETWORK");
		map.put(0x000004C7, "ERROR_CANCELLED");
		map.put(0x000004C8, "ERROR_USER_MAPPED_FILE");
		map.put(0x000004C9, "ERROR_CONNECTION_REFUSED");
		map.put(0x000004CA, "ERROR_GRACEFUL_DISCONNECT");
		map.put(0x000004CB, "ERROR_ADDRESS_ALREADY_ASSOCIATED");
		map.put(0x000004CC, "ERROR_ADDRESS_NOT_ASSOCIATED");
		map.put(0x000004CD, "ERROR_CONNECTION_INVALID");
		map.put(0x000004CE, "ERROR_CONNECTION_ACTIVE");
		map.put(0x000004CF, "ERROR_NETWORK_UNREACHABLE");
		map.put(0x000004D0, "ERROR_HOST_UNREACHABLE");
		map.put(0x000004D1, "ERROR_PROTOCOL_UNREACHABLE");
		map.put(0x000004D2, "ERROR_PORT_UNREACHABLE");
		map.put(0x000004D3, "ERROR_REQUEST_ABORTED");
		map.put(0x000004D4, "ERROR_CONNECTION_ABORTED");
		map.put(0x000004D5, "ERROR_RETRY");
		map.put(0x000004D6, "ERROR_CONNECTION_COUNT_LIMIT");
		map.put(0x000004D7, "ERROR_LOGIN_TIME_RESTRICTION");
		map.put(0x000004D8, "ERROR_LOGIN_WKSTA_RESTRICTION");
		map.put(0x000004D9, "ERROR_INCORRECT_ADDRESS");
		map.put(0x000004DA, "ERROR_ALREADY_REGISTERED");
		map.put(0x000004DB, "ERROR_SERVICE_NOT_FOUND");
		map.put(0x000004DC, "ERROR_NOT_AUTHENTICATED");
		map.put(0x000004DD, "ERROR_NOT_LOGGED_ON");
		map.put(0x000004DE, "ERROR_CONTINUE");
		map.put(0x000004DF, "ERROR_ALREADY_INITIALIZED");
		map.put(0x000004E0, "ERROR_NO_MORE_DEVICES");
		map.put(0x000004E1, "ERROR_NO_SUCH_SITE");
		map.put(0x000004E2, "ERROR_DOMAIN_CONTROLLER_EXISTS");
		map.put(0x000004E3, "ERROR_ONLY_IF_CONNECTED");
		map.put(0x000004E4, "ERROR_OVERRIDE_NOCHANGES");
		map.put(0x000004E5, "ERROR_BAD_USER_PROFILE");
		map.put(0x000004E6, "ERROR_NOT_SUPPORTED_ON_SBS");
		map.put(0x000004E7, "ERROR_SERVER_SHUTDOWN_IN_PROGRESS");
		map.put(0x000004E8, "ERROR_HOST_DOWN");
		map.put(0x000004E9, "ERROR_NON_ACCOUNT_SID");
		map.put(0x000004EA, "ERROR_NON_DOMAIN_SID");
		map.put(0x000004EB, "ERROR_APPHELP_BLOCK");
		map.put(0x000004EC, "ERROR_ACCESS_DISABLED_BY_POLICY");
		map.put(0x000004ED, "ERROR_REG_NAT_CONSUMPTION");
		map.put(0x000004EE, "ERROR_CSCSHARE_OFFLINE");
		map.put(0x000004EF, "ERROR_PKINIT_FAILURE");
		map.put(0x000004F0, "ERROR_SMARTCARD_SUBSYSTEM_FAILURE");
		map.put(0x000004F1, "ERROR_DOWNGRADE_DETECTED");
		map.put(0x000004F7, "ERROR_MACHINE_LOCKED");
		map.put(0x000004F9, "ERROR_CALLBACK_SUPPLIED_INVALID_DATA");
		map.put(0x000004FA, "ERROR_SYNC_FOREGROUND_REFRESH_REQUIRED");
		map.put(0x000004FB, "ERROR_DRIVER_BLOCKED");
		map.put(0x000004FC, "ERROR_INVALID_IMPORT_OF_NON_DLL");
		map.put(0x000004FD, "ERROR_ACCESS_DISABLED_WEBBLADE");
		map.put(0x000004FE, "ERROR_ACCESS_DISABLED_WEBBLADE_TAMPER");
		map.put(0x000004FF, "ERROR_RECOVERY_FAILURE");
		map.put(0x00000500, "ERROR_ALREADY_FIBER");
		map.put(0x00000501, "ERROR_ALREADY_THREAD");
		map.put(0x00000502, "ERROR_STACK_BUFFER_OVERRUN");
		map.put(0x00000503, "ERROR_PARAMETER_QUOTA_EXCEEDED");
		map.put(0x00000504, "ERROR_DEBUGGER_INACTIVE");
		map.put(0x00000505, "ERROR_DELAY_LOAD_FAILED");
		map.put(0x00000506, "ERROR_VDM_DISALLOWED");
		map.put(0x00000507, "ERROR_UNIDENTIFIED_ERROR");
		map.put(0x00000508, "ERROR_INVALID_CRUNTIME_PARAMETER");
		map.put(0x00000509, "ERROR_BEYOND_VDL");
		map.put(0x0000050A, "ERROR_INCOMPATIBLE_SERVICE_SID_TYPE");
		map.put(0x0000050B, "ERROR_DRIVER_PROCESS_TERMINATED");
		map.put(0x0000050C, "ERROR_IMPLEMENTATION_LIMIT");
		map.put(0x0000050D, "ERROR_PROCESS_IS_PROTECTED");
		map.put(0x0000050E, "ERROR_SERVICE_NOTIFY_CLIENT_LAGGING");
		map.put(0x0000050F, "ERROR_DISK_QUOTA_EXCEEDED");
		map.put(0x00000510, "ERROR_CONTENT_BLOCKED");
		map.put(0x00000511, "ERROR_INCOMPATIBLE_SERVICE_PRIVILEGE");
		map.put(0x00000513, "ERROR_INVALID_LABEL");
		map.put(0x00000514, "ERROR_NOT_ALL_ASSIGNED");
		map.put(0x00000515, "ERROR_SOME_NOT_MAPPED");
		map.put(0x00000516, "ERROR_NO_QUOTAS_FOR_ACCOUNT");
		map.put(0x00000517, "ERROR_LOCAL_USER_SESSION_KEY");
		map.put(0x00000518, "ERROR_NULL_LM_PASSWORD");
		map.put(0x00000519, "ERROR_UNKNOWN_REVISION");
		map.put(0x0000051A, "ERROR_REVISION_MISMATCH");
		map.put(0x0000051B, "ERROR_INVALID_OWNER");
		map.put(0x0000051C, "ERROR_INVALID_PRIMARY_GROUP");
		map.put(0x0000051D, "ERROR_NO_IMPERSONATION_TOKEN");
		map.put(0x0000051E, "ERROR_CANT_DISABLE_MANDATORY");
		map.put(0x0000051F, "ERROR_NO_LOGON_SERVERS");
		map.put(0x00000520, "ERROR_NO_SUCH_LOGON_SESSION");
		map.put(0x00000521, "ERROR_NO_SUCH_PRIVILEGE");
		map.put(0x00000522, "ERROR_PRIVILEGE_NOT_HELD");
		map.put(0x00000523, "ERROR_INVALID_ACCOUNT_NAME");
		map.put(0x00000524, "ERROR_USER_EXISTS");
		map.put(0x00000525, "ERROR_NO_SUCH_USER");
		map.put(0x00000526, "ERROR_GROUP_EXISTS");
		map.put(0x00000527, "ERROR_NO_SUCH_GROUP");
		map.put(0x00000528, "ERROR_MEMBER_IN_GROUP");
		map.put(0x00000529, "ERROR_MEMBER_NOT_IN_GROUP");
		map.put(0x0000052A, "ERROR_LAST_ADMIN");
		map.put(0x0000052B, "ERROR_WRONG_PASSWORD");
		map.put(0x0000052C, "ERROR_ILL_FORMED_PASSWORD");
		map.put(0x0000052D, "ERROR_PASSWORD_RESTRICTION");
		map.put(0x0000052E, "ERROR_LOGON_FAILURE");
		map.put(0x0000052F, "ERROR_ACCOUNT_RESTRICTION");
		map.put(0x00000530, "ERROR_INVALID_LOGON_HOURS");
		map.put(0x00000531, "ERROR_INVALID_WORKSTATION");
		map.put(0x00000532, "ERROR_PASSWORD_EXPIRED");
		map.put(0x00000533, "ERROR_ACCOUNT_DISABLED");
		map.put(0x00000534, "ERROR_NONE_MAPPED");
		map.put(0x00000535, "ERROR_TOO_MANY_LUIDS_REQUESTED");
		map.put(0x00000536, "ERROR_LUIDS_EXHAUSTED");
		map.put(0x00000537, "ERROR_INVALID_SUB_AUTHORITY");
		map.put(0x00000538, "ERROR_INVALID_ACL");
		map.put(0x00000539, "ERROR_INVALID_SID");
		map.put(0x0000053A, "ERROR_INVALID_SECURITY_DESCR");
		map.put(0x0000053C, "ERROR_BAD_INHERITANCE_ACL");
		map.put(0x0000053D, "ERROR_SERVER_DISABLED");
		map.put(0x0000053E, "ERROR_SERVER_NOT_DISABLED");
		map.put(0x0000053F, "ERROR_INVALID_ID_AUTHORITY");
		map.put(0x00000540, "ERROR_ALLOTTED_SPACE_EXCEEDED");
		map.put(0x00000541, "ERROR_INVALID_GROUP_ATTRIBUTES");
		map.put(0x00000542, "ERROR_BAD_IMPERSONATION_LEVEL");
		map.put(0x00000543, "ERROR_CANT_OPEN_ANONYMOUS");
		map.put(0x00000544, "ERROR_BAD_VALIDATION_CLASS");
		map.put(0x00000545, "ERROR_BAD_TOKEN_TYPE");
		map.put(0x00000546, "ERROR_NO_SECURITY_ON_OBJECT");
		map.put(0x00000547, "ERROR_CANT_ACCESS_DOMAIN_INFO");
		map.put(0x00000548, "ERROR_INVALID_SERVER_STATE");
		map.put(0x00000549, "ERROR_INVALID_DOMAIN_STATE");
		map.put(0x0000054A, "ERROR_INVALID_DOMAIN_ROLE");
		map.put(0x0000054B, "ERROR_NO_SUCH_DOMAIN");
		map.put(0x0000054C, "ERROR_DOMAIN_EXISTS");
		map.put(0x0000054D, "ERROR_DOMAIN_LIMIT_EXCEEDED");
		map.put(0x0000054E, "ERROR_INTERNAL_DB_CORRUPTION");
		map.put(0x0000054F, "ERROR_INTERNAL_ERROR");
		map.put(0x00000550, "ERROR_GENERIC_NOT_MAPPED");
		map.put(0x00000551, "ERROR_BAD_DESCRIPTOR_FORMAT");
		map.put(0x00000552, "ERROR_NOT_LOGON_PROCESS");
		map.put(0x00000553, "ERROR_LOGON_SESSION_EXISTS");
		map.put(0x00000554, "ERROR_NO_SUCH_PACKAGE");
		map.put(0x00000555, "ERROR_BAD_LOGON_SESSION_STATE");
		map.put(0x00000556, "ERROR_LOGON_SESSION_COLLISION");
		map.put(0x00000557, "ERROR_INVALID_LOGON_TYPE");
		map.put(0x00000558, "ERROR_CANNOT_IMPERSONATE");
		map.put(0x00000559, "ERROR_RXACT_INVALID_STATE");
		map.put(0x0000055A, "ERROR_RXACT_COMMIT_FAILURE");
		map.put(0x0000055B, "ERROR_SPECIAL_ACCOUNT");
		map.put(0x0000055C, "ERROR_SPECIAL_GROUP");
		map.put(0x0000055D, "ERROR_SPECIAL_USER");
		map.put(0x0000055E, "ERROR_MEMBERS_PRIMARY_GROUP");
		map.put(0x0000055F, "ERROR_TOKEN_ALREADY_IN_USE");
		map.put(0x00000560, "ERROR_NO_SUCH_ALIAS");
		map.put(0x00000561, "ERROR_MEMBER_NOT_IN_ALIAS");
		map.put(0x00000562, "ERROR_MEMBER_IN_ALIAS");
		map.put(0x00000563, "ERROR_ALIAS_EXISTS");
		map.put(0x00000564, "ERROR_LOGON_NOT_GRANTED");
		map.put(0x00000565, "ERROR_TOO_MANY_SECRETS");
		map.put(0x00000566, "ERROR_SECRET_TOO_LONG");
		map.put(0x00000567, "ERROR_INTERNAL_DB_ERROR");
		map.put(0x00000568, "ERROR_TOO_MANY_CONTEXT_IDS");
		map.put(0x00000569, "ERROR_LOGON_TYPE_NOT_GRANTED");
		map.put(0x0000056A, "ERROR_NT_CROSS_ENCRYPTION_REQUIRED");
		map.put(0x0000056B, "ERROR_NO_SUCH_MEMBER");
		map.put(0x0000056C, "ERROR_INVALID_MEMBER");
		map.put(0x0000056D, "ERROR_TOO_MANY_SIDS");
		map.put(0x0000056E, "ERROR_LM_CROSS_ENCRYPTION_REQUIRED");
		map.put(0x0000056F, "ERROR_NO_INHERITANCE");
		map.put(0x00000570, "ERROR_FILE_CORRUPT");
		map.put(0x00000571, "ERROR_DISK_CORRUPT");
		map.put(0x00000572, "ERROR_NO_USER_SESSION_KEY");
		map.put(0x00000573, "ERROR_LICENSE_QUOTA_EXCEEDED");
		map.put(0x00000574, "ERROR_WRONG_TARGET_NAME");
		map.put(0x00000575, "ERROR_MUTUAL_AUTH_FAILED");
		map.put(0x00000576, "ERROR_TIME_SKEW");
		map.put(0x00000577, "ERROR_CURRENT_DOMAIN_NOT_ALLOWED");
		map.put(0x00000578, "ERROR_INVALID_WINDOW_HANDLE");
		map.put(0x00000579, "ERROR_INVALID_MENU_HANDLE");
		map.put(0x0000057A, "ERROR_INVALID_CURSOR_HANDLE");
		map.put(0x0000057B, "ERROR_INVALID_ACCEL_HANDLE");
		map.put(0x0000057C, "ERROR_INVALID_HOOK_HANDLE");
		map.put(0x0000057D, "ERROR_INVALID_DWP_HANDLE");
		map.put(0x0000057E, "ERROR_TLW_WITH_WSCHILD");
		map.put(0x0000057F, "ERROR_CANNOT_FIND_WND_CLASS");
		map.put(0x00000580, "ERROR_WINDOW_OF_OTHER_THREAD");
		map.put(0x00000581, "ERROR_HOTKEY_ALREADY_REGISTERED");
		map.put(0x00000582, "ERROR_CLASS_ALREADY_EXISTS");
		map.put(0x00000583, "ERROR_CLASS_DOES_NOT_EXIST");
		map.put(0x00000584, "ERROR_CLASS_HAS_WINDOWS");
		map.put(0x00000585, "ERROR_INVALID_INDEX");
		map.put(0x00000586, "ERROR_INVALID_ICON_HANDLE");
		map.put(0x00000587, "ERROR_PRIVATE_DIALOG_INDEX");
		map.put(0x00000588, "ERROR_LISTBOX_ID_NOT_FOUND");
		map.put(0x00000589, "ERROR_NO_WILDCARD_CHARACTERS");
		map.put(0x0000058A, "ERROR_CLIPBOARD_NOT_OPEN");
		map.put(0x0000058B, "ERROR_HOTKEY_NOT_REGISTERED");
		map.put(0x0000058C, "ERROR_WINDOW_NOT_DIALOG");
		map.put(0x0000058D, "ERROR_CONTROL_ID_NOT_FOUND");
		map.put(0x0000058E, "ERROR_INVALID_COMBOBOX_MESSAGE");
		map.put(0x0000058F, "ERROR_WINDOW_NOT_COMBOBOX");
		map.put(0x00000590, "ERROR_INVALID_EDIT_HEIGHT");
		map.put(0x00000591, "ERROR_DC_NOT_FOUND");
		map.put(0x00000592, "ERROR_INVALID_HOOK_FILTER");
		map.put(0x00000593, "ERROR_INVALID_FILTER_PROC");
		map.put(0x00000594, "ERROR_HOOK_NEEDS_HMOD");
		map.put(0x00000595, "ERROR_GLOBAL_ONLY_HOOK");
		map.put(0x00000596, "ERROR_JOURNAL_HOOK_SET");
		map.put(0x00000597, "ERROR_HOOK_NOT_INSTALLED");
		map.put(0x00000598, "ERROR_INVALID_LB_MESSAGE");
		map.put(0x00000599, "ERROR_SETCOUNT_ON_BAD_LB");
		map.put(0x0000059A, "ERROR_LB_WITHOUT_TABSTOPS");
		map.put(0x0000059B, "ERROR_DESTROY_OBJECT_OF_OTHER_THREAD");
		map.put(0x0000059C, "ERROR_CHILD_WINDOW_MENU");
		map.put(0x0000059D, "ERROR_NO_SYSTEM_MENU");
		map.put(0x0000059E, "ERROR_INVALID_MSGBOX_STYLE");
		map.put(0x0000059F, "ERROR_INVALID_SPI_VALUE");
		map.put(0x000005A0, "ERROR_SCREEN_ALREADY_LOCKED");
		map.put(0x000005A1, "ERROR_HWNDS_HAVE_DIFF_PARENT");
		map.put(0x000005A2, "ERROR_NOT_CHILD_WINDOW");
		map.put(0x000005A3, "ERROR_INVALID_GW_COMMAND");
		map.put(0x000005A4, "ERROR_INVALID_THREAD_ID");
		map.put(0x000005A5, "ERROR_NON_MDICHILD_WINDOW");
		map.put(0x000005A6, "ERROR_POPUP_ALREADY_ACTIVE");
		map.put(0x000005A7, "ERROR_NO_SCROLLBARS");
		map.put(0x000005A8, "ERROR_INVALID_SCROLLBAR_RANGE");
		map.put(0x000005A9, "ERROR_INVALID_SHOWWIN_COMMAND");
		map.put(0x000005AA, "ERROR_NO_SYSTEM_RESOURCES");
		map.put(0x000005AB, "ERROR_NONPAGED_SYSTEM_RESOURCES");
		map.put(0x000005AC, "ERROR_PAGED_SYSTEM_RESOURCES");
		map.put(0x000005AD, "ERROR_WORKING_SET_QUOTA");
		map.put(0x000005AE, "ERROR_PAGEFILE_QUOTA");
		map.put(0x000005AF, "ERROR_COMMITMENT_LIMIT");
		map.put(0x000005B0, "ERROR_MENU_ITEM_NOT_FOUND");
		map.put(0x000005B1, "ERROR_INVALID_KEYBOARD_HANDLE");
		map.put(0x000005B2, "ERROR_HOOK_TYPE_NOT_ALLOWED");
		map.put(0x000005B3, "ERROR_REQUIRES_INTERACTIVE_WINDOWSTATION");
		map.put(0x000005B4, "ERROR_TIMEOUT");
		map.put(0x000005B5, "ERROR_INVALID_MONITOR_HANDLE");
		map.put(0x000005B6, "ERROR_INCORRECT_SIZE");
		map.put(0x000005B7, "ERROR_SYMLINK_CLASS_DISABLED");
		map.put(0x000005B8, "ERROR_SYMLINK_NOT_SUPPORTED");
		map.put(0x000005DC, "ERROR_EVENTLOG_FILE_CORRUPT");
		map.put(0x000005DD, "ERROR_EVENTLOG_CANT_START");
		map.put(0x000005DE, "ERROR_LOG_FILE_FULL");
		map.put(0x000005DF, "ERROR_EVENTLOG_FILE_CHANGED");
		map.put(0x0000060E, "ERROR_INVALID_TASK_NAME");
		map.put(0x0000060F, "ERROR_INVALID_TASK_INDEX");
		map.put(0x00000610, "ERROR_THREAD_ALREADY_IN_TASK");
		map.put(0x00000641, "ERROR_INSTALL_SERVICE_FAILURE");
		map.put(0x00000642, "ERROR_INSTALL_USEREXIT");
		map.put(0x00000643, "ERROR_INSTALL_FAILURE");
		map.put(0x00000644, "ERROR_INSTALL_SUSPEND");
		map.put(0x00000645, "ERROR_UNKNOWN_PRODUCT");
		map.put(0x00000646, "ERROR_UNKNOWN_FEATURE");
		map.put(0x00000647, "ERROR_UNKNOWN_COMPONENT");
		map.put(0x00000648, "ERROR_UNKNOWN_PROPERTY");
		map.put(0x00000649, "ERROR_INVALID_HANDLE_STATE");
		map.put(0x0000064A, "ERROR_BAD_CONFIGURATION");
		map.put(0x0000064B, "ERROR_INDEX_ABSENT");
		map.put(0x0000064C, "ERROR_INSTALL_SOURCE_ABSENT");
		map.put(0x0000064D, "ERROR_INSTALL_PACKAGE_VERSION");
		map.put(0x0000064E, "ERROR_PRODUCT_UNINSTALLED");
		map.put(0x0000064F, "ERROR_BAD_QUERY_SYNTAX");
		map.put(0x00000650, "ERROR_INVALID_FIELD");
		map.put(0x00000651, "ERROR_DEVICE_REMOVED");
		map.put(0x00000652, "ERROR_INSTALL_ALREADY_RUNNING");
		map.put(0x00000653, "ERROR_INSTALL_PACKAGE_OPEN_FAILED");
		map.put(0x00000654, "ERROR_INSTALL_PACKAGE_INVALID");
		map.put(0x00000655, "ERROR_INSTALL_UI_FAILURE");
		map.put(0x00000656, "ERROR_INSTALL_LOG_FAILURE");
		map.put(0x00000657, "ERROR_INSTALL_LANGUAGE_UNSUPPORTED");
		map.put(0x00000658, "ERROR_INSTALL_TRANSFORM_FAILURE");
		map.put(0x00000659, "ERROR_INSTALL_PACKAGE_REJECTED");
		map.put(0x0000065A, "ERROR_FUNCTION_NOT_CALLED");
		map.put(0x0000065B, "ERROR_FUNCTION_FAILED");
		map.put(0x0000065C, "ERROR_INVALID_TABLE");
		map.put(0x0000065D, "ERROR_DATATYPE_MISMATCH");
		map.put(0x0000065E, "ERROR_UNSUPPORTED_TYPE");
		map.put(0x0000065F, "ERROR_CREATE_FAILED");
		map.put(0x00000660, "ERROR_INSTALL_TEMP_UNWRITABLE");
		map.put(0x00000661, "ERROR_INSTALL_PLATFORM_UNSUPPORTED");
		map.put(0x00000662, "ERROR_INSTALL_NOTUSED");
		map.put(0x00000663, "ERROR_PATCH_PACKAGE_OPEN_FAILED");
		map.put(0x00000664, "ERROR_PATCH_PACKAGE_INVALID");
		map.put(0x00000665, "ERROR_PATCH_PACKAGE_UNSUPPORTED");
		map.put(0x00000666, "ERROR_PRODUCT_VERSION");
		map.put(0x00000667, "ERROR_INVALID_COMMAND_LINE");
		map.put(0x00000668, "ERROR_INSTALL_REMOTE_DISALLOWED");
		map.put(0x00000669, "ERROR_SUCCESS_REBOOT_INITIATED");
		map.put(0x0000066A, "ERROR_PATCH_TARGET_NOT_FOUND");
		map.put(0x0000066B, "ERROR_PATCH_PACKAGE_REJECTED");
		map.put(0x0000066C, "ERROR_INSTALL_TRANSFORM_REJECTED");
		map.put(0x0000066D, "ERROR_INSTALL_REMOTE_PROHIBITED");
		map.put(0x0000066E, "ERROR_PATCH_REMOVAL_UNSUPPORTED");
		map.put(0x0000066F, "ERROR_UNKNOWN_PATCH");
		map.put(0x00000670, "ERROR_PATCH_NO_SEQUENCE");
		map.put(0x00000671, "ERROR_PATCH_REMOVAL_DISALLOWED");
		map.put(0x00000672, "ERROR_INVALID_PATCH_XML");
		map.put(0x00000673, "ERROR_PATCH_MANAGED_ADVERTISED_PRODUCT");
		map.put(0x00000674, "ERROR_INSTALL_SERVICE_SAFEBOOT");
		map.put(0x000006A4, "RPC_S_INVALID_STRING_BINDING");
		map.put(0x000006A5, "RPC_S_WRONG_KIND_OF_BINDING");
		map.put(0x000006A6, "RPC_S_INVALID_BINDING");
		map.put(0x000006A7, "RPC_S_PROTSEQ_NOT_SUPPORTED");
		map.put(0x000006A8, "RPC_S_INVALID_RPC_PROTSEQ");
		map.put(0x000006A9, "RPC_S_INVALID_STRING_UUID");
		map.put(0x000006AA, "RPC_S_INVALID_ENDPOINT_FORMAT");
		map.put(0x000006AB, "RPC_S_INVALID_NET_ADDR");
		map.put(0x000006AC, "RPC_S_NO_ENDPOINT_FOUND");
		map.put(0x000006AD, "RPC_S_INVALID_TIMEOUT");
		map.put(0x000006AE, "RPC_S_OBJECT_NOT_FOUND");
		map.put(0x000006AF, "RPC_S_ALREADY_REGISTERED");
		map.put(0x000006B0, "RPC_S_TYPE_ALREADY_REGISTERED");
		map.put(0x000006B1, "RPC_S_ALREADY_LISTENING");
		map.put(0x000006B2, "RPC_S_NO_PROTSEQS_REGISTERED");
		map.put(0x000006B3, "RPC_S_NOT_LISTENING");
		map.put(0x000006B4, "RPC_S_UNKNOWN_MGR_TYPE");
		map.put(0x000006B5, "RPC_S_UNKNOWN_IF");
		map.put(0x000006B6, "RPC_S_NO_BINDINGS");
		map.put(0x000006B7, "RPC_S_NO_PROTSEQS");
		map.put(0x000006B8, "RPC_S_CANT_CREATE_ENDPOINT");
		map.put(0x000006B9, "RPC_S_OUT_OF_RESOURCES");
		map.put(0x000006BA, "RPC_S_SERVER_UNAVAILABLE");
		map.put(0x000006BB, "RPC_S_SERVER_TOO_BUSY");
		map.put(0x000006BC, "RPC_S_INVALID_NETWORK_OPTIONS");
		map.put(0x000006BD, "RPC_S_NO_CALL_ACTIVE");
		map.put(0x000006BE, "RPC_S_CALL_FAILED");
		map.put(0x000006BF, "RPC_S_CALL_FAILED_DNE");
		map.put(0x000006C0, "RPC_S_PROTOCOL_ERROR");
		map.put(0x000006C1, "RPC_S_PROXY_ACCESS_DENIED");
		map.put(0x000006C2, "RPC_S_UNSUPPORTED_TRANS_SYN");
		map.put(0x000006C4, "RPC_S_UNSUPPORTED_TYPE");
		map.put(0x000006C5, "RPC_S_INVALID_TAG");
		map.put(0x000006C6, "RPC_S_INVALID_BOUND");
		map.put(0x000006C7, "RPC_S_NO_ENTRY_NAME");
		map.put(0x000006C8, "RPC_S_INVALID_NAME_SYNTAX");
		map.put(0x000006C9, "RPC_S_UNSUPPORTED_NAME_SYNTAX");
		map.put(0x000006CB, "RPC_S_UUID_NO_ADDRESS");
		map.put(0x000006CC, "RPC_S_DUPLICATE_ENDPOINT");
		map.put(0x000006CD, "RPC_S_UNKNOWN_AUTHN_TYPE");
		map.put(0x000006CE, "RPC_S_MAX_CALLS_TOO_SMALL");
		map.put(0x000006CF, "RPC_S_STRING_TOO_LONG");
		map.put(0x000006D0, "RPC_S_PROTSEQ_NOT_FOUND");
		map.put(0x000006D1, "RPC_S_PROCNUM_OUT_OF_RANGE");
		map.put(0x000006D2, "RPC_S_BINDING_HAS_NO_AUTH");
		map.put(0x000006D3, "RPC_S_UNKNOWN_AUTHN_SERVICE");
		map.put(0x000006D4, "RPC_S_UNKNOWN_AUTHN_LEVEL");
		map.put(0x000006D5, "RPC_S_INVALID_AUTH_IDENTITY");
		map.put(0x000006D6, "RPC_S_UNKNOWN_AUTHZ_SERVICE");
		map.put(0x000006D7, "EPT_S_INVALID_ENTRY");
		map.put(0x000006D8, "EPT_S_CANT_PERFORM_OP");
		map.put(0x000006D9, "EPT_S_NOT_REGISTERED");
		map.put(0x000006DA, "RPC_S_NOTHING_TO_EXPORT");
		map.put(0x000006DB, "RPC_S_INCOMPLETE_NAME");
		map.put(0x000006DC, "RPC_S_INVALID_VERS_OPTION");
		map.put(0x000006DD, "RPC_S_NO_MORE_MEMBERS");
		map.put(0x000006DE, "RPC_S_NOT_ALL_OBJS_UNEXPORTED");
		map.put(0x000006DF, "RPC_S_INTERFACE_NOT_FOUND");
		map.put(0x000006E0, "RPC_S_ENTRY_ALREADY_EXISTS");
		map.put(0x000006E1, "RPC_S_ENTRY_NOT_FOUND");
		map.put(0x000006E2, "RPC_S_NAME_SERVICE_UNAVAILABLE");
		map.put(0x000006E3, "RPC_S_INVALID_NAF_ID");
		map.put(0x000006E4, "RPC_S_CANNOT_SUPPORT");
		map.put(0x000006E5, "RPC_S_NO_CONTEXT_AVAILABLE");
		map.put(0x000006E6, "RPC_S_INTERNAL_ERROR");
		map.put(0x000006E7, "RPC_S_ZERO_DIVIDE");
		map.put(0x000006E8, "RPC_S_ADDRESS_ERROR");
		map.put(0x000006E9, "RPC_S_FP_DIV_ZERO");
		map.put(0x000006EA, "RPC_S_FP_UNDERFLOW");
		map.put(0x000006EB, "RPC_S_FP_OVERFLOW");
		map.put(0x000006EC, "RPC_X_NO_MORE_ENTRIES");
		map.put(0x000006ED, "RPC_X_SS_CHAR_TRANS_OPEN_FAIL");
		map.put(0x000006EE, "RPC_X_SS_CHAR_TRANS_SHORT_FILE");
		map.put(0x000006EF, "RPC_X_SS_IN_NULL_CONTEXT");
		map.put(0x000006F1, "RPC_X_SS_CONTEXT_DAMAGED");
		map.put(0x000006F2, "RPC_X_SS_HANDLES_MISMATCH");
		map.put(0x000006F3, "RPC_X_SS_CANNOT_GET_CALL_HANDLE");
		map.put(0x000006F4, "RPC_X_NULL_REF_POINTER");
		map.put(0x000006F5, "RPC_X_ENUM_VALUE_OUT_OF_RANGE");
		map.put(0x000006F6, "RPC_X_BYTE_COUNT_TOO_SMALL");
		map.put(0x000006F7, "RPC_X_BAD_STUB_DATA");
		map.put(0x000006F8, "ERROR_INVALID_USER_BUFFER");
		map.put(0x000006F9, "ERROR_UNRECOGNIZED_MEDIA");
		map.put(0x000006FA, "ERROR_NO_TRUST_LSA_SECRET");
		map.put(0x000006FB, "ERROR_NO_TRUST_SAM_ACCOUNT");
		map.put(0x000006FC, "ERROR_TRUSTED_DOMAIN_FAILURE");
		map.put(0x000006FD, "ERROR_TRUSTED_RELATIONSHIP_FAILURE");
		map.put(0x000006FE, "ERROR_TRUST_FAILURE");
		map.put(0x000006FF, "RPC_S_CALL_IN_PROGRESS");
		map.put(0x00000700, "ERROR_NETLOGON_NOT_STARTED");
		map.put(0x00000701, "ERROR_ACCOUNT_EXPIRED");
		map.put(0x00000702, "ERROR_REDIRECTOR_HAS_OPEN_HANDLES");
		map.put(0x00000703, "ERROR_PRINTER_DRIVER_ALREADY_INSTALLED");
		map.put(0x00000704, "ERROR_UNKNOWN_PORT");
		map.put(0x00000705, "ERROR_UNKNOWN_PRINTER_DRIVER");
		map.put(0x00000706, "ERROR_UNKNOWN_PRINTPROCESSOR");
		map.put(0x00000707, "ERROR_INVALID_SEPARATOR_FILE");
		map.put(0x00000708, "ERROR_INVALID_PRIORITY");
		map.put(0x00000709, "ERROR_INVALID_PRINTER_NAME");
		map.put(0x0000070A, "ERROR_PRINTER_ALREADY_EXISTS");
		map.put(0x0000070B, "ERROR_INVALID_PRINTER_COMMAND");
		map.put(0x0000070C, "ERROR_INVALID_DATATYPE");
		map.put(0x0000070D, "ERROR_INVALID_ENVIRONMENT");
		map.put(0x0000070E, "RPC_S_NO_MORE_BINDINGS");
		map.put(0x0000070F, "ERROR_NOLOGON_INTERDOMAIN_TRUST_ACCOUNT");
		map.put(0x00000710, "ERROR_NOLOGON_WORKSTATION_TRUST_ACCOUNT");
		map.put(0x00000711, "ERROR_NOLOGON_SERVER_TRUST_ACCOUNT");
		map.put(0x00000712, "ERROR_DOMAIN_TRUST_INCONSISTENT");
		map.put(0x00000713, "ERROR_SERVER_HAS_OPEN_HANDLES");
		map.put(0x00000714, "ERROR_RESOURCE_DATA_NOT_FOUND");
		map.put(0x00000715, "ERROR_RESOURCE_TYPE_NOT_FOUND");
		map.put(0x00000716, "ERROR_RESOURCE_NAME_NOT_FOUND");
		map.put(0x00000717, "ERROR_RESOURCE_LANG_NOT_FOUND");
		map.put(0x00000718, "ERROR_NOT_ENOUGH_QUOTA");
		map.put(0x00000719, "RPC_S_NO_INTERFACES");
		map.put(0x0000071A, "RPC_S_CALL_CANCELLED");
		map.put(0x0000071B, "RPC_S_BINDING_INCOMPLETE");
		map.put(0x0000071C, "RPC_S_COMM_FAILURE");
		map.put(0x0000071D, "RPC_S_UNSUPPORTED_AUTHN_LEVEL");
		map.put(0x0000071E, "RPC_S_NO_PRINC_NAME");
		map.put(0x0000071F, "RPC_S_NOT_RPC_ERROR");
		map.put(0x00000720, "RPC_S_UUID_LOCAL_ONLY");
		map.put(0x00000721, "RPC_S_SEC_PKG_ERROR");
		map.put(0x00000722, "RPC_S_NOT_CANCELLED");
		map.put(0x00000723, "RPC_X_INVALID_ES_ACTION");
		map.put(0x00000724, "RPC_X_WRONG_ES_VERSION");
		map.put(0x00000725, "RPC_X_WRONG_STUB_VERSION");
		map.put(0x00000726, "RPC_X_INVALID_PIPE_OBJECT");
		map.put(0x00000727, "RPC_X_WRONG_PIPE_ORDER");
		map.put(0x00000728, "RPC_X_WRONG_PIPE_VERSION");
		map.put(0x0000076A, "RPC_S_GROUP_MEMBER_NOT_FOUND");
		map.put(0x0000076B, "EPT_S_CANT_CREATE");
		map.put(0x0000076C, "RPC_S_INVALID_OBJECT");
		map.put(0x0000076D, "ERROR_INVALID_TIME");
		map.put(0x0000076E, "ERROR_INVALID_FORM_NAME");
		map.put(0x0000076F, "ERROR_INVALID_FORM_SIZE");
		map.put(0x00000770, "ERROR_ALREADY_WAITING");
		map.put(0x00000771, "ERROR_PRINTER_DELETED");
		map.put(0x00000772, "ERROR_INVALID_PRINTER_STATE");
		map.put(0x00000773, "ERROR_PASSWORD_MUST_CHANGE");
		map.put(0x00000774, "ERROR_DOMAIN_CONTROLLER_NOT_FOUND");
		map.put(0x00000775, "ERROR_ACCOUNT_LOCKED_OUT");
		map.put(0x00000776, "OR_INVALID_OXID");
		map.put(0x00000777, "OR_INVALID_OID");
		map.put(0x00000778, "OR_INVALID_SET");
		map.put(0x00000779, "RPC_S_SEND_INCOMPLETE");
		map.put(0x0000077A, "RPC_S_INVALID_ASYNC_HANDLE");
		map.put(0x0000077B, "RPC_S_INVALID_ASYNC_CALL");
		map.put(0x0000077C, "RPC_X_PIPE_CLOSED");
		map.put(0x0000077D, "RPC_X_PIPE_DISCIPLINE_ERROR");
		map.put(0x0000077E, "RPC_X_PIPE_EMPTY");
		map.put(0x0000077F, "ERROR_NO_SITENAME");
		map.put(0x00000780, "ERROR_CANT_ACCESS_FILE");
		map.put(0x00000781, "ERROR_CANT_RESOLVE_FILENAME");
		map.put(0x00000782, "RPC_S_ENTRY_TYPE_MISMATCH");
		map.put(0x00000783, "RPC_S_NOT_ALL_OBJS_EXPORTED");
		map.put(0x00000784, "RPC_S_INTERFACE_NOT_EXPORTED");
		map.put(0x00000785, "RPC_S_PROFILE_NOT_ADDED");
		map.put(0x00000786, "RPC_S_PRF_ELT_NOT_ADDED");
		map.put(0x00000787, "RPC_S_PRF_ELT_NOT_REMOVED");
		map.put(0x00000788, "RPC_S_GRP_ELT_NOT_ADDED");
		map.put(0x00000789, "RPC_S_GRP_ELT_NOT_REMOVED");
		map.put(0x0000078A, "ERROR_KM_DRIVER_BLOCKED");
		map.put(0x0000078B, "ERROR_CONTEXT_EXPIRED");
		map.put(0x0000078C, "ERROR_PER_USER_TRUST_QUOTA_EXCEEDED");
		map.put(0x0000078D, "ERROR_ALL_USER_TRUST_QUOTA_EXCEEDED");
		map.put(0x0000078E, "ERROR_USER_DELETE_TRUST_QUOTA_EXCEEDED");
		map.put(0x0000078F, "ERROR_AUTHENTICATION_FIREWALL_FAILED");
		map.put(0x00000790, "ERROR_REMOTE_PRINT_CONNECTIONS_BLOCKED");
		map.put(0x000007D0, "ERROR_INVALID_PIXEL_FORMAT");
		map.put(0x000007D1, "ERROR_BAD_DRIVER");
		map.put(0x000007D2, "ERROR_INVALID_WINDOW_STYLE");
		map.put(0x000007D3, "ERROR_METAFILE_NOT_SUPPORTED");
		map.put(0x000007D4, "ERROR_TRANSFORM_NOT_SUPPORTED");
		map.put(0x000007D5, "ERROR_CLIPPING_NOT_SUPPORTED");
		map.put(0x000007DA, "ERROR_INVALID_CMM");
		map.put(0x000007DB, "ERROR_INVALID_PROFILE");
		map.put(0x000007DC, "ERROR_TAG_NOT_FOUND");
		map.put(0x000007DD, "ERROR_TAG_NOT_PRESENT");
		map.put(0x000007DE, "ERROR_DUPLICATE_TAG");
		map.put(0x000007DF, "ERROR_PROFILE_NOT_ASSOCIATED_WITH_DEVICE");
		map.put(0x000007E0, "ERROR_PROFILE_NOT_FOUND");
		map.put(0x000007E1, "ERROR_INVALID_COLORSPACE");
		map.put(0x000007E2, "ERROR_ICM_NOT_ENABLED");
		map.put(0x000007E3, "ERROR_DELETING_ICM_XFORM");
		map.put(0x000007E4, "ERROR_INVALID_TRANSFORM");
		map.put(0x000007E5, "ERROR_COLORSPACE_MISMATCH");
		map.put(0x000007E6, "ERROR_INVALID_COLORINDEX");
		map.put(0x000007E7, "ERROR_PROFILE_DOES_NOT_MATCH_DEVICE");
		map.put(0x00000836, "NERR_NetNotStarted");
		map.put(0x00000837, "NERR_UnknownServer");
		map.put(0x00000838, "NERR_ShareMem");
		map.put(0x00000839, "NERR_NoNetworkResource");
		map.put(0x0000083A, "NERR_RemoteOnly");
		map.put(0x0000083B, "NERR_DevNotRedirected");
		map.put(0x0000083C, "ERROR_CONNECTED_OTHER_PASSWORD");
		map.put(0x0000083D, "ERROR_CONNECTED_OTHER_PASSWORD_DEFAULT");
		map.put(0x00000842, "NERR_ServerNotStarted");
		map.put(0x00000843, "NERR_ItemNotFound");
		map.put(0x00000844, "NERR_UnknownDevDir");
		map.put(0x00000845, "NERR_RedirectedPath");
		map.put(0x00000846, "NERR_DuplicateShare");
		map.put(0x00000847, "NERR_NoRoom");
		map.put(0x00000849, "NERR_TooManyItems");
		map.put(0x0000084A, "NERR_InvalidMaxUsers");
		map.put(0x0000084B, "NERR_BufTooSmall");
		map.put(0x0000084F, "NERR_RemoteErr");
		map.put(0x00000853, "NERR_LanmanIniError");
		map.put(0x00000858, "NERR_NetworkError");
		map.put(0x00000859, "NERR_WkstaInconsistentState");
		map.put(0x0000085A, "NERR_WkstaNotStarted");
		map.put(0x0000085B, "NERR_BrowserNotStarted");
		map.put(0x0000085C, "NERR_InternalError");
		map.put(0x0000085D, "NERR_BadTransactConfig");
		map.put(0x0000085E, "NERR_InvalidAPI");
		map.put(0x0000085F, "NERR_BadEventName");
		map.put(0x00000860, "NERR_DupNameReboot");
		map.put(0x00000862, "NERR_CfgCompNotFound");
		map.put(0x00000863, "NERR_CfgParamNotFound");
		map.put(0x00000865, "NERR_LineTooLong");
		map.put(0x00000866, "NERR_QNotFound");
		map.put(0x00000867, "NERR_JobNotFound");
		map.put(0x00000868, "NERR_DestNotFound");
		map.put(0x00000869, "NERR_DestExists");
		map.put(0x0000086A, "NERR_QExists");
		map.put(0x0000086B, "NERR_QNoRoom");
		map.put(0x0000086C, "NERR_JobNoRoom");
		map.put(0x0000086D, "NERR_DestNoRoom");
		map.put(0x0000086E, "NERR_DestIdle");
		map.put(0x0000086F, "NERR_DestInvalidOp");
		map.put(0x00000870, "NERR_ProcNoRespond");
		map.put(0x00000871, "NERR_SpoolerNotLoaded");
		map.put(0x00000872, "NERR_DestInvalidState");
		map.put(0x00000873, "NERR_QinvalidState");
		map.put(0x00000874, "NERR_JobInvalidState");
		map.put(0x00000875, "NERR_SpoolNoMemory");
		map.put(0x00000876, "NERR_DriverNotFound");
		map.put(0x00000877, "NERR_DataTypeInvalid");
		map.put(0x00000878, "NERR_ProcNotFound");
		map.put(0x00000884, "NERR_ServiceTableLocked");
		map.put(0x00000885, "NERR_ServiceTableFull");
		map.put(0x00000886, "NERR_ServiceInstalled");
		map.put(0x00000887, "NERR_ServiceEntryLocked");
		map.put(0x00000888, "NERR_ServiceNotInstalled");
		map.put(0x00000889, "NERR_BadServiceName");
		map.put(0x0000088A, "NERR_ServiceCtlTimeout");
		map.put(0x0000088B, "NERR_ServiceCtlBusy");
		map.put(0x0000088C, "NERR_BadServiceProgName");
		map.put(0x0000088D, "NERR_ServiceNotCtrl");
		map.put(0x0000088E, "NERR_ServiceKillProc");
		map.put(0x0000088F, "NERR_ServiceCtlNotValid");
		map.put(0x00000890, "NERR_NotInDispatchTbl");
		map.put(0x00000891, "NERR_BadControlRecv");
		map.put(0x00000892, "NERR_ServiceNotStarting");
		map.put(0x00000898, "NERR_AlreadyLoggedOn");
		map.put(0x00000899, "NERR_NotLoggedOn");
		map.put(0x0000089A, "NERR_BadUsername");
		map.put(0x0000089B, "NERR_BadPassword");
		map.put(0x0000089C, "NERR_UnableToAddName_W");
		map.put(0x0000089D, "NERR_UnableToAddName_F");
		map.put(0x0000089E, "NERR_UnableToDelName_W");
		map.put(0x0000089F, "NERR_UnableToDelName_F");
		map.put(0x000008A1, "NERR_LogonsPaused");
		map.put(0x000008A2, "NERR_LogonServerConflict");
		map.put(0x000008A3, "NERR_LogonNoUserPath");
		map.put(0x000008A4, "NERR_LogonScriptError");
		map.put(0x000008A6, "NERR_StandaloneLogon");
		map.put(0x000008A7, "NERR_LogonServerNotFound");
		map.put(0x000008A8, "NERR_LogonDomainExists");
		map.put(0x000008A9, "NERR_NonValidatedLogon");
		map.put(0x000008AB, "NERR_ACFNotFound");
		map.put(0x000008AC, "NERR_GroupNotFound");
		map.put(0x000008AD, "NERR_UserNotFound");
		map.put(0x000008AE, "NERR_ResourceNotFound");
		map.put(0x000008AF, "NERR_GroupExists");
		map.put(0x000008B0, "NERR_UserExists");
		map.put(0x000008B1, "NERR_ResourceExists");
		map.put(0x000008B2, "NERR_NotPrimary");
		map.put(0x000008B3, "NERR_ACFNotLoaded");
		map.put(0x000008B4, "NERR_ACFNoRoom");
		map.put(0x000008B5, "NERR_ACFFileIOFail");
		map.put(0x000008B6, "NERR_ACFTooManyLists");
		map.put(0x000008B7, "NERR_UserLogon");
		map.put(0x000008B8, "NERR_ACFNoParent");
		map.put(0x000008B9, "NERR_CanNotGrowSegment");
		map.put(0x000008BA, "NERR_SpeGroupOp");
		map.put(0x000008BB, "NERR_NotInCache");
		map.put(0x000008BC, "NERR_UserInGroup");
		map.put(0x000008BD, "NERR_UserNotInGroup");
		map.put(0x000008BE, "NERR_AccountUndefined");
		map.put(0x000008BF, "NERR_AccountExpired");
		map.put(0x000008C0, "NERR_InvalidWorkstation");
		map.put(0x000008C1, "NERR_InvalidLogonHours");
		map.put(0x000008C2, "NERR_PasswordExpired");
		map.put(0x000008C3, "NERR_PasswordCantChange");
		map.put(0x000008C4, "NERR_PasswordHistConflict");
		map.put(0x000008C5, "NERR_PasswordTooShort");
		map.put(0x000008C6, "NERR_PasswordTooRecent");
		map.put(0x000008C7, "NERR_InvalidDatabase");
		map.put(0x000008C8, "NERR_DatabaseUpToDate");
		map.put(0x000008C9, "NERR_SyncRequired");
		map.put(0x000008CA, "NERR_UseNotFound");
		map.put(0x000008CB, "NERR_BadAsgType");
		map.put(0x000008CC, "NERR_DeviceIsShared");
		map.put(0x000008DE, "NERR_NoComputerName");
		map.put(0x000008DF, "NERR_MsgAlreadyStarted");
		map.put(0x000008E0, "NERR_MsgInitFailed");
		map.put(0x000008E1, "NERR_NameNotFound");
		map.put(0x000008E2, "NERR_AlreadyForwarded");
		map.put(0x000008E3, "NERR_AddForwarded");
		map.put(0x000008E4, "NERR_AlreadyExists");
		map.put(0x000008E5, "NERR_TooManyNames");
		map.put(0x000008E6, "NERR_DelComputerName");
		map.put(0x000008E7, "NERR_LocalForward");
		map.put(0x000008E8, "NERR_GrpMsgProcessor");
		map.put(0x000008E9, "NERR_PausedRemote");
		map.put(0x000008EA, "NERR_BadReceive");
		map.put(0x000008EB, "NERR_NameInUse");
		map.put(0x000008EC, "NERR_MsgNotStarted");
		map.put(0x000008ED, "NERR_NotLocalName");
		map.put(0x000008EE, "NERR_NoForwardName");
		map.put(0x000008EF, "NERR_RemoteFull");
		map.put(0x000008F0, "NERR_NameNotForwarded");
		map.put(0x000008F1, "NERR_TruncatedBroadcast");
		map.put(0x000008F6, "NERR_InvalidDevice");
		map.put(0x000008F7, "NERR_WriteFault");
		map.put(0x000008F9, "NERR_DuplicateName");
		map.put(0x000008FA, "NERR_DeleteLater");
		map.put(0x000008FB, "NERR_IncompleteDel");
		map.put(0x000008FC, "NERR_MultipleNets");
		map.put(0x00000906, "NERR_NetNameNotFound");
		map.put(0x00000907, "NERR_DeviceNotShared");
		map.put(0x00000908, "NERR_ClientNameNotFound");
		map.put(0x0000090A, "NERR_FileIdNotFound");
		map.put(0x0000090B, "NERR_ExecFailure");
		map.put(0x0000090C, "NERR_TmpFile");
		map.put(0x0000090D, "NERR_TooMuchData");
		map.put(0x0000090E, "NERR_DeviceShareConflict");
		map.put(0x0000090F, "NERR_BrowserTableIncomplete");
		map.put(0x00000910, "NERR_NotLocalDomain");
		map.put(0x00000911, "NERR_IsDfsShare");
		map.put(0x0000091B, "NERR_DevInvalidOpCode");
		map.put(0x0000091C, "NERR_DevNotFound");
		map.put(0x0000091D, "NERR_DevNotOpen");
		map.put(0x0000091E, "NERR_BadQueueDevString");
		map.put(0x0000091F, "NERR_BadQueuePriority");
		map.put(0x00000921, "NERR_NoCommDevs");
		map.put(0x00000922, "NERR_QueueNotFound");
		map.put(0x00000924, "NERR_BadDevString");
		map.put(0x00000925, "NERR_BadDev");
		map.put(0x00000926, "NERR_InUseBySpooler");
		map.put(0x00000927, "NERR_CommDevInUse");
		map.put(0x0000092F, "NERR_InvalidComputer");
		map.put(0x00000932, "NERR_MaxLenExceeded");
		map.put(0x00000934, "NERR_BadComponent");
		map.put(0x00000935, "NERR_CantType");
		map.put(0x0000093A, "NERR_TooManyEntries");
		map.put(0x00000942, "NERR_ProfileFileTooBig");
		map.put(0x00000943, "NERR_ProfileOffset");
		map.put(0x00000944, "NERR_ProfileCleanup");
		map.put(0x00000945, "NERR_ProfileUnknownCmd");
		map.put(0x00000946, "NERR_ProfileLoadErr");
		map.put(0x00000947, "NERR_ProfileSaveErr");
		map.put(0x00000949, "NERR_LogOverflow");
		map.put(0x0000094A, "NERR_LogFileChanged");
		map.put(0x0000094B, "NERR_LogFileCorrupt");
		map.put(0x0000094C, "NERR_SourceIsDir");
		map.put(0x0000094D, "NERR_BadSource");
		map.put(0x0000094E, "NERR_BadDest");
		map.put(0x0000094F, "NERR_DifferentServers");
		map.put(0x00000951, "NERR_RunSrvPaused");
		map.put(0x00000955, "NERR_ErrCommRunSrv");
		map.put(0x00000957, "NERR_ErrorExecingGhost");
		map.put(0x00000958, "NERR_ShareNotFound");
		map.put(0x00000960, "NERR_InvalidLana");
		map.put(0x00000961, "NERR_OpenFiles");
		map.put(0x00000962, "NERR_ActiveConns");
		map.put(0x00000963, "NERR_BadPasswordCore");
		map.put(0x00000964, "NERR_DevInUse");
		map.put(0x00000965, "NERR_LocalDrive");
		map.put(0x0000097E, "NERR_AlertExists");
		map.put(0x0000097F, "NERR_TooManyAlerts");
		map.put(0x00000980, "NERR_NoSuchAlert");
		map.put(0x00000981, "NERR_BadRecipient");
		map.put(0x00000982, "NERR_AcctLimitExceeded");
		map.put(0x00000988, "NERR_InvalidLogSeek");
		map.put(0x00000992, "NERR_BadUasConfig");
		map.put(0x00000993, "NERR_InvalidUASOp");
		map.put(0x00000994, "NERR_LastAdmin");
		map.put(0x00000995, "NERR_DCNotFound");
		map.put(0x00000996, "NERR_LogonTrackingError");
		map.put(0x00000997, "NERR_NetlogonNotStarted");
		map.put(0x00000998, "NERR_CanNotGrowUASFile");
		map.put(0x00000999, "NERR_TimeDiffAtDC");
		map.put(0x0000099A, "NERR_PasswordMismatch");
		map.put(0x0000099C, "NERR_NoSuchServer");
		map.put(0x0000099D, "NERR_NoSuchSession");
		map.put(0x0000099E, "NERR_NoSuchConnection");
		map.put(0x0000099F, "NERR_TooManyServers");
		map.put(0x000009A0, "NERR_TooManySessions");
		map.put(0x000009A1, "NERR_TooManyConnections");
		map.put(0x000009A2, "NERR_TooManyFiles");
		map.put(0x000009A3, "NERR_NoAlternateServers");
		map.put(0x000009A6, "NERR_TryDownLevel");
		map.put(0x000009B0, "NERR_UPSDriverNotStarted");
		map.put(0x000009B1, "NERR_UPSInvalidConfig");
		map.put(0x000009B2, "NERR_UPSInvalidCommPort");
		map.put(0x000009B3, "NERR_UPSSignalAsserted");
		map.put(0x000009B4, "NERR_UPSShutdownFailed");
		map.put(0x000009C4, "NERR_BadDosRetCode");
		map.put(0x000009C5, "NERR_ProgNeedsExtraMem");
		map.put(0x000009C6, "NERR_BadDosFunction");
		map.put(0x000009C7, "NERR_RemoteBootFailed");
		map.put(0x000009C8, "NERR_BadFileCheckSum");
		map.put(0x000009C9, "NERR_NoRplBootSystem");
		map.put(0x000009CA, "NERR_RplLoadrNetBiosErr");
		map.put(0x000009CB, "NERR_RplLoadrDiskErr");
		map.put(0x000009CC, "NERR_ImageParamErr");
		map.put(0x000009CD, "NERR_TooManyImageParams");
		map.put(0x000009CE, "NERR_NonDosFloppyUsed");
		map.put(0x000009CF, "NERR_RplBootRestart");
		map.put(0x000009D0, "NERR_RplSrvrCallFailed");
		map.put(0x000009D1, "NERR_CantConnectRplSrvr");
		map.put(0x000009D2, "NERR_CantOpenImageFile");
		map.put(0x000009D3, "NERR_CallingRplSrvr");
		map.put(0x000009D4, "NERR_StartingRplBoot");
		map.put(0x000009D5, "NERR_RplBootServiceTerm");
		map.put(0x000009D6, "NERR_RplBootStartFailed");
		map.put(0x000009D7, "NERR_RPL_CONNECTED");
		map.put(0x000009F6, "NERR_BrowserConfiguredToNotRun");
		map.put(0x00000A32, "NERR_RplNoAdaptersStarted");
		map.put(0x00000A33, "NERR_RplBadRegistry");
		map.put(0x00000A34, "NERR_RplBadDatabase");
		map.put(0x00000A35, "NERR_RplRplfilesShare");
		map.put(0x00000A36, "NERR_RplNotRplServer");
		map.put(0x00000A37, "NERR_RplCannotEnum");
		map.put(0x00000A38, "NERR_RplWkstaInfoCorrupted");
		map.put(0x00000A39, "NERR_RplWkstaNotFound");
		map.put(0x00000A3A, "NERR_RplWkstaNameUnavailable");
		map.put(0x00000A3B, "NERR_RplProfileInfoCorrupted");
		map.put(0x00000A3C, "NERR_RplProfileNotFound");
		map.put(0x00000A3D, "NERR_RplProfileNameUnavailable");
		map.put(0x00000A3E, "NERR_RplProfileNotEmpty");
		map.put(0x00000A3F, "NERR_RplConfigInfoCorrupted");
		map.put(0x00000A40, "NERR_RplConfigNotFound");
		map.put(0x00000A41, "NERR_RplAdapterInfoCorrupted");
		map.put(0x00000A42, "NERR_RplInternal");
		map.put(0x00000A43, "NERR_RplVendorInfoCorrupted");
		map.put(0x00000A44, "NERR_RplBootInfoCorrupted");
		map.put(0x00000A45, "NERR_RplWkstaNeedsUserAcct");
		map.put(0x00000A46, "NERR_RplNeedsRPLUSERAcct");
		map.put(0x00000A47, "NERR_RplBootNotFound");
		map.put(0x00000A48, "NERR_RplIncompatibleProfile");
		map.put(0x00000A49, "NERR_RplAdapterNameUnavailable");
		map.put(0x00000A4A, "NERR_RplConfigNotEmpty");
		map.put(0x00000A4B, "NERR_RplBootInUse");
		map.put(0x00000A4C, "NERR_RplBackupDatabase");
		map.put(0x00000A4D, "NERR_RplAdapterNotFound");
		map.put(0x00000A4E, "NERR_RplVendorNotFound");
		map.put(0x00000A4F, "NERR_RplVendorNameUnavailable");
		map.put(0x00000A50, "NERR_RplBootNameUnavailable");
		map.put(0x00000A51, "NERR_RplConfigNameUnavailable");
		map.put(0x00000A64, "NERR_DfsInternalCorruption");
		map.put(0x00000A65, "NERR_DfsVolumeDataCorrupt");
		map.put(0x00000A66, "NERR_DfsNoSuchVolume");
		map.put(0x00000A67, "NERR_DfsVolumeAlreadyExists");
		map.put(0x00000A68, "NERR_DfsAlreadyShared");
		map.put(0x00000A69, "NERR_DfsNoSuchShare");
		map.put(0x00000A6A, "NERR_DfsNotALeafVolume");
		map.put(0x00000A6B, "NERR_DfsLeafVolume");
		map.put(0x00000A6C, "NERR_DfsVolumeHasMultipleServers");
		map.put(0x00000A6D, "NERR_DfsCantCreateJunctionPoint");
		map.put(0x00000A6E, "NERR_DfsServerNotDfsAware");
		map.put(0x00000A6F, "NERR_DfsBadRenamePath");
		map.put(0x00000A70, "NERR_DfsVolumeIsOffline");
		map.put(0x00000A71, "NERR_DfsNoSuchServer");
		map.put(0x00000A72, "NERR_DfsCyclicalName");
		map.put(0x00000A73, "NERR_DfsNotSupportedInServerDfs");
		map.put(0x00000A74, "NERR_DfsDuplicateService");
		map.put(0x00000A75, "NERR_DfsCantRemoveLastServerShare");
		map.put(0x00000A76, "NERR_DfsVolumeIsInterDfs");
		map.put(0x00000A77, "NERR_DfsInconsistent");
		map.put(0x00000A78, "NERR_DfsServerUpgraded");
		map.put(0x00000A79, "NERR_DfsDataIsIdentical");
		map.put(0x00000A7A, "NERR_DfsCantRemoveDfsRoot");
		map.put(0x00000A7B, "NERR_DfsChildOrParentInDfs");
		map.put(0x00000A82, "NERR_DfsInternalError");
		map.put(0x00000A83, "NERR_SetupAlreadyJoined");
		map.put(0x00000A84, "NERR_SetupNotJoined");
		map.put(0x00000A85, "NERR_SetupDomainController");
		map.put(0x00000A86, "NERR_DefaultJoinRequired");
		map.put(0x00000A87, "NERR_InvalidWorkgroupName");
		map.put(0x00000A88, "NERR_NameUsesIncompatibleCodePage");
		map.put(0x00000A89, "NERR_ComputerAccountNotFound");
		map.put(0x00000A8A, "NERR_PersonalSku");
		map.put(0x00000A8D, "NERR_PasswordMustChange");
		map.put(0x00000A8E, "NERR_AccountLockedOut");
		map.put(0x00000A8F, "NERR_PasswordTooLong");
		map.put(0x00000A90, "NERR_PasswordNotComplexEnough");
		map.put(0x00000A91, "NERR_PasswordFilterError");
		map.put(0x00000BB8, "ERROR_UNKNOWN_PRINT_MONITOR");
		map.put(0x00000BB9, "ERROR_PRINTER_DRIVER_IN_USE");
		map.put(0x00000BBA, "ERROR_SPOOL_FILE_NOT_FOUND");
		map.put(0x00000BBB, "ERROR_SPL_NO_STARTDOC");
		map.put(0x00000BBC, "ERROR_SPL_NO_ADDJOB");
		map.put(0x00000BBD, "ERROR_PRINT_PROCESSOR_ALREADY_INSTALLED");
		map.put(0x00000BBE, "ERROR_PRINT_MONITOR_ALREADY_INSTALLED");
		map.put(0x00000BBF, "ERROR_INVALID_PRINT_MONITOR");
		map.put(0x00000BC0, "ERROR_PRINT_MONITOR_IN_USE");
		map.put(0x00000BC1, "ERROR_PRINTER_HAS_JOBS_QUEUED");
		map.put(0x00000BC2, "ERROR_SUCCESS_REBOOT_REQUIRED");
		map.put(0x00000BC3, "ERROR_SUCCESS_RESTART_REQUIRED");
		map.put(0x00000BC4, "ERROR_PRINTER_NOT_FOUND");
		map.put(0x00000BC5, "ERROR_PRINTER_DRIVER_WARNED");
		map.put(0x00000BC6, "ERROR_PRINTER_DRIVER_BLOCKED");
		map.put(0x00000BC7, "ERROR_PRINTER_DRIVER_PACKAGE_IN_USE");
		map.put(0x00000BC8, "ERROR_CORE_DRIVER_PACKAGE_NOT_FOUND");
		map.put(0x00000BC9, "ERROR_FAIL_REBOOT_REQUIRED");
		map.put(0x00000BCA, "ERROR_FAIL_REBOOT_INITIATED");
		map.put(0x00000F6E, "ERROR_IO_REISSUE_AS_CACHED");
		map.put(0x00000FA0, "ERROR_WINS_INTERNAL");
		map.put(0x00000FA1, "ERROR_CAN_NOT_DEL_LOCAL_WINS");
		map.put(0x00000FA2, "ERROR_STATIC_INIT");
		map.put(0x00000FA3, "ERROR_INC_BACKUP");
		map.put(0x00000FA4, "ERROR_FULL_BACKUP");
		map.put(0x00000FA5, "ERROR_REC_NON_EXISTENT");
		map.put(0x00000FA6, "ERROR_RPL_NOT_ALLOWED");
		map.put(0x00000FD2, "PEERDIST_ERROR_CONTENTINFO_VERSION_UNSUPPORTED");
		map.put(0x00000FD3, "PEERDIST_ERROR_CANNOT_PARSE_CONTENTINFO");
		map.put(0x00000FD4, "PEERDIST_ERROR_MISSING_DATA");
		map.put(0x00000FD5, "PEERDIST_ERROR_NO_MORE");
		map.put(0x00000FD6, "PEERDIST_ERROR_NOT_INITIALIZED");
		map.put(0x00000FD7, "PEERDIST_ERROR_ALREADY_INITIALIZED");
		map.put(0x00000FD8, "PEERDIST_ERROR_SHUTDOWN_IN_PROGRESS");
		map.put(0x00000FD9, "PEERDIST_ERROR_INVALIDATED");
		map.put(0x00000FDA, "PEERDIST_ERROR_ALREADY_EXISTS");
		map.put(0x00000FDB, "PEERDIST_ERROR_OPERATION_NOTFOUND");
		map.put(0x00000FDC, "PEERDIST_ERROR_ALREADY_COMPLETED");
		map.put(0x00000FDD, "PEERDIST_ERROR_OUT_OF_BOUNDS");
		map.put(0x00000FDE, "PEERDIST_ERROR_VERSION_UNSUPPORTED");
		map.put(0x00000FDF, "PEERDIST_ERROR_INVALID_CONFIGURATION");
		map.put(0x00000FE0, "PEERDIST_ERROR_NOT_LICENSED");
		map.put(0x00000FE1, "PEERDIST_ERROR_SERVICE_UNAVAILABLE");
		map.put(0x00001004, "ERROR_DHCP_ADDRESS_CONFLICT");
		map.put(0x00001068, "ERROR_WMI_GUID_NOT_FOUND");
		map.put(0x00001069, "ERROR_WMI_INSTANCE_NOT_FOUND");
		map.put(0x0000106A, "ERROR_WMI_ITEMID_NOT_FOUND");
		map.put(0x0000106B, "ERROR_WMI_TRY_AGAIN");
		map.put(0x0000106C, "ERROR_WMI_DP_NOT_FOUND");
		map.put(0x0000106D, "ERROR_WMI_UNRESOLVED_INSTANCE_REF");
		map.put(0x0000106E, "ERROR_WMI_ALREADY_ENABLED");
		map.put(0x0000106F, "ERROR_WMI_GUID_DISCONNECTED");
		map.put(0x00001070, "ERROR_WMI_SERVER_UNAVAILABLE");
		map.put(0x00001071, "ERROR_WMI_DP_FAILED");
		map.put(0x00001072, "ERROR_WMI_INVALID_MOF");
		map.put(0x00001073, "ERROR_WMI_INVALID_REGINFO");
		map.put(0x00001074, "ERROR_WMI_ALREADY_DISABLED");
		map.put(0x00001075, "ERROR_WMI_READ_ONLY");
		map.put(0x00001076, "ERROR_WMI_SET_FAILURE");
		map.put(0x000010CC, "ERROR_INVALID_MEDIA");
		map.put(0x000010CD, "ERROR_INVALID_LIBRARY");
		map.put(0x000010CE, "ERROR_INVALID_MEDIA_POOL");
		map.put(0x000010CF, "ERROR_DRIVE_MEDIA_MISMATCH");
		map.put(0x000010D0, "ERROR_MEDIA_OFFLINE");
		map.put(0x000010D1, "ERROR_LIBRARY_OFFLINE");
		map.put(0x000010D2, "ERROR_EMPTY");
		map.put(0x000010D3, "ERROR_NOT_EMPTY");
		map.put(0x000010D4, "ERROR_MEDIA_UNAVAILABLE");
		map.put(0x000010D5, "ERROR_RESOURCE_DISABLED");
		map.put(0x000010D6, "ERROR_INVALID_CLEANER");
		map.put(0x000010D7, "ERROR_UNABLE_TO_CLEAN");
		map.put(0x000010D8, "ERROR_OBJECT_NOT_FOUND");
		map.put(0x000010D9, "ERROR_DATABASE_FAILURE");
		map.put(0x000010DA, "ERROR_DATABASE_FULL");
		map.put(0x000010DB, "ERROR_MEDIA_INCOMPATIBLE");
		map.put(0x000010DC, "ERROR_RESOURCE_NOT_PRESENT");
		map.put(0x000010DD, "ERROR_INVALID_OPERATION");
		map.put(0x000010DE, "ERROR_MEDIA_NOT_AVAILABLE");
		map.put(0x000010DF, "ERROR_DEVICE_NOT_AVAILABLE");
		map.put(0x000010E0, "ERROR_REQUEST_REFUSED");
		map.put(0x000010E1, "ERROR_INVALID_DRIVE_OBJECT");
		map.put(0x000010E2, "ERROR_LIBRARY_FULL");
		map.put(0x000010E3, "ERROR_MEDIUM_NOT_ACCESSIBLE");
		map.put(0x000010E4, "ERROR_UNABLE_TO_LOAD_MEDIUM");
		map.put(0x000010E5, "ERROR_UNABLE_TO_INVENTORY_DRIVE");
		map.put(0x000010E6, "ERROR_UNABLE_TO_INVENTORY_SLOT");
		map.put(0x000010E7, "ERROR_UNABLE_TO_INVENTORY_TRANSPORT");
		map.put(0x000010E8, "ERROR_TRANSPORT_FULL");
		map.put(0x000010E9, "ERROR_CONTROLLING_IEPORT");
		map.put(0x000010EA, "ERROR_UNABLE_TO_EJECT_MOUNTED_MEDIA");
		map.put(0x000010EB, "ERROR_CLEANER_SLOT_SET");
		map.put(0x000010EC, "ERROR_CLEANER_SLOT_NOT_SET");
		map.put(0x000010ED, "ERROR_CLEANER_CARTRIDGE_SPENT");
		map.put(0x000010EE, "ERROR_UNEXPECTED_OMID");
		map.put(0x000010EF, "ERROR_CANT_DELETE_LAST_ITEM");
		map.put(0x000010F0, "ERROR_MESSAGE_EXCEEDS_MAX_SIZE");
		map.put(0x000010F1, "ERROR_VOLUME_CONTAINS_SYS_FILES");
		map.put(0x000010F2, "ERROR_INDIGENOUS_TYPE");
		map.put(0x000010F3, "ERROR_NO_SUPPORTING_DRIVES");
		map.put(0x000010F4, "ERROR_CLEANER_CARTRIDGE_INSTALLED");
		map.put(0x000010F5, "ERROR_IEPORT_FULL");
		map.put(0x000010FE, "ERROR_FILE_OFFLINE");
		map.put(0x000010FF, "ERROR_REMOTE_STORAGE_NOT_ACTIVE");
		map.put(0x00001100, "ERROR_REMOTE_STORAGE_MEDIA_ERROR");
		map.put(0x00001126, "ERROR_NOT_A_REPARSE_POINT");
		map.put(0x00001127, "ERROR_REPARSE_ATTRIBUTE_CONFLICT");
		map.put(0x00001128, "ERROR_INVALID_REPARSE_DATA");
		map.put(0x00001129, "ERROR_REPARSE_TAG_INVALID");
		map.put(0x0000112A, "ERROR_REPARSE_TAG_MISMATCH");
		map.put(0x00001194, "ERROR_VOLUME_NOT_SIS_ENABLED");
		map.put(0x00001389, "ERROR_DEPENDENT_RESOURCE_EXISTS");
		map.put(0x0000138A, "ERROR_DEPENDENCY_NOT_FOUND");
		map.put(0x0000138B, "ERROR_DEPENDENCY_ALREADY_EXISTS");
		map.put(0x0000138C, "ERROR_RESOURCE_NOT_ONLINE");
		map.put(0x0000138D, "ERROR_HOST_NODE_NOT_AVAILABLE");
		map.put(0x0000138E, "ERROR_RESOURCE_NOT_AVAILABLE");
		map.put(0x0000138F, "ERROR_RESOURCE_NOT_FOUND");
		map.put(0x00001390, "ERROR_SHUTDOWN_CLUSTER");
		map.put(0x00001391, "ERROR_CANT_EVICT_ACTIVE_NODE");
		map.put(0x00001392, "ERROR_OBJECT_ALREADY_EXISTS");
		map.put(0x00001393, "ERROR_OBJECT_IN_LIST");
		map.put(0x00001394, "ERROR_GROUP_NOT_AVAILABLE");
		map.put(0x00001395, "ERROR_GROUP_NOT_FOUND");
		map.put(0x00001396, "ERROR_GROUP_NOT_ONLINE");
		map.put(0x00001397, "ERROR_HOST_NODE_NOT_RESOURCE_OWNER");
		map.put(0x00001398, "ERROR_HOST_NODE_NOT_GROUP_OWNER");
		map.put(0x00001399, "ERROR_RESMON_CREATE_FAILED");
		map.put(0x0000139A, "ERROR_RESMON_ONLINE_FAILED");
		map.put(0x0000139B, "ERROR_RESOURCE_ONLINE");
		map.put(0x0000139C, "ERROR_QUORUM_RESOURCE");
		map.put(0x0000139D, "ERROR_NOT_QUORUM_CAPABLE");
		map.put(0x0000139E, "ERROR_CLUSTER_SHUTTING_DOWN");
		map.put(0x0000139F, "ERROR_INVALID_STATE");
		map.put(0x000013A0, "ERROR_RESOURCE_PROPERTIES_STORED");
		map.put(0x000013A1, "ERROR_NOT_QUORUM_CLASS");
		map.put(0x000013A2, "ERROR_CORE_RESOURCE");
		map.put(0x000013A3, "ERROR_QUORUM_RESOURCE_ONLINE_FAILED");
		map.put(0x000013A4, "ERROR_QUORUMLOG_OPEN_FAILED");
		map.put(0x000013A5, "ERROR_CLUSTERLOG_CORRUPT");
		map.put(0x000013A6, "ERROR_CLUSTERLOG_RECORD_EXCEEDS_MAXSIZE");
		map.put(0x000013A7, "ERROR_CLUSTERLOG_EXCEEDS_MAXSIZE");
		map.put(0x000013A8, "ERROR_CLUSTERLOG_CHKPOINT_NOT_FOUND");
		map.put(0x000013A9, "ERROR_CLUSTERLOG_NOT_ENOUGH_SPACE");
		map.put(0x000013AA, "ERROR_QUORUM_OWNER_ALIVE");
		map.put(0x000013AB, "ERROR_NETWORK_NOT_AVAILABLE");
		map.put(0x000013AC, "ERROR_NODE_NOT_AVAILABLE");
		map.put(0x000013AD, "ERROR_ALL_NODES_NOT_AVAILABLE");
		map.put(0x000013AE, "ERROR_RESOURCE_FAILED");
		map.put(0x000013AF, "ERROR_CLUSTER_INVALID_NODE");
		map.put(0x000013B0, "ERROR_CLUSTER_NODE_EXISTS");
		map.put(0x000013B1, "ERROR_CLUSTER_JOIN_IN_PROGRESS");
		map.put(0x000013B2, "ERROR_CLUSTER_NODE_NOT_FOUND");
		map.put(0x000013B3, "ERROR_CLUSTER_LOCAL_NODE_NOT_FOUND");
		map.put(0x000013B4, "ERROR_CLUSTER_NETWORK_EXISTS");
		map.put(0x000013B5, "ERROR_CLUSTER_NETWORK_NOT_FOUND");
		map.put(0x000013B6, "ERROR_CLUSTER_NETINTERFACE_EXISTS");
		map.put(0x000013B7, "ERROR_CLUSTER_NETINTERFACE_NOT_FOUND");
		map.put(0x000013B8, "ERROR_CLUSTER_INVALID_REQUEST");
		map.put(0x000013B9, "ERROR_CLUSTER_INVALID_NETWORK_PROVIDER");
		map.put(0x000013BA, "ERROR_CLUSTER_NODE_DOWN");
		map.put(0x000013BB, "ERROR_CLUSTER_NODE_UNREACHABLE");
		map.put(0x000013BC, "ERROR_CLUSTER_NODE_NOT_MEMBER");
		map.put(0x000013BD, "ERROR_CLUSTER_JOIN_NOT_IN_PROGRESS");
		map.put(0x000013BE, "ERROR_CLUSTER_INVALID_NETWORK");
		map.put(0x000013C0, "ERROR_CLUSTER_NODE_UP");
		map.put(0x000013C1, "ERROR_CLUSTER_IPADDR_IN_USE");
		map.put(0x000013C2, "ERROR_CLUSTER_NODE_NOT_PAUSED");
		map.put(0x000013C3, "ERROR_CLUSTER_NO_SECURITY_CONTEXT");
		map.put(0x000013C4, "ERROR_CLUSTER_NETWORK_NOT_INTERNAL");
		map.put(0x000013C5, "ERROR_CLUSTER_NODE_ALREADY_UP");
		map.put(0x000013C6, "ERROR_CLUSTER_NODE_ALREADY_DOWN");
		map.put(0x000013C7, "ERROR_CLUSTER_NETWORK_ALREADY_ONLINE");
		map.put(0x000013C8, "ERROR_CLUSTER_NETWORK_ALREADY_OFFLINE");
		map.put(0x000013C9, "ERROR_CLUSTER_NODE_ALREADY_MEMBER");
		map.put(0x000013CA, "ERROR_CLUSTER_LAST_INTERNAL_NETWORK");
		map.put(0x000013CB, "ERROR_CLUSTER_NETWORK_HAS_DEPENDENTS");
		map.put(0x000013CC, "ERROR_INVALID_OPERATION_ON_QUORUM");
		map.put(0x000013CD, "ERROR_DEPENDENCY_NOT_ALLOWED");
		map.put(0x000013CE, "ERROR_CLUSTER_NODE_PAUSED");
		map.put(0x000013CF, "ERROR_NODE_CANT_HOST_RESOURCE");
		map.put(0x000013D0, "ERROR_CLUSTER_NODE_NOT_READY");
		map.put(0x000013D1, "ERROR_CLUSTER_NODE_SHUTTING_DOWN");
		map.put(0x000013D2, "ERROR_CLUSTER_JOIN_ABORTED");
		map.put(0x000013D3, "ERROR_CLUSTER_INCOMPATIBLE_VERSIONS");
		map.put(0x000013D4, "ERROR_CLUSTER_MAXNUM_OF_RESOURCES_EXCEEDED");
		map.put(0x000013D5, "ERROR_CLUSTER_SYSTEM_CONFIG_CHANGED");
		map.put(0x000013D6, "ERROR_CLUSTER_RESOURCE_TYPE_NOT_FOUND");
		map.put(0x000013D7, "ERROR_CLUSTER_RESTYPE_NOT_SUPPORTED");
		map.put(0x000013D8, "ERROR_CLUSTER_RESNAME_NOT_FOUND");
		map.put(0x000013D9, "ERROR_CLUSTER_NO_RPC_PACKAGES_REGISTERED");
		map.put(0x000013DA, "ERROR_CLUSTER_OWNER_NOT_IN_PREFLIST");
		map.put(0x000013DB, "ERROR_CLUSTER_DATABASE_SEQMISMATCH");
		map.put(0x000013DC, "ERROR_RESMON_INVALID_STATE");
		map.put(0x000013DD, "ERROR_CLUSTER_GUM_NOT_LOCKER");
		map.put(0x000013DE, "ERROR_QUORUM_DISK_NOT_FOUND");
		map.put(0x000013DF, "ERROR_DATABASE_BACKUP_CORRUPT");
		map.put(0x000013E0, "ERROR_CLUSTER_NODE_ALREADY_HAS_DFS_ROOT");
		map.put(0x000013E1, "ERROR_RESOURCE_PROPERTY_UNCHANGEABLE");
		map.put(0x00001702, "ERROR_CLUSTER_MEMBERSHIP_INVALID_STATE");
		map.put(0x00001703, "ERROR_CLUSTER_QUORUMLOG_NOT_FOUND");
		map.put(0x00001704, "ERROR_CLUSTER_MEMBERSHIP_HALT");
		map.put(0x00001705, "ERROR_CLUSTER_INSTANCE_ID_MISMATCH");
		map.put(0x00001706, "ERROR_CLUSTER_NETWORK_NOT_FOUND_FOR_IP");
		map.put(0x00001707, "ERROR_CLUSTER_PROPERTY_DATA_TYPE_MISMATCH");
		map.put(0x00001708, "ERROR_CLUSTER_EVICT_WITHOUT_CLEANUP");
		map.put(0x00001709, "ERROR_CLUSTER_PARAMETER_MISMATCH");
		map.put(0x0000170A, "ERROR_NODE_CANNOT_BE_CLUSTERED");
		map.put(0x0000170B, "ERROR_CLUSTER_WRONG_OS_VERSION");
		map.put(0x0000170C, "ERROR_CLUSTER_CANT_CREATE_DUP_CLUSTER_NAME");
		map.put(0x0000170D, "ERROR_CLUSCFG_ALREADY_COMMITTED");
		map.put(0x0000170E, "ERROR_CLUSCFG_ROLLBACK_FAILED");
		map.put(0x0000170F, "ERROR_CLUSCFG_SYSTEM_DISK_DRIVE_LETTER_CONFLICT");
		map.put(0x00001710, "ERROR_CLUSTER_OLD_VERSION");
		map.put(0x00001711, "ERROR_CLUSTER_MISMATCHED_COMPUTER_ACCT_NAME");
		map.put(0x00001712, "ERROR_CLUSTER_NO_NET_ADAPTERS");
		map.put(0x00001713, "ERROR_CLUSTER_POISONED");
		map.put(0x00001714, "ERROR_CLUSTER_GROUP_MOVING");
		map.put(0x00001715, "ERROR_CLUSTER_RESOURCE_TYPE_BUSY");
		map.put(0x00001716, "ERROR_RESOURCE_CALL_TIMED_OUT");
		map.put(0x00001717, "ERROR_INVALID_CLUSTER_IPV6_ADDRESS");
		map.put(0x00001718, "ERROR_CLUSTER_INTERNAL_INVALID_FUNCTION");
		map.put(0x00001719, "ERROR_CLUSTER_PARAMETER_OUT_OF_BOUNDS");
		map.put(0x0000171A, "ERROR_CLUSTER_PARTIAL_SEND");
		map.put(0x0000171B, "ERROR_CLUSTER_REGISTRY_INVALID_FUNCTION");
		map.put(0x0000171C, "ERROR_CLUSTER_INVALID_STRING_TERMINATION");
		map.put(0x0000171D, "ERROR_CLUSTER_INVALID_STRING_FORMAT");
		map.put(0x0000171E, "ERROR_CLUSTER_DATABASE_TRANSACTION_IN_PROGRESS");
		map.put(0x0000171F, "ERROR_CLUSTER_DATABASE_TRANSACTION_NOT_IN_PROGRESS");
		map.put(0x00001720, "ERROR_CLUSTER_NULL_DATA");
		map.put(0x00001721, "ERROR_CLUSTER_PARTIAL_READ");
		map.put(0x00001722, "ERROR_CLUSTER_PARTIAL_WRITE");
		map.put(0x00001723, "ERROR_CLUSTER_CANT_DESERIALIZE_DATA");
		map.put(0x00001724, "ERROR_DEPENDENT_RESOURCE_PROPERTY_CONFLICT");
		map.put(0x00001725, "ERROR_CLUSTER_NO_QUORUM");
		map.put(0x00001726, "ERROR_CLUSTER_INVALID_IPV6_NETWORK");
		map.put(0x00001727, "ERROR_CLUSTER_INVALID_IPV6_TUNNEL_NETWORK");
		map.put(0x00001728, "ERROR_QUORUM_NOT_ALLOWED_IN_THIS_GROUP");
		map.put(0x00001770, "ERROR_ENCRYPTION_FAILED");
		map.put(0x00001771, "ERROR_DECRYPTION_FAILED");
		map.put(0x00001772, "ERROR_FILE_ENCRYPTED");
		map.put(0x00001773, "ERROR_NO_RECOVERY_POLICY");
		map.put(0x00001774, "ERROR_NO_EFS");
		map.put(0x00001775, "ERROR_WRONG_EFS");
		map.put(0x00001776, "ERROR_NO_USER_KEYS");
		map.put(0x00001777, "ERROR_FILE_NOT_ENCRYPTED");
		map.put(0x00001778, "ERROR_NOT_EXPORT_FORMAT");
		map.put(0x00001779, "ERROR_FILE_READ_ONLY");
		map.put(0x0000177A, "ERROR_DIR_EFS_DISALLOWED");
		map.put(0x0000177B, "ERROR_EFS_SERVER_NOT_TRUSTED");
		map.put(0x0000177C, "ERROR_BAD_RECOVERY_POLICY");
		map.put(0x0000177D, "ERROR_EFS_ALG_BLOB_TOO_BIG");
		map.put(0x0000177E, "ERROR_VOLUME_NOT_SUPPORT_EFS");
		map.put(0x0000177F, "ERROR_EFS_DISABLED");
		map.put(0x00001780, "ERROR_EFS_VERSION_NOT_SUPPORT");
		map.put(0x00001781, "ERROR_CS_ENCRYPTION_INVALID_SERVER_RESPONSE");
		map.put(0x00001782, "ERROR_CS_ENCRYPTION_UNSUPPORTED_SERVER");
		map.put(0x00001783, "ERROR_CS_ENCRYPTION_EXISTING_ENCRYPTED_FILE");
		map.put(0x00001784, "ERROR_CS_ENCRYPTION_NEW_ENCRYPTED_FILE");
		map.put(0x00001785, "ERROR_CS_ENCRYPTION_FILE_NOT_CSE");
		map.put(0x000017E6, "ERROR_NO_BROWSER_SERVERS_FOUND");
		map.put(0x00001838, "SCHED_E_SERVICE_NOT_LOCALSYSTEM");
		map.put(0x000019C8, "ERROR_LOG_SECTOR_INVALID");
		map.put(0x000019C9, "ERROR_LOG_SECTOR_PARITY_INVALID");
		map.put(0x000019CA, "ERROR_LOG_SECTOR_REMAPPED");
		map.put(0x000019CB, "ERROR_LOG_BLOCK_INCOMPLETE");
		map.put(0x000019CC, "ERROR_LOG_INVALID_RANGE");
		map.put(0x000019CD, "ERROR_LOG_BLOCKS_EXHAUSTED");
		map.put(0x000019CE, "ERROR_LOG_READ_CONTEXT_INVALID");
		map.put(0x000019CF, "ERROR_LOG_RESTART_INVALID");
		map.put(0x000019D0, "ERROR_LOG_BLOCK_VERSION");
		map.put(0x000019D1, "ERROR_LOG_BLOCK_INVALID");
		map.put(0x000019D2, "ERROR_LOG_READ_MODE_INVALID");
		map.put(0x000019D3, "ERROR_LOG_NO_RESTART");
		map.put(0x000019D4, "ERROR_LOG_METADATA_CORRUPT");
		map.put(0x000019D5, "ERROR_LOG_METADATA_INVALID");
		map.put(0x000019D6, "ERROR_LOG_METADATA_INCONSISTENT");
		map.put(0x000019D7, "ERROR_LOG_RESERVATION_INVALID");
		map.put(0x000019D8, "ERROR_LOG_CANT_DELETE");
		map.put(0x000019D9, "ERROR_LOG_CONTAINER_LIMIT_EXCEEDED");
		map.put(0x000019DA, "ERROR_LOG_START_OF_LOG");
		map.put(0x000019DB, "ERROR_LOG_POLICY_ALREADY_INSTALLED");
		map.put(0x000019DC, "ERROR_LOG_POLICY_NOT_INSTALLED");
		map.put(0x000019DD, "ERROR_LOG_POLICY_INVALID");
		map.put(0x000019DE, "ERROR_LOG_POLICY_CONFLICT");
		map.put(0x000019DF, "ERROR_LOG_PINNED_ARCHIVE_TAIL");
		map.put(0x000019E0, "ERROR_LOG_RECORD_NONEXISTENT");
		map.put(0x000019E1, "ERROR_LOG_RECORDS_RESERVED_INVALID");
		map.put(0x000019E2, "ERROR_LOG_SPACE_RESERVED_INVALID");
		map.put(0x000019E3, "ERROR_LOG_TAIL_INVALID");
		map.put(0x000019E4, "ERROR_LOG_FULL");
		map.put(0x000019E5, "ERROR_COULD_NOT_RESIZE_LOG");
		map.put(0x000019E6, "ERROR_LOG_MULTIPLEXED");
		map.put(0x000019E7, "ERROR_LOG_DEDICATED");
		map.put(0x000019E8, "ERROR_LOG_ARCHIVE_NOT_IN_PROGRESS");
		map.put(0x000019E9, "ERROR_LOG_ARCHIVE_IN_PROGRESS");
		map.put(0x000019EA, "ERROR_LOG_EPHEMERAL");
		map.put(0x000019EB, "ERROR_LOG_NOT_ENOUGH_CONTAINERS");
		map.put(0x000019EC, "ERROR_LOG_CLIENT_ALREADY_REGISTERED");
		map.put(0x000019ED, "ERROR_LOG_CLIENT_NOT_REGISTERED");
		map.put(0x000019EE, "ERROR_LOG_FULL_HANDLER_IN_PROGRESS");
		map.put(0x000019EF, "ERROR_LOG_CONTAINER_READ_FAILED");
		map.put(0x000019F0, "ERROR_LOG_CONTAINER_WRITE_FAILED");
		map.put(0x000019F1, "ERROR_LOG_CONTAINER_OPEN_FAILED");
		map.put(0x000019F2, "ERROR_LOG_CONTAINER_STATE_INVALID");
		map.put(0x000019F3, "ERROR_LOG_STATE_INVALID");
		map.put(0x000019F4, "ERROR_LOG_PINNED");
		map.put(0x000019F5, "ERROR_LOG_METADATA_FLUSH_FAILED");
		map.put(0x000019F6, "ERROR_LOG_INCONSISTENT_SECURITY");
		map.put(0x000019F7, "ERROR_LOG_APPENDED_FLUSH_FAILED");
		map.put(0x000019F8, "ERROR_LOG_PINNED_RESERVATION");
		map.put(0x00001A2C, "ERROR_INVALID_TRANSACTION");
		map.put(0x00001A2D, "ERROR_TRANSACTION_NOT_ACTIVE");
		map.put(0x00001A2E, "ERROR_TRANSACTION_REQUEST_NOT_VALID");
		map.put(0x00001A2F, "ERROR_TRANSACTION_NOT_REQUESTED");
		map.put(0x00001A30, "ERROR_TRANSACTION_ALREADY_ABORTED");
		map.put(0x00001A31, "ERROR_TRANSACTION_ALREADY_COMMITTED");
		map.put(0x00001A32, "ERROR_TM_INITIALIZATION_FAILED");
		map.put(0x00001A33, "ERROR_RESOURCEMANAGER_READ_ONLY");
		map.put(0x00001A34, "ERROR_TRANSACTION_NOT_JOINED");
		map.put(0x00001A35, "ERROR_TRANSACTION_SUPERIOR_EXISTS");
		map.put(0x00001A36, "ERROR_CRM_PROTOCOL_ALREADY_EXISTS");
		map.put(0x00001A37, "ERROR_TRANSACTION_PROPAGATION_FAILED");
		map.put(0x00001A38, "ERROR_CRM_PROTOCOL_NOT_FOUND");
		map.put(0x00001A39, "ERROR_TRANSACTION_INVALID_MARSHALL_BUFFER");
		map.put(0x00001A3A, "ERROR_CURRENT_TRANSACTION_NOT_VALID");
		map.put(0x00001A3B, "ERROR_TRANSACTION_NOT_FOUND");
		map.put(0x00001A3C, "ERROR_RESOURCEMANAGER_NOT_FOUND");
		map.put(0x00001A3D, "ERROR_ENLISTMENT_NOT_FOUND");
		map.put(0x00001A3E, "ERROR_TRANSACTIONMANAGER_NOT_FOUND");
		map.put(0x00001A3F, "ERROR_TRANSACTIONMANAGER_NOT_ONLINE");
		map.put(0x00001A40, "ERROR_TRANSACTIONMANAGER_RECOVERY_NAME_COLLISION");
		map.put(0x00001A90, "ERROR_TRANSACTIONAL_CONFLICT");
		map.put(0x00001A91, "ERROR_RM_NOT_ACTIVE");
		map.put(0x00001A92, "ERROR_RM_METADATA_CORRUPT");
		map.put(0x00001A93, "ERROR_DIRECTORY_NOT_RM");
		map.put(0x00001A95, "ERROR_TRANSACTIONS_UNSUPPORTED_REMOTE");
		map.put(0x00001A96, "ERROR_LOG_RESIZE_INVALID_SIZE");
		map.put(0x00001A97, "ERROR_OBJECT_NO_LONGER_EXISTS");
		map.put(0x00001A98, "ERROR_STREAM_MINIVERSION_NOT_FOUND");
		map.put(0x00001A99, "ERROR_STREAM_MINIVERSION_NOT_VALID");
		map.put(0x00001A9A, "ERROR_MINIVERSION_INACCESSIBLE_FROM_SPECIFIED_TRANSACTION");
		map.put(0x00001A9B, "ERROR_CANT_OPEN_MINIVERSION_WITH_MODIFY_INTENT");
		map.put(0x00001A9C, "ERROR_CANT_CREATE_MORE_STREAM_MINIVERSIONS");
		map.put(0x00001A9E, "ERROR_REMOTE_FILE_VERSION_MISMATCH");
		map.put(0x00001A9F, "ERROR_HANDLE_NO_LONGER_VALID");
		map.put(0x00001AA0, "ERROR_NO_TXF_METADATA");
		map.put(0x00001AA1, "ERROR_LOG_CORRUPTION_DETECTED");
		map.put(0x00001AA2, "ERROR_CANT_RECOVER_WITH_HANDLE_OPEN");
		map.put(0x00001AA3, "ERROR_RM_DISCONNECTED");
		map.put(0x00001AA4, "ERROR_ENLISTMENT_NOT_SUPERIOR");
		map.put(0x00001AA5, "ERROR_RECOVERY_NOT_NEEDED");
		map.put(0x00001AA6, "ERROR_RM_ALREADY_STARTED");
		map.put(0x00001AA7, "ERROR_FILE_IDENTITY_NOT_PERSISTENT");
		map.put(0x00001AA8, "ERROR_CANT_BREAK_TRANSACTIONAL_DEPENDENCY");
		map.put(0x00001AA9, "ERROR_CANT_CROSS_RM_BOUNDARY");
		map.put(0x00001AAA, "ERROR_TXF_DIR_NOT_EMPTY");
		map.put(0x00001AAB, "ERROR_INDOUBT_TRANSACTIONS_EXIST");
		map.put(0x00001AAC, "ERROR_TM_VOLATILE");
		map.put(0x00001AAD, "ERROR_ROLLBACK_TIMER_EXPIRED");
		map.put(0x00001AAE, "ERROR_TXF_ATTRIBUTE_CORRUPT");
		map.put(0x00001AAF, "ERROR_EFS_NOT_ALLOWED_IN_TRANSACTION");
		map.put(0x00001AB0, "ERROR_TRANSACTIONAL_OPEN_NOT_ALLOWED");
		map.put(0x00001AB1, "ERROR_LOG_GROWTH_FAILED");
		map.put(0x00001AB2, "ERROR_TRANSACTED_MAPPING_UNSUPPORTED_REMOTE");
		map.put(0x00001AB3, "ERROR_TXF_METADATA_ALREADY_PRESENT");
		map.put(0x00001AB4, "ERROR_TRANSACTION_SCOPE_CALLBACKS_NOT_SET");
		map.put(0x00001AB5, "ERROR_TRANSACTION_REQUIRED_PROMOTION");
		map.put(0x00001AB6, "ERROR_CANNOT_EXECUTE_FILE_IN_TRANSACTION");
		map.put(0x00001AB7, "ERROR_TRANSACTIONS_NOT_FROZEN");
		map.put(0x00001AB8, "ERROR_TRANSACTION_FREEZE_IN_PROGRESS");
		map.put(0x00001AB9, "ERROR_NOT_SNAPSHOT_VOLUME");
		map.put(0x00001ABA, "ERROR_NO_SAVEPOINT_WITH_OPEN_FILES");
		map.put(0x00001ABB, "ERROR_DATA_LOST_REPAIR");
		map.put(0x00001ABC, "ERROR_SPARSE_NOT_ALLOWED_IN_TRANSACTION");
		map.put(0x00001ABD, "ERROR_TM_IDENTITY_MISMATCH");
		map.put(0x00001ABE, "ERROR_FLOATED_SECTION");
		map.put(0x00001ABF, "ERROR_CANNOT_ACCEPT_TRANSACTED_WORK");
		map.put(0x00001AC0, "ERROR_CANNOT_ABORT_TRANSACTIONS");
		map.put(0x00001B59, "ERROR_CTX_WINSTATION_NAME_INVALID");
		map.put(0x00001B5A, "ERROR_CTX_INVALID_PD");
		map.put(0x00001B5B, "ERROR_CTX_PD_NOT_FOUND");
		map.put(0x00001B5C, "ERROR_CTX_WD_NOT_FOUND");
		map.put(0x00001B5D, "ERROR_CTX_CANNOT_MAKE_EVENTLOG_ENTRY");
		map.put(0x00001B5E, "ERROR_CTX_SERVICE_NAME_COLLISION");
		map.put(0x00001B5F, "ERROR_CTX_CLOSE_PENDING");
		map.put(0x00001B60, "ERROR_CTX_NO_OUTBUF");
		map.put(0x00001B61, "ERROR_CTX_MODEM_INF_NOT_FOUND");
		map.put(0x00001B62, "ERROR_CTX_INVALID_MODEMNAME");
		map.put(0x00001B63, "ERROR_CTX_MODEM_RESPONSE_ERROR");
		map.put(0x00001B64, "ERROR_CTX_MODEM_RESPONSE_TIMEOUT");
		map.put(0x00001B65, "ERROR_CTX_MODEM_RESPONSE_NO_CARRIER");
		map.put(0x00001B66, "ERROR_CTX_MODEM_RESPONSE_NO_DIALTONE");
		map.put(0x00001B67, "ERROR_CTX_MODEM_RESPONSE_BUSY");
		map.put(0x00001B68, "ERROR_CTX_MODEM_RESPONSE_VOICE");
		map.put(0x00001B69, "ERROR_CTX_TD_ERROR");
		map.put(0x00001B6E, "ERROR_CTX_WINSTATION_NOT_FOUND");
		map.put(0x00001B6F, "ERROR_CTX_WINSTATION_ALREADY_EXISTS");
		map.put(0x00001B70, "ERROR_CTX_WINSTATION_BUSY");
		map.put(0x00001B71, "ERROR_CTX_BAD_VIDEO_MODE");
		map.put(0x00001B7B, "ERROR_CTX_GRAPHICS_INVALID");
		map.put(0x00001B7D, "ERROR_CTX_LOGON_DISABLED");
		map.put(0x00001B7E, "ERROR_CTX_NOT_CONSOLE");
		map.put(0x00001B80, "ERROR_CTX_CLIENT_QUERY_TIMEOUT");
		map.put(0x00001B81, "ERROR_CTX_CONSOLE_DISCONNECT");
		map.put(0x00001B82, "ERROR_CTX_CONSOLE_CONNECT");
		map.put(0x00001B84, "ERROR_CTX_SHADOW_DENIED");
		map.put(0x00001B85, "ERROR_CTX_WINSTATION_ACCESS_DENIED");
		map.put(0x00001B89, "ERROR_CTX_INVALID_WD");
		map.put(0x00001B8A, "ERROR_CTX_SHADOW_INVALID");
		map.put(0x00001B8B, "ERROR_CTX_SHADOW_DISABLED");
		map.put(0x00001B8C, "ERROR_CTX_CLIENT_LICENSE_IN_USE");
		map.put(0x00001B8D, "ERROR_CTX_CLIENT_LICENSE_NOT_SET");
		map.put(0x00001B8E, "ERROR_CTX_LICENSE_NOT_AVAILABLE");
		map.put(0x00001B8F, "ERROR_CTX_LICENSE_CLIENT_INVALID");
		map.put(0x00001B90, "ERROR_CTX_LICENSE_EXPIRED");
		map.put(0x00001B91, "ERROR_CTX_SHADOW_NOT_RUNNING");
		map.put(0x00001B92, "ERROR_CTX_SHADOW_ENDED_BY_MODE_CHANGE");
		map.put(0x00001B93, "ERROR_ACTIVATION_COUNT_EXCEEDED");
		map.put(0x00001B94, "ERROR_CTX_WINSTATIONS_DISABLED");
		map.put(0x00001B95, "ERROR_CTX_ENCRYPTION_LEVEL_REQUIRED");
		map.put(0x00001B96, "ERROR_CTX_SESSION_IN_USE");
		map.put(0x00001B97, "ERROR_CTX_NO_FORCE_LOGOFF");
		map.put(0x00001B98, "ERROR_CTX_ACCOUNT_RESTRICTION");
		map.put(0x00001B99, "ERROR_RDP_PROTOCOL_ERROR");
		map.put(0x00001B9A, "ERROR_CTX_CDM_CONNECT");
		map.put(0x00001B9B, "ERROR_CTX_CDM_DISCONNECT");
		map.put(0x00001B9C, "ERROR_CTX_SECURITY_LAYER_ERROR");
		map.put(0x00001B9D, "ERROR_TS_INCOMPATIBLE_SESSIONS");
		map.put(0x00001F41, "FRS_ERR_INVALID_API_SEQUENCE");
		map.put(0x00001F42, "FRS_ERR_STARTING_SERVICE");
		map.put(0x00001F43, "FRS_ERR_STOPPING_SERVICE");
		map.put(0x00001F44, "FRS_ERR_INTERNAL_API");
		map.put(0x00001F45, "FRS_ERR_INTERNAL");
		map.put(0x00001F46, "FRS_ERR_SERVICE_COMM");
		map.put(0x00001F47, "FRS_ERR_INSUFFICIENT_PRIV");
		map.put(0x00001F48, "FRS_ERR_AUTHENTICATION");
		map.put(0x00001F49, "FRS_ERR_PARENT_INSUFFICIENT_PRIV");
		map.put(0x00001F4A, "FRS_ERR_PARENT_AUTHENTICATION");
		map.put(0x00001F4B, "FRS_ERR_CHILD_TO_PARENT_COMM");
		map.put(0x00001F4C, "FRS_ERR_PARENT_TO_CHILD_COMM");
		map.put(0x00001F4D, "FRS_ERR_SYSVOL_POPULATE");
		map.put(0x00001F4E, "FRS_ERR_SYSVOL_POPULATE_TIMEOUT");
		map.put(0x00001F4F, "FRS_ERR_SYSVOL_IS_BUSY");
		map.put(0x00001F50, "FRS_ERR_SYSVOL_DEMOTE");
		map.put(0x00001F51, "FRS_ERR_INVALID_SERVICE_PARAMETER");
		map.put(0x00002008, "ERROR_DS_NOT_INSTALLED");
		map.put(0x00002009, "ERROR_DS_MEMBERSHIP_EVALUATED_LOCALLY");
		map.put(0x0000200A, "ERROR_DS_NO_ATTRIBUTE_OR_VALUE");
		map.put(0x0000200B, "ERROR_DS_INVALID_ATTRIBUTE_YNTAX");
		map.put(0x0000200C, "ERROR_DS_ATTRIBUTE_TYPE_UNDEFINED");
		map.put(0x0000200D, "ERROR_DS_ATTRIBUTE_OR_VALUE_EXISTS");
		map.put(0x0000200E, "ERROR_DS_BUSY");
		map.put(0x0000200F, "ERROR_DS_UNAVAILABLE");
		map.put(0x00002010, "ERROR_DS_NO_RIDS_ALLOCATED");
		map.put(0x00002011, "ERROR_DS_NO_MORE_RIDS");
		map.put(0x00002012, "ERROR_DS_INCORRECT_ROLE_OWNER");
		map.put(0x00002013, "ERROR_DS_RIDMGR_INIT_ERROR");
		map.put(0x00002014, "ERROR_DS_OBJ_CLASS_VIOLATION");
		map.put(0x00002015, "ERROR_DS_CANT_ON_NON_LEAF");
		map.put(0x00002016, "ERROR_DS_CANT_ON_RDN");
		map.put(0x00002017, "ERROR_DS_CANT_MOD_OBJ_CLASS");
		map.put(0x00002018, "ERROR_DS_CROSS_DOM_MOVE_ERROR");
		map.put(0x00002019, "ERROR_DS_GC_NOT_AVAILABLE");
		map.put(0x0000201A, "ERROR_SHARED_POLICY");
		map.put(0x0000201B, "ERROR_POLICY_OBJECT_NOT_FOUND");
		map.put(0x0000201C, "ERROR_POLICY_ONLY_IN_DS");
		map.put(0x0000201D, "ERROR_PROMOTION_ACTIVE");
		map.put(0x0000201E, "ERROR_NO_PROMOTION_ACTIVE");
		map.put(0x00002020, "ERROR_DS_OPERATIONS_ERROR");
		map.put(0x00002021, "ERROR_DS_PROTOCOL_ERROR");
		map.put(0x00002022, "ERROR_DS_TIMELIMIT_EXCEEDED");
		map.put(0x00002023, "ERROR_DS_SIZELIMIT_EXCEEDED");
		map.put(0x00002024, "ERROR_DS_ADMIN_LIMIT_EXCEEDED");
		map.put(0x00002025, "ERROR_DS_COMPARE_FALSE");
		map.put(0x00002026, "ERROR_DS_COMPARE_TRUE");
		map.put(0x00002027, "ERROR_DS_AUTH_METHOD_NOT_SUPPORTED");
		map.put(0x00002028, "ERROR_DS_STRONG_AUTH_REQUIRED");
		map.put(0x00002029, "ERROR_DS_INAPPROPRIATE_AUTH");
		map.put(0x0000202A, "ERROR_DS_AUTH_UNKNOWN");
		map.put(0x0000202B, "ERROR_DS_REFERRAL");
		map.put(0x0000202C, "ERROR_DS_UNAVAILABLE_CRIT_EXTENSION");
		map.put(0x0000202D, "ERROR_DS_CONFIDENTIALITY_REQUIRED");
		map.put(0x0000202E, "ERROR_DS_INAPPROPRIATE_MATCHING");
		map.put(0x0000202F, "ERROR_DS_CONSTRAINT_VIOLATION");
		map.put(0x00002030, "ERROR_DS_NO_SUCH_OBJECT");
		map.put(0x00002031, "ERROR_DS_ALIAS_PROBLEM");
		map.put(0x00002032, "ERROR_DS_INVALID_DN_SYNTAX");
		map.put(0x00002033, "ERROR_DS_IS_LEAF");
		map.put(0x00002034, "ERROR_DS_ALIAS_DEREF_PROBLEM");
		map.put(0x00002035, "ERROR_DS_UNWILLING_TO_PERFORM");
		map.put(0x00002036, "ERROR_DS_LOOP_DETECT");
		map.put(0x00002037, "ERROR_DS_NAMING_VIOLATION");
		map.put(0x00002038, "ERROR_DS_OBJECT_RESULTS_TOO_LARGE");
		map.put(0x00002039, "ERROR_DS_AFFECTS_MULTIPLE_DSAS");
		map.put(0x0000203A, "ERROR_DS_SERVER_DOWN");
		map.put(0x0000203B, "ERROR_DS_LOCAL_ERROR");
		map.put(0x0000203C, "ERROR_DS_ENCODING_ERROR");
		map.put(0x0000203D, "ERROR_DS_DECODING_ERROR");
		map.put(0x0000203E, "ERROR_DS_FILTER_UNKNOWN");
		map.put(0x0000203F, "ERROR_DS_PARAM_ERROR");
		map.put(0x00002040, "ERROR_DS_NOT_SUPPORTED");
		map.put(0x00002041, "ERROR_DS_NO_RESULTS_RETURNED");
		map.put(0x00002042, "ERROR_DS_CONTROL_NOT_FOUND");
		map.put(0x00002043, "ERROR_DS_CLIENT_LOOP");
		map.put(0x00002044, "ERROR_DS_REFERRAL_LIMIT_EXCEEDED");
		map.put(0x00002045, "ERROR_DS_SORT_CONTROL_MISSING");
		map.put(0x00002046, "ERROR_DS_OFFSET_RANGE_ERROR");
		map.put(0x0000206D, "ERROR_DS_ROOT_MUST_BE_NC");
		map.put(0x0000206E, "ERROR_DS_ADD_REPLICA_INHIBITED");
		map.put(0x0000206F, "ERROR_DS_ATT_NOT_DEF_IN_SCHEMA");
		map.put(0x00002070, "ERROR_DS_MAX_OBJ_SIZE_EXCEEDED");
		map.put(0x00002071, "ERROR_DS_OBJ_STRING_NAME_EXISTS");
		map.put(0x00002072, "ERROR_DS_NO_RDN_DEFINED_IN_SCHEMA");
		map.put(0x00002073, "ERROR_DS_RDN_DOESNT_MATCH_SCHEMA");
		map.put(0x00002074, "ERROR_DS_NO_REQUESTED_ATTS_FOUND");
		map.put(0x00002075, "ERROR_DS_USER_BUFFER_TO_SMALL");
		map.put(0x00002076, "ERROR_DS_ATT_IS_NOT_ON_OBJ");
		map.put(0x00002077, "ERROR_DS_ILLEGAL_MOD_OPERATION");
		map.put(0x00002078, "ERROR_DS_OBJ_TOO_LARGE");
		map.put(0x00002079, "ERROR_DS_BAD_INSTANCE_TYPE");
		map.put(0x0000207A, "ERROR_DS_MASTERDSA_REQUIRED");
		map.put(0x0000207B, "ERROR_DS_OBJECT_CLASS_REQUIRED");
		map.put(0x0000207C, "ERROR_DS_MISSING_REQUIRED_ATT");
		map.put(0x0000207D, "ERROR_DS_ATT_NOT_DEF_FOR_CLASS");
		map.put(0x0000207E, "ERROR_DS_ATT_ALREADY_EXISTS");
		map.put(0x00002080, "ERROR_DS_CANT_ADD_ATT_VALUES");
		map.put(0x00002081, "ERROR_DS_SINGLE_VALUE_CONSTRAINT");
		map.put(0x00002082, "ERROR_DS_RANGE_CONSTRAINT");
		map.put(0x00002083, "ERROR_DS_ATT_VAL_ALREADY_EXISTS");
		map.put(0x00002084, "ERROR_DS_CANT_REM_MISSING_ATT");
		map.put(0x00002085, "ERROR_DS_CANT_REM_MISSING_ATT_VAL");
		map.put(0x00002086, "ERROR_DS_ROOT_CANT_BE_SUBREF");
		map.put(0x00002087, "ERROR_DS_NO_CHAINING");
		map.put(0x00002088, "ERROR_DS_NO_CHAINED_EVAL");
		map.put(0x00002089, "ERROR_DS_NO_PARENT_OBJECT");
		map.put(0x0000208A, "ERROR_DS_PARENT_IS_AN_ALIAS");
		map.put(0x0000208B, "ERROR_DS_CANT_MIX_MASTER_AND_REPS");
		map.put(0x0000208C, "ERROR_DS_CHILDREN_EXIST");
		map.put(0x0000208D, "ERROR_DS_OBJ_NOT_FOUND");
		map.put(0x0000208E, "ERROR_DS_ALIASED_OBJ_MISSING");
		map.put(0x0000208F, "ERROR_DS_BAD_NAME_SYNTAX");
		map.put(0x00002090, "ERROR_DS_ALIAS_POINTS_TO_ALIAS");
		map.put(0x00002091, "ERROR_DS_CANT_DEREF_ALIAS");
		map.put(0x00002092, "ERROR_DS_OUT_OF_SCOPE");
		map.put(0x00002093, "ERROR_DS_OBJECT_BEING_REMOVED");
		map.put(0x00002094, "ERROR_DS_CANT_DELETE_DSA_OBJ");
		map.put(0x00002095, "ERROR_DS_GENERIC_ERROR");
		map.put(0x00002096, "ERROR_DS_DSA_MUST_BE_INT_MASTER");
		map.put(0x00002097, "ERROR_DS_CLASS_NOT_DSA");
		map.put(0x00002098, "ERROR_DS_INSUFF_ACCESS_RIGHTS");
		map.put(0x00002099, "ERROR_DS_ILLEGAL_SUPERIOR");
		map.put(0x0000209A, "ERROR_DS_ATTRIBUTE_OWNED_BY_SAM");
		map.put(0x0000209B, "ERROR_DS_NAME_TOO_MANY_PARTS");
		map.put(0x0000209C, "ERROR_DS_NAME_TOO_LONG");
		map.put(0x0000209D, "ERROR_DS_NAME_VALUE_TOO_LONG");
		map.put(0x0000209E, "ERROR_DS_NAME_UNPARSEABLE");
		map.put(0x0000209F, "ERROR_DS_NAME_TYPE_UNKNOWN");
		map.put(0x000020A0, "ERROR_DS_NOT_AN_OBJECT");
		map.put(0x000020A1, "ERROR_DS_SEC_DESC_TOO_SHORT");
		map.put(0x000020A2, "ERROR_DS_SEC_DESC_INVALID");
		map.put(0x000020A3, "ERROR_DS_NO_DELETED_NAME");
		map.put(0x000020A4, "ERROR_DS_SUBREF_MUST_HAVE_PARENT");
		map.put(0x000020A5, "ERROR_DS_NCNAME_MUST_BE_NC");
		map.put(0x000020A6, "ERROR_DS_CANT_ADD_SYSTEM_ONLY");
		map.put(0x000020A7, "ERROR_DS_CLASS_MUST_BE_CONCRETE");
		map.put(0x000020A8, "ERROR_DS_INVALID_DMD");
		map.put(0x000020A9, "ERROR_DS_OBJ_GUID_EXISTS");
		map.put(0x000020AA, "ERROR_DS_NOT_ON_BACKLINK");
		map.put(0x000020AB, "ERROR_DS_NO_CROSSREF_FOR_NC");
		map.put(0x000020AC, "ERROR_DS_SHUTTING_DOWN");
		map.put(0x000020AD, "ERROR_DS_UNKNOWN_OPERATION");
		map.put(0x000020AE, "ERROR_DS_INVALID_ROLE_OWNER");
		map.put(0x000020AF, "ERROR_DS_COULDNT_CONTACT_FSMO");
		map.put(0x000020B0, "ERROR_DS_CROSS_NC_DN_RENAME");
		map.put(0x000020B1, "ERROR_DS_CANT_MOD_SYSTEM_ONLY");
		map.put(0x000020B2, "ERROR_DS_REPLICATOR_ONLY");
		map.put(0x000020B3, "ERROR_DS_OBJ_CLASS_NOT_DEFINED");
		map.put(0x000020B4, "ERROR_DS_OBJ_CLASS_NOT_SUBCLASS");
		map.put(0x000020B5, "ERROR_DS_NAME_REFERENCE_INVALID");
		map.put(0x000020B6, "ERROR_DS_CROSS_REF_EXISTS");
		map.put(0x000020B7, "ERROR_DS_CANT_DEL_MASTER_CROSSREF");
		map.put(0x000020B8, "ERROR_DS_SUBTREE_NOTIFY_NOT_NC_HEAD");
		map.put(0x000020B9, "ERROR_DS_NOTIFY_FILTER_TOO_COMPLEX");
		map.put(0x000020BA, "ERROR_DS_DUP_RDN");
		map.put(0x000020BB, "ERROR_DS_DUP_OID");
		map.put(0x000020BC, "ERROR_DS_DUP_MAPI_ID");
		map.put(0x000020BD, "ERROR_DS_DUP_SCHEMA_ID_GUID");
		map.put(0x000020BE, "ERROR_DS_DUP_LDAP_DISPLAY_NAME");
		map.put(0x000020BF, "ERROR_DS_SEMANTIC_ATT_TEST");
		map.put(0x000020C0, "ERROR_DS_SYNTAX_MISMATCH");
		map.put(0x000020C1, "ERROR_DS_EXISTS_IN_MUST_HAVE");
		map.put(0x000020C2, "ERROR_DS_EXISTS_IN_MAY_HAVE");
		map.put(0x000020C3, "ERROR_DS_NONEXISTENT_MAY_HAVE");
		map.put(0x000020C4, "ERROR_DS_NONEXISTENT_MUST_HAVE");
		map.put(0x000020C5, "ERROR_DS_AUX_CLS_TEST_FAIL");
		map.put(0x000020C6, "ERROR_DS_NONEXISTENT_POSS_SUP");
		map.put(0x000020C7, "ERROR_DS_SUB_CLS_TEST_FAIL");
		map.put(0x000020C8, "ERROR_DS_BAD_RDN_ATT_ID_SYNTAX");
		map.put(0x000020C9, "ERROR_DS_EXISTS_IN_AUX_CLS");
		map.put(0x000020CA, "ERROR_DS_EXISTS_IN_SUB_CLS");
		map.put(0x000020CB, "ERROR_DS_EXISTS_IN_POSS_SUP");
		map.put(0x000020CC, "ERROR_DS_RECALCSCHEMA_FAILED");
		map.put(0x000020CD, "ERROR_DS_TREE_DELETE_NOT_FINISHED");
		map.put(0x000020CE, "ERROR_DS_CANT_DELETE");
		map.put(0x000020CF, "ERROR_DS_ATT_SCHEMA_REQ_ID");
		map.put(0x000020D0, "ERROR_DS_BAD_ATT_SCHEMA_SYNTAX");
		map.put(0x000020D1, "ERROR_DS_CANT_CACHE_ATT");
		map.put(0x000020D2, "ERROR_DS_CANT_CACHE_CLASS");
		map.put(0x000020D3, "ERROR_DS_CANT_REMOVE_ATT_CACHE");
		map.put(0x000020D4, "ERROR_DS_CANT_REMOVE_CLASS_CACHE");
		map.put(0x000020D5, "ERROR_DS_CANT_RETRIEVE_DN");
		map.put(0x000020D6, "ERROR_DS_MISSING_SUPREF");
		map.put(0x000020D7, "ERROR_DS_CANT_RETRIEVE_INSTANCE");
		map.put(0x000020D8, "ERROR_DS_CODE_INCONSISTENCY");
		map.put(0x000020D9, "ERROR_DS_DATABASE_ERROR");
		map.put(0x000020DA, "ERROR_DS_GOVERNSID_MISSING");
		map.put(0x000020DB, "ERROR_DS_MISSING_EXPECTED_ATT");
		map.put(0x000020DC, "ERROR_DS_NCNAME_MISSING_CR_REF");
		map.put(0x000020DD, "ERROR_DS_SECURITY_CHECKING_ERROR");
		map.put(0x000020DE, "ERROR_DS_SCHEMA_NOT_LOADED");
		map.put(0x000020DF, "ERROR_DS_SCHEMA_ALLOC_FAILED");
		map.put(0x000020E0, "ERROR_DS_ATT_SCHEMA_REQ_SYNTAX");
		map.put(0x000020E1, "ERROR_DS_GCVERIFY_ERROR");
		map.put(0x000020E2, "ERROR_DS_DRA_SCHEMA_MISMATCH");
		map.put(0x000020E3, "ERROR_DS_CANT_FIND_DSA_OBJ");
		map.put(0x000020E4, "ERROR_DS_CANT_FIND_EXPECTED_NC");
		map.put(0x000020E5, "ERROR_DS_CANT_FIND_NC_IN_CACHE");
		map.put(0x000020E6, "ERROR_DS_CANT_RETRIEVE_CHILD");
		map.put(0x000020E7, "ERROR_DS_SECURITY_ILLEGAL_MODIFY");
		map.put(0x000020E8, "ERROR_DS_CANT_REPLACE_HIDDEN_REC");
		map.put(0x000020E9, "ERROR_DS_BAD_HIERARCHY_FILE");
		map.put(0x000020EA, "ERROR_DS_BUILD_HIERARCHY_TABLE_FAILED");
		map.put(0x000020EB, "ERROR_DS_CONFIG_PARAM_MISSING");
		map.put(0x000020EC, "ERROR_DS_COUNTING_AB_INDICES_FAILED");
		map.put(0x000020ED, "ERROR_DS_HIERARCHY_TABLE_MALLOC_FAILED");
		map.put(0x000020EE, "ERROR_DS_INTERNAL_FAILURE");
		map.put(0x000020EF, "ERROR_DS_UNKNOWN_ERROR");
		map.put(0x000020F0, "ERROR_DS_ROOT_REQUIRES_CLASS_TOP");
		map.put(0x000020F1, "ERROR_DS_REFUSING_FSMO_ROLES");
		map.put(0x000020F2, "ERROR_DS_MISSING_FSMO_SETTINGS");
		map.put(0x000020F3, "ERROR_DS_UNABLE_TO_SURRENDER_ROLES");
		map.put(0x000020F4, "ERROR_DS_DRA_GENERIC");
		map.put(0x000020F5, "ERROR_DS_DRA_INVALID_PARAMETER");
		map.put(0x000020F6, "ERROR_DS_DRA_BUSY");
		map.put(0x000020F7, "ERROR_DS_DRA_BAD_DN");
		map.put(0x000020F8, "ERROR_DS_DRA_BAD_NC");
		map.put(0x000020F9, "ERROR_DS_DRA_DN_EXISTS");
		map.put(0x000020FA, "ERROR_DS_DRA_INTERNAL_ERROR");
		map.put(0x000020FB, "ERROR_DS_DRA_INCONSISTENT_DIT");
		map.put(0x000020FC, "ERROR_DS_DRA_CONNECTION_FAILED");
		map.put(0x000020FD, "ERROR_DS_DRA_BAD_INSTANCE_TYPE");
		map.put(0x000020FE, "ERROR_DS_DRA_OUT_OF_MEM");
		map.put(0x000020FF, "ERROR_DS_DRA_MAIL_PROBLEM");
		map.put(0x00002100, "ERROR_DS_DRA_REF_ALREADY_EXISTS");
		map.put(0x00002101, "ERROR_DS_DRA_REF_NOT_FOUND");
		map.put(0x00002102, "ERROR_DS_DRA_OBJ_IS_REP_SOURCE");
		map.put(0x00002103, "ERROR_DS_DRA_DB_ERROR");
		map.put(0x00002104, "ERROR_DS_DRA_NO_REPLICA");
		map.put(0x00002105, "ERROR_DS_DRA_ACCESS_DENIED");
		map.put(0x00002106, "ERROR_DS_DRA_NOT_SUPPORTED");
		map.put(0x00002107, "ERROR_DS_DRA_RPC_CANCELLED");
		map.put(0x00002108, "ERROR_DS_DRA_SOURCE_DISABLED");
		map.put(0x00002109, "ERROR_DS_DRA_SINK_DISABLED");
		map.put(0x0000210A, "ERROR_DS_DRA_NAME_COLLISION");
		map.put(0x0000210B, "ERROR_DS_DRA_SOURCE_REINSTALLED");
		map.put(0x0000210C, "ERROR_DS_DRA_MISSING_PARENT");
		map.put(0x0000210D, "ERROR_DS_DRA_PREEMPTED");
		map.put(0x0000210E, "ERROR_DS_DRA_ABANDON_SYNC");
		map.put(0x0000210F, "ERROR_DS_DRA_SHUTDOWN");
		map.put(0x00002110, "ERROR_DS_DRA_INCOMPATIBLE_PARTIAL_SET");
		map.put(0x00002111, "ERROR_DS_DRA_SOURCE_IS_PARTIAL_REPLICA");
		map.put(0x00002112, "ERROR_DS_DRA_EXTN_CONNECTION_FAILED");
		map.put(0x00002113, "ERROR_DS_INSTALL_SCHEMA_MISMATCH");
		map.put(0x00002114, "ERROR_DS_DUP_LINK_ID");
		map.put(0x00002115, "ERROR_DS_NAME_ERROR_RESOLVING");
		map.put(0x00002116, "ERROR_DS_NAME_ERROR_NOT_FOUND");
		map.put(0x00002117, "ERROR_DS_NAME_ERROR_NOT_UNIQUE");
		map.put(0x00002118, "ERROR_DS_NAME_ERROR_NO_MAPPING");
		map.put(0x00002119, "ERROR_DS_NAME_ERROR_DOMAIN_ONLY");
		map.put(0x0000211A, "ERROR_DS_NAME_ERROR_NO_SYNTACTICAL_MAPPING");
		map.put(0x0000211B, "ERROR_DS_CONSTRUCTED_ATT_MOD");
		map.put(0x0000211C, "ERROR_DS_WRONG_OM_OBJ_CLASS");
		map.put(0x0000211D, "ERROR_DS_DRA_REPL_PENDING");
		map.put(0x0000211E, "ERROR_DS_DS_REQUIRED");
		map.put(0x0000211F, "ERROR_DS_INVALID_LDAP_DISPLAY_NAME");
		map.put(0x00002120, "ERROR_DS_NON_BASE_SEARCH");
		map.put(0x00002121, "ERROR_DS_CANT_RETRIEVE_ATTS");
		map.put(0x00002122, "ERROR_DS_BACKLINK_WITHOUT_LINK");
		map.put(0x00002123, "ERROR_DS_EPOCH_MISMATCH");
		map.put(0x00002124, "ERROR_DS_SRC_NAME_MISMATCH");
		map.put(0x00002125, "ERROR_DS_SRC_AND_DST_NC_IDENTICAL");
		map.put(0x00002126, "ERROR_DS_DST_NC_MISMATCH");
		map.put(0x00002127, "ERROR_DS_NOT_AUTHORITIVE_FOR_DST_NC");
		map.put(0x00002128, "ERROR_DS_SRC_GUID_MISMATCH");
		map.put(0x00002129, "ERROR_DS_CANT_MOVE_DELETED_OBJECT");
		map.put(0x0000212A, "ERROR_DS_PDC_OPERATION_IN_PROGRESS");
		map.put(0x0000212B, "ERROR_DS_CROSS_DOMAIN_CLEANUP_REQD");
		map.put(0x0000212C, "ERROR_DS_ILLEGAL_XDOM_MOVE_OPERATION");
		map.put(0x0000212D, "ERROR_DS_CANT_WITH_ACCT_GROUP_MEMBERSHPS");
		map.put(0x0000212E, "ERROR_DS_NC_MUST_HAVE_NC_PARENT");
		map.put(0x0000212F, "ERROR_DS_CR_IMPOSSIBLE_TO_VALIDATE");
		map.put(0x00002130, "ERROR_DS_DST_DOMAIN_NOT_NATIVE");
		map.put(0x00002131, "ERROR_DS_MISSING_INFRASTRUCTURE_CONTAINER");
		map.put(0x00002132, "ERROR_DS_CANT_MOVE_ACCOUNT_GROUP");
		map.put(0x00002133, "ERROR_DS_CANT_MOVE_RESOURCE_GROUP");
		map.put(0x00002134, "ERROR_DS_INVALID_SEARCH_FLAG");
		map.put(0x00002135, "ERROR_DS_NO_TREE_DELETE_ABOVE_NC");
		map.put(0x00002136, "ERROR_DS_COULDNT_LOCK_TREE_FOR_DELETE");
		map.put(0x00002137, "ERROR_DS_COULDNT_IDENTIFY_OBJECTS_FOR_TREE_DELETE");
		map.put(0x00002138, "ERROR_DS_SAM_INIT_FAILURE");
		map.put(0x00002139, "ERROR_DS_SENSITIVE_GROUP_VIOLATION");
		map.put(0x0000213A, "ERROR_DS_CANT_MOD_PRIMARYGROUPID");
		map.put(0x0000213B, "ERROR_DS_ILLEGAL_BASE_SCHEMA_MOD");
		map.put(0x0000213C, "ERROR_DS_NONSAFE_SCHEMA_CHANGE");
		map.put(0x0000213D, "ERROR_DS_SCHEMA_UPDATE_DISALLOWED");
		map.put(0x0000213E, "ERROR_DS_CANT_CREATE_UNDER_SCHEMA");
		map.put(0x0000213F, "ERROR_DS_INSTALL_NO_SRC_SCH_VERSION");
		map.put(0x00002140, "ERROR_DS_INSTALL_NO_SCH_VERSION_IN_INIFILE");
		map.put(0x00002141, "ERROR_DS_INVALID_GROUP_TYPE");
		map.put(0x00002142, "ERROR_DS_NO_NEST_GLOBALGROUP_IN_MIXEDDOMAIN");
		map.put(0x00002143, "ERROR_DS_NO_NEST_LOCALGROUP_IN_MIXEDDOMAIN");
		map.put(0x00002144, "ERROR_DS_GLOBAL_CANT_HAVE_LOCAL_MEMBER");
		map.put(0x00002145, "ERROR_DS_GLOBAL_CANT_HAVE_UNIVERSAL_MEMBER");
		map.put(0x00002146, "ERROR_DS_UNIVERSAL_CANT_HAVE_LOCAL_MEMBER");
		map.put(0x00002147, "ERROR_DS_GLOBAL_CANT_HAVE_CROSSDOMAIN_MEMBER");
		map.put(0x00002148, "ERROR_DS_LOCAL_CANT_HAVE_CROSSDOMAIN_LOCAL_MEMBER");
		map.put(0x00002149, "ERROR_DS_HAVE_PRIMARY_MEMBERS");
		map.put(0x0000214A, "ERROR_DS_STRING_SD_CONVERSION_FAILED");
		map.put(0x0000214B, "ERROR_DS_NAMING_MASTER_GC");
		map.put(0x0000214C, "ERROR_DS_DNS_LOOKUP_FAILURE");
		map.put(0x0000214D, "ERROR_DS_COULDNT_UPDATE_SPNS");
		map.put(0x0000214E, "ERROR_DS_CANT_RETRIEVE_SD");
		map.put(0x0000214F, "ERROR_DS_KEY_NOT_UNIQUE");
		map.put(0x00002150, "ERROR_DS_WRONG_LINKED_ATT_SYNTAX");
		map.put(0x00002151, "ERROR_DS_SAM_NEED_BOOTKEY_PASSWORD");
		map.put(0x00002152, "ERROR_DS_SAM_NEED_BOOTKEY_FLOPPY");
		map.put(0x00002153, "ERROR_DS_CANT_START");
		map.put(0x00002154, "ERROR_DS_INIT_FAILURE");
		map.put(0x00002155, "ERROR_DS_NO_PKT_PRIVACY_ON_CONNECTION");
		map.put(0x00002156, "ERROR_DS_SOURCE_DOMAIN_IN_FOREST");
		map.put(0x00002157, "ERROR_DS_DESTINATION_DOMAIN_NOT_IN_FOREST");
		map.put(0x00002158, "ERROR_DS_DESTINATION_AUDITING_NOT_ENABLED");
		map.put(0x00002159, "ERROR_DS_CANT_FIND_DC_FOR_SRC_DOMAIN");
		map.put(0x0000215A, "ERROR_DS_SRC_OBJ_NOT_GROUP_OR_USER");
		map.put(0x0000215B, "ERROR_DS_SRC_SID_EXISTS_IN_FOREST");
		map.put(0x0000215C, "ERROR_DS_SRC_AND_DST_OBJECT_CLASS_MISMATCH");
		map.put(0x0000215D, "ERROR_SAM_INIT_FAILURE");
		map.put(0x0000215E, "ERROR_DS_DRA_SCHEMA_INFO_SHIP");
		map.put(0x0000215F, "ERROR_DS_DRA_SCHEMA_CONFLICT");
		map.put(0x00002160, "ERROR_DS_DRA_EARLIER_SCHEMA_CONFLICT");
		map.put(0x00002161, "ERROR_DS_DRA_OBJ_NC_MISMATCH");
		map.put(0x00002162, "ERROR_DS_NC_STILL_HAS_DSAS");
		map.put(0x00002163, "ERROR_DS_GC_REQUIRED");
		map.put(0x00002164, "ERROR_DS_LOCAL_MEMBER_OF_LOCAL_ONLY");
		map.put(0x00002165, "ERROR_DS_NO_FPO_IN_UNIVERSAL_GROUPS");
		map.put(0x00002166, "ERROR_DS_CANT_ADD_TO_GC");
		map.put(0x00002167, "ERROR_DS_NO_CHECKPOINT_WITH_PDC");
		map.put(0x00002168, "ERROR_DS_SOURCE_AUDITING_NOT_ENABLED");
		map.put(0x00002169, "ERROR_DS_CANT_CREATE_IN_NONDOMAIN_NC");
		map.put(0x0000216A, "ERROR_DS_INVALID_NAME_FOR_SPN");
		map.put(0x0000216B, "ERROR_DS_FILTER_USES_CONTRUCTED_ATTRS");
		map.put(0x0000216C, "ERROR_DS_UNICODEPWD_NOT_IN_QUOTES");
		map.put(0x0000216D, "ERROR_DS_MACHINE_ACCOUNT_QUOTA_EXCEEDED");
		map.put(0x0000216E, "ERROR_DS_MUST_BE_RUN_ON_DST_DC");
		map.put(0x0000216F, "ERROR_DS_SRC_DC_MUST_BE_SP4_OR_GREATER");
		map.put(0x00002170, "ERROR_DS_CANT_TREE_DELETE_CRITICAL_OBJ");
		map.put(0x00002171, "ERROR_DS_INIT_FAILURE_CONSOLE");
		map.put(0x00002172, "ERROR_DS_SAM_INIT_FAILURE_CONSOLE");
		map.put(0x00002173, "ERROR_DS_FOREST_VERSION_TOO_HIGH");
		map.put(0x00002174, "ERROR_DS_DOMAIN_VERSION_TOO_HIGH");
		map.put(0x00002175, "ERROR_DS_FOREST_VERSION_TOO_LOW");
		map.put(0x00002176, "ERROR_DS_DOMAIN_VERSION_TOO_LOW");
		map.put(0x00002177, "ERROR_DS_INCOMPATIBLE_VERSION");
		map.put(0x00002178, "ERROR_DS_LOW_DSA_VERSION");
		map.put(0x00002179, "ERROR_DS_NO_BEHAVIOR_VERSION_IN_MIXEDDOMAIN");
		map.put(0x0000217A, "ERROR_DS_NOT_SUPPORTED_SORT_ORDER");
		map.put(0x0000217B, "ERROR_DS_NAME_NOT_UNIQUE");
		map.put(0x0000217C, "ERROR_DS_MACHINE_ACCOUNT_CREATED_PRENT4");
		map.put(0x0000217D, "ERROR_DS_OUT_OF_VERSION_STORE");
		map.put(0x0000217E, "ERROR_DS_INCOMPATIBLE_CONTROLS_USED");
		map.put(0x0000217F, "ERROR_DS_NO_REF_DOMAIN");
		map.put(0x00002180, "ERROR_DS_RESERVED_LINK_ID");
		map.put(0x00002181, "ERROR_DS_LINK_ID_NOT_AVAILABLE");
		map.put(0x00002182, "ERROR_DS_AG_CANT_HAVE_UNIVERSAL_MEMBER");
		map.put(0x00002183, "ERROR_DS_MODIFYDN_DISALLOWED_BY_INSTANCE_TYPE");
		map.put(0x00002184, "ERROR_DS_NO_OBJECT_MOVE_IN_SCHEMA_NC");
		map.put(0x00002185, "ERROR_DS_MODIFYDN_DISALLOWED_BY_FLAG");
		map.put(0x00002186, "ERROR_DS_MODIFYDN_WRONG_GRANDPARENT");
		map.put(0x00002187, "ERROR_DS_NAME_ERROR_TRUST_REFERRAL");
		map.put(0x00002188, "ERROR_NOT_SUPPORTED_ON_STANDARD_SERVER");
		map.put(0x00002189, "ERROR_DS_CANT_ACCESS_REMOTE_PART_OF_AD");
		map.put(0x0000218A, "ERROR_DS_CR_IMPOSSIBLE_TO_VALIDATE_V2");
		map.put(0x0000218B, "ERROR_DS_THREAD_LIMIT_EXCEEDED");
		map.put(0x0000218C, "ERROR_DS_NOT_CLOSEST");
		map.put(0x0000218D, "ERROR_DS_CANT_DERIVE_SPN_WITHOUT_SERVER_REF");
		map.put(0x0000218E, "ERROR_DS_SINGLE_USER_MODE_FAILED");
		map.put(0x0000218F, "ERROR_DS_NTDSCRIPT_SYNTAX_ERROR");
		map.put(0x00002190, "ERROR_DS_NTDSCRIPT_PROCESS_ERROR");
		map.put(0x00002191, "ERROR_DS_DIFFERENT_REPL_EPOCHS");
		map.put(0x00002192, "ERROR_DS_DRS_EXTENSIONS_CHANGED");
		map.put(0x00002193, "ERROR_DS_REPLICA_SET_CHANGE_NOT_ALLOWED_ON_DISABLED_CR");
		map.put(0x00002194, "ERROR_DS_NO_MSDS_INTID");
		map.put(0x00002195, "ERROR_DS_DUP_MSDS_INTID");
		map.put(0x00002196, "ERROR_DS_EXISTS_IN_RDNATTID");
		map.put(0x00002197, "ERROR_DS_AUTHORIZATION_FAILED");
		map.put(0x00002198, "ERROR_DS_INVALID_SCRIPT");
		map.put(0x00002199, "ERROR_DS_REMOTE_CROSSREF_OP_FAILED");
		map.put(0x0000219A, "ERROR_DS_CROSS_REF_BUSY");
		map.put(0x0000219B, "ERROR_DS_CANT_DERIVE_SPN_FOR_DELETED_DOMAIN");
		map.put(0x0000219C, "ERROR_DS_CANT_DEMOTE_WITH_WRITEABLE_NC");
		map.put(0x0000219D, "ERROR_DS_DUPLICATE_ID_FOUND");
		map.put(0x0000219E, "ERROR_DS_INSUFFICIENT_ATTR_TO_CREATE_OBJECT");
		map.put(0x0000219F, "ERROR_DS_GROUP_CONVERSION_ERROR");
		map.put(0x000021A0, "ERROR_DS_CANT_MOVE_APP_BASIC_GROUP");
		map.put(0x000021A1, "ERROR_DS_CANT_MOVE_APP_QUERY_GROUP");
		map.put(0x000021A2, "ERROR_DS_ROLE_NOT_VERIFIED");
		map.put(0x000021A3, "ERROR_DS_WKO_CONTAINER_CANNOT_BE_SPECIAL");
		map.put(0x000021A4, "ERROR_DS_DOMAIN_RENAME_IN_PROGRESS");
		map.put(0x000021A5, "ERROR_DS_EXISTING_AD_CHILD_NC");
		map.put(0x000021A6, "ERROR_DS_REPL_LIFETIME_EXCEEDED");
		map.put(0x000021A7, "ERROR_DS_DISALLOWED_IN_SYSTEM_CONTAINER");
		map.put(0x000021A8, "ERROR_DS_LDAP_SEND_QUEUE_FULL");
		map.put(0x000021A9, "ERROR_DS_DRA_OUT_SCHEDULE_WINDOW");
		map.put(0x000021AA, "ERROR_DS_POLICY_NOT_KNOWN");
		map.put(0x000021AB, "ERROR_NO_SITE_SETTINGS_OBJECT");
		map.put(0x000021AC, "ERROR_NO_SECRETS");
		map.put(0x000021AD, "ERROR_NO_WRITABLE_DC_FOUND");
		map.put(0x000021AE, "ERROR_DS_NO_SERVER_OBJECT");
		map.put(0x000021AF, "ERROR_DS_NO_NTDSA_OBJECT");
		map.put(0x000021B0, "ERROR_DS_NON_ASQ_SEARCH");
		map.put(0x000021B1, "ERROR_DS_AUDIT_FAILURE");
		map.put(0x000021B2, "ERROR_DS_INVALID_SEARCH_FLAG_SUBTREE");
		map.put(0x000021B3, "ERROR_DS_INVALID_SEARCH_FLAG_TUPLE");
		map.put(0x00002329, "DNS_ERROR_RCODE_FORMAT_ERROR");
		map.put(0x0000232A, "DNS_ERROR_RCODE_SERVER_FAILURE");
		map.put(0x0000232B, "DNS_ERROR_RCODE_NAME_ERROR");
		map.put(0x0000232C, "DNS_ERROR_RCODE_NOT_IMPLEMENTED");
		map.put(0x0000232D, "DNS_ERROR_RCODE_REFUSED");
		map.put(0x0000232E, "DNS_ERROR_RCODE_YXDOMAIN");
		map.put(0x0000232F, "DNS_ERROR_RCODE_YXRRSET");
		map.put(0x00002330, "DNS_ERROR_RCODE_NXRRSET");
		map.put(0x00002331, "DNS_ERROR_RCODE_NOTAUTH");
		map.put(0x00002332, "DNS_ERROR_RCODE_NOTZONE");
		map.put(0x00002338, "DNS_ERROR_RCODE_BADSIG");
		map.put(0x00002339, "DNS_ERROR_RCODE_BADKEY");
		map.put(0x0000233A, "DNS_ERROR_RCODE_BADTIME");
		map.put(0x0000251D, "DNS_INFO_NO_RECORDS");
		map.put(0x0000251E, "DNS_ERROR_BAD_PACKET");
		map.put(0x0000251F, "DNS_ERROR_NO_PACKET");
		map.put(0x00002520, "DNS_ERROR_RCODE");
		map.put(0x00002521, "DNS_ERROR_UNSECURE_PACKET");
		map.put(0x0000254F, "DNS_ERROR_INVALID_TYPE");
		map.put(0x00002550, "DNS_ERROR_INVALID_IP_ADDRESS");
		map.put(0x00002551, "DNS_ERROR_INVALID_PROPERTY");
		map.put(0x00002552, "DNS_ERROR_TRY_AGAIN_LATER");
		map.put(0x00002553, "DNS_ERROR_NOT_UNIQUE");
		map.put(0x00002554, "DNS_ERROR_NON_RFC_NAME");
		map.put(0x00002555, "DNS_STATUS_FQDN");
		map.put(0x00002556, "DNS_STATUS_DOTTED_NAME");
		map.put(0x00002557, "DNS_STATUS_SINGLE_PART_NAME");
		map.put(0x00002558, "DNS_ERROR_INVALID_NAME_CHAR");
		map.put(0x00002559, "DNS_ERROR_NUMERIC_NAME");
		map.put(0x0000255A, "DNS_ERROR_NOT_ALLOWED_ON_ROOT_SERVER");
		map.put(0x0000255B, "DNS_ERROR_NOT_ALLOWED_UNDER_DELEGATION");
		map.put(0x0000255C, "DNS_ERROR_CANNOT_FIND_ROOT_HINTS");
		map.put(0x0000255D, "DNS_ERROR_INCONSISTENT_ROOT_HINTS");
		map.put(0x0000255E, "DNS_ERROR_DWORD_VALUE_TOO_SMALL");
		map.put(0x0000255F, "DNS_ERROR_DWORD_VALUE_TOO_LARGE");
		map.put(0x00002560, "DNS_ERROR_BACKGROUND_LOADING");
		map.put(0x00002561, "DNS_ERROR_NOT_ALLOWED_ON_RODC");
		map.put(0x00002581, "DNS_ERROR_ZONE_DOES_NOT_EXIST");
		map.put(0x00002582, "DNS_ERROR_NO_ZONE_INFO");
		map.put(0x00002583, "DNS_ERROR_INVALID_ZONE_OPERATION");
		map.put(0x00002584, "DNS_ERROR_ZONE_CONFIGURATION_ERROR");
		map.put(0x00002585, "DNS_ERROR_ZONE_HAS_NO_SOA_RECORD");
		map.put(0x00002586, "DNS_ERROR_ZONE_HAS_NO_NS_RECORDS");
		map.put(0x00002587, "DNS_ERROR_ZONE_LOCKED");
		map.put(0x00002588, "DNS_ERROR_ZONE_CREATION_FAILED");
		map.put(0x00002589, "DNS_ERROR_ZONE_ALREADY_EXISTS");
		map.put(0x0000258A, "DNS_ERROR_AUTOZONE_ALREADY_EXISTS");
		map.put(0x0000258B, "DNS_ERROR_INVALID_ZONE_TYPE");
		map.put(0x0000258C, "DNS_ERROR_SECONDARY_REQUIRES_MASTER_IP");
		map.put(0x0000258D, "DNS_ERROR_ZONE_NOT_SECONDARY");
		map.put(0x0000258E, "DNS_ERROR_NEED_SECONDARY_ADDRESSES");
		map.put(0x0000258F, "DNS_ERROR_WINS_INIT_FAILED");
		map.put(0x00002590, "DNS_ERROR_NEED_WINS_SERVERS");
		map.put(0x00002591, "DNS_ERROR_NBSTAT_INIT_FAILED");
		map.put(0x00002592, "DNS_ERROR_SOA_DELETE_INVALID");
		map.put(0x00002593, "DNS_ERROR_FORWARDER_ALREADY_EXISTS");
		map.put(0x00002594, "DNS_ERROR_ZONE_REQUIRES_MASTER_IP");
		map.put(0x00002595, "DNS_ERROR_ZONE_IS_SHUTDOWN");
		map.put(0x000025B3, "DNS_ERROR_PRIMARY_REQUIRES_DATAFILE");
		map.put(0x000025B4, "DNS_ERROR_INVALID_DATAFILE_NAME");
		map.put(0x000025B5, "DNS_ERROR_DATAFILE_OPEN_FAILURE");
		map.put(0x000025B6, "DNS_ERROR_FILE_WRITEBACK_FAILED");
		map.put(0x000025B7, "DNS_ERROR_DATAFILE_PARSING");
		map.put(0x000025E5, "DNS_ERROR_RECORD_DOES_NOT_EXIST");
		map.put(0x000025E6, "DNS_ERROR_RECORD_FORMAT");
		map.put(0x000025E7, "DNS_ERROR_NODE_CREATION_FAILED");
		map.put(0x000025E8, "DNS_ERROR_UNKNOWN_RECORD_TYPE");
		map.put(0x000025E9, "DNS_ERROR_RECORD_TIMED_OUT");
		map.put(0x000025EA, "DNS_ERROR_NAME_NOT_IN_ZONE");
		map.put(0x000025EB, "DNS_ERROR_CNAME_LOOP");
		map.put(0x000025EC, "DNS_ERROR_NODE_IS_CNAME");
		map.put(0x000025ED, "DNS_ERROR_CNAME_COLLISION");
		map.put(0x000025EE, "DNS_ERROR_RECORD_ONLY_AT_ZONE_ROOT");
		map.put(0x000025EF, "DNS_ERROR_RECORD_ALREADY_EXISTS");
		map.put(0x000025F0, "DNS_ERROR_SECONDARY_DATA");
		map.put(0x000025F1, "DNS_ERROR_NO_CREATE_CACHE_DATA");
		map.put(0x000025F2, "DNS_ERROR_NAME_DOES_NOT_EXIST");
		map.put(0x000025F3, "DNS_WARNING_PTR_CREATE_FAILED");
		map.put(0x000025F4, "DNS_WARNING_DOMAIN_UNDELETED");
		map.put(0x000025F5, "DNS_ERROR_DS_UNAVAILABLE");
		map.put(0x000025F6, "DNS_ERROR_DS_ZONE_ALREADY_EXISTS");
		map.put(0x000025F7, "DNS_ERROR_NO_BOOTFILE_IF_DS_ZONE");
		map.put(0x00002617, "DNS_INFO_AXFR_COMPLETE");
		map.put(0x00002618, "DNS_ERROR_AXFR");
		map.put(0x00002619, "DNS_INFO_ADDED_LOCAL_WINS");
		map.put(0x00002649, "DNS_STATUS_CONTINUE_NEEDED");
		map.put(0x0000267B, "DNS_ERROR_NO_TCPIP");
		map.put(0x0000267C, "DNS_ERROR_NO_DNS_SERVERS");
		map.put(0x000026AD, "DNS_ERROR_DP_DOES_NOT_EXIST");
		map.put(0x000026AE, "DNS_ERROR_DP_ALREADY_EXISTS");
		map.put(0x000026AF, "DNS_ERROR_DP_NOT_ENLISTED");
		map.put(0x000026B0, "DNS_ERROR_DP_ALREADY_ENLISTED");
		map.put(0x000026B1, "DNS_ERROR_DP_NOT_AVAILABLE");
		map.put(0x000026B2, "DNS_ERROR_DP_FSMO_ERROR");
		map.put(0x00002714, "WSAEINTR");
		map.put(0x00002719, "WSAEBADF");
		map.put(0x0000271D, "WSAEACCES");
		map.put(0x0000271E, "WSAEFAULT");
		map.put(0x00002726, "WSAEINVAL");
		map.put(0x00002728, "WSAEMFILE");
		map.put(0x00002733, "WSAEWOULDBLOCK");
		map.put(0x00002734, "WSAEINPROGRESS");
		map.put(0x00002735, "WSAEALREADY");
		map.put(0x00002736, "WSAENOTSOCK");
		map.put(0x00002737, "WSAEDESTADDRREQ");
		map.put(0x00002738, "WSAEMSGSIZE");
		map.put(0x00002739, "WSAEPROTOTYPE");
		map.put(0x0000273A, "WSAENOPROTOOPT");
		map.put(0x0000273B, "WSAEPROTONOSUPPORT");
		map.put(0x0000273C, "WSAESOCKTNOSUPPORT");
		map.put(0x0000273D, "WSAEOPNOTSUPP");
		map.put(0x0000273E, "WSAEPFNOSUPPORT");
		map.put(0x0000273F, "WSAEAFNOSUPPORT");
		map.put(0x00002740, "WSAEADDRINUSE");
		map.put(0x00002741, "WSAEADDRNOTAVAIL");
		map.put(0x00002742, "WSAENETDOWN");
		map.put(0x00002743, "WSAENETUNREACH");
		map.put(0x00002744, "WSAENETRESET");
		map.put(0x00002745, "WSAECONNABORTED");
		map.put(0x00002746, "WSAECONNRESET");
		map.put(0x00002747, "WSAENOBUFS");
		map.put(0x00002748, "WSAEISCONN");
		map.put(0x00002749, "WSAENOTCONN");
		map.put(0x0000274A, "WSAESHUTDOWN");
		map.put(0x0000274B, "WSAETOOMANYREFS");
		map.put(0x0000274C, "WSAETIMEDOUT");
		map.put(0x0000274D, "WSAECONNREFUSED");
		map.put(0x0000274E, "WSAELOOP");
		map.put(0x0000274F, "WSAENAMETOOLONG");
		map.put(0x00002750, "WSAEHOSTDOWN");
		map.put(0x00002751, "WSAEHOSTUNREACH");
		map.put(0x00002752, "WSAENOTEMPTY");
		map.put(0x00002753, "WSAEPROCLIM");
		map.put(0x00002754, "WSAEUSERS");
		map.put(0x00002755, "WSAEDQUOT");
		map.put(0x00002756, "WSAESTALE");
		map.put(0x00002757, "WSAEREMOTE");
		map.put(0x0000276B, "WSASYSNOTREADY");
		map.put(0x0000276C, "WSAVERNOTSUPPORTED");
		map.put(0x0000276D, "WSANOTINITIALISED");
		map.put(0x00002775, "WSAEDISCON");
		map.put(0x00002776, "WSAENOMORE");
		map.put(0x00002777, "WSAECANCELLED");
		map.put(0x00002778, "WSAEINVALIDPROCTABLE");
		map.put(0x00002779, "WSAEINVALIDPROVIDER");
		map.put(0x0000277A, "WSAEPROVIDERFAILEDINIT");
		map.put(0x0000277B, "WSASYSCALLFAILURE");
		map.put(0x0000277C, "WSASERVICE_NOT_FOUND");
		map.put(0x0000277D, "WSATYPE_NOT_FOUND");
		map.put(0x0000277E, "WSA_E_NO_MORE");
		map.put(0x0000277F, "WSA_E_CANCELLED");
		map.put(0x00002780, "WSAEREFUSED");
		map.put(0x00002AF9, "WSAHOST_NOT_FOUND");
		map.put(0x00002AFA, "WSATRY_AGAIN");
		map.put(0x00002AFB, "WSANO_RECOVERY");
		map.put(0x00002AFC, "WSANO_DATA");
		map.put(0x00002AFD, "WSA_QOS_RECEIVERS");
		map.put(0x00002AFE, "WSA_QOS_SENDERS");
		map.put(0x00002AFF, "WSA_QOS_NO_SENDERS");
		map.put(0x00002B00, "WSA_QOS_NO_RECEIVERS");
		map.put(0x00002B01, "WSA_QOS_REQUEST_CONFIRMED");
		map.put(0x00002B02, "WSA_QOS_ADMISSION_FAILURE");
		map.put(0x00002B03, "WSA_QOS_POLICY_FAILURE");
		map.put(0x00002B04, "WSA_QOS_BAD_STYLE");
		map.put(0x00002B05, "WSA_QOS_BAD_OBJECT");
		map.put(0x00002B06, "WSA_QOS_TRAFFIC_CTRL_ERROR");
		map.put(0x00002B07, "WSA_QOS_GENERIC_ERROR");
		map.put(0x00002B08, "WSA_QOS_ESERVICETYPE");
		map.put(0x00002B09, "WSA_QOS_EFLOWSPEC");
		map.put(0x00002B0A, "WSA_QOS_EPROVSPECBUF");
		map.put(0x00002B0B, "WSA_QOS_EFILTERSTYLE");
		map.put(0x00002B0C, "WSA_QOS_EFILTERTYPE");
		map.put(0x00002B0D, "WSA_QOS_EFILTERCOUNT");
		map.put(0x00002B0E, "WSA_QOS_EOBJLENGTH");
		map.put(0x00002B0F, "WSA_QOS_EFLOWCOUNT");
		map.put(0x00002B10, "WSA_QOS_EUNKOWNPSOBJ");
		map.put(0x00002B11, "WSA_QOS_EPOLICYOBJ");
		map.put(0x00002B12, "WSA_QOS_EFLOWDESC");
		map.put(0x00002B13, "WSA_QOS_EPSFLOWSPEC");
		map.put(0x00002B14, "WSA_QOS_EPSFILTERSPEC");
		map.put(0x00002B15, "WSA_QOS_ESDMODEOBJ");
		map.put(0x00002B16, "WSA_QOS_ESHAPERATEOBJ");
		map.put(0x00002B17, "WSA_QOS_RESERVED_PETYPE");
		map.put(0x000032C8, "ERROR_IPSEC_QM_POLICY_EXISTS");
		map.put(0x000032C9, "ERROR_IPSEC_QM_POLICY_NOT_FOUND");
		map.put(0x000032CA, "ERROR_IPSEC_QM_POLICY_IN_USE");
		map.put(0x000032CB, "ERROR_IPSEC_MM_POLICY_EXISTS");
		map.put(0x000032CC, "ERROR_IPSEC_MM_POLICY_NOT_FOUND");
		map.put(0x000032CD, "ERROR_IPSEC_MM_POLICY_IN_USE");
		map.put(0x000032CE, "ERROR_IPSEC_MM_FILTER_EXISTS");
		map.put(0x000032CF, "ERROR_IPSEC_MM_FILTER_NOT_FOUND");
		map.put(0x000032D0, "ERROR_IPSEC_TRANSPORT_FILTER_EXISTS");
		map.put(0x000032D1, "ERROR_IPSEC_TRANSPORT_FILTER_NOT_FOUND");
		map.put(0x000032D2, "ERROR_IPSEC_MM_AUTH_EXISTS");
		map.put(0x000032D3, "ERROR_IPSEC_MM_AUTH_NOT_FOUND");
		map.put(0x000032D4, "ERROR_IPSEC_MM_AUTH_IN_USE");
		map.put(0x000032D5, "ERROR_IPSEC_DEFAULT_MM_POLICY_NOT_FOUND");
		map.put(0x000032D6, "ERROR_IPSEC_DEFAULT_MM_AUTH_NOT_FOUND");
		map.put(0x000032D7, "ERROR_IPSEC_DEFAULT_QM_POLICY_NOT_FOUND");
		map.put(0x000032D8, "ERROR_IPSEC_TUNNEL_FILTER_EXISTS");
		map.put(0x000032D9, "ERROR_IPSEC_TUNNEL_FILTER_NOT_FOUND");
		map.put(0x000032DA, "ERROR_IPSEC_MM_FILTER_PENDING_DELETION");
		map.put(0x000032DB, "ERROR_IPSEC_TRANSPORT_FILTER_ENDING_DELETION");
		map.put(0x000032DC, "ERROR_IPSEC_TUNNEL_FILTER_PENDING_DELETION");
		map.put(0x000032DD, "ERROR_IPSEC_MM_POLICY_PENDING_ELETION");
		map.put(0x000032DE, "ERROR_IPSEC_MM_AUTH_PENDING_DELETION");
		map.put(0x000032DF, "ERROR_IPSEC_QM_POLICY_PENDING_DELETION");
		map.put(0x000032E0, "WARNING_IPSEC_MM_POLICY_PRUNED");
		map.put(0x000032E1, "WARNING_IPSEC_QM_POLICY_PRUNED");
		map.put(0x000035E8, "ERROR_IPSEC_IKE_NEG_STATUS_BEGIN");
		map.put(0x000035E9, "ERROR_IPSEC_IKE_AUTH_FAIL");
		map.put(0x000035EA, "ERROR_IPSEC_IKE_ATTRIB_FAIL");
		map.put(0x000035EB, "ERROR_IPSEC_IKE_NEGOTIATION_PENDING");
		map.put(0x000035EC, "ERROR_IPSEC_IKE_GENERAL_PROCESSING_ERROR");
		map.put(0x000035ED, "ERROR_IPSEC_IKE_TIMED_OUT");
		map.put(0x000035EE, "ERROR_IPSEC_IKE_NO_CERT");
		map.put(0x000035EF, "ERROR_IPSEC_IKE_SA_DELETED");
		map.put(0x000035F0, "ERROR_IPSEC_IKE_SA_REAPED");
		map.put(0x000035F1, "ERROR_IPSEC_IKE_MM_ACQUIRE_DROP");
		map.put(0x000035F2, "ERROR_IPSEC_IKE_QM_ACQUIRE_DROP");
		map.put(0x000035F3, "ERROR_IPSEC_IKE_QUEUE_DROP_MM");
		map.put(0x000035F4, "ERROR_IPSEC_IKE_QUEUE_DROP_NO_MM");
		map.put(0x000035F5, "ERROR_IPSEC_IKE_DROP_NO_RESPONSE");
		map.put(0x000035F6, "ERROR_IPSEC_IKE_MM_DELAY_DROP");
		map.put(0x000035F7, "ERROR_IPSEC_IKE_QM_DELAY_DROP");
		map.put(0x000035F8, "ERROR_IPSEC_IKE_ERROR");
		map.put(0x000035F9, "ERROR_IPSEC_IKE_CRL_FAILED");
		map.put(0x000035FA, "ERROR_IPSEC_IKE_INVALID_KEY_USAGE");
		map.put(0x000035FB, "ERROR_IPSEC_IKE_INVALID_CERT_TYPE");
		map.put(0x000035FC, "ERROR_IPSEC_IKE_NO_PRIVATE_KEY");
		map.put(0x000035FE, "ERROR_IPSEC_IKE_DH_FAIL");
		map.put(0x00003600, "ERROR_IPSEC_IKE_INVALID_HEADER");
		map.put(0x00003601, "ERROR_IPSEC_IKE_NO_POLICY");
		map.put(0x00003602, "ERROR_IPSEC_IKE_INVALID_SIGNATURE");
		map.put(0x00003603, "ERROR_IPSEC_IKE_KERBEROS_ERROR");
		map.put(0x00003604, "ERROR_IPSEC_IKE_NO_PUBLIC_KEY");
		map.put(0x00003605, "ERROR_IPSEC_IKE_PROCESS_ERR");
		map.put(0x00003606, "ERROR_IPSEC_IKE_PROCESS_ERR_SA");
		map.put(0x00003607, "ERROR_IPSEC_IKE_PROCESS_ERR_PROP");
		map.put(0x00003608, "ERROR_IPSEC_IKE_PROCESS_ERR_TRANS");
		map.put(0x00003609, "ERROR_IPSEC_IKE_PROCESS_ERR_KE");
		map.put(0x0000360A, "ERROR_IPSEC_IKE_PROCESS_ERR_ID");
		map.put(0x0000360B, "ERROR_IPSEC_IKE_PROCESS_ERR_CERT");
		map.put(0x0000360C, "ERROR_IPSEC_IKE_PROCESS_ERR_CERT_REQ");
		map.put(0x0000360D, "ERROR_IPSEC_IKE_PROCESS_ERR_HASH");
		map.put(0x0000360E, "ERROR_IPSEC_IKE_PROCESS_ERR_SIG");
		map.put(0x0000360F, "ERROR_IPSEC_IKE_PROCESS_ERR_NONCE");
		map.put(0x00003610, "ERROR_IPSEC_IKE_PROCESS_ERR_NOTIFY");
		map.put(0x00003611, "ERROR_IPSEC_IKE_PROCESS_ERR_DELETE");
		map.put(0x00003612, "ERROR_IPSEC_IKE_PROCESS_ERR_VENDOR");
		map.put(0x00003613, "ERROR_IPSEC_IKE_INVALID_PAYLOAD");
		map.put(0x00003614, "ERROR_IPSEC_IKE_LOAD_SOFT_SA");
		map.put(0x00003615, "ERROR_IPSEC_IKE_SOFT_SA_TORN_DOWN");
		map.put(0x00003616, "ERROR_IPSEC_IKE_INVALID_COOKIE");
		map.put(0x00003617, "ERROR_IPSEC_IKE_NO_PEER_CERT");
		map.put(0x00003618, "ERROR_IPSEC_IKE_PEER_CRL_FAILED");
		map.put(0x00003619, "ERROR_IPSEC_IKE_POLICY_CHANGE");
		map.put(0x0000361A, "ERROR_IPSEC_IKE_NO_MM_POLICY");
		map.put(0x0000361B, "ERROR_IPSEC_IKE_NOTCBPRIV");
		map.put(0x0000361C, "ERROR_IPSEC_IKE_SECLOADFAIL");
		map.put(0x0000361D, "ERROR_IPSEC_IKE_FAILSSPINIT");
		map.put(0x0000361E, "ERROR_IPSEC_IKE_FAILQUERYSSP");
		map.put(0x0000361F, "ERROR_IPSEC_IKE_SRVACQFAIL");
		map.put(0x00003620, "ERROR_IPSEC_IKE_SRVQUERYCRED");
		map.put(0x00003621, "ERROR_IPSEC_IKE_GETSPIFAIL");
		map.put(0x00003622, "ERROR_IPSEC_IKE_INVALID_FILTER");
		map.put(0x00003623, "ERROR_IPSEC_IKE_OUT_OF_MEMORY");
		map.put(0x00003624, "ERROR_IPSEC_IKE_ADD_UPDATE_KEY_FAILED");
		map.put(0x00003625, "ERROR_IPSEC_IKE_INVALID_POLICY");
		map.put(0x00003626, "ERROR_IPSEC_IKE_UNKNOWN_DOI");
		map.put(0x00003627, "ERROR_IPSEC_IKE_INVALID_SITUATION");
		map.put(0x00003628, "ERROR_IPSEC_IKE_DH_FAILURE");
		map.put(0x00003629, "ERROR_IPSEC_IKE_INVALID_GROUP");
		map.put(0x0000362A, "ERROR_IPSEC_IKE_ENCRYPT");
		map.put(0x0000362B, "ERROR_IPSEC_IKE_DECRYPT");
		map.put(0x0000362C, "ERROR_IPSEC_IKE_POLICY_MATCH");
		map.put(0x0000362D, "ERROR_IPSEC_IKE_UNSUPPORTED_ID");
		map.put(0x0000362E, "ERROR_IPSEC_IKE_INVALID_HASH");
		map.put(0x0000362F, "ERROR_IPSEC_IKE_INVALID_HASH_ALG");
		map.put(0x00003630, "ERROR_IPSEC_IKE_INVALID_HASH_SIZE");
		map.put(0x00003631, "ERROR_IPSEC_IKE_INVALID_ENCRYPT_ALG");
		map.put(0x00003632, "ERROR_IPSEC_IKE_INVALID_AUTH_ALG");
		map.put(0x00003633, "ERROR_IPSEC_IKE_INVALID_SIG");
		map.put(0x00003634, "ERROR_IPSEC_IKE_LOAD_FAILED");
		map.put(0x00003635, "ERROR_IPSEC_IKE_RPC_DELETE");
		map.put(0x00003636, "ERROR_IPSEC_IKE_BENIGN_REINIT");
		map.put(0x00003637, "ERROR_IPSEC_IKE_INVALID_RESPONDER_LIFETIME_NOTIFY");
		map.put(0x00003639, "ERROR_IPSEC_IKE_INVALID_CERT_KEYLEN");
		map.put(0x0000363A, "ERROR_IPSEC_IKE_MM_LIMIT");
		map.put(0x0000363B, "ERROR_IPSEC_IKE_NEGOTIATION_DISABLED");
		map.put(0x0000363C, "ERROR_IPSEC_IKE_QM_LIMIT");
		map.put(0x0000363D, "ERROR_IPSEC_IKE_MM_EXPIRED");
		map.put(0x0000363E, "ERROR_IPSEC_IKE_PEER_MM_ASSUMED_INVALID");
		map.put(0x0000363F, "ERROR_IPSEC_IKE_CERT_CHAIN_POLICY_MISMATCH");
		map.put(0x00003640, "ERROR_IPSEC_IKE_UNEXPECTED_MESSAGE_ID");
		map.put(0x00003641, "ERROR_IPSEC_IKE_INVALID_UMATTS");
		map.put(0x00003642, "ERROR_IPSEC_IKE_DOS_COOKIE_SENT");
		map.put(0x00003643, "ERROR_IPSEC_IKE_SHUTTING_DOWN");
		map.put(0x00003644, "ERROR_IPSEC_IKE_CGA_AUTH_FAILED");
		map.put(0x00003645, "ERROR_IPSEC_IKE_PROCESS_ERR_NATOA");
		map.put(0x00003646, "ERROR_IPSEC_IKE_INVALID_MM_FOR_QM");
		map.put(0x00003647, "ERROR_IPSEC_IKE_QM_EXPIRED");
		map.put(0x00003648, "ERROR_IPSEC_IKE_TOO_MANY_FILTERS");
		map.put(0x00003649, "ERROR_IPSEC_IKE_NEG_STATUS_END");
		map.put(0x000036B0, "ERROR_SXS_SECTION_NOT_FOUND");
		map.put(0x000036B1, "ERROR_SXS_CANT_GEN_ACTCTX");
		map.put(0x000036B2, "ERROR_SXS_INVALID_ACTCTXDATA_FORMAT");
		map.put(0x000036B3, "ERROR_SXS_ASSEMBLY_NOT_FOUND");
		map.put(0x000036B4, "ERROR_SXS_MANIFEST_FORMAT_ERROR");
		map.put(0x000036B5, "ERROR_SXS_MANIFEST_PARSE_ERROR");
		map.put(0x000036B6, "ERROR_SXS_ACTIVATION_CONTEXT_DISABLED");
		map.put(0x000036B7, "ERROR_SXS_KEY_NOT_FOUND");
		map.put(0x000036B8, "ERROR_SXS_VERSION_CONFLICT");
		map.put(0x000036B9, "ERROR_SXS_WRONG_SECTION_TYPE");
		map.put(0x000036BA, "ERROR_SXS_THREAD_QUERIES_DISABLED");
		map.put(0x000036BB, "ERROR_SXS_PROCESS_DEFAULT_ALREADY_SET");
		map.put(0x000036BC, "ERROR_SXS_UNKNOWN_ENCODING_GROUP");
		map.put(0x000036BD, "ERROR_SXS_UNKNOWN_ENCODING");
		map.put(0x000036BE, "ERROR_SXS_INVALID_XML_NAMESPACE_URI");
		map.put(0x000036BF, "ERROR_SXS_ROOT_MANIFEST_DEPENDENCY_OT_INSTALLED");
		map.put(0x000036C0, "ERROR_SXS_LEAF_MANIFEST_DEPENDENCY_NOT_INSTALLED");
		map.put(0x000036C1, "ERROR_SXS_INVALID_ASSEMBLY_IDENTITY_ATTRIBUTE");
		map.put(0x000036C2, "ERROR_SXS_MANIFEST_MISSING_REQUIRED_DEFAULT_NAMESPACE");
		map.put(0x000036C3, "ERROR_SXS_MANIFEST_INVALID_REQUIRED_DEFAULT_NAMESPACE");
		map.put(0x000036C4, "ERROR_SXS_PRIVATE_MANIFEST_CROSS_PATH_WITH_REPARSE_POINT");
		map.put(0x000036C5, "ERROR_SXS_DUPLICATE_DLL_NAME");
		map.put(0x000036C6, "ERROR_SXS_DUPLICATE_WINDOWCLASS_NAME");
		map.put(0x000036C7, "ERROR_SXS_DUPLICATE_CLSID");
		map.put(0x000036C8, "ERROR_SXS_DUPLICATE_IID");
		map.put(0x000036C9, "ERROR_SXS_DUPLICATE_TLBID");
		map.put(0x000036CA, "ERROR_SXS_DUPLICATE_PROGID");
		map.put(0x000036CB, "ERROR_SXS_DUPLICATE_ASSEMBLY_NAME");
		map.put(0x000036CC, "ERROR_SXS_FILE_HASH_MISMATCH");
		map.put(0x000036CD, "ERROR_SXS_POLICY_PARSE_ERROR");
		map.put(0x000036CE, "ERROR_SXS_XML_E_MISSINGQUOTE");
		map.put(0x000036CF, "ERROR_SXS_XML_E_COMMENTSYNTAX");
		map.put(0x000036D0, "ERROR_SXS_XML_E_BADSTARTNAMECHAR");
		map.put(0x000036D1, "ERROR_SXS_XML_E_BADNAMECHAR");
		map.put(0x000036D2, "ERROR_SXS_XML_E_BADCHARINSTRING");
		map.put(0x000036D3, "ERROR_SXS_XML_E_XMLDECLSYNTAX");
		map.put(0x000036D4, "ERROR_SXS_XML_E_BADCHARDATA");
		map.put(0x000036D5, "ERROR_SXS_XML_E_MISSINGWHITESPACE");
		map.put(0x000036D6, "ERROR_SXS_XML_E_EXPECTINGTAGEND");
		map.put(0x000036D7, "ERROR_SXS_XML_E_MISSINGSEMICOLON");
		map.put(0x000036D8, "ERROR_SXS_XML_E_UNBALANCEDPAREN");
		map.put(0x000036D9, "ERROR_SXS_XML_E_INTERNALERROR");
		map.put(0x000036DA, "ERROR_SXS_XML_E_UNEXPECTED_WHITESPACE");
		map.put(0x000036DB, "ERROR_SXS_XML_E_INCOMPLETE_ENCODING");
		map.put(0x000036DC, "ERROR_SXS_XML_E_MISSING_PAREN");
		map.put(0x000036DD, "ERROR_SXS_XML_E_EXPECTINGCLOSEQUOTE");
		map.put(0x000036DE, "ERROR_SXS_XML_E_MULTIPLE_COLONS");
		map.put(0x000036DF, "ERROR_SXS_XML_E_INVALID_DECIMAL");
		map.put(0x000036E0, "ERROR_SXS_XML_E_INVALID_HEXIDECIMAL");
		map.put(0x000036E1, "ERROR_SXS_XML_E_INVALID_UNICODE");
		map.put(0x000036E2, "ERROR_SXS_XML_E_WHITESPACEORQUESTIONMARK");
		map.put(0x000036E3, "ERROR_SXS_XML_E_UNEXPECTEDENDTAG");
		map.put(0x000036E4, "ERROR_SXS_XML_E_UNCLOSEDTAG");
		map.put(0x000036E5, "ERROR_SXS_XML_E_DUPLICATEATTRIBUTE");
		map.put(0x000036E6, "ERROR_SXS_XML_E_MULTIPLEROOTS");
		map.put(0x000036E7, "ERROR_SXS_XML_E_INVALIDATROOTLEVEL");
		map.put(0x000036E8, "ERROR_SXS_XML_E_BADXMLDECL");
		map.put(0x000036E9, "ERROR_SXS_XML_E_MISSINGROOT");
		map.put(0x000036EA, "ERROR_SXS_XML_E_UNEXPECTEDEOF");
		map.put(0x000036EB, "ERROR_SXS_XML_E_BADPEREFINSUBSET");
		map.put(0x000036EC, "ERROR_SXS_XML_E_UNCLOSEDSTARTTAG");
		map.put(0x000036ED, "ERROR_SXS_XML_E_UNCLOSEDENDTAG");
		map.put(0x000036EE, "ERROR_SXS_XML_E_UNCLOSEDSTRING");
		map.put(0x000036EF, "ERROR_SXS_XML_E_UNCLOSEDCOMMENT");
		map.put(0x000036F0, "ERROR_SXS_XML_E_UNCLOSEDDECL");
		map.put(0x000036F1, "ERROR_SXS_XML_E_UNCLOSEDCDATA");
		map.put(0x000036F2, "ERROR_SXS_XML_E_RESERVEDNAMESPACE");
		map.put(0x000036F3, "ERROR_SXS_XML_E_INVALIDENCODING");
		map.put(0x000036F4, "ERROR_SXS_XML_E_INVALIDSWITCH");
		map.put(0x000036F5, "ERROR_SXS_XML_E_BADXMLCASE");
		map.put(0x000036F6, "ERROR_SXS_XML_E_INVALID_STANDALONE");
		map.put(0x000036F7, "ERROR_SXS_XML_E_UNEXPECTED_STANDALONE");
		map.put(0x000036F8, "ERROR_SXS_XML_E_INVALID_VERSION");
		map.put(0x000036F9, "ERROR_SXS_XML_E_MISSINGEQUALS");
		map.put(0x000036FA, "ERROR_SXS_PROTECTION_RECOVERY_FAILED");
		map.put(0x000036FB, "ERROR_SXS_PROTECTION_PUBLIC_KEY_OO_SHORT");
		map.put(0x000036FC, "ERROR_SXS_PROTECTION_CATALOG_NOT_VALID");
		map.put(0x000036FD, "ERROR_SXS_UNTRANSLATABLE_HRESULT");
		map.put(0x000036FE, "ERROR_SXS_PROTECTION_CATALOG_FILE_MISSING");
		map.put(0x000036FF, "ERROR_SXS_MISSING_ASSEMBLY_IDENTITY_ATTRIBUTE");
		map.put(0x00003700, "ERROR_SXS_INVALID_ASSEMBLY_IDENTITY_ATTRIBUTE_NAME");
		map.put(0x00003701, "ERROR_SXS_ASSEMBLY_MISSING");
		map.put(0x00003702, "ERROR_SXS_CORRUPT_ACTIVATION_STACK");
		map.put(0x00003703, "ERROR_SXS_CORRUPTION");
		map.put(0x00003704, "ERROR_SXS_EARLY_DEACTIVATION");
		map.put(0x00003705, "ERROR_SXS_INVALID_DEACTIVATION");
		map.put(0x00003706, "ERROR_SXS_MULTIPLE_DEACTIVATION");
		map.put(0x00003707, "ERROR_SXS_PROCESS_TERMINATION_REQUESTED");
		map.put(0x00003708, "ERROR_SXS_RELEASE_ACTIVATION_ONTEXT");
		map.put(0x00003709, "ERROR_SXS_SYSTEM_DEFAULT_ACTIVATION_CONTEXT_EMPTY");
		map.put(0x0000370A, "ERROR_SXS_INVALID_IDENTITY_ATTRIBUTE_VALUE");
		map.put(0x0000370B, "ERROR_SXS_INVALID_IDENTITY_ATTRIBUTE_NAME");
		map.put(0x0000370C, "ERROR_SXS_IDENTITY_DUPLICATE_ATTRIBUTE");
		map.put(0x0000370D, "ERROR_SXS_IDENTITY_PARSE_ERROR");
		map.put(0x0000370E, "ERROR_MALFORMED_SUBSTITUTION_STRING");
		map.put(0x0000370F, "ERROR_SXS_INCORRECT_PUBLIC_KEY_OKEN");
		map.put(0x00003710, "ERROR_UNMAPPED_SUBSTITUTION_STRING");
		map.put(0x00003711, "ERROR_SXS_ASSEMBLY_NOT_LOCKED");
		map.put(0x00003712, "ERROR_SXS_COMPONENT_STORE_CORRUPT");
		map.put(0x00003713, "ERROR_ADVANCED_INSTALLER_FAILED");
		map.put(0x00003714, "ERROR_XML_ENCODING_MISMATCH");
		map.put(0x00003715, "ERROR_SXS_MANIFEST_IDENTITY_SAME_BUT_CONTENTS_DIFFERENT");
		map.put(0x00003716, "ERROR_SXS_IDENTITIES_DIFFERENT");
		map.put(0x00003717, "ERROR_SXS_ASSEMBLY_IS_NOT_A_DEPLOYMENT");
		map.put(0x00003718, "ERROR_SXS_FILE_NOT_PART_OF_ASSEMBLY");
		map.put(0x00003719, "ERROR_SXS_MANIFEST_TOO_BIG");
		map.put(0x0000371A, "ERROR_SXS_SETTING_NOT_REGISTERED");
		map.put(0x0000371B, "ERROR_SXS_TRANSACTION_CLOSURE_INCOMPLETE");
		map.put(0x00003A98, "ERROR_EVT_INVALID_CHANNEL_PATH");
		map.put(0x00003A99, "ERROR_EVT_INVALID_QUERY");
		map.put(0x00003A9A, "ERROR_EVT_PUBLISHER_METADATA_NOT_FOUND");
		map.put(0x00003A9B, "ERROR_EVT_EVENT_TEMPLATE_NOT_FOUND");
		map.put(0x00003A9C, "ERROR_EVT_INVALID_PUBLISHER_NAME");
		map.put(0x00003A9D, "ERROR_EVT_INVALID_EVENT_DATA");
		map.put(0x00003A9F, "ERROR_EVT_CHANNEL_NOT_FOUND");
		map.put(0x00003AA0, "ERROR_EVT_MALFORMED_XML_TEXT");
		map.put(0x00003AA1, "ERROR_EVT_SUBSCRIPTION_TO_DIRECT_CHANNEL");
		map.put(0x00003AA2, "ERROR_EVT_CONFIGURATION_ERROR");
		map.put(0x00003AA3, "ERROR_EVT_QUERY_RESULT_STALE");
		map.put(0x00003AA4, "ERROR_EVT_QUERY_RESULT_INVALID_POSITION");
		map.put(0x00003AA5, "ERROR_EVT_NON_VALIDATING_MSXML");
		map.put(0x00003AA6, "ERROR_EVT_FILTER_ALREADYSCOPED");
		map.put(0x00003AA7, "ERROR_EVT_FILTER_NOTELTSET");
		map.put(0x00003AA8, "ERROR_EVT_FILTER_INVARG");
		map.put(0x00003AA9, "ERROR_EVT_FILTER_INVTEST");
		map.put(0x00003AAA, "ERROR_EVT_FILTER_INVTYPE");
		map.put(0x00003AAB, "ERROR_EVT_FILTER_PARSEERR");
		map.put(0x00003AAC, "ERROR_EVT_FILTER_UNSUPPORTEDOP");
		map.put(0x00003AAD, "ERROR_EVT_FILTER_UNEXPECTEDTOKEN");
		map.put(0x00003AAE, "ERROR_EVT_INVALID_OPERATION_OVER_ENABLED_DIRECT_CHANNEL");
		map.put(0x00003AAF, "ERROR_EVT_INVALID_CHANNEL_PROPERTY_VALUE");
		map.put(0x00003AB0, "ERROR_EVT_INVALID_PUBLISHER_PROPERTY_VALUE");
		map.put(0x00003AB1, "ERROR_EVT_CHANNEL_CANNOT_ACTIVATE");
		map.put(0x00003AB2, "ERROR_EVT_FILTER_TOO_COMPLEX");
		map.put(0x00003AB3, "ERROR_EVT_MESSAGE_NOT_FOUND");
		map.put(0x00003AB4, "ERROR_EVT_MESSAGE_ID_NOT_FOUND");
		map.put(0x00003AB5, "ERROR_EVT_UNRESOLVED_VALUE_INSERT");
		map.put(0x00003AB6, "ERROR_EVT_UNRESOLVED_PARAMETER_INSERT");
		map.put(0x00003AB7, "ERROR_EVT_MAX_INSERTS_REACHED");
		map.put(0x00003AB8, "ERROR_EVT_EVENT_DEFINITION_NOT_OUND");
		map.put(0x00003AB9, "ERROR_EVT_MESSAGE_LOCALE_NOT_FOUND");
		map.put(0x00003ABA, "ERROR_EVT_VERSION_TOO_OLD");
		map.put(0x00003ABB, "ERROR_EVT_VERSION_TOO_NEW");
		map.put(0x00003ABC, "ERROR_EVT_CANNOT_OPEN_CHANNEL_OF_QUERY");
		map.put(0x00003ABD, "ERROR_EVT_PUBLISHER_DISABLED");
		map.put(0x00003AE8, "ERROR_EC_SUBSCRIPTION_CANNOT_ACTIVATE");
		map.put(0x00003AE9, "ERROR_EC_LOG_DISABLED");
		map.put(0x00003AFC, "ERROR_MUI_FILE_NOT_FOUND");
		map.put(0x00003AFD, "ERROR_MUI_INVALID_FILE");
		map.put(0x00003AFE, "ERROR_MUI_INVALID_RC_CONFIG");
		map.put(0x00003AFF, "ERROR_MUI_INVALID_LOCALE_NAME");
		map.put(0x00003B00, "ERROR_MUI_INVALID_ULTIMATEFALLBACK_NAME");
		map.put(0x00003B01, "ERROR_MUI_FILE_NOT_LOADED");
		map.put(0x00003B02, "ERROR_RESOURCE_ENUM_USER_STOP");
		map.put(0x00003B03, "ERROR_MUI_INTLSETTINGS_UILANG_NOT_INSTALLED");
		map.put(0x00003B04, "ERROR_MUI_INTLSETTINGS_INVALID_LOCALE_NAME");
		map.put(0x00003B60, "ERROR_MCA_INVALID_CAPABILITIES_STRING");
		map.put(0x00003B61, "ERROR_MCA_INVALID_VCP_VERSION");
		map.put(0x00003B62, "ERROR_MCA_MONITOR_VIOLATES_MCCS_SPECIFICATION");
		map.put(0x00003B63, "ERROR_MCA_MCCS_VERSION_MISMATCH");
		map.put(0x00003B64, "ERROR_MCA_UNSUPPORTED_MCCS_VERSION");
		map.put(0x00003B65, "ERROR_MCA_INTERNAL_ERROR");
		map.put(0x00003B66, "ERROR_MCA_INVALID_TECHNOLOGY_TYPE_RETURNED");
		map.put(0x00003B67, "ERROR_MCA_UNSUPPORTED_COLOR_TEMPERATURE");
		map.put(0x00003B92, "ERROR_AMBIGUOUS_SYSTEM_DEVICE");
		map.put(0x00003BC3, "ERROR_SYSTEM_DEVICE_NOT_FOUND");
	}
}
