/*
Copyright (C) 2015 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.
 */

package com.clustercontrol.xcloud.aws.ui.handlers;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

import org.apache.log4j.Logger;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.window.Window;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.handlers.HandlerUtil;

import com.clustercontrol.util.Messages;
import com.clustercontrol.ws.xcloud.AccessKeyCredential;
import com.clustercontrol.ws.xcloud.AddCloudLoginUserRequest;
import com.clustercontrol.ws.xcloud.CloudEndpoint;
import com.clustercontrol.xcloud.aws.ui.dialogs.EditLimitedUserDialog;
import com.clustercontrol.xcloud.common.CloudConstants;
import com.clustercontrol.xcloud.extensions.ICloudOptionHandler;
import com.clustercontrol.xcloud.model.cloud.ICloudScope;
import com.clustercontrol.xcloud.model.cloud.ILoginUser;

public class ModifyLimitedUserHandler implements ICloudOptionHandler {
	@Override
	public Object execute(ExecutionEvent event) throws ExecutionException {
		IStructuredSelection selection = (IStructuredSelection)HandlerUtil.getCurrentSelection(event);
		final ICloudScope selectedScope = (ICloudScope)selection.getFirstElement();
		
		EditLimitedUserDialog dialog = new EditLimitedUserDialog(HandlerUtil.getActiveShell(event));
		dialog.setCloudScope(selectedScope);
		
		while (true) {
			try {
				if (dialog.open() != Window.OK)
					break;
			} catch (Exception e) {
				Logger logger = Logger.getLogger(this.getClass());
				logger.error(e.getMessage(), e);

				String message = e.getMessage();
				if (message == null) {
					ByteArrayOutputStream bos = new ByteArrayOutputStream();
					PrintStream ps = new PrintStream(bos, true);
					e.printStackTrace(ps);
					
					message = bos.toString();
				}
				
				// 失敗報告ダイアログを生成
				MessageDialog.openError(null, Messages.getString("failed"), message);
				break;
			}
				
			if (MessageDialog.openConfirm(
				null,
				Messages.getString("confirmed"),
				CloudConstants.bundle_messages.getString("message.confirm.subaccount.modify"))) {
			
				try {
					List<EditLimitedUserDialog.DialogOutput> output = new ArrayList<>(dialog.getOutput());
					Collections.sort(output, new java.util.Comparator<EditLimitedUserDialog.DialogOutput>() {
						@Override
						public int compare(EditLimitedUserDialog.DialogOutput o1, EditLimitedUserDialog.DialogOutput o2) {
							return o1.getPriorty().compareTo(o2.getPriorty());
						}
					});
					
					final List<AddCloudLoginUserRequest> addRequestList = new ArrayList<>();
					final List<String> removeIdList = new ArrayList<>();
					final List<String> idList = new ArrayList<>();
					
					List<ILoginUser> currentUsers = new ArrayList<>(Arrays.asList(selectedScope.getLoginUsers().getLoginUsers()));
					currentUsers.remove(selectedScope.getLoginUsers().getLoginUser(selectedScope.getAccountId()));
					
					for(EditLimitedUserDialog.DialogOutput item: new ArrayList<>(output)){
						idList.add(item.getAccountId());
						for(ILoginUser user: new ArrayList<>(currentUsers)){
							if(item.getAccountId().equals(user.getId())){
								output.remove(item);
								currentUsers.remove(user);
								break;
							}
						}
					}
					
					for (EditLimitedUserDialog.DialogOutput item: output) {
						AddCloudLoginUserRequest request = new AddCloudLoginUserRequest();
//						request.setDescription(value);
						request.setLoginUserId(item.getAccountId());
						request.setCloudScopeId(selectedScope.getId());
						request.setUserName(item.getDisplayName());
						AccessKeyCredential credentail = new AccessKeyCredential();
						credentail.setAccessKey(item.getAccessKey());
						credentail.setSecretKey(item.getSecretKey());
						request.setCredential(credentail);
						addRequestList.add(request);
					}
					
					for(ILoginUser user: currentUsers){
						removeIdList.add(user.getId());
					}
					
					CloudEndpoint endpoint = selectedScope.getCloudScopes().getHinemosManager().getEndpoint(CloudEndpoint.class);
					
					for(AddCloudLoginUserRequest request: addRequestList){
						endpoint.addCloudLoginUser(request);
					}
					for(String id: removeIdList){
						endpoint.removeCloudLoginUser(selectedScope.getId(), id);
					}
					
					endpoint.modifyCloudLoginUserPriority(selectedScope.getId(), idList);
				
					// 成功報告ダイアログを生成
					MessageDialog.openInformation(
						null,
						Messages.getString("successful"),
						CloudConstants.bundle_messages.getString("message.finish.subaccount.modify"));
				} catch (Exception e) {
					Logger logger = Logger.getLogger(this.getClass());
					logger.error(e.getMessage(), e);
	
					String message = e.getMessage();
					if (message == null) {
						ByteArrayOutputStream bos = new ByteArrayOutputStream();
						PrintStream ps = new PrintStream(bos, true);
						e.printStackTrace(ps);
						
						message = bos.toString();
					}
					
					// 失敗報告ダイアログを生成
					MessageDialog.openError(null, Messages.getString("failed"), message);
				} finally {
					Display.getCurrent().asyncExec(new Runnable() {
						@Override
						public void run() {
							selectedScope.getLoginUsers().update();
						}
					});
				}
				
				return null;
			}
		}
		return null;
	}
}