/*
Copyright (C) 2015 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.
 */
package com.clustercontrol.xcloud.aws.ui.dialogs;

import static com.clustercontrol.xcloud.aws.common.AWSConstants.bundle_messages;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.window.Window;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wb.swt.SWTResourceManager;

import com.clustercontrol.util.Messages;
import com.clustercontrol.ws.xcloud.AccessKeyCredential;
import com.clustercontrol.ws.xcloud.PlatformUser;
import com.clustercontrol.xcloud.aws.common.AWSStringConstants;
import com.clustercontrol.xcloud.common.CloudStringConstants;
import com.clustercontrol.xcloud.model.cloud.ICloudScope;
import com.clustercontrol.xcloud.model.cloud.ILoginUser;
import com.clustercontrol.xcloud.platform.PlatformDependent;
import com.clustercontrol.xcloud.ui.dialogs.IDialogConstants;
import com.clustercontrol.xcloud.util.ControlUtil;
import com.clustercontrol.xcloud.util.TableViewerSorter;
import com.clustercontrol.xcloud.util.validation.ControlValidator;
import com.clustercontrol.xcloud.util.validation.ValidateException;
import com.clustercontrol.xcloud.util.validation.annotation.RequiredInput;

public class EditLimitedUserDialog extends Dialog implements CloudStringConstants, AWSStringConstants {
	public interface IDialogBehavior{
		void setupAccessKey(Text txtAccessKey);
		void setupSecretKey(Text txtSecretKey);
		void setupAccountId(Text txtAccountId);
		void setupDisplayName(Text txtDisplayName);
	}
	
	public static class DialogBehavior implements IDialogBehavior{
		@Override
		public void setupAccessKey(Text txtAccessKey) {}
		@Override
		public void setupSecretKey(Text txtSecretKey) {}
		@Override
		public void setupAccountId(Text txtAccountId) {}
		@Override
		public void setupDisplayName(Text txtDisplayName) {}
	}
	
	public static class DialogOutput {
		private boolean registered = false;
		private String accountId;
		private String accessKey;
		private String secretKey;
		private String displayName;
		private Integer priorty;
		public String getAccountId() {return accountId;}
		public void setAccountId(String accountId) {this.accountId = accountId;}
		public String getAccessKey() {return accessKey;}
		public void setAccessKey(String accessKey) {this.accessKey = accessKey;}
		public String getSecretKey() {return secretKey;}
		public void setSecretKey(String secretKey) {this.secretKey = secretKey;}
		public String getDisplayName() {return displayName;}
		public void setDisplayName(String displayName) {this.displayName = displayName;}
		public boolean isRegistered() {return registered;}
		public void setRegistered(boolean registered) {this.registered = registered;}
		public Integer getPriorty() {return priorty;}
		public void setPriorty(Integer priorty) {this.priorty = priorty;}
	}

	private List<DialogOutput> output;
	
	@RequiredInput
	private Text txtAccessKey;
	@RequiredInput
	private Text txtSecretKey;
	@RequiredInput
	private Text txtAccountId;
	@RequiredInput
	private Text txtDisplayName;
	
	private Button btnInsert;
	
	private Button btnAdd;
	private Button btnSub;
	
	private TableViewer tableViewer;
	
	private Button btnUp;
	private Button btnDown;
	
	private Shell shell;

	private IDialogBehavior behavior = new DialogBehavior();

	private ICloudScope cloudScope;
	
	/**
	 * Create the dialog.
	 * @param parentShell
	 */
	public EditLimitedUserDialog(Shell parentShell) {
		super(parentShell);
		shell = parentShell;
	}

	/**
	 * Create contents of the dialog.
	 * @param parent
	 */
	@Override
	protected Control createDialogArea(Composite parent) {
		assert cloudScope != null;
		
		Composite area = (Composite) super.createDialogArea(parent);
		Composite container = new Composite(area, SWT.FILL);
		container.setBackground(SWTResourceManager.getColor(SWT.COLOR_WIDGET_BACKGROUND));
		GridLayout gl_container = new GridLayout(4, true);
		container.setLayout(gl_container);
		GridData gd_container = new GridData(SWT.FILL, SWT.FILL, true, false);
		gd_container.verticalAlignment = SWT.FILL;
		gd_container.horizontalAlignment = SWT.FILL;
		container.setLayoutData(gd_container);
		
		Composite composite = new Composite(container, SWT.NONE);
		GridLayout gl_composite = new GridLayout(2, false);
		gl_composite.verticalSpacing = 10;
		gl_composite.marginRight = 3;
		gl_composite.marginLeft = 3;
		composite.setLayout(gl_composite);
		composite.setLayoutData(new GridData(SWT.FILL, SWT.FILL, false, false, 4, 1));
				
						Label lblManager = new Label(composite, SWT.RIGHT);
						lblManager.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1));
						lblManager.setText(strManager + strSeparator);
														
														Label lblNewLabel = new Label(composite, SWT.NONE);
														lblNewLabel.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
														lblNewLabel.setText(cloudScope.getCloudScopes().getHinemosManager().getManagerName());
																		
																				Label lblCloudScope = new Label(composite, SWT.RIGHT);
																				lblCloudScope.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1));
																				lblCloudScope.setText(strCloudScopeId + strSeparator);
																		
																		Label lblNewLabel_1 = new Label(composite, SWT.NONE);
																		lblNewLabel_1.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1));
																		lblNewLabel_1.setText(cloudScope.getName() + " ( " +cloudScope.getId() + " )");
																		
																				Label lblCloudUserId = new Label(composite, SWT.RIGHT);
																				lblCloudUserId.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1));
																				lblCloudUserId.setText(strAdminAccount + strSeparator);
																		
																		Label lblNewLabel_2 = new Label(composite, SWT.NONE);
																		lblNewLabel_2.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1));
																		lblNewLabel_2.setText(cloudScope.getLoginUsers().getLoginUser(cloudScope.getAccountId()).getName() + " ( " + cloudScope.getAccountId() + " )");

		Group grpSubAccount = new Group(container, SWT.NONE);
		GridLayout gl_managerAccount = new GridLayout(4, false);
		grpSubAccount.setLayout(gl_managerAccount);
		grpSubAccount.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, false, 4, 1));
		grpSubAccount.setText(strManagerAccount);

		Label lblAccessKey = new Label(grpSubAccount, SWT.RIGHT);
		lblAccessKey.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1));
		lblAccessKey.setText(strAccessKey + strSeparator);

		txtAccessKey = new Text(grpSubAccount, SWT.BORDER);
		txtAccessKey.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true, 3, 1));
		txtAccessKey.setData(ControlValidator.labelKey, strAccessKey);

		Label lblSecretKey = new Label(grpSubAccount, SWT.RIGHT);
		lblSecretKey.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1));
		lblSecretKey.setText(strSecretKey + strSeparator);

		txtSecretKey = new Text(grpSubAccount, SWT.BORDER | SWT.PASSWORD);
		txtSecretKey.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true, 3, 1));
		txtSecretKey.setData(ControlValidator.labelKey, strSecretKey);

		Label lblAccountId = new Label(grpSubAccount, SWT.RIGHT);
		lblAccountId.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1));
		lblAccountId.setText(strAccountId + strSeparator);

		txtAccountId = new Text(grpSubAccount, SWT.BORDER);
		txtAccountId.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true, 3, 1));
		txtAccountId.setData(ControlValidator.labelKey, strAccountId);

		Label lblDisplayName = new Label(grpSubAccount, SWT.RIGHT);
		lblDisplayName.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1));
		lblDisplayName.setText(strDisplayName + strSeparator);

		txtDisplayName = new Text(grpSubAccount, SWT.BORDER);
		txtDisplayName.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true, 3, 1));
		txtDisplayName.setData(ControlValidator.labelKey, strDisplayName);
		
		new Label(grpSubAccount, SWT.NONE).setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true, 2, 1));

		btnInsert = new Button(grpSubAccount, SWT.NONE);
		btnInsert.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true, 2, 1));
		btnInsert.setText(strGetIAMAccount);

		new Label(container, SWT.NONE).setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true, 1, 1));

		btnAdd = new Button(container, SWT.NONE);
		btnAdd.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true, 1, 1));
		btnAdd.setText(strArrowAdd);
		
		btnSub = new Button(container, SWT.NONE);
		btnSub.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true, 1, 1));
		btnSub.setText(strArrowDelete);

		new Label(container, SWT.NONE).setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true, 1, 1));

		Composite tblCmp = new Composite(container, SWT.NONE);
		TableColumnLayout tclTblCmp = new TableColumnLayout();
		tblCmp.setLayout(tclTblCmp);
		tblCmp.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true, 3, 6));
		((GridData)tblCmp.getLayoutData()).heightHint = 100;

		tableViewer = new TableViewer(tblCmp, SWT.BORDER | SWT.FULL_SELECTION | SWT.V_SCROLL);
		tableViewer.getTable().setHeaderVisible(true);
		tableViewer.getTable().setLinesVisible(true);
		
		for(final ViewColumn column: ViewColumn.values()){
			TableViewerColumn tableViewerColumn = new TableViewerColumn(tableViewer, SWT.NONE);
			TableColumn tableColumn = tableViewerColumn.getColumn();
			tclTblCmp.setColumnData(tableColumn, column.getPixelData());
			tableColumn.setText(column.getLabel());
			tableViewerColumn.setLabelProvider(column.getProvider());
			tableColumn.addSelectionListener(new SelectionAdapter(){
				@Override
				public void widgetSelected(SelectionEvent e) {
					tableViewer.setSorter(new TableViewerSorter(tableViewer, column.getProvider()));
				}
			});
		}

		btnUp = new Button(container, SWT.NONE);
		btnUp.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true, 1, 1));
		btnUp.setText(strArrowUp);
		
		btnDown = new Button(container, SWT.NONE);
		btnDown.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true, 1, 1));
		btnDown.setText(strArrowDown);
		
		{
			behavior.setupAccessKey(txtAccessKey);
			behavior.setupSecretKey(txtSecretKey);
			behavior.setupAccountId(txtAccountId);
			behavior.setupDisplayName(txtDisplayName);
		}
		new Label(container, SWT.NONE);
		new Label(container, SWT.NONE);
		new Label(container, SWT.NONE);
		new Label(container, SWT.NONE);
		
		ControlUtil.setRequired(new Control[]{
			txtAccountId,
			txtAccessKey,
			txtSecretKey,
			txtDisplayName
		});

		if (!PlatformDependent.getPlatformDependent().isRapPlatfome()) {
			container.layout();
			Control[] labels = new Control[]{lblManager, lblCloudScope, lblCloudUserId, lblAccountId, lblAccessKey, lblSecretKey, lblDisplayName, };
			int maxWidth = 0;
			for (Control l: labels) {
				Point p = l.getSize();
				maxWidth = Math.max(maxWidth, p.x);
			}
			for (Control l: labels) {
				((GridData)l.getLayoutData()).widthHint = maxWidth;
			}
	
			tableViewer.setContentProvider(new IStructuredContentProvider() {
				@Override
				public Object[] getElements(Object inputElement) {return ((List<?>) inputElement).toArray();}
				@Override
				public void dispose() {}
				@Override
				public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {}
			});
	
			grpSubAccount.layout(true);
		} else {
			tableViewer.setContentProvider(new IStructuredContentProvider() {
				@Override
				public Object[] getElements(Object inputElement) {return ((List<?>) inputElement).toArray();}
				@Override
				public void dispose() {}
				@Override
				public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {}
			});
		}
		
		init();
		
		Collections.sort(output, new java.util.Comparator<DialogOutput>() {
			@Override
			public int compare(DialogOutput o1, DialogOutput o2) {
				return o1.getPriorty().compareTo(o2.getPriorty());
			}
		});
		tableViewer.setInput(output);
		
		return area;
	}

	/**
	 * Create contents of the button bar.
	 * @param parent
	 */
	@Override
	protected void createButtonsForButtonBar(Composite parent) {
		createButton(parent, IDialogConstants.OK_ID, IDialogConstants.OK_LABEL,
				false);
		createButton(parent, IDialogConstants.CANCEL_ID,
				IDialogConstants.CANCEL_LABEL, false);
	}

	/**
	 * Return the initial size of the dialog.
	 */
	@Override
	protected Point getInitialSize() {
		return new Point(460, 550);
	}

	@Override
	protected void okPressed() {
		for (int i = 0; i < output.size(); ++i) {
			output.get(i).setPriorty(i);
		}
		super.okPressed();
	}

	@Override
	protected void configureShell(Shell newShell) {
		super.configureShell(newShell);
		newShell.setText(MessageFormat.format(dlgLoginuserSubAccountSetting, strAws));
	}

	public List<DialogOutput> getOutput() {
		return output;
	}

	public void setBehavior(IDialogBehavior behavior){
		this.behavior = behavior;
	}
	
	private void init(){
		if(output == null){
			if(cloudScope != null){
				output = new ArrayList<>();
				for(ILoginUser user: cloudScope.getLoginUsers().getLoginUsers()){
					if(!cloudScope.getAccountId().equals(user.getId())){
						DialogOutput item = new DialogOutput();
						item.setRegistered(true);
						item.setAccountId(user.getId());
						item.setPriorty(user.getPriority());
						item.setAccessKey(((AccessKeyCredential)user.getCredential()).getAccessKey());
						item.setSecretKey(((AccessKeyCredential)user.getCredential()).getSecretKey());
						item.setDisplayName(user.getName());
						output.add(item);
					}
				}
			}
		}
		
		btnInsert.addSelectionListener(new SelectionAdapter(){
			@Override
			public void widgetSelected(SelectionEvent e) {
				GetUserByListDialog dialog = new GetUserByListDialog(shell, output);
				if(dialog.open() == Window.OK){
					updateInputText(dialog.getOutput());
				}
			}
		});
		
		btnAdd.addSelectionListener(new SelectionAdapter(){
			@Override
			public void widgetSelected(SelectionEvent e) {
				try{
					ControlUtil.validate(EditLimitedUserDialog.this);
				} catch(ValidateException e1){
					MessageDialog.openError(null, Messages.getString("failed"), e1.getMessage());
					return;
				} catch(Exception e1){
					throw new RuntimeException(e1);
				}
				for(DialogOutput item: output){
					if(item.getAccountId().equals(txtAccountId.getText())){
						return;
					}
				}
				DialogOutput item = new DialogOutput();
				item.setAccountId(txtAccountId.getText());
				item.setAccessKey(txtAccessKey.getText());
				item.setSecretKey(txtSecretKey.getText());
				item.setDisplayName(txtDisplayName.getText());
				output.add(item);
				tableViewer.refresh();
			}
		});
		
		btnSub.addSelectionListener(new SelectionAdapter(){
			@Override
			public void widgetSelected(SelectionEvent e) {
				String selectedId = getSelectedItem().getAccountId();
				for(DialogOutput item: new ArrayList<>(output)){
					if(item.getAccountId().equals(selectedId)){
						output.remove(item);
						tableViewer.refresh();
						break;
					}
				}
			}
		});

		btnUp.addSelectionListener(new SelectionAdapter(){
			@Override
			public void widgetSelected(SelectionEvent e) {
				DialogOutput item = getSelectedItem();
				if(item != null && output.indexOf(item) > 0){
					changeIndex(output, output.indexOf(item), output.indexOf(item) - 1);
					tableViewer.refresh();
				}
			}
		});

		btnDown.addSelectionListener(new SelectionAdapter(){
			@Override
			public void widgetSelected(SelectionEvent e) {
				DialogOutput item = getSelectedItem();
				if(item != null && output.indexOf(item) < output.size() - 1){
					changeIndex(output, output.indexOf(item), output.indexOf(item) + 1);
					tableViewer.refresh();
				}
			}
		});
		
		tableViewer.addSelectionChangedListener(new ISelectionChangedListener() {
			@Override
			public void selectionChanged(SelectionChangedEvent event) {
				DialogOutput item = getSelectedItem();
				if(item != null){
					updateInputText(item);
				}
			}
		});
	}
	
	private <T> void changeIndex(List<T> list, int index1, int index2){
		T item = list.get(index1);
		list.set(index1, list.get(index2));
		list.set(index2, item);
	}
	
	private DialogOutput getSelectedItem(){
		return (DialogOutput)((IStructuredSelection)tableViewer.getSelection()).getFirstElement();
	}
	
	private void updateInputText(DialogOutput output){
		txtAccessKey.setText(output.getAccessKey() != null? output.getAccessKey(): "");
		txtSecretKey.setText(output.getSecretKey() != null? output.getSecretKey(): "");
		txtAccountId.setText(output.getAccountId() != null? output.getAccountId(): "");
		txtDisplayName.setText(output.getDisplayName() != null? output.getDisplayName(): "");
	}
	
	private static enum ViewColumn{
		identifier(
				bundle_messages.getString(strIAMAccount),
				new ColumnPixelData(150, true, true),
				new ColumnLabelProvider(){
					@Override
					public String getText(Object element) {
						return ((DialogOutput)element).getDisplayName() + " ( " + ((DialogOutput)element).getAccountId() + " )";
					}
				}
			),
		access_key(
				bundle_messages.getString("word.description"),
			new ColumnPixelData(150, true, true),
			new ColumnLabelProvider(){
				@Override
				public String getText(Object element) {
					return ((DialogOutput)element).getAccessKey();
				}
			}
		);

		private String label;
		private ColumnLabelProvider provider;
		private ColumnPixelData pixelData;
		
		ViewColumn(String label, ColumnPixelData pixelData, ColumnLabelProvider provider){
			this.label = label;
			this.pixelData = pixelData;
			this.provider = provider;
		}

		public String getLabel() {
			return label;
		}

		public ColumnPixelData getPixelData() {
			return pixelData;
		}

		public ColumnLabelProvider getProvider() {
			return provider;
		}
	}
	

	private class ViewItem{
		private DialogOutput output;
		public ViewItem(DialogOutput output){this.output = output;}
		public DialogOutput getOutput(){return output;}
	}

	private class GetUserByListDialog extends Dialog {	
		private DialogOutput output;
			
		private TableViewer tableViewer;
		private List<ViewItem> items;
		
		/**
		 * Create the dialog.
		 * @param parentShell
		 */
		public GetUserByListDialog(Shell parentShell, List<DialogOutput> excludes) {
			super(parentShell);
			init(excludes);
		}
	
		/**
		 * Create contents of the dialog.
		 * @param parent
		 */
		@Override
		protected Control createDialogArea(Composite parent) {
			Composite area = (Composite) super.createDialogArea(parent);
			Composite container = new Composite(area, SWT.FILL);
			container.setBackground(SWTResourceManager.getColor(SWT.COLOR_WIDGET_BACKGROUND));
			GridLayout gl_container = new GridLayout(1, true);
			gl_container.verticalSpacing = 20;
			container.setLayout(gl_container);
			GridData gd_container = new GridData(SWT.FILL, SWT.FILL, true, false);
			gd_container.verticalAlignment = SWT.FILL;
			gd_container.horizontalAlignment = SWT.FILL;
			container.setLayoutData(gd_container);
		
			Composite tblCmp = new Composite(container, SWT.NONE);
			TableColumnLayout tclTblCmp = new TableColumnLayout();
			tblCmp.setLayout(tclTblCmp);
			GridData gd_tblCmp = new GridData(SWT.FILL, SWT.FILL, true, true, 1, 1);
			gd_tblCmp.heightHint = 200;
			tblCmp.setLayoutData(gd_tblCmp);
	
			tableViewer = new TableViewer(tblCmp, SWT.BORDER | SWT.FULL_SELECTION | SWT.V_SCROLL);
			tableViewer.getTable().setHeaderVisible(true);
			tableViewer.getTable().setLinesVisible(true);
			
			for(final InnerViewColumn column: InnerViewColumn.values()){
				TableViewerColumn tableViewerColumn = new TableViewerColumn(tableViewer, SWT.NONE);
				TableColumn tableColumn = tableViewerColumn.getColumn();
				tclTblCmp.setColumnData(tableColumn, column.getPixelData());
				tableColumn.setText(column.getLabel());
				tableViewerColumn.setLabelProvider(column.getProvider());
				tableColumn.addSelectionListener(new SelectionAdapter(){
					@Override
					public void widgetSelected(SelectionEvent e) {
						tableViewer.setSorter(new TableViewerSorter(tableViewer, column.getProvider()));
					}
				});
			}
			tableViewer.setContentProvider(new IStructuredContentProvider() {
				@Override
				public Object[] getElements(Object inputElement) {return ((List<?>) inputElement).toArray();}
				@Override
				public void dispose() {}
				@Override
				public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {}
			});
			tableViewer.addSelectionChangedListener(new ISelectionChangedListener(){
				@Override
			    public void selectionChanged(SelectionChangedEvent event){
					ViewItem selectedItem = (ViewItem) ((IStructuredSelection)event.getSelection()).getFirstElement();
					output = selectedItem.getOutput();
					tableViewer.refresh();
			    }
			});
			
			tableViewer.setInput(items);
			
			return area;
		}

		private void init(List<DialogOutput> excludes){
			items = new ArrayList<>();
			for(PlatformUser user: cloudScope.getUnassignedUsers()){
				boolean skip = false;
				for (DialogOutput ex: excludes) {
					if (user.getName().equals(ex.getDisplayName())) {
						skip = true;
						break;
					}
				}
				
				if (skip)
					continue;
				
				DialogOutput output = new DialogOutput();
				output.setAccessKey(((AccessKeyCredential)user.getCredential()).getAccessKey());
				output.setSecretKey(((AccessKeyCredential)user.getCredential()).getSecretKey());
				output.setDisplayName(user.getName());
				output.setAccountId(txtAccountId.getText());
				items.add(new ViewItem(output));
			}
		}
		
		/**
		 * Create contents of the button bar.
		 * @param parent
		 */
		@Override
		protected void createButtonsForButtonBar(Composite parent) {
			createButton(parent, IDialogConstants.OK_ID, IDialogConstants.OK_LABEL,
					false);
			createButton(parent, IDialogConstants.CANCEL_ID,
					IDialogConstants.CANCEL_LABEL, false);
		}
	
		/**
		 * Return the initial size of the dialog.
		 */
		@Override
		protected Point getInitialSize() {
			return new Point(460, 380);
		}
	
		@Override
		protected void okPressed() {
			if(output == null){
				MessageDialog.openError(null, Messages.getString("failed"), msgMustSelect);
				return;
			}
			setReturnCode(OK);
			close();
		}
	
		@Override
		protected void configureShell(Shell newShell) {
			super.configureShell(newShell);
			newShell.setText(MessageFormat.format(dlgLoginuserSubAccountAutoInput, strAws));
		}
	
		public DialogOutput getOutput() {
			return output;
		}
	}

	private enum InnerViewColumn{
		user_name(
			strUserName,
			new ColumnPixelData(140, true, true),
			new ColumnLabelProvider(){
				@Override
				public String getText(Object element) {
					return ((ViewItem)element).getOutput().getDisplayName();
				}
			}
		),
		description(
			strDescription,
			new ColumnPixelData(140, true, true),
			new ColumnLabelProvider(){
				@Override
				public String getText(Object element) {
					return ((ViewItem)element).getOutput().getAccessKey();
				}
			}
		);

		private String label;
		private ColumnLabelProvider provider;
		private ColumnPixelData pixelData;
		
		InnerViewColumn(String label, ColumnPixelData pixelData, ColumnLabelProvider provider){
			this.label = label;
			this.pixelData = pixelData;
			this.provider = provider;
		}

		public String getLabel() {
			return label;
		}

		public ColumnPixelData getPixelData() {
			return pixelData;
		}

		public ColumnLabelProvider getProvider() {
			return provider;
		}
	}
	
	public void setCloudScope(ICloudScope cloudScope){this.cloudScope = cloudScope;}
}
