/*
Copyright (C) 2014 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.
 */
package com.clustercontrol.cloud.cloudn.rest;

import java.util.ArrayList;
import java.util.List;

import org.eclipse.jdt.annotation.NonNullByDefault;

import com.clustercontrol.cloud.cloudn.rest.api.MarshalParam;
import com.clustercontrol.cloud.cloudn.rest.api.TagParamMarshaller;

@NonNullByDefault(false)
@MarshalParam
public class ListPublicIpAddressesRequest {
	// List resources by account. Must be used with the domainId parameter. false
	public String account;
	// limits search results to allocated public IP addresses false
	public String allocatedonly;
	// lists all public IP addresses associated to the network specified false
	public String associatednetworkid;
	// list only resources belonging to the domain specified false
	public String domainid;
	// list only ips used for load balancing false
	public String forloadbalancing;
	// the virtual network for the IP address false
	public String forvirtualnetwork;
	// lists ip address by id false
	public String id;
	// lists the specified IP address false
	public String ipaddress;
	// defaults to false, but if true, lists all resources from the parent specified by the domainId till leaves. false
	public String isrecursive;
	// list only source nat ip addresses false
	public String issourcenat;
	// list only static nat ip addresses false
	public String isstaticnat;
	// List by keyword false
	public String keyword;
	// If set to false, list only resources belonging to the command's caller; if set to true - list resources that the caller is authorized to see. Default value is false false
	public String listall;
	// false
	public Boolean page;
	// false
	public Boolean ppagesize;
	// lists all public IP addresses by physical network idfalse
	public String physicalnetworkid;
	// list objects by project false
	public String projectid;
	// List resources by tags (key/value pairs) false
	@MarshalParam(TagParamMarshaller.class)
	public List<RTag> tags = new ArrayList<>();
	// lists all public IP addresses by VLAN ID false
	public String vlanid;
	// List ips belonging to the VPC false
	public String vpcid;
	// lists all public IP addresses by Zone ID false
	public String zoneid;
	
	public ListPublicIpAddressesRequest withIpaddress(String ipaddress) {
		this.ipaddress = ipaddress;
		return this;
	}
	public ListPublicIpAddressesRequest withKeyword(String keyword) {
		this.keyword = keyword;
		return this;
	}
}
