/*
Copyright (C) 2014 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.
 */
package com.clustercontrol.cloud.cloudn.rest;

import org.eclipse.jdt.annotation.NonNullByDefault;

import com.clustercontrol.cloud.cloudn.rest.api.MarshalParam;

@NonNullByDefault(false)
@MarshalParam
public class CreateVolumeRequest extends RestApplicationRequest {
	// Volumeの名前を指定する 
	public String name;
	
	// Disk Offering IDを指定する 
	public String diskofferingid;

	// Snapshot IDを指定する 
	public String snapshotid;
	
	// Zone idを指定する 
	public String zoneid;
	
	// domainidと共に使用して、任意のアカウントを指定する 
	public String account;
	
	// domainid を指定する。accountと同時に指定する 
	public String domainid;
	
	public CreateVolumeRequest withSnapshotid(String snapshotid) {
		this.snapshotid = snapshotid;
		return this;
	}
	public CreateVolumeRequest withDiskOfferingId(String diskofferingid) {
		this.diskofferingid = diskofferingid;
		return this;
	}
	public CreateVolumeRequest withZoneId(String zoneid) {
		this.zoneid = zoneid;
		return this;
	}
	public CreateVolumeRequest withName(String name) {
		this.name = name;
		return this;
	}
}
