/*
Copyright (C) 2013 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.
 */
package com.clustercontrol.cloud.factory;

import java.io.File;
import java.util.ArrayList;
import java.util.List;

import javax.persistence.EntityExistsException;

import com.clustercontrol.cloud.CloudManagerFault;
import com.clustercontrol.cloud.ErrorCode;
import com.clustercontrol.cloud.Filter;
import com.clustercontrol.cloud.SessionService;
import com.clustercontrol.cloud.bean.CloudTemplate;
import com.clustercontrol.cloud.bean.CreateTemplateRequest;
import com.clustercontrol.cloud.bean.ModifyTemplateRequest;
import com.clustercontrol.cloud.commons.CloudConstants;
import com.clustercontrol.cloud.commons.CloudPropertyConstants;
import com.clustercontrol.cloud.dao.CloudTemplateDao;
import com.clustercontrol.cloud.persistence.EntityManagerEx;
import com.clustercontrol.cloud.persistence.Transactional;

@Transactional
public class TemplateOperator extends ResourceOperatorBase implements ITemplateOperator, CloudConstants {

	@Override
	public CloudTemplate createTemplate(CreateTemplateRequest request) throws CloudManagerFault {
		EntityManagerEx em = SessionService.current().getEntityManagerEx();

		CloudTemplateDao dao = new CloudTemplateDao();
		dao.setTemplateId(request.getTemplateId());
		dao.setCloudServiceId(getCloudService().getCloudServiceId());
		dao.setRegion(request.getRegion());
		dao.setAccountResourceId(getAccountResource().getAccountResourceId());
		dao.setTemplateName(request.getTemplateName());
		dao.setCloudUserId(getCloudUser().getCloudUserId());
		dao.setJobUnitId(getAccountResource().getAccountResourceId());
		dao.setImageId(request.getImageId());
		dao.setStartJobId(request.getStartJobId());
		dao.setLaunchJobId(request.getLaunchJobId());
		dao.setStopJobId(request.getStopJobId());

		try {
			em.persist(dao);
		}
		catch (EntityExistsException e) {
			throw ErrorCode.CLOUDTEMPLATE_ALREADY_EXIST.cloudManagerFault(request.getTemplateId());
		}

		return new CloudTemplate(dao, getCloudService().getCloudTypeId());
	}

	@Override
	public CloudTemplate modifyTemplate(ModifyTemplateRequest request) throws CloudManagerFault {
		EntityManagerEx em = SessionService.current().getEntityManagerEx();
		CloudTemplateDao dao = em.find(CloudTemplateDao.class, request.getTemplateId());
		if (dao == null) {
			throw ErrorCode.CLOUDUSER_NOT_FOUND.cloudManagerFault(request.getTemplateId());
		}

		if (request.getTemplateName() != null) {
			dao.setTemplateName(request.getTemplateName());
		}
		if (request.getRegion() != null) {
			dao.setRegion(request.getRegion());
		}
		if (request.getImageId() != null) {
			dao.setImageId(request.getImageId());
		}
		if (!"".equals(request.getStartJobId())) {
			dao.setStartJobId(request.getStartJobId());
		}else{
			dao.setStartJobId(null);
		}
		if (!"".equals(request.getLaunchJobId())) {
			dao.setLaunchJobId(request.getLaunchJobId());
		}else{
			dao.setLaunchJobId(null);
		}
		if (!"".equals(request.getStopJobId())) {
			dao.setStopJobId(request.getStopJobId());
		}else{
			dao.setStopJobId(null);
		}
		return new CloudTemplate(dao, getCloudService().getCloudTypeId());
	}

	@Override
	public void removeTemplate(String templateId) throws CloudManagerFault {
		EntityManagerEx em = SessionService.current().getEntityManagerEx();
		CloudTemplateDao dao = em.find(CloudTemplateDao.class, templateId);
		if (dao == null) {
			throw ErrorCode.CLOUDUSER_NOT_FOUND.cloudManagerFault(templateId);
		}
		em.remove(dao);
	}

	@Override
	public CloudTemplate findTemplate(String templateId) throws CloudManagerFault {
		EntityManagerEx em = SessionService.current().getEntityManagerEx();
		CloudTemplateDao dao = em.find(CloudTemplateDao.class, templateId);
		if (dao == null) {
			throw ErrorCode.CLOUDTEMPLATE_NOT_FOUND.cloudManagerFault(templateId);
		}
		return new CloudTemplate(dao, getCloudService().getCloudTypeId());
	}

	@Override
	public List<CloudTemplate> findAllTemplates() throws CloudManagerFault {
		EntityManagerEx em = SessionService.current().getEntityManagerEx();
		List<CloudTemplateDao> daos = em.findByFilter(CloudTemplateDao.class, new Filter("accountResourceId", getAccountResource().getAccountResourceId()));
		List<CloudTemplate> cloudTemplates = new ArrayList<>();
		for (CloudTemplateDao dao: daos) {
			cloudTemplates.add(new CloudTemplate(dao, getCloudService().getCloudTypeId()));
		}
		return cloudTemplates;
	}

	@Override
	public List<String> findTemplateScripts() throws CloudManagerFault {
		String hinemosHome = System.getProperty("hinemos.manager.home.dir");
		File directory = new File(hinemosHome + "/" + CloudPropertyConstants.templatejob_script_file_dir.value());
		File[] files = directory.listFiles();
		List<String> scripts = new ArrayList<>();
		for(File tmpFile: files){
			if (tmpFile.isFile()) {
				scripts.add(tmpFile.getName());
			}
		}
		return scripts;
	}
}
