/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.cloud.cloudn.util;

import com.clustercontrol.cloud.CloudManagerFault;
import com.clustercontrol.cloud.SessionService;
import com.clustercontrol.cloud.dao.CloudUserDao;
import com.clustercontrol.cloud.persistence.EntityManagerEx;
import com.clustercontrol.cloud.util.AuthorizingUtil;
import java.util.List;
import javax.persistence.Query;

public class AuthorizingUtilEx
extends AuthorizingUtil {
    private AuthorizingUtilEx() {
    }

    public static boolean checkHinemousUser_cloudServiceId(String hinemousUserId, String cloudServiceId) throws CloudManagerFault {
        return !AuthorizingUtilEx.getCloudUsersByCloudService(hinemousUserId, cloudServiceId).isEmpty();
    }

    public static List<CloudUserDao> getCloudUsersByCloudService(String hinemousUserId, String cloudServiceId) throws CloudManagerFault {
        EntityManagerEx em = SessionService.current().getEntityManagerEx();
        Query query = em.createQuery("SELECT c FROM UserEntity u JOIN u.roleEntities r JOIN CloudUserDao AS c ON c.roleId = r.roleId JOIN c.accountResource a WHERE a.cloudServiceId = :cloudServiceId AND (u.userId = :userId OR EXISTS (SELECT u FROM UserEntity u JOIN u.roleEntities r WHERE u.userId = :userId AND r.roleId = :ADMINISTRATORS))");
        query.setParameter("userId", (Object)hinemousUserId);
        query.setParameter("cloudServiceId", (Object)cloudServiceId);
        query.setParameter("ADMINISTRATORS", (Object)"ADMINISTRATORS");
        return query.getResultList();
    }
}

