/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.cloud.cloudn.rest.api;

import com.clustercontrol.cloud.InternalManagerError;
import com.clustercontrol.cloud.cloudn.rest.CloudnResponse;
import com.clustercontrol.cloud.cloudn.rest.api.CloudnEndpoint;
import com.clustercontrol.cloud.cloudn.rest.api.CloudnRestfulApplicationError;
import com.clustercontrol.cloud.cloudn.rest.api.ErrorUnmarshaller;
import com.clustercontrol.cloud.cloudn.rest.api.ParamAnnotations;
import com.clustercontrol.cloud.cloudn.rest.api.ParamHolder;
import com.clustercontrol.cloud.cloudn.rest.api.RestfulApplicationException;
import com.google.common.base.Preconditions;
import com.google.common.reflect.Reflection;
import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.WebResource;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import javax.ws.rs.ClientErrorException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;

public class RestApplicationBuilder {
    public static final String COMMON_PARAM_API_KEY = "apikey";
    public static final String COMMON_PARAM_COMMAND = "command";
    public static final String COMMON_PARAM_SIGNAURE = "signature";
    public static final String COMMON_PARAM_RESPONSE = "response";
    public static final String COMMON_PARAM_EXPIRES = "expires";
    public static final String COMMON_PARAM_SIGNATURE_VERSION = "signatureVersion";

    public static <T extends CloudnEndpoint> T buildRestApplicationProxy(Class<T> interfaceClass, String accessKey, String secretKey, ErrorUnmarshaller emarshaller) {
        Preconditions.checkNotNull(interfaceClass);
        Preconditions.checkNotNull((Object)accessKey);
        Preconditions.checkNotNull((Object)secretKey);
        return (T)((CloudnEndpoint)Reflection.newProxy(interfaceClass, (InvocationHandler)new RestApplicationInvoker(accessKey, secretKey, emarshaller)));
    }

    public static <T extends CloudnEndpoint> T buildRestApplicationProxy(Class<T> interfaceClass, String accessKey, String secretKey) {
        return RestApplicationBuilder.buildRestApplicationProxy(interfaceClass, accessKey, secretKey, new ErrorUnmarshaller(){

            @Override
            public ErrorUnmarshaller.Error unmarshal(Method m, Response r) throws RestfulApplicationException {
                try {
                    if (!r.hasEntity()) {
                        return new ErrorUnmarshaller.Error(null, r.getStatusInfo().getReasonPhrase());
                    }
                    CloudnResponse response = (CloudnResponse)r.readEntity(m.getReturnType());
                    return new ErrorUnmarshaller.Error(Integer.toString(response.cserrorcode), response.errortext);
                }
                catch (Exception e) {
                    throw new InternalManagerError((Throwable)e);
                }
            }
        });
    }

    private static class RestApplicationInvoker
    implements InvocationHandler {
        public static Method setEndpoint = RestApplicationInvoker.getSetEndpointMethod();
        @Nullable
        private String endpointUrl;
        private static Client client = Client.create();
        private String accessKey;
        private String secretKey;
        private ErrorUnmarshaller emarshaller;

        private static Method getSetEndpointMethod() {
            try {
                return CloudnEndpoint.class.getMethod("setEndpoint", String.class);
            }
            catch (NoSuchMethodException | SecurityException e) {
                throw new InternalManagerError((Throwable)e);
            }
        }

        public RestApplicationInvoker(String accessKey, String secretKey, ErrorUnmarshaller emarshaller) {
            Preconditions.checkNotNull((Object)accessKey);
            Preconditions.checkNotNull((Object)secretKey);
            this.accessKey = accessKey;
            this.secretKey = secretKey;
            this.emarshaller = emarshaller;
        }

        @Override
        @NonNullByDefault(value=false)
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            Preconditions.checkNotNull((Object)proxy);
            Preconditions.checkNotNull((Object)method);
            if (setEndpoint.equals(method)) {
                if (args == null) {
                    throw new NullPointerException();
                }
                this.setEndpointUrl(args[0].toString());
                return null;
            }
            String endpointUrl = this.getEndpointUrl();
            if (endpointUrl == null) {
                throw CloudnRestfulApplicationError.Endpoint_Unset.exception(new Object[0]);
            }
            ParamHolder params = ParamHolder.create().with(RestApplicationBuilder.COMMON_PARAM_API_KEY, this.accessKey).with(RestApplicationBuilder.COMMON_PARAM_COMMAND, method.getName()).withs(ParamAnnotations.makeRestParams(method, args));
            String requestURL = params.toRequest(endpointUrl, this.secretKey);
            try {
                WebResource.Builder builder = client.resource(requestURL).type(MediaType.APPLICATION_JSON_TYPE);
                return builder.get(method.getReturnType());
            }
            catch (ClientErrorException e) {
                if (e.getResponse().hasEntity()) {
                    ErrorUnmarshaller.Error erorr = this.emarshaller.unmarshal(method, e.getResponse());
                    throw CloudnRestfulApplicationError.Request_ProcessingError.restRequestException(e.getResponse().getStatusInfo().getStatusCode(), erorr.getDetailCode(), requestURL, erorr.getReason(), (Exception)((Object)e), new Object[0]);
                }
                throw CloudnRestfulApplicationError.Request_ProcessingError.exceptionException(e.getMessage(), (Exception)((Object)e));
            }
        }

        @Nullable
        private String getEndpointUrl() {
            return this.endpointUrl;
        }

        private void setEndpointUrl(@Nullable String endpointUrl) {
            this.endpointUrl = endpointUrl;
        }
    }
}

