/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.cloud.cloudn.rest.api;

import com.clustercontrol.cloud.cloudn.rest.api.CloudnRestfulApplicationError;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Collections2;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;

public class ParamHolder {
    private static final String HMAC_SHA1_ALGORITHM = "HmacSHA1";
    private List<Param> params = new ArrayList<Param>();

    private ParamHolder() {
    }

    public ParamHolder with(String name, String value) {
        this.params.add(new Param(name, value));
        return this;
    }

    public ParamHolder withs(Param ... p) {
        this.withs(Arrays.asList(p));
        return this;
    }

    public ParamHolder withs(Collection<Param> ps) {
        this.params.addAll(ps);
        return this;
    }

    public ParamHolder with(ParamHolder holder) {
        this.withs(holder.params);
        return this;
    }

    public static ParamHolder create() {
        return new ParamHolder();
    }

    public String toString() {
        return ParamHolder.toString(this.params);
    }

    public String toParameterString(String secretKey) {
        ArrayList<Param> params = new ArrayList<Param>(this.params);
        Calendar c = Calendar.getInstance();
        c.add(12, 5);
        int zoneOffset = c.get(15) / 1000 / 60;
        params.add(Param.build("expires", String.format("%04d-%02d-%02dT%02d:%02d:%02d%s%02d%02d", c.get(1), c.get(2) + 1, c.get(5), c.get(11), c.get(12), c.get(13), Character.valueOf(zoneOffset >= 0 ? (char)'+' : '-'), Math.abs(zoneOffset / 60), zoneOffset % 60)));
        params.add(Param.build("signatureVersion", "3"));
        Collections.sort(params, new Comparator<Param>(){

            @Override
            public int compare(Param o1, Param o2) {
                return o1.name.toLowerCase().compareTo(o2.name.toLowerCase());
            }
        });
        ArrayList<Param> encoded = new ArrayList<Param>(Collections2.transform(params, (Function)new Function<Param, Param>(){

            public Param apply(Param input) {
                try {
                    return new Param(input.name, URLEncoder.encode(input.param, "UTF-8"));
                }
                catch (UnsupportedEncodingException e) {
                    throw CloudnRestfulApplicationError.Params_FailToMakeParamString.exceptionException(e, input.param);
                }
            }
        }));
        ArrayList<Param> hash = new ArrayList<Param>(Collections2.transform(encoded, (Function)new Function<Param, Param>(){

            public Param apply(Param input) {
                return new Param(input.name.toLowerCase(), input.param.toLowerCase().replace("+", "%20"));
            }
        }));
        return ParamHolder.create().withs(encoded).with("signature", ParamHolder.createSignature(ParamHolder.toString(hash), secretKey)).toString();
    }

    public String toRequest(String endpointUrl, String secretKey) {
        return endpointUrl + "?" + this.toParameterString(secretKey);
    }

    private static String createSignature(String parameters, String secretKey) {
        try {
            SecretKeySpec signingKey = new SecretKeySpec(secretKey.getBytes(), HMAC_SHA1_ALGORITHM);
            Mac mac = Mac.getInstance(HMAC_SHA1_ALGORITHM);
            mac.init(signingKey);
            return URLEncoder.encode(Base64.encodeBase64String((byte[])mac.doFinal(parameters.getBytes())), "UTF-8");
        }
        catch (UnsupportedEncodingException | IllegalStateException | InvalidKeyException | NoSuchAlgorithmException e) {
            throw CloudnRestfulApplicationError.Signature_FailToMakeSignature.exceptionException(e, parameters);
        }
    }

    private static String toString(List<Param> params) {
        StringBuffer strBuffer = new StringBuffer();
        boolean first = false;
        for (Param param : params) {
            if (first) {
                strBuffer.append("&");
            } else {
                first = true;
            }
            strBuffer.append(param.name).append("=").append(param.param);
        }
        return strBuffer.toString();
    }

    public static class Param {
        public final String name;
        public final String param;

        public Param(String name, String param) {
            Preconditions.checkNotNull((Object)name);
            Preconditions.checkNotNull((Object)param);
            this.name = name;
            this.param = param;
        }

        public static Param build(String name, String param) {
            return new Param(name, param);
        }
    }
}

