/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.model.internal;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import javax.ws.rs.RuntimeType;
import javax.ws.rs.core.Configuration;
import javax.ws.rs.core.Feature;
import javax.ws.rs.core.FeatureContext;
import org.glassfish.hk2.api.DynamicConfiguration;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.hk2.utilities.Binder;
import org.glassfish.jersey.ExtendedConfig;
import org.glassfish.jersey.internal.LocalizationMessages;
import org.glassfish.jersey.internal.inject.Injections;
import org.glassfish.jersey.internal.util.PropertiesHelper;
import org.glassfish.jersey.model.ContractProvider;
import org.glassfish.jersey.model.internal.ComponentBag;
import org.glassfish.jersey.process.Inflector;

public class CommonConfig
implements FeatureContext,
ExtendedConfig {
    private static final Logger LOGGER = Logger.getLogger(CommonConfig.class.getName());
    private static final Function<Object, Binder> CAST_TO_BINDER = new Function<Object, Binder>(){

        public Binder apply(Object input) {
            return (Binder)Binder.class.cast(input);
        }
    };
    private final RuntimeType type;
    private final Map<String, Object> properties;
    private final Map<String, Object> immutablePropertiesView;
    private final Collection<String> immutablePropertyNames;
    private final ComponentBag componentBag;
    private final List<FeatureRegistration> newFeatureRegistrations;
    private final Set<Class<? extends Feature>> enabledFeatureClasses;
    private final Set<Feature> enabledFeatures;

    public CommonConfig(RuntimeType type, Predicate<ContractProvider> registrationStrategy) {
        this.type = type;
        this.properties = new HashMap<String, Object>();
        this.immutablePropertiesView = Collections.unmodifiableMap(this.properties);
        this.immutablePropertyNames = Collections.unmodifiableCollection(this.properties.keySet());
        this.componentBag = ComponentBag.newInstance(registrationStrategy);
        this.newFeatureRegistrations = new LinkedList<FeatureRegistration>();
        this.enabledFeatureClasses = Sets.newIdentityHashSet();
        this.enabledFeatures = Sets.newHashSet();
    }

    public CommonConfig(CommonConfig config) {
        this.type = config.type;
        this.properties = new HashMap<String, Object>(config.properties);
        this.immutablePropertiesView = Collections.unmodifiableMap(this.properties);
        this.immutablePropertyNames = Collections.unmodifiableCollection(this.properties.keySet());
        this.componentBag = config.componentBag.copy();
        this.newFeatureRegistrations = Lists.newLinkedList(config.newFeatureRegistrations);
        this.enabledFeatureClasses = Sets.newIdentityHashSet();
        this.enabledFeatureClasses.addAll(config.enabledFeatureClasses);
        this.enabledFeatures = Sets.newHashSet();
        this.enabledFeatures.addAll(config.enabledFeatures);
    }

    public ExtendedConfig getConfiguration() {
        return this;
    }

    public RuntimeType getRuntimeType() {
        return this.type;
    }

    public Map<String, Object> getProperties() {
        return this.immutablePropertiesView;
    }

    public Object getProperty(String name) {
        return this.properties.get(name);
    }

    @Override
    public boolean isProperty(String name) {
        return PropertiesHelper.isProperty(this.getProperty(name));
    }

    public Collection<String> getPropertyNames() {
        return this.immutablePropertyNames;
    }

    public boolean isEnabled(Class<? extends Feature> featureClass) {
        return this.enabledFeatureClasses.contains(featureClass);
    }

    public boolean isEnabled(Feature feature) {
        return this.enabledFeatures.contains(feature);
    }

    public boolean isRegistered(Object component) {
        return this.componentBag.getInstances().contains(component);
    }

    public boolean isRegistered(Class<?> componentClass) {
        return this.componentBag.getRegistrations().contains(componentClass);
    }

    public Map<Class<?>, Integer> getContracts(Class<?> componentClass) {
        ContractProvider model = this.componentBag.getModel(componentClass);
        return model == null ? Collections.emptyMap() : model.getContractMap();
    }

    public Set<Class<?>> getClasses() {
        return this.componentBag.getClasses();
    }

    public Set<Object> getInstances() {
        return this.componentBag.getInstances();
    }

    public final ComponentBag getComponentBag() {
        return this.componentBag;
    }

    protected Inflector<ContractProvider.Builder, ContractProvider> getModelEnhancer(Class<?> componentClass) {
        return ComponentBag.AS_IS;
    }

    public CommonConfig setProperties(Map<String, ?> properties) {
        this.properties.clear();
        if (properties != null) {
            this.properties.putAll(properties);
        }
        return this;
    }

    public CommonConfig addProperties(Map<String, ?> properties) {
        if (properties != null) {
            this.properties.putAll(properties);
        }
        return this;
    }

    public CommonConfig property(String name, Object value) {
        if (value == null) {
            this.properties.remove(name);
        } else {
            this.properties.put(name, value);
        }
        return this;
    }

    public CommonConfig register(Class<?> componentClass) {
        this.checkComponentClassNotNull(componentClass);
        if (this.componentBag.register(componentClass, this.getModelEnhancer(componentClass))) {
            this.processFeatureRegistration(null, componentClass);
        }
        return this;
    }

    public CommonConfig register(Class<?> componentClass, int bindingPriority) {
        this.checkComponentClassNotNull(componentClass);
        if (this.componentBag.register(componentClass, bindingPriority, this.getModelEnhancer(componentClass))) {
            this.processFeatureRegistration(null, componentClass);
        }
        return this;
    }

    public CommonConfig register(Class<?> componentClass, Class<?> ... contracts) {
        this.checkComponentClassNotNull(componentClass);
        if (this.componentBag.register(componentClass, this.asNewIdentitySet(contracts), this.getModelEnhancer(componentClass))) {
            this.processFeatureRegistration(null, componentClass);
        }
        return this;
    }

    public CommonConfig register(Class<?> componentClass, Map<Class<?>, Integer> contracts) {
        this.checkComponentClassNotNull(componentClass);
        if (this.componentBag.register(componentClass, contracts, this.getModelEnhancer(componentClass))) {
            this.processFeatureRegistration(null, componentClass);
        }
        return this;
    }

    public CommonConfig register(Object component) {
        this.checkProviderNotNull(component);
        Class<?> componentClass = component.getClass();
        if (this.componentBag.register(component, this.getModelEnhancer(componentClass))) {
            this.processFeatureRegistration(component, componentClass);
        }
        return this;
    }

    public CommonConfig register(Object component, int bindingPriority) {
        this.checkProviderNotNull(component);
        Class<?> componentClass = component.getClass();
        if (this.componentBag.register(component, bindingPriority, this.getModelEnhancer(componentClass))) {
            this.processFeatureRegistration(component, componentClass);
        }
        return this;
    }

    public CommonConfig register(Object component, Class<?> ... contracts) {
        this.checkProviderNotNull(component);
        Class<?> componentClass = component.getClass();
        if (this.componentBag.register(component, this.asNewIdentitySet(contracts), this.getModelEnhancer(componentClass))) {
            this.processFeatureRegistration(component, componentClass);
        }
        return this;
    }

    public CommonConfig register(Object component, Map<Class<?>, Integer> contracts) {
        this.checkProviderNotNull(component);
        Class<?> componentClass = component.getClass();
        if (this.componentBag.register(component, contracts, this.getModelEnhancer(componentClass))) {
            this.processFeatureRegistration(component, componentClass);
        }
        return this;
    }

    private void processFeatureRegistration(Object component, Class<?> componentClass) {
        ContractProvider model = this.componentBag.getModel(componentClass);
        if (model.getContracts().contains(Feature.class)) {
            FeatureRegistration registration = component != null ? new FeatureRegistration((Feature)component) : new FeatureRegistration(componentClass);
            this.newFeatureRegistrations.add(registration);
        }
    }

    public CommonConfig replaceWith(Configuration config) {
        this.setProperties(config.getProperties());
        this.enabledFeatures.clear();
        this.enabledFeatureClasses.clear();
        this.componentBag.clear();
        this.resetRegistrations();
        for (Class cls : config.getClasses()) {
            this.register(cls, config.getContracts(cls));
        }
        for (Object o : config.getInstances()) {
            this.register(o, config.getContracts(o.getClass()));
        }
        return this;
    }

    private Set<Class<?>> asNewIdentitySet(Class<?> ... contracts) {
        Set result = Sets.newIdentityHashSet();
        result.addAll(Arrays.asList(contracts));
        return result;
    }

    private void checkProviderNotNull(Object provider) {
        if (provider == null) {
            throw new IllegalArgumentException(LocalizationMessages.COMPONENT_CANNOT_BE_NULL());
        }
    }

    private void checkComponentClassNotNull(Class<?> componentClass) {
        if (componentClass == null) {
            throw new IllegalArgumentException(LocalizationMessages.COMPONENT_CLASS_CANNOT_BE_NULL());
        }
    }

    public void configureMetaProviders(ServiceLocator locator) {
        Set<Binder> configuredBinders = this.configureBinders(locator, Collections.<Binder>emptySet());
        this.configureFeatures(locator, new HashSet<FeatureRegistration>(), this.resetRegistrations());
        this.configureBinders(locator, configuredBinders);
    }

    private Set<Binder> configureBinders(ServiceLocator locator, Set<Binder> configured) {
        Set allConfigured = Sets.newIdentityHashSet();
        allConfigured.addAll(configured);
        Collection<Binder> binders = this.getBinders(configured);
        if (!binders.isEmpty()) {
            DynamicConfiguration dc = Injections.getConfiguration(locator);
            for (Binder binder : binders) {
                binder.bind(dc);
                allConfigured.add(binder);
            }
            dc.commit();
        }
        return allConfigured;
    }

    private Collection<Binder> getBinders(final Set<Binder> configured) {
        return Collections2.filter((Collection)Collections2.transform(this.componentBag.getInstances(ComponentBag.BINDERS_ONLY), CAST_TO_BINDER), (Predicate)new Predicate<Binder>(){

            public boolean apply(Binder binder) {
                return !configured.contains(binder);
            }
        });
    }

    private void configureFeatures(ServiceLocator locator, Set<FeatureRegistration> processed, List<FeatureRegistration> unprocessed) {
        for (FeatureRegistration registration : unprocessed) {
            if (processed.contains(registration)) {
                LOGGER.config(LocalizationMessages.FEATURE_HAS_ALREADY_BEEN_PROCESSED(registration.getFeatureClass()));
                continue;
            }
            Feature feature = registration.getFeature();
            if (feature == null) {
                feature = (Feature)locator.create(registration.getFeatureClass());
            } else {
                locator.inject((Object)feature);
            }
            if (this.enabledFeatures.contains(feature)) {
                LOGGER.config(LocalizationMessages.FEATURE_HAS_ALREADY_BEEN_PROCESSED(feature));
                continue;
            }
            boolean success = feature.configure((FeatureContext)this);
            if (!success) continue;
            processed.add(registration);
            this.configureFeatures(locator, processed, this.resetRegistrations());
            this.enabledFeatureClasses.add(registration.getFeatureClass());
            this.enabledFeatures.add(feature);
        }
    }

    private List<FeatureRegistration> resetRegistrations() {
        ArrayList<FeatureRegistration> result = new ArrayList<FeatureRegistration>(this.newFeatureRegistrations);
        this.newFeatureRegistrations.clear();
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CommonConfig)) {
            return false;
        }
        CommonConfig that = (CommonConfig)o;
        if (this.type != that.type) {
            return false;
        }
        if (!((Object)this.properties).equals(that.properties)) {
            return false;
        }
        if (!this.componentBag.equals(that.componentBag)) {
            return false;
        }
        if (!((Object)this.enabledFeatureClasses).equals(that.enabledFeatureClasses)) {
            return false;
        }
        if (!((Object)this.enabledFeatures).equals(that.enabledFeatures)) {
            return false;
        }
        return ((Object)this.newFeatureRegistrations).equals(that.newFeatureRegistrations);
    }

    public int hashCode() {
        int result = this.type.hashCode();
        result = 31 * result + ((Object)this.properties).hashCode();
        result = 31 * result + this.componentBag.hashCode();
        result = 31 * result + ((Object)this.newFeatureRegistrations).hashCode();
        result = 31 * result + ((Object)this.enabledFeatures).hashCode();
        result = 31 * result + ((Object)this.enabledFeatureClasses).hashCode();
        return result;
    }

    private static final class FeatureRegistration {
        private final Class<? extends Feature> featureClass;
        private final Feature feature;

        private FeatureRegistration(Class<? extends Feature> featureClass) {
            this.featureClass = featureClass;
            this.feature = null;
        }

        private FeatureRegistration(Feature feature) {
            this.featureClass = feature.getClass();
            this.feature = feature;
        }

        public Class<? extends Feature> getFeatureClass() {
            return this.featureClass;
        }

        public Feature getFeature() {
            return this.feature;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof FeatureRegistration)) {
                return false;
            }
            FeatureRegistration other = (FeatureRegistration)obj;
            return this.featureClass == other.featureClass || this.feature != null && (this.feature == other.feature || this.feature.equals(other.feature));
        }

        public int hashCode() {
            int hash = 47;
            hash = 13 * hash + (this.feature != null ? this.feature.hashCode() : 0);
            hash = 13 * hash + (this.featureClass != null ? this.featureClass.hashCode() : 0);
            return hash;
        }
    }
}

