/*
Copyright (C) 2013 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.
 */
package com.clustercontrol.cloud.ui.views;

import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IViewPart;

import com.clustercontrol.cloud.commons.util.MessageManager;
import com.clustercontrol.cloud.commons.util.TableViewerSorter;
import com.clustercontrol.cloud.presenter.CloudStorageBackupManager;
import com.clustercontrol.cloud.presenter.CollectionObserver2;
import com.clustercontrol.cloud.presenter.ICloudComputeService;
import com.clustercontrol.cloud.presenter.ICloudStorage;
import com.clustercontrol.cloud.presenter.ICloudStorageBackup;
import com.clustercontrol.cloud.presenter.ICloudStorageBackupManager;
import com.clustercontrol.cloud.presenter.PropertyId2;
import com.clustercontrol.cloud.presenter.IAccountResource.IRegion;
import com.clustercontrol.util.LoginManager;
import com.clustercontrol.ws.cloud.CloudEndpoint;
import com.clustercontrol.ws.cloud.CloudManagerFault_Exception;
import com.clustercontrol.ws.cloud.InvalidRole_Exception;
import com.clustercontrol.ws.cloud.InvalidUserPass_Exception;


/**
 */
public class StorageBackupsView extends FilterlingViewPartByScopeAndAnother<ICloudStorageBackupManager, ICloudStorageBackup, com.clustercontrol.ws.cloud.CloudStorageBackup> implements ISelectionListener {
	public static final String Id = "com.clustercontrol.cloud.ui.views.StorageBackupsView";

	private static ThreadPoolExecutor threadPool = new ThreadPoolExecutor(3, 3, 60, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>());
	private static MessageManager bundle_messages = MessageManager.getInstance("messages");
		
	private Label lblHeader;
	private FooterComposite footerComposite;
	private Table table;
	private TableViewer tableViewer;

	public StorageBackupsView() {
 		super();
		LoginManager.login();  // ログインしていない場合は、ビュー表示前に必ずログインダイアログを出すようにする
	}

	@Override
	protected void internalCreatePartControl(Composite arg0) {
		Composite composite = new Composite(arg0, SWT.NONE);
		GridLayout gl_composite = new GridLayout(1, true);
		gl_composite.horizontalSpacing = 0;
		gl_composite.marginHeight = 0;
		gl_composite.marginWidth = 0;
		gl_composite.verticalSpacing = 0;
		composite.setLayout(gl_composite);
		
		lblHeader = new Label(composite, SWT.NONE);
		lblHeader.setSize(lblHeader.getSize().x, 80);
		GridData gridData = new GridData();
		gridData.horizontalAlignment = GridData.FILL;
		gridData.verticalAlignment = GridData.FILL;
		lblHeader.setLayoutData(gridData);

		Composite composite_1 = new Composite(composite, SWT.NONE);
		TableColumnLayout tcl_composite_1 = new TableColumnLayout();
		composite_1.setLayout(tcl_composite_1);

		tableViewer = new TableViewer(composite_1, SWT.BORDER | SWT.FULL_SELECTION | SWT.MULTI);
		table = tableViewer.getTable();
		table.setHeaderVisible(true);
		table.setLinesVisible(true);

		for(final ViewColumn column: ViewColumn.values()){
			TableViewerColumn tableViewerColumn = new TableViewerColumn(tableViewer, SWT.NONE);
			TableColumn tableColumn = tableViewerColumn.getColumn();
			tcl_composite_1.setColumnData(tableColumn, column.getPixelData());
			tableColumn.setText(column.getLabel());
			tableViewerColumn.setLabelProvider(column.getProvider());
			tableColumn.addSelectionListener(new SelectionAdapter(){
				@Override
				public void widgetSelected(SelectionEvent e) {
					tableViewer.setSorter(new TableViewerSorter(tableViewer, column.getProvider()));
				}
			});
		}

		gridData = new GridData();
		gridData.horizontalAlignment = GridData.FILL;
		gridData.verticalAlignment = GridData.FILL;
		gridData.grabExcessHorizontalSpace = true;
		gridData.grabExcessVerticalSpace = true;
		composite_1.setLayoutData(gridData);

		footerComposite = new FooterComposite(composite, SWT.NONE);
		gridData = new GridData();
		gridData.horizontalAlignment = GridData.FILL;
		gridData.verticalAlignment = GridData.FILL;
		footerComposite.setSize(lblHeader.getSize().x, 80);
		footerComposite.setLayoutData(gridData);

		tableViewer.setContentProvider(new IStructuredContentProvider() {
			@Override
			public Object[] getElements(Object inputElement) {
				return ((List<?>) inputElement).toArray();
			}

			@Override
			public void dispose() {

			}

			@Override
			public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
			}
		});

		getSite().getPage().addSelectionListener(this);
		getSite().setSelectionProvider(tableViewer);

		getSite().getWorkbenchWindow().getShell().getDisplay().asyncExec(
				new Runnable() {
					@Override
					public void run() {
						IViewPart view = getSite().getPage().findView(ScopeView.Id);
						view.getSite().getPage().activate(view);
						view.getSite().getSelectionProvider().setSelection(view.getSite().getSelectionProvider().getSelection());
						getSite().getPage().activate(StorageBackupsView.this);
					}
				});
		update();
	}
	
	@Override
	protected ICloudStorageBackupManager getRootElement(IRegion region) {
		return region.getCloudService(ICloudComputeService.class).getStorageBackupManager();
	}
	@Override
	protected List<ICloudStorageBackup> getElements(ICloudStorageBackupManager root) {
		return Arrays.asList(root.getCloudStorageBackups());
	}
	@Override
	protected PropertyId2<CollectionObserver2<ICloudStorageBackup>> getPropertyId() {
		return ICloudStorageBackupManager.p2.cloudStorageBackups;
	}
	@Override
	protected boolean isMatchRegion(IRegion region, ICloudStorageBackup element) {
		return element.getCloudStorageBackupManager().getRegion().equals(region);
	}
	@Override
	protected Label getHeaderLabel() {
		return lblHeader;
	}
	@Override
	protected Label getLeftFooter() {
		return footerComposite.getLeftControl();
	}
	@Override
	protected Label getRightFooter() {
		return footerComposite.getRightControl();
	}
	@Override
	protected StructuredViewer getViewer() {
		return tableViewer;
	}
	@Override
	protected List<com.clustercontrol.ws.cloud.CloudStorageBackup> getManagerElements(CloudEndpoint endpoint, IRegion region)  throws InvalidRole_Exception, InvalidUserPass_Exception, CloudManagerFault_Exception {
		return endpoint.getStorageBackupsByRegion(region.getAccountResource().getActiveUser().getRoleId(), region.getRegion());
	}
	@Override
	protected void setManagerElements(ICloudStorageBackupManager rootElement, List<com.clustercontrol.ws.cloud.CloudStorageBackup> managerElements) {
		((CloudStorageBackupManager)rootElement).internalUpdate(managerElements);
	}
	@Override
	protected boolean isInitialized(ICloudStorageBackupManager rootElement) {
		return ((CloudStorageBackupManager)rootElement).isInitialized();
	}
	@Override
	protected ThreadPoolExecutor getExecutor() {
		return threadPool;
	}

	private enum ViewColumn{
		snapshot_id(
			bundle_messages.getString("word.snapshot_id"),
			new ColumnPixelData(100, true, true),
			new ColumnLabelProvider(){
				@Override
				public String getText(Object element) {
					return ((ICloudStorageBackup)element).getStorageBackupId();
				}
			}
		),
		snapshot_name(
			bundle_messages.getString("word.snapshot_name"),
			new ColumnPixelData(100, true, true),
			new ColumnLabelProvider(){
				@Override
				public String getText(Object element) {
					return ((ICloudStorageBackup)element).getSnapshotName();
				}
			}
		),
		reg_date(
			bundle_messages.getString("word.create_date"),
			new ColumnPixelData(100, true, true),
			new ColumnLabelProvider(){
				@Override
				public String getText(Object element) {
					if(((ICloudStorageBackup)element).getRegDate() != null){
						return format.format(((ICloudStorageBackup)element).getRegDate());
					}
					return "";
				}
			}
		),
		cloud_type_id(
			bundle_messages.getString("word.cloud_type_id"),
			new ColumnPixelData(100, true, true),
			new ColumnLabelProvider(){
				@Override
				public String getText(Object element) {
					return ((ICloudStorageBackup)element).getCloudTypeId();
				}
			}
		),
		description(
			bundle_messages.getString("word.description"),
			new ColumnPixelData(100, true, true),
			new ColumnLabelProvider(){
				@Override
				public String getText(Object element) {
					return ((ICloudStorageBackup)element).getDescription();
				}
			}
		),
		volume_id(
			bundle_messages.getString("word.volume_id"),
			new ColumnPixelData(100, true, true),
			new ColumnLabelProvider(){
				@Override
				public String getText(Object element) {
					return ((ICloudStorageBackup)element).getStorageId();
				}
			}
		),
		exist_status(
			bundle_messages.getString("word.exist_status"),
			new ColumnPixelData(100, true, true),
			new ColumnLabelProvider(){
				@Override
				public String getText(Object element) {
					return ((ICloudStorageBackup)element).getRestoreStatus();
				}
			}
		),
		region(
			bundle_messages.getString("word.region"),
			new ColumnPixelData(100, true, true),
			new ColumnLabelProvider(){
				@Override
				public String getText(Object element) {
					return ((ICloudStorageBackup)element).getRegion();
				}
			}
		),
		reg_user(
			bundle_messages.getString("word.reg_user"),
			new ColumnPixelData(100, true, true),
			new ColumnLabelProvider(){
				@Override
				public String getText(Object element) {
					return ((ICloudStorageBackup)element).getRegUser();
				}
			}
		),
		;

		private String label;
		private ColumnLabelProvider provider;
		private ColumnPixelData pixelData;
		private static SimpleDateFormat format = new SimpleDateFormat("yyyy/MM/dd H:mm:ss");
		
		ViewColumn(String label, ColumnPixelData pixelData, ColumnLabelProvider provider){
			this.label = label;
			this.pixelData = pixelData;
			this.provider = provider;
		}

		public String getLabel() {
			return label;
		}

		public ColumnPixelData getPixelData() {
			return pixelData;
		}

		public ColumnLabelProvider getProvider() {
			return provider;
		}
	}

	@Override
	protected String getHeaderByElementId(IRegion region, List<String> elementIds) {
		if (!elementIds.isEmpty()) {
			return 	bundle_messages.getString("word.region") + bundle_messages.getString("caption.title_separator") + bundle_messages.getString(region.getRegionName()) + " " + 
					bundle_messages.getString("word.volume_id") + bundle_messages.getString("caption.title_separator") + elementIds.get(0);
		}
		else {
			return bundle_messages.getString("word.region") + bundle_messages.getString("caption.title_separator") + bundle_messages.getString(region.getRegionName());
		}
	}

	@Override
	protected String getElementId(Object selected) {
		if (selected instanceof ICloudStorage) {
			return ((ICloudStorage)selected).getStorageId();
		}
		return null;
	}

	@Override
	protected boolean isMatchElementIds(List<String> elementIds, ICloudStorageBackup element) {
		if (elementIds.isEmpty() || elementIds.size() > 1) {
			return false;
		}
		return element.getStorageId().equals(elementIds.get(0));
	}

	@Override
	protected String getSupportViewId() {
		return StoragesView.Id;
	}

	@Override
	public void dispose() {
		getSite().getPage().removeSelectionListener(this);
		getSite().setSelectionProvider(null);
		super.dispose();
	}
}
