/*
Copyright (C) 2014 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.
 */
package com.clustercontrol.cloud.cloudn.base.presenter;


import com.clustercontrol.cloud.presenter.IEndpointManager;
import com.clustercontrol.util.LoginManager;
import com.clustercontrol.ws.cloudn.CloudnOptionEndpoint;
import com.clustercontrol.ws.cloudn.CloudnOptionEndpointService;

public class EndpointManager implements IEndpointManager {
	private static final EndpointHolder<CloudnOptionEndpoint> endpointHolder = new EndpointHolder<CloudnOptionEndpoint>() {
		@Override
		protected Class<CloudnOptionEndpoint> getEndpointClass() {
			return CloudnOptionEndpoint.class;
		}

		@Override
		protected Class<?> getEndpointServiceClass() {
			return CloudnOptionEndpointService.class;
		}

		@Override
		protected String getNamespace() {
			return "http://cloudn.ws.clustercontrol.com";
		}
	};

	@Override
	public String getAccountName() {
		return LoginManager.getUserId();
	}

	@SuppressWarnings("unchecked")
	public synchronized <T> T getEndpoint(final Class<T> clazz) {
		T endpoint = null;
		
		if (clazz == CloudnOptionEndpoint.class) {
			endpoint = (T)endpointHolder.get();
		}
		else {
			endpoint = com.clustercontrol.cloud.Activator.getEndpointManager().getEndpoint(clazz);
		}
		return endpoint;
	}
}
